/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.scion.jpan.Constants;
import org.scion.jpan.PathMetadata;
import org.scion.jpan.internal.PathRawParser;

public class ScionUtil {
    private static final int ISD_BITS = 16;
    private static final int MAX_ISD = 65535;
    private static final int AS_BITS = 48;
    private static final long MAX_AS = 0xFFFFFFFFFFFFL;
    private static final int AS_PART_BITS = 16;
    private static final int AS_PART_BASE = 16;
    private static final int AS_PARTS = 3;

    public static long parseIA(String ia) {
        String[] parts = ia.split("-");
        if (parts.length != 2) {
            throw new IllegalArgumentException("invalid ISD-AS: value=" + ia);
        }
        int isd = ScionUtil.parseISD(parts[0]);
        long as = ScionUtil.parseAS(parts[1]);
        ScionUtil.checkLimits(isd, as);
        return Integer.toUnsignedLong(isd) << 48 | as & 0xFFFFFFFFFFFFL;
    }

    public static int parseISD(String isd) {
        int parsed = Integer.parseUnsignedInt(isd, 10);
        ScionUtil.checkLimits(parsed, 0L);
        return parsed;
    }

    public static long parseAS(String as) {
        String[] parts = as.split(":");
        if (parts.length == 1) {
            return Integer.parseUnsignedInt(as, 10);
        }
        if (parts.length != 3) {
            throw new IllegalArgumentException("Wrong number of ':' separators in value=" + as);
        }
        long parsed = 0L;
        for (int i = 0; i < 3; ++i) {
            parsed <<= 16;
            parsed |= Long.parseUnsignedLong(parts[i], 16) & 0xFFFFL;
        }
        ScionUtil.checkLimits(0, parsed);
        return parsed;
    }

    public static String toStringIA(long ia) {
        long mask = -281474976710656L;
        String s = "";
        s = s + Long.toString((ia & mask) >>> 48, 10) + "-";
        s = s + Long.toString((ia & (mask >>>= 16)) >>> 32, 16) + ":";
        s = s + Long.toString((ia & (mask >>>= 16)) >>> 16, 16) + ":";
        s = s + Long.toString(ia & (mask >>>= 16), 16);
        return s;
    }

    public static String toStringIA(int isd, long as) {
        ScionUtil.checkLimits(isd, as);
        long ia = (long)isd << 48 | as;
        long mask = -281474976710656L;
        String s = "";
        s = s + Long.toString((ia & mask) >>> 48, 10) + "-";
        s = s + Long.toString((ia & (mask >>>= 16)) >>> 32, 16) + ":";
        s = s + Long.toString((ia & (mask >>>= 16)) >>> 16, 16) + ":";
        s = s + Long.toString(ia & (mask >>>= 16), 16);
        return s;
    }

    public static String toStringPath(byte[] raw) {
        PathRawParser ph = PathRawParser.create(raw);
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int[] segLen = new int[]{ph.getSegLen(0), ph.getSegLen(1), ph.getSegLen(2)};
        int offset = 0;
        for (int j = 0; j < segLen.length; ++j) {
            boolean flagC = ph.getInfoField(j).getFlagC();
            for (int i = offset; i < offset + segLen[j] - 1; ++i) {
                PathRawParser.HopField hfE = ph.getHopField(i);
                PathRawParser.HopField hfI = ph.getHopField(i + 1);
                if (flagC) {
                    sb.append(hfE.getEgress()).append(">").append(hfI.getIngress());
                } else {
                    sb.append(hfE.getIngress()).append(">").append(hfI.getEgress());
                }
                if (i >= ph.getHopFieldCount() - 2) continue;
                sb.append(" ");
            }
            offset += segLen[j];
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toStringPath(PathMetadata meta) {
        if (meta.getInterfacesList().isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int nInterfaces = meta.getInterfacesList().size();
        for (int i = 0; i < nInterfaces; ++i) {
            PathMetadata.PathInterface pIf = meta.getInterfacesList().get(i);
            if (i % 2 == 0) {
                sb.append(ScionUtil.toStringIA(pIf.getIsdAs())).append(" ");
                sb.append(pIf.getId()).append(">");
                continue;
            }
            sb.append(pIf.getId()).append(" ");
        }
        sb.append(ScionUtil.toStringIA(meta.getInterfacesList().get(nInterfaces - 1).getIsdAs()));
        sb.append("]");
        return sb.toString();
    }

    private static void checkLimits(int isd, long as) {
        if (isd < 0 || isd > 65535) {
            throw new IllegalArgumentException("ISD out of range: " + isd);
        }
        if (as < 0L || as > 0xFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("AS out of range: " + as);
        }
    }

    public static String getPropertyOrEnv(String propertyName, String envName) {
        String value = System.getProperty(propertyName);
        return value != null || Constants.debugIgnoreEnvironment ? value : System.getenv(envName);
    }

    public static String getPropertyOrEnv(String propertyName, String envName, String defaultValue) {
        String value = ScionUtil.getPropertyOrEnv(propertyName, envName);
        return value != null ? value : defaultValue;
    }

    public static boolean getPropertyOrEnv(String propertyName, String envName, boolean defaultValue) {
        String value = ScionUtil.getPropertyOrEnv(propertyName, envName);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public static int getPropertyOrEnv(String propertyName, String envName, int defaultValue) {
        String value = ScionUtil.getPropertyOrEnv(propertyName, envName);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public static double getPropertyOrEnv(String propertyName, String envName, double defaultValue) {
        String value = ScionUtil.getPropertyOrEnv(propertyName, envName);
        return value != null ? Double.parseDouble(value) : defaultValue;
    }

    public static int extractIsd(long isdAs) {
        return (int)(isdAs >>> 48);
    }

    public static long extractAs(long isdAs) {
        return isdAs & 0xFFFFFFFFFFFFL;
    }

    static InetSocketAddress parseInetSocketAddress(String addrStr) {
        try {
            int posColon = addrStr.indexOf(58);
            InetAddress inetAddress = InetAddress.getByName(addrStr.substring(0, posColon));
            return new InetSocketAddress(inetAddress, Integer.parseInt(addrStr.substring(posColon + 1)));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isWildcard(long isdAs) {
        return isdAs == ScionUtil.toWildcard(isdAs);
    }

    public static long toWildcard(long isdAs) {
        return isdAs >>> 48 << 48;
    }

    private ScionUtil() {
    }
}

