/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.nio.ByteBuffer;
import org.scion.jpan.internal.ByteUtil;
import org.scion.jpan.internal.InternalConstants;

public class ExtensionHeader {
    private int nextHdr;
    private int extLen;
    private int extLenBytes;
    private long options;

    public static ExtensionHeader consume(ByteBuffer data) {
        ExtensionHeader eh = new ExtensionHeader();
        eh.nextHdr = ByteUtil.toUnsigned(data.get());
        eh.extLen = ByteUtil.toUnsigned(data.get());
        eh.extLenBytes = (eh.extLen + 1) * 4;
        eh.options = (long)ByteUtil.toUnsigned(data.getShort()) << 32 | (long)data.getInt();
        data.position(data.position() + eh.extLenBytes - 8);
        return eh;
    }

    public String toString() {
        return "ExtensionHeader{nextHdr=" + this.nextHdr + ", extLen=" + this.extLen + ", options=" + this.options + '}';
    }

    public InternalConstants.HdrTypes nextHdr() {
        return InternalConstants.HdrTypes.parse(this.nextHdr);
    }

    public int getExtLenBytes() {
        return this.extLenBytes;
    }
}

