/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.atomic.AtomicReference;
import org.scion.jpan.ScionRuntimeException;

public class ExternalIpDiscovery {
    private static final AtomicReference<ExternalIpDiscovery> singleton = new AtomicReference();
    private DatagramChannel ifDiscoveryChannel = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExternalIpDiscovery getInstance() {
        AtomicReference<ExternalIpDiscovery> atomicReference = singleton;
        synchronized (atomicReference) {
            if (singleton.get() == null) {
                singleton.set(new ExternalIpDiscovery());
            }
            return singleton.get();
        }
    }

    private ExternalIpDiscovery() {
    }

    public static synchronized InetAddress getExternalIP(InetSocketAddress firstHop) {
        return ExternalIpDiscovery.getInstance().getIp(firstHop);
    }

    private InetAddress getIp(InetSocketAddress firstHop) {
        try {
            if (this.ifDiscoveryChannel == null) {
                this.ifDiscoveryChannel = DatagramChannel.open();
            }
            this.ifDiscoveryChannel.connect(firstHop);
            SocketAddress address = this.ifDiscoveryChannel.getLocalAddress();
            this.ifDiscoveryChannel.disconnect();
            return ((InetSocketAddress)address).getAddress();
        }
        catch (IOException e) {
            throw new ScionRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        AtomicReference<ExternalIpDiscovery> atomicReference = singleton;
        synchronized (atomicReference) {
            try {
                if (this.ifDiscoveryChannel != null) {
                    this.ifDiscoveryChannel.close();
                }
                this.ifDiscoveryChannel = null;
            }
            catch (IOException e) {
                throw new ScionRuntimeException(e);
            }
            singleton.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstall() {
        AtomicReference<ExternalIpDiscovery> atomicReference = singleton;
        synchronized (atomicReference) {
            if (singleton.get() != null) {
                singleton.get().close();
            }
        }
    }
}

