/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.ppl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.scion.jpan.Path;
import org.scion.jpan.PathMetadata;

class PplDefaults {
    private final int minMtu;
    private final long minBandwidthBPS;
    private final int minValiditySec;
    private final String[] orderingStr;
    private final Comparator<Path> ordering;

    public PplDefaults(int minMtuBytes, long minBandwidthBytesPerSeconds, int minValiditySeconds, String ordering) {
        this.minMtu = minMtuBytes;
        this.minBandwidthBPS = minBandwidthBytesPerSeconds;
        this.minValiditySec = minValiditySeconds;
        this.orderingStr = ordering == null ? new String[]{} : ordering.split(",");
        this.ordering = this.buildComparator(this.orderingStr);
    }

    public List<Path> filter(List<Path> paths, PplDefaults global) {
        ArrayList<Path> filtered = new ArrayList<Path>();
        long now = System.currentTimeMillis() / 1000L;
        for (Path path : paths) {
            PathMetadata meta = path.getMetadata();
            boolean pass = true;
            if (this.minMtu > 0) {
                pass &= meta.getMtu() >= this.minMtu;
            } else if (global != null && global.minMtu > 0) {
                pass &= meta.getMtu() >= global.minMtu;
            }
            if (this.minValiditySec > 0) {
                pass &= meta.getExpiration() >= now + (long)this.minValiditySec;
            } else if (global != null && global.minValiditySec > 0) {
                pass &= meta.getExpiration() >= now + (long)global.minValiditySec;
            }
            if (this.minBandwidthBPS > 0L) {
                pass &= this.getMinBandwidth(path) >= this.minBandwidthBPS;
            } else if (global != null && global.minBandwidthBPS > 0L) {
                pass &= this.getMinBandwidth(path) >= global.minBandwidthBPS;
            }
            if (!pass) continue;
            filtered.add(path);
        }
        return filtered;
    }

    public void sortPaths(List<Path> filtered) {
        if (this.ordering != null) {
            filtered.sort(this.ordering);
        }
    }

    private long getMinBandwidth(Path path) {
        long minBandwidth = Long.MAX_VALUE;
        for (long bandwidth : path.getMetadata().getBandwidthList()) {
            if (bandwidth >= minBandwidth) continue;
            minBandwidth = bandwidth;
        }
        return minBandwidth;
    }

    private Comparator<Path> buildComparator(String[] orderings) {
        if (orderings.length == 0) {
            return null;
        }
        ChainableComparator comparator = this.getPathComparator(orderings[orderings.length - 1]);
        for (int i = orderings.length - 2; i >= 0; --i) {
            comparator = new ChainableComparator(this.getPathComparator(orderings[i]), comparator);
        }
        return comparator;
    }

    private Comparator<Path> getPathComparator(String ordering) {
        switch (ordering) {
            case "hops_asc": {
                return Comparator.comparingInt(p -> p.getMetadata().getInterfacesList().size());
            }
            case "hops_desc": {
                return (p1, p2) -> Integer.compare(p2.getMetadata().getInterfacesList().size(), p1.getMetadata().getInterfacesList().size());
            }
            case "meta_bandwidth_desc": {
                return (p1, p2) -> Long.compare(p2.getMetadata().getBandwidthList().stream().mapToLong(Long::longValue).min().orElse(Long.MAX_VALUE), p1.getMetadata().getBandwidthList().stream().mapToLong(Long::longValue).min().orElse(Long.MAX_VALUE));
            }
            case "meta_latency_asc": {
                return Comparator.comparingInt(p -> p.getMetadata().getLatencyList().stream().mapToInt(l -> l < 0 ? 10000 : l).sum());
            }
        }
        throw new IllegalArgumentException("PPL: unknown ordering: " + ordering);
    }

    void toJson(JsonObject defaultsObj) {
        if (this.minBandwidthBPS > 0L) {
            defaultsObj.addProperty("min_meta_bandwidth", (Number)this.minBandwidthBPS);
        }
        if (this.minMtu > 0) {
            defaultsObj.addProperty("min_mtu", (Number)this.minMtu);
        }
        if (this.minValiditySec > 0) {
            defaultsObj.addProperty("min_validity_sec", (Number)this.minValiditySec);
        }
        if (this.orderingStr.length > 0) {
            StringBuilder oStr = new StringBuilder(this.orderingStr[0]);
            for (int i = 1; i < this.orderingStr.length; ++i) {
                oStr.append(",").append(this.orderingStr[i]);
            }
            defaultsObj.addProperty("ordering", oStr.toString());
        }
    }

    static class Builder {
        private int minMtuBytes = 0;
        private long minBandwidthBytesPerSeconds = 0L;
        private int minValiditySeconds = 0;
        private String ordering = null;

        Builder() {
        }

        public Builder minMetaBandwidth(long minBandwidthBytesPerSeconds) {
            this.minBandwidthBytesPerSeconds = minBandwidthBytesPerSeconds;
            return this;
        }

        public Builder minMtu(int minMtuBytes) {
            this.minMtuBytes = minMtuBytes;
            return this;
        }

        public Builder minValidity(int minValiditySeconds) {
            this.minValiditySeconds = minValiditySeconds;
            return this;
        }

        public Builder ordering(String ordering) {
            this.ordering = ordering;
            return this;
        }

        public PplDefaults build() {
            return new PplDefaults(this.minMtuBytes, this.minBandwidthBytesPerSeconds, this.minValiditySeconds, this.ordering);
        }
    }

    private static class ChainableComparator
    implements Comparator<Path> {
        private final Comparator<Path> primary;
        private final Comparator<Path> secondary;

        public ChainableComparator(Comparator<Path> primary, Comparator<Path> secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public int compare(Path p1, Path p2) {
            int res = this.primary.compare(p1, p2);
            return res != 0 ? res : this.secondary.compare(p1, p2);
        }
    }
}

