/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.Closeable;
import org.scion.jpan.ScionService;

public final class Scion {
    private Scion() {
    }

    public static ScionService defaultService() {
        return ScionService.defaultService();
    }

    public static void closeDefault() {
        ScionService.closeDefault();
    }

    public static CloseableService newServiceWithDaemon(String hostAndPort) {
        return new CloseableService(hostAndPort, ScionService.Mode.DAEMON);
    }

    public static CloseableService newServiceWithDNS(String hostName) {
        return new CloseableService(hostName, ScionService.Mode.BOOTSTRAP_VIA_DNS);
    }

    public static CloseableService newServiceWithBootstrapServer(String hostAndPort) {
        return new CloseableService(hostAndPort, ScionService.Mode.BOOTSTRAP_SERVER_IP);
    }

    public static CloseableService newServiceWithTopologyFile(String filePath) {
        return new CloseableService(filePath, ScionService.Mode.BOOTSTRAP_TOPO_FILE);
    }

    public static class CloseableService
    extends ScionService
    implements Closeable {
        private CloseableService(String address, ScionService.Mode mode) {
            super(address, mode);
        }
    }
}

