/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionUtil;

class ScionAddress {
    private final long isdAs;
    private final InetAddress ipAddress;

    private ScionAddress(long isdAs, InetAddress ip) {
        this.ipAddress = ip;
        this.isdAs = isdAs;
    }

    static ScionAddress create(long isdAs, InetAddress address) {
        return new ScionAddress(isdAs, address);
    }

    static ScionAddress create(long isdAs, String hostName, byte[] ipBytes) {
        try {
            InetAddress ip = InetAddress.getByAddress(hostName, ipBytes);
            return new ScionAddress(isdAs, ip);
        }
        catch (UnknownHostException e) {
            throw new ScionRuntimeException(e);
        }
    }

    public long getIsdAs() {
        return this.isdAs;
    }

    public String getHostName() {
        return this.ipAddress.getHostName();
    }

    public InetAddress getInetAddress() {
        return this.ipAddress;
    }

    public int getIsd() {
        return ScionUtil.extractIsd(this.isdAs);
    }
}

