/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.DatagramChannel;
import java.time.Instant;
import java.util.List;
import java.util.WeakHashMap;
import org.scion.jpan.AbstractDatagramChannel;
import org.scion.jpan.Path;
import org.scion.jpan.PathMetadata;
import org.scion.jpan.RequestPath;
import org.scion.jpan.ResponsePath;
import org.scion.jpan.Scion;
import org.scion.jpan.ScionException;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionService;
import org.scion.jpan.ScionSocketAddress;
import org.scion.jpan.internal.ByteUtil;
import org.scion.jpan.internal.InternalConstants;
import org.scion.jpan.internal.ScionHeaderParser;

public class ScionDatagramChannel
extends AbstractDatagramChannel<ScionDatagramChannel>
implements ByteChannel,
Closeable {
    private final WeakHashMap<InetSocketAddress, RequestPath> resolvedDestinations = new WeakHashMap();
    private final WeakHashMap<Path, RequestPath> refreshedPaths = new WeakHashMap();

    protected ScionDatagramChannel(ScionService service, DatagramChannel channel) throws IOException {
        super(service, channel);
    }

    public static ScionDatagramChannel open() throws IOException {
        return ScionDatagramChannel.open(Scion.defaultService());
    }

    public static ScionDatagramChannel open(ScionService service) throws IOException {
        return ScionDatagramChannel.open(service, DatagramChannel.open());
    }

    public static ScionDatagramChannel open(ScionService service, DatagramChannel channel) throws IOException {
        return new ScionDatagramChannel(service, channel);
    }

    @Override
    public void configureBlocking(boolean block) throws IOException {
        super.configureBlocking(block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScionSocketAddress receive(ByteBuffer userBuffer) throws IOException {
        this.readLock().lock();
        try {
            ByteBuffer buffer = this.getBufferReceive(userBuffer.capacity());
            ResponsePath receivePath = this.receiveFromChannel(buffer, InternalConstants.HdrTypes.UDP);
            if (receivePath == null) {
                ScionSocketAddress scionSocketAddress = null;
                return scionSocketAddress;
            }
            ScionHeaderParser.extractUserPayload(buffer, userBuffer);
            buffer.clear();
            ScionSocketAddress scionSocketAddress = receivePath.getRemoteSocketAddress();
            return scionSocketAddress;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(ByteBuffer srcBuffer, SocketAddress destination) throws IOException {
        RequestPath path;
        if (!(destination instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Address must be of type InetSocketAddress.");
        }
        if (destination instanceof ScionSocketAddress) {
            return this.send(srcBuffer, ((ScionSocketAddress)destination).getPath(), RefreshPolicy.OFF);
        }
        InetSocketAddress dst = (InetSocketAddress)destination;
        Object object = this.stateLock();
        synchronized (object) {
            path = this.resolvedDestinations.get(dst);
            if (path == null) {
                path = (RequestPath)this.applyFilter(this.getService().lookupPaths(dst), dst).get(0);
                this.resolvedDestinations.put(dst, path);
            }
        }
        return this.send(srcBuffer, path, RefreshPolicy.POLICY);
    }

    public int send(ByteBuffer srcBuffer, Path path) throws IOException {
        return this.send(srcBuffer, path, RefreshPolicy.SAME_LINKS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(ByteBuffer srcBuffer, Path path, RefreshPolicy refresh) throws IOException {
        this.writeLock().lock();
        try {
            ByteBuffer buffer = this.getBufferSend(srcBuffer.remaining());
            this.checkPathAndBuildHeaderUDP(buffer, path, srcBuffer.remaining(), refresh);
            int headerSize = buffer.position();
            try {
                buffer.put(srcBuffer);
            }
            catch (BufferOverflowException e) {
                throw new IOException("Packet is larger than max send buffer size.");
            }
            buffer.flip();
            int size = this.sendRaw(buffer, path);
            int n = size - headerSize;
            return n;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.checkOpen();
        this.checkConnected(true);
        int oldPos = dst.position();
        this.receive(dst);
        return dst.position() - oldPos;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.writeLock().lock();
        try {
            this.checkOpen();
            this.checkConnected(true);
            Path path = this.getConnectionPath();
            ByteBuffer buffer = this.getBufferSend(src.remaining());
            int len = src.remaining();
            this.checkPathAndBuildHeaderUDP(buffer, path, len, RefreshPolicy.POLICY);
            buffer.put(src);
            buffer.flip();
            int sent = this.sendRaw(buffer, path);
            if (sent < buffer.limit() || buffer.remaining() > 0) {
                throw new ScionException("Failed to send all data.");
            }
            int n = len - buffer.remaining();
            return n;
        }
        catch (BufferOverflowException e) {
            throw new IOException("Source buffer larger than MTU", e);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPathAndBuildHeaderUDP(ByteBuffer buffer, Path path, int payloadLength, RefreshPolicy rf) throws IOException {
        Object object = super.stateLock();
        synchronized (object) {
            RequestPath requestPath;
            RequestPath newPath;
            if (path instanceof RequestPath && (newPath = this.refreshPath(requestPath = (RequestPath)path, rf)) != null) {
                this.refreshedPaths.put(path, newPath);
                this.updateConnection(requestPath, true);
            }
            ByteUtil.MutInt srcPort = new ByteUtil.MutInt(-1);
            this.buildHeader(buffer, path, payloadLength + 8, InternalConstants.HdrTypes.UDP, srcPort);
            int dstPort = path.getRemotePort();
            ScionHeaderParser.writeUdpOverlayHeader(buffer, payloadLength, srcPort.get(), dstPort);
        }
    }

    private RequestPath refreshPath(RequestPath path, RefreshPolicy refreshPolicy) {
        int expiryMargin = this.getCfgExpirationSafetyMargin();
        if (Instant.now().getEpochSecond() + (long)expiryMargin <= path.getMetadata().getExpiration()) {
            return null;
        }
        List<Path> paths = this.getService().getPaths(path);
        switch (refreshPolicy) {
            case OFF: {
                if (Instant.now().getEpochSecond() <= path.getMetadata().getExpiration()) {
                    return path;
                }
                throw new ScionRuntimeException("Path is expired");
            }
            case POLICY: {
                return (RequestPath)this.applyFilter(this.getService().getPaths(path), path.getRemoteSocketAddress()).get(0);
            }
            case SAME_LINKS: {
                return this.findPathSameLinks(paths, path);
            }
        }
        throw new UnsupportedOperationException();
    }

    private RequestPath findPathSameLinks(List<Path> paths, RequestPath path) {
        List<PathMetadata.PathInterface> reference = path.getMetadata().getInterfacesList();
        for (Path newPath : paths) {
            List<PathMetadata.PathInterface> ifs = newPath.getMetadata().getInterfacesList();
            if (ifs.size() != reference.size()) continue;
            boolean isSame = true;
            for (int i = 0; i < ifs.size(); ++i) {
                PathMetadata.PathInterface if1 = ifs.get(i);
                PathMetadata.PathInterface if2 = reference.get(i);
                if (if1.getIsdAs() == if2.getIsdAs() && if1.getId() == if2.getId()) continue;
                isSame = false;
                break;
            }
            if (!isSame) continue;
            return (RequestPath)newPath;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getMappedPath(InetSocketAddress address) {
        Object object = this.stateLock();
        synchronized (object) {
            return this.resolvedDestinations.get(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getMappedPath(Path path) {
        if (!(path instanceof RequestPath)) {
            return null;
        }
        Object object = this.stateLock();
        synchronized (object) {
            return this.refreshedPaths.getOrDefault(path, (RequestPath)path);
        }
    }

    public static enum RefreshPolicy {
        OFF,
        SAME_LINKS,
        POLICY;

    }
}

