/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.function.Function;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.internal.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public class DNSHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DNSHelper.class);
    private static final String STR_X_SCION = "x-sciondiscovery";
    private static final String STR_X_SCION_TCP = "x-sciondiscovery:tcp";
    private static final String ERR_PARSING_TXT = "Error parsing TXT entry: ";
    private static final String ERR_PARSING_TXT_LOG = "Error parsing TXT entry: {}";
    private static final String ERR_PARSING_TXT_LOG2 = "Error parsing TXT entry: {} {}";

    private DNSHelper() {
    }

    public static <R> R queryTXT(String hostName, String key, Function<String, R> valueParser) {
        String nameStr = hostName.endsWith(".") ? hostName : hostName + ".";
        try {
            return DNSHelper.queryTXT(Name.fromString((String)nameStr), key, valueParser);
        }
        catch (TextParseException e) {
            LOG.info(ERR_PARSING_TXT_LOG, (Object)e.getMessage());
            return null;
        }
    }

    public static <R> R queryTXT(Name name, String key, Function<String, R> valueParser) {
        Record[] records = DNSHelper.newLookup(name, 16).run();
        if (records == null) {
            return null;
        }
        for (int i = 0; i < records.length; ++i) {
            String data;
            R result;
            TXTRecord txt = (TXTRecord)records[i];
            String entry = txt.rdataToString();
            if (!entry.startsWith("\"" + key + "=")) continue;
            if (entry.endsWith("\"") && (result = valueParser.apply(data = entry.substring(key.length() + 2, entry.length() - 1))) != null) {
                return result;
            }
            LOG.info(ERR_PARSING_TXT_LOG, (Object)entry);
        }
        return null;
    }

    public static InetAddress queryA(Name hostName) {
        Record[] recordsA = DNSHelper.newLookup(hostName, 1).run();
        if (recordsA == null) {
            throw new ScionRuntimeException("No DNS A entry found for host: " + hostName);
        }
        return ((ARecord)recordsA[0]).getAddress();
    }

    public static InetAddress queryAAAA(Name hostName) {
        Record[] recordsA = DNSHelper.newLookup(hostName, 28).run();
        if (recordsA == null) {
            throw new ScionRuntimeException("No DNS AAAA entry found for host: " + hostName);
        }
        return ((AAAARecord)recordsA[0]).getAddress();
    }

    public static String searchForDiscoveryService() {
        List domains;
        String searchDomains = ScionUtil.getPropertyOrEnv("org.scion.dnsSearchDomains", "SCION_DNS_SEARCH_DOMAINS");
        if (searchDomains != null) {
            for (String domain : searchDomains.split(";")) {
                LOG.debug("Checking discovery service domain from environment variable/property: {}", (Object)domain);
                try {
                    String a = DNSHelper.getScionDiscoveryAddress(Name.fromString((String)domain));
                    if (a == null) continue;
                    return a;
                }
                catch (TextParseException e) {
                    throw new ScionRuntimeException(e);
                }
            }
        }
        if ((domains = Lookup.getDefaultSearchPath()).isEmpty()) {
            Name domain = DNSHelper.findSearchDomainViaReverseLookup();
            if (domain != null) {
                domains.add(domain);
            } else {
                LOG.warn("No DNS search domain found. Please check your /etc/resolv.conf or similar. You can also specify a domain via {} or {}", (Object)"SCION_DNS_SEARCH_DOMAINS", (Object)"org.scion.dnsSearchDomains");
            }
        }
        for (Name domain : domains) {
            LOG.debug("Checking discovery service domain: {}", (Object)domain);
            String address = DNSHelper.getScionDiscoveryAddress(domain);
            if (address == null) continue;
            return address;
        }
        return null;
    }

    public static String getScionDiscoveryAddress(String hostName) throws IOException {
        return DNSHelper.getScionDiscoveryAddress(Name.fromString((String)hostName));
    }

    private static String getScionDiscoveryAddress(Name hostName) {
        Record[] records = DNSHelper.newLookup(hostName, 35).run();
        if (records == null) {
            LOG.debug("Checking discovery service NAPTR: no records found");
            return null;
        }
        for (int i = 0; i < records.length; ++i) {
            NAPTRRecord nr = (NAPTRRecord)records[i];
            String naptrService = nr.getService();
            if (!STR_X_SCION_TCP.equals(naptrService)) continue;
            String naptrFlag = nr.getFlags();
            int port = DNSHelper.getScionDiscoveryPort(hostName);
            if ("A".equals(naptrFlag)) {
                InetAddress addr = DNSHelper.queryA(nr.getReplacement());
                return addr.getHostAddress() + ":" + port;
            }
            if (!"AAAA".equals(naptrFlag)) continue;
            InetAddress addr = DNSHelper.queryAAAA(nr.getReplacement());
            return "[" + addr.getHostAddress() + "]:" + port;
        }
        return null;
    }

    private static int getScionDiscoveryPort(Name hostName) {
        Integer discoveryPort = DNSHelper.queryTXT(hostName, STR_X_SCION, (String txtEntry) -> {
            try {
                int port = Integer.parseInt(txtEntry);
                if (port < 0 || port > 65536) {
                    LOG.info(ERR_PARSING_TXT_LOG, txtEntry);
                    return null;
                }
                return port;
            }
            catch (NumberFormatException e) {
                LOG.info(ERR_PARSING_TXT_LOG2, txtEntry, (Object)e.getMessage());
                return null;
            }
        });
        if (discoveryPort == null) {
            throw new ScionRuntimeException("Could not find valid TXT x-sciondiscovery record for host: " + hostName);
        }
        return discoveryPort;
    }

    static Name findSearchDomainViaReverseLookup() {
        try {
            Record[] records6;
            Record[] records4;
            Name reverseLookupHost = Name.fromString((String)"whoami.akamai.net");
            SimpleResolver resolver = new SimpleResolver("zh.akamaitech.net");
            Lookup lookup4 = DNSHelper.newLookup(reverseLookupHost, 1);
            lookup4.setResolver((Resolver)resolver);
            for (Record record4 : records4 = lookup4.run()) {
                ARecord arecord = (ARecord)record4;
                InetAddress localAddress = arecord.getAddress();
                Name domain = DNSHelper.findSearchDomainViaReverseLookup(localAddress);
                if (domain == null) continue;
                return domain;
            }
            Lookup lookup6 = DNSHelper.newLookup(reverseLookupHost, 28);
            lookup6.setResolver((Resolver)resolver);
            for (Record record6 : records6 = lookup6.run()) {
                AAAARecord arecord = (AAAARecord)record6;
                InetAddress localAddress = arecord.getAddress();
                Name domain = DNSHelper.findSearchDomainViaReverseLookup(localAddress);
                if (domain == null) continue;
                return domain;
            }
        }
        catch (UnknownHostException | TextParseException e) {
            throw new ScionRuntimeException(e);
        }
        return null;
    }

    private static Name findSearchDomainViaReverseLookup(InetAddress address) throws TextParseException {
        Name name = Name.fromString((String)DNSHelper.reverseAddressForARPA(address));
        Record[] records = DNSHelper.newLookup(name, 12).run();
        if (records == null) {
            return null;
        }
        block0: for (Record record2 : records) {
            PTRRecord ptrRecord = (PTRRecord)record2;
            Name domain = ptrRecord.getTarget();
            while (DNSHelper.newLookup(domain, 35).run() == null) {
                String domStr = domain.toString(false);
                int pos = domStr.indexOf(46);
                if (pos <= 0 || pos == domStr.length() - 1) continue block0;
                domain = Name.fromString((String)domStr.substring(pos + 1));
            }
            return domain;
        }
        return null;
    }

    static String reverseAddressForARPA(InetAddress address) {
        StringBuilder sb = new StringBuilder();
        if (address instanceof Inet4Address) {
            byte[] ba = address.getAddress();
            for (int i = 0; i < ba.length; ++i) {
                sb.append(ByteUtil.toUnsigned(ba[ba.length - i - 1])).append(".");
            }
            sb.append("in-addr.arpa.");
        } else {
            byte[] ba = address.getAddress();
            for (int i = 0; i < ba.length; ++i) {
                int b = ByteUtil.toUnsigned(ba[ba.length - i - 1]);
                int b0 = b >> 4;
                int b1 = b & 0xF;
                sb.append(Integer.toHexString(b1)).append(".");
                sb.append(Integer.toHexString(b0)).append(".");
            }
            sb.append("ip6.arpa.");
        }
        return sb.toString();
    }

    private static Lookup newLookup(Name name, int type) {
        Lookup lookup = new Lookup(name, type);
        lookup.setHostsFileParser(null);
        return lookup;
    }
}

