/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.internal.ScionBootstrapper;

public class GlobalTopology {
    private final Map<Integer, Isd> world = new HashMap<Integer, Isd>();
    private final boolean isEmpty;

    private GlobalTopology(ScionBootstrapper server) {
        if (server == null) {
            this.isEmpty = true;
        } else {
            this.isEmpty = false;
            this.getTrcFiles(server);
        }
    }

    public static synchronized GlobalTopology create(ScionBootstrapper server) {
        return new GlobalTopology(server);
    }

    public static GlobalTopology createEmpty() {
        return new GlobalTopology(null);
    }

    private static JsonElement safeGet(JsonObject o, String name) {
        JsonElement e = o.get(name);
        if (e == null) {
            throw new ScionRuntimeException("Entry not found in topology file: " + name);
        }
        return e;
    }

    public Optional<Boolean> isCoreAs(long isdAs) {
        if (this.isEmpty) {
            return Optional.empty();
        }
        int isdCode = ScionUtil.extractIsd(isdAs);
        Isd isd = this.world.get(isdCode);
        if (isd == null) {
            throw new ScionRuntimeException("Unknown ISD: " + isdCode);
        }
        for (Long core : isd.coreASes) {
            if (core != isdAs) continue;
            return Optional.of(true);
        }
        return Optional.of(false);
    }

    private void getTrcFiles(ScionBootstrapper server) {
        String filesString = server.fetchFile("trcs");
        this.parseTrcFiles(filesString);
        for (Isd isd : this.world.values()) {
            String fileName = "isd" + isd.isd + "-b" + isd.baseNumber + "-s" + isd.serialNumber;
            String file = server.fetchFile("trcs/" + fileName);
            GlobalTopology.parseTrcFile(file, isd);
        }
    }

    private void parseTrcFiles(String trcFile) {
        JsonElement jsonTree = JsonParser.parseString((String)trcFile);
        JsonArray entries = jsonTree.getAsJsonArray();
        for (int i = 0; i < entries.size(); ++i) {
            JsonObject entry = entries.get(i).getAsJsonObject();
            for (Map.Entry e : entry.entrySet()) {
                JsonObject cs = ((JsonElement)e.getValue()).getAsJsonObject();
                int base = cs.get("base_number").getAsInt();
                int isd = cs.get("isd").getAsInt();
                int serial = cs.get("serial_number").getAsInt();
                this.world.put(isd, new Isd(isd, base, serial));
            }
        }
    }

    private static void parseTrcFile(String trcFile, Isd isd) {
        JsonElement jsonTree = JsonParser.parseString((String)trcFile);
        if (jsonTree.isJsonObject()) {
            JsonObject o = jsonTree.getAsJsonObject();
            JsonArray authoritativeAses = GlobalTopology.safeGet(o, "authoritative_ases").getAsJsonArray();
            for (int i = 0; i < authoritativeAses.size(); ++i) {
                String isdCode = authoritativeAses.get(i).getAsString();
                isd.authorativeASes.add(ScionUtil.parseIA(isdCode));
            }
            JsonArray coreAses = GlobalTopology.safeGet(o, "core_ases").getAsJsonArray();
            for (int i = 0; i < coreAses.size(); ++i) {
                String isdCode = coreAses.get(i).getAsString();
                isd.coreASes.add(ScionUtil.parseIA(isdCode));
            }
            isd.description = GlobalTopology.safeGet(o, "description").getAsString();
            JsonObject id = GlobalTopology.safeGet(o, "id").getAsJsonObject();
            int base = id.get("base_number").getAsInt();
            int isdCode = id.get("isd").getAsInt();
            int serial = id.get("serial_number").getAsInt();
            if (isd.isd != isdCode || isd.baseNumber != base || isd.serialNumber != serial) {
                throw new IllegalStateException("ISD/Base/Serial mismatch in TRC file.");
            }
            JsonObject validity = GlobalTopology.safeGet(o, "validity").getAsJsonObject();
            String afterStr = validity.get("not_after").getAsString();
            String beforeStr = validity.get("not_before").getAsString();
            isd.notAfter = Instant.parse(afterStr);
            isd.notBefore = Instant.parse(beforeStr);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Isd isd : this.world.values()) {
            sb.append("ISD:   ").append(isd).append('\n');
        }
        return sb.toString();
    }

    private static class Isd {
        String description;
        int baseNumber;
        int isd;
        int serialNumber;
        Instant notAfter;
        Instant notBefore;
        final List<Long> authorativeASes = new ArrayList<Long>();
        final List<Long> coreASes = new ArrayList<Long>();

        Isd(int isd, int base, int serial) {
            this.isd = isd;
            this.baseNumber = base;
            this.serialNumber = serial;
        }

        public String toString() {
            return "{description='" + this.description + '\'' + ", baseNumber=" + this.baseNumber + ", isd=" + this.isd + ", serialNumber=" + this.serialNumber + ", notAfter=" + this.notAfter + ", notBefore=" + this.notBefore + ", authorativeASes=" + this.authorativeASes + ", coreASes=" + this.coreASes + '}';
        }
    }
}

