/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.scion.jpan.internal.MultiMap;
import org.scion.jpan.internal.PathRawParserLight;
import org.scion.jpan.proto.daemon.Daemon;

class PathDuplicationFilter {
    MultiMap<Integer, Entry> paths = new MultiMap();

    PathDuplicationFilter() {
    }

    void checkDuplicatePaths(Daemon.Path.Builder path) {
        int[] interfaces = PathDuplicationFilter.extractInterfaces(path);
        int hash = Arrays.hashCode(interfaces);
        if (this.paths.contains(hash)) {
            for (Entry storedPath : this.paths.get(hash)) {
                if (!Arrays.equals(interfaces, storedPath.interfaces)) continue;
                if (path.getExpiration().getSeconds() > storedPath.path.getExpiration().getSeconds()) {
                    storedPath.update(path.build(), interfaces);
                }
                return;
            }
        }
        this.paths.put(hash, new Entry(path.build(), interfaces));
    }

    public List<Daemon.Path> getPaths() {
        List<Entry> entries = this.paths.values();
        ArrayList<Daemon.Path> result = new ArrayList<Daemon.Path>(entries.size());
        for (Entry entry : entries) {
            result.add(entry.path);
        }
        return result;
    }

    private static int[] extractInterfaces(Daemon.Path.Builder path) {
        ByteBuffer raw = path.getRaw().asReadOnlyByteBuffer();
        int[] segLen = PathRawParserLight.getSegments(raw);
        int segCount = PathRawParserLight.calcSegmentCount(segLen);
        int[] result = new int[PathRawParserLight.extractHopCount(segLen) * 2];
        int offset = 0;
        int ifPos = 0;
        for (int j = 0; j < segLen.length; ++j) {
            boolean flagC = PathRawParserLight.extractInfoFlagC(raw, j);
            for (int i = offset; i < offset + segLen[j] - 1; ++i) {
                if (flagC) {
                    result[ifPos++] = PathRawParserLight.extractHopFieldEgress(raw, segCount, i);
                    result[ifPos++] = PathRawParserLight.extractHopFieldIngress(raw, segCount, i + 1);
                    continue;
                }
                result[ifPos++] = PathRawParserLight.extractHopFieldIngress(raw, segCount, i);
                result[ifPos++] = PathRawParserLight.extractHopFieldEgress(raw, segCount, i + 1);
            }
            offset += segLen[j];
        }
        return result;
    }

    private static class Entry {
        Daemon.Path path;
        int[] interfaces;

        public Entry(Daemon.Path path, int[] interfaces) {
            this.path = path;
            this.interfaces = interfaces;
        }

        public void update(Daemon.Path path, int[] interfaces) {
            this.path = path;
            this.interfaces = interfaces;
        }
    }
}

