/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.nio.ByteBuffer;
import org.scion.jpan.internal.ByteUtil;

public class PathRawParserLight {
    private static final int PATH_META_LEN = 4;
    private static final int PATH_INFO_LEN = 8;
    private static final int HOP_FIELD_LEN = 12;

    private PathRawParserLight() {
    }

    public static int[] getSegments(ByteBuffer data) {
        int i0 = data.getInt(data.position());
        int[] segLen = new int[]{ByteUtil.readInt(i0, 14, 6), ByteUtil.readInt(i0, 20, 6), ByteUtil.readInt(i0, 26, 6)};
        return segLen;
    }

    public static boolean extractInfoFlagC(ByteBuffer data, int segID) {
        int i0 = data.getInt(4 + segID * 8);
        return ByteUtil.readBoolean(i0, 7);
    }

    public static int extractHopCount(int[] segLen) {
        int nHops = segLen[0] + segLen[1] + segLen[2];
        return nHops;
    }

    public static int extractHopCount(ByteBuffer data) {
        int i0 = data.getInt(data.position());
        int nHops = 0;
        nHops += ByteUtil.readInt(i0, 14, 6);
        nHops += ByteUtil.readInt(i0, 20, 6);
        return nHops += ByteUtil.readInt(i0, 26, 6);
    }

    public static int extractHopFieldIngress(ByteBuffer data, int segCount, int hopID) {
        int hfOffset = 4 + segCount * 8 + hopID * 12;
        return ByteUtil.toUnsigned(data.getShort(data.position() + hfOffset + 2));
    }

    public static int extractHopFieldEgress(ByteBuffer data, int segCount, int hopID) {
        int hfOffset = 4 + segCount * 8 + hopID * 12;
        return ByteUtil.toUnsigned(data.getShort(data.position() + hfOffset + 4));
    }

    public static int[] extractHopFieldInterfaceIDs(ByteBuffer data, int hopID) {
        int segCount = PathRawParserLight.extractSegmentCount(data);
        int hfOffset = 4 + segCount * 8 + hopID * 12;
        int[] result = new int[]{ByteUtil.toUnsigned(data.getShort(data.position() + hfOffset + 2)), ByteUtil.toUnsigned(data.getShort(data.position() + hfOffset + 4))};
        return result;
    }

    public static int extractSegmentCount(ByteBuffer data) {
        int i0 = data.getInt(data.position());
        int segmentCount = 0;
        segmentCount += ByteUtil.readInt(i0, 14, 6) > 0 ? 1 : 0;
        segmentCount += ByteUtil.readInt(i0, 20, 6) > 0 ? 1 : 0;
        return segmentCount += ByteUtil.readInt(i0, 26, 6) > 0 ? 1 : 0;
    }

    public static int calcSegmentCount(int[] segLen) {
        int segmentCount = 1;
        segmentCount += segLen[1] > 0 ? 1 : 0;
        return segmentCount += segLen[2] > 0 ? 1 : 0;
    }
}

