/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.zip.CRC32;
import org.scion.jpan.ScionRuntimeException;
import org.scion.jpan.internal.ByteUtil;
import org.scion.jpan.internal.InternalConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STUN {
    private static final Logger log = LoggerFactory.getLogger(STUN.class);
    private static final SecureRandom rnd = new SecureRandom();
    private static final int MAGIC_COOKIE = 554869826;
    private static final int FINGERPRINT_XOR = 1398035790;
    private static final boolean ADD_FINGERPRINT = true;
    private static final String SOFTWARE_ID = "jpan.scion.org v0.4.0";

    public static boolean isStunPacket(ByteBuffer buf, TransactionID id) {
        try {
            return buf.getShort(2) + 20 == buf.remaining() && buf.getInt(4) == 554869826 && buf.getInt(8) == id.id0 && buf.getInt(12) == id.id1 && buf.getInt(16) == id.id2;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean isStunResponse(ByteBuffer buf, TransactionID id) {
        byte b0 = buf.get(0);
        byte b1 = buf.get(1);
        return STUN.isStunPacket(buf, id) && b0 == 1 && b1 == 1;
    }

    public static boolean isStunRequest(ByteBuffer buf) {
        return buf.get(0) == 0 && buf.get(1) == 1 && buf.getShort(2) + 20 == buf.remaining() && buf.getInt(4) == 554869826;
    }

    public static InetSocketAddress parseResponse(ByteBuffer in, Predicate<TransactionID> idHandler, ByteUtil.MutRef<TransactionID> txIdOut, ByteUtil.MutRef<String> error) {
        STUN.parseHeader(in, idHandler, txIdOut, error);
        if (error.get() != null) {
            return null;
        }
        return STUN.parseBody(in, error);
    }

    public static TransactionID parseRequest(ByteBuffer in) {
        ByteUtil.MutRef<String> error = new ByteUtil.MutRef<String>();
        ByteUtil.MutRef<TransactionID> txIdOut = new ByteUtil.MutRef<TransactionID>();
        STUN.parseHeader(in, transactionID -> true, txIdOut, error);
        if (error.get() != null) {
            return null;
        }
        return txIdOut.get();
    }

    private static void parseHeader(ByteBuffer in, Predicate<TransactionID> idHandler, ByteUtil.MutRef<TransactionID> txIdOut, ByteUtil.MutRef<String> error) {
        if (in.remaining() < 20) {
            error.set("STUN validation error, packet too short.");
            return;
        }
        in.get();
        in.get();
        short dataLength = in.getShort();
        if (in.remaining() - 16 != dataLength) {
            error.set("STUN validation error, invalid length.");
            return;
        }
        int magic = in.getInt();
        if (magic != 554869826) {
            error.set("STUN validation error, invalid MAGIC_COOKIE.");
            return;
        }
        int txId1 = in.getInt();
        int txId2 = in.getInt();
        int txId3 = in.getInt();
        TransactionID id = TransactionID.from(txId1, txId2, txId3);
        txIdOut.set(id);
        if (!idHandler.test(id)) {
            error.set("STUN validation error, TxID validation failed.");
        }
    }

    private static InetSocketAddress parseBody(ByteBuffer in, ByteUtil.MutRef<String> error) {
        InetSocketAddress mappedAddress = null;
        InetSocketAddress mappedAddressXor = null;
        in.position(in.position() - 16);
        byte[] txId = new byte[16];
        in.get(txId);
        block13: while (in.remaining() > 0) {
            int typeInt = ByteUtil.toUnsigned(in.getShort());
            short len = in.getShort();
            Type typeEnum = Type.parse(typeInt);
            switch (typeEnum) {
                case MAPPED_ADDRESS: {
                    mappedAddress = STUN.readMappedAddress(in);
                    log.info("MAPPED_ADDRESS: {}", (Object)mappedAddress);
                    continue block13;
                }
                case WAS_SOURCE_ADDRESS: {
                    log.info("SOURCE_ADDRESS: {}", (Object)STUN.readMappedAddress(in));
                    continue block13;
                }
                case WAS_CHANGED_ADDRESS: {
                    log.info("CHANGED_ADDRESS: {}", (Object)STUN.readMappedAddress(in));
                    continue block13;
                }
                case XOR_MAPPED_ADDRESS: {
                    mappedAddressXor = STUN.readXorMappedAddress(in, txId);
                    log.info("XOR_MAPPED_ADDRESS: {}", (Object)mappedAddressXor);
                    continue block13;
                }
                case OLD_XOR_MAPPED_ADDRESS: {
                    mappedAddressXor = STUN.readXorMappedAddress(in, txId);
                    log.info("OLD_XOR_MAPPED_ADDRESS: {}", (Object)mappedAddressXor);
                    continue block13;
                }
                case SOFTWARE: {
                    String software = STUN.readSoftware(in, len);
                    log.info("SOFTWARE: {}", (Object)software);
                    continue block13;
                }
                case XXX_RESERVATION_TOKEN: {
                    in.position(in.position() + len);
                    continue block13;
                }
                case ERROR_CODE: {
                    String errorMessage = STUN.readErrorCode(in);
                    error.set(errorMessage);
                    log.error(errorMessage);
                    continue block13;
                }
                case FINGERPRINT: {
                    boolean match = STUN.readFingerprint(in);
                    log.info("FINGERPRINT: match = {}", (Object)match);
                    if (match) continue block13;
                    return null;
                }
                case RESPONSE_ORIGIN: {
                    log.info("RESPONSE_ORIGIN: {}", (Object)STUN.readMappedAddress(in));
                    continue block13;
                }
                case OTHER_ADDRESS: {
                    log.info("OTHER_ADDRESS: {}", (Object)STUN.readMappedAddress(in));
                    continue block13;
                }
            }
            byte[] data = new byte[len];
            in.get(data);
            error.set("ERROR: Type not implemented: " + typeEnum);
            log.error(error.get());
            return null;
        }
        if (mappedAddress != null && mappedAddressXor != null && !mappedAddress.equals(mappedAddressXor)) {
            log.error("Mismatch: {} <-> {}", (Object)mappedAddress, (Object)mappedAddressXor);
        }
        return mappedAddressXor != null ? mappedAddressXor : mappedAddress;
    }

    private static boolean readFingerprint(ByteBuffer in) {
        int fpPos = in.position() - 4;
        int packetCRC = in.getInt();
        CRC32 crc32 = new CRC32();
        in.flip();
        in.position(0);
        in.limit(fpPos);
        crc32.update(in);
        in.limit(fpPos + 8);
        long fingerprintLong = crc32.getValue() ^ 0x5354554EL;
        int fingerPrint32 = ByteUtil.toInt(fingerprintLong);
        in.position(fpPos + 8);
        if (packetCRC != fingerPrint32) {
            log.error("FINGERPRINT mismatch: packet = {} vs calculated = {}", (Object)packetCRC, (Object)fingerPrint32);
            return false;
        }
        return true;
    }

    private static String readErrorCode(ByteBuffer in) {
        int i0 = in.getInt();
        int errorClass = ByteUtil.readInt(i0, 21, 3);
        int errorNumber = ByteUtil.readInt(i0, 24, 8);
        int errorCode = errorClass * 100 + errorNumber;
        byte[] bytes = new byte[in.remaining()];
        in.get(bytes);
        String msg = new String(bytes);
        if (!STUN.processError(errorCode).isEmpty()) {
            msg = msg + "\n" + STUN.processError(errorCode);
        }
        return "Remote error " + errorCode + ": " + msg;
    }

    private static InetSocketAddress readMappedAddress(ByteBuffer in) {
        byte[] bytes;
        in.get();
        byte family = in.get();
        int port = ByteUtil.toUnsigned(in.getShort());
        if (family == 1) {
            bytes = new byte[4];
        } else if (family == 2) {
            bytes = new byte[16];
        } else {
            log.error("Unknown address family for MAPPED_ADDRESS: {}", (Object)family);
            return null;
        }
        in.get(bytes);
        try {
            InetAddress address = InetAddress.getByAddress(bytes);
            return new InetSocketAddress(address, port);
        }
        catch (UnknownHostException e) {
            throw new ScionRuntimeException(e);
        }
    }

    private static String readSoftware(ByteBuffer in, int length) {
        length = length + 3 & 0xFFFC;
        byte[] bytes = new byte[length];
        in.get(bytes);
        return new String(bytes);
    }

    private static InetSocketAddress readXorMappedAddress(ByteBuffer in, byte[] id) {
        byte[] bytes;
        in.get();
        byte family = in.get();
        int port = ByteUtil.toUnsigned(in.getShort());
        port ^= 0x2112;
        if (family == 1) {
            bytes = new byte[4];
        } else if (family == 2) {
            bytes = new byte[16];
        } else {
            log.error("Unknown address family for XOR_MAPPED_ADDRESS: {}", (Object)family);
            return null;
        }
        in.get(bytes);
        STUN.xorBytes(bytes, id);
        try {
            InetAddress address = InetAddress.getByAddress(bytes);
            return new InetSocketAddress(address, port);
        }
        catch (UnknownHostException e) {
            throw new ScionRuntimeException(e);
        }
    }

    private static void xorBytes(byte[] bytes, byte[] bytes2) {
        for (int i = 0; i < bytes.length; ++i) {
            int n = i;
            bytes[n] = (byte)(bytes[n] ^ bytes2[i]);
        }
    }

    private static String processError(int errorCode) {
        switch (errorCode) {
            case 300: {
                return "Try Alternate: The client should contact an alternate server for\nthis request.  This error response MUST only be sent if the\nrequest included a USERNAME attribute and a valid MESSAGE-\nINTEGRITY attribute; otherwise, it MUST NOT be sent and error\ncode 400 (Bad Request) is suggested.  This error response MUST\nbe protected with the MESSAGE-INTEGRITY attribute, and receivers\nMUST validate the MESSAGE-INTEGRITY of this response before\nredirecting themselves to an alternate server.\n\nNote: Failure to generate and validate message integrity\nfor a 300 response allows an on-path attacker to falsify\na 300 response thus causing subsequent STUN messages to be\nsent to a victim.";
            }
            case 400: {
                return "Bad Request: The request was malformed.  The client SHOULD NOT\nretry the request without modification from the previous\nattempt.  The server may not be able to generate a valid\nMESSAGE-INTEGRITY for this error, so the client MUST NOT expect\na valid MESSAGE-INTEGRITY attribute on this response.";
            }
            case 401: {
                return "Unauthorized: The request did not contain the correct\ncredentials to proceed.  The client should retry the request\nwith proper credentials.";
            }
            case 420: {
                return "Unknown Attribute: The server received a STUN packet containing\na comprehension-required attribute that it did not understand.\nThe server MUST put this unknown attribute in the UNKNOWN-\nATTRIBUTE attribute of its error response.";
            }
            case 438: {
                return "Stale Nonce: The NONCE used by the client was no longer valid.\nThe client should retry, using the NONCE provided in the\nresponse.";
            }
            case 500: {
                return "Server Error: The server has suffered a temporary error.  The\nclient should try again.";
            }
        }
        return "Unknown error " + errorCode;
    }

    private static void writeAttribute(ByteBuffer out, Type type, Runnable writer) {
        out.putShort(ByteUtil.toShort(type.code()));
        int posLength = out.position();
        out.putShort((short)0);
        int posBegin = out.position();
        writer.run();
        int posEnd = out.position();
        out.putShort(posLength, ByteUtil.toShort(posEnd - posBegin));
    }

    private static void writeMappedAddress(ByteBuffer out, InetSocketAddress address) {
        byte[] addrBytes = address.getAddress().getAddress();
        out.put((byte)0);
        out.put((byte)(addrBytes.length == 4 ? 1 : 2));
        out.putShort(ByteUtil.toShort(address.getPort()));
        out.put(addrBytes);
    }

    private static void writeSoftware(ByteBuffer out) {
        byte[] softwareBytes = SOFTWARE_ID.getBytes();
        int softwareLength = softwareBytes.length + 3 & 0xFFFC;
        out.put(softwareBytes);
        for (int i = softwareBytes.length; i < softwareLength; ++i) {
            out.put((byte)0);
        }
    }

    private static void writeXorMappedAddress(ByteBuffer out, byte[] id, InetSocketAddress address) {
        out.put((byte)0);
        byte[] addrBytes = address.getAddress().getAddress();
        out.put((byte)(addrBytes.length == 4 ? 1 : 2));
        out.putShort(ByteUtil.toShort(address.getPort() ^ 0x2112));
        STUN.xorBytes(addrBytes, id);
        out.put(addrBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TransactionID createTxID() {
        SecureRandom secureRandom = rnd;
        synchronized (secureRandom) {
            return new TransactionID(rnd);
        }
    }

    public static TransactionID writeRequest(ByteBuffer buffer) {
        buffer.put(ByteUtil.toByte(0));
        buffer.put(ByteUtil.toByte(1));
        buffer.putShort((short)0);
        buffer.putInt(554869826);
        TransactionID id = STUN.createTxID();
        buffer.putInt(id.id0);
        buffer.putInt(id.id1);
        buffer.putInt(id.id2);
        byte[] softwareBytes = SOFTWARE_ID.getBytes();
        int softwareLength = softwareBytes.length + 3 & 0xFFFC;
        buffer.putShort(ByteUtil.toShort(32802L));
        buffer.putShort(ByteUtil.toShort(softwareLength));
        buffer.put(softwareBytes);
        for (int i = softwareBytes.length; i < softwareLength; ++i) {
            buffer.put((byte)0);
        }
        int fpPos = buffer.position();
        buffer.putShort(ByteUtil.toShort(Type.FINGERPRINT.code()));
        buffer.putShort(ByteUtil.toShort(4L));
        buffer.putInt(0);
        buffer.putShort(2, (short)(buffer.position() - 20));
        CRC32 crc32 = new CRC32();
        buffer.flip();
        buffer.position(0);
        buffer.limit(fpPos);
        crc32.update(buffer);
        buffer.limit(fpPos + 8);
        buffer.position(fpPos + 4);
        long fingerprint = crc32.getValue() ^ 0x5354554EL;
        buffer.putInt(ByteUtil.toInt(fingerprint));
        return id;
    }

    public static void writeResponse(ByteBuffer buffer, TransactionID txId, InetSocketAddress src) {
        buffer.put(ByteUtil.toByte(1));
        buffer.put(ByteUtil.toByte(1));
        buffer.putShort((short)0);
        buffer.putInt(554869826);
        buffer.putInt(txId.id0);
        buffer.putInt(txId.id1);
        buffer.putInt(txId.id2);
        STUN.writeAttribute(buffer, Type.MAPPED_ADDRESS, () -> STUN.writeMappedAddress(buffer, src));
        byte[] id = new byte[16];
        int pos = buffer.position();
        buffer.position(4);
        buffer.get(id);
        buffer.position(pos);
        STUN.writeAttribute(buffer, Type.XOR_MAPPED_ADDRESS, () -> STUN.writeXorMappedAddress(buffer, id, src));
        STUN.writeAttribute(buffer, Type.SOFTWARE, () -> STUN.writeSoftware(buffer));
        int fpPos = buffer.position();
        buffer.putShort(ByteUtil.toShort(Type.FINGERPRINT.code()));
        buffer.putShort(ByteUtil.toShort(4L));
        buffer.putInt(0);
        buffer.putShort(2, (short)(buffer.position() - 20));
        CRC32 crc32 = new CRC32();
        buffer.flip();
        buffer.position(0);
        buffer.limit(fpPos);
        crc32.update(buffer);
        buffer.limit(fpPos + 8);
        buffer.position(fpPos + 4);
        long fingerprint = crc32.getValue() ^ 0x5354554EL;
        buffer.putInt(ByteUtil.toInt(fingerprint));
    }

    public static class TransactionID {
        final int id0;
        final int id1;
        final int id2;

        TransactionID(Random rnd) {
            this.id0 = rnd.nextInt();
            this.id1 = rnd.nextInt();
            this.id2 = rnd.nextInt();
        }

        TransactionID(int id0, int id1, int id2) {
            this.id0 = id0;
            this.id1 = id1;
            this.id2 = id2;
        }

        public static TransactionID from(int id0, int id1, int id2) {
            return new TransactionID(id0, id1, id2);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransactionID that = (TransactionID)o;
            return this.id0 == that.id0 && this.id1 == that.id1 && this.id2 == that.id2;
        }

        public int hashCode() {
            return Objects.hash(this.id0, this.id1, this.id2);
        }
    }

    static enum Type implements InternalConstants.ParseEnum
    {
        RESERVED_0(0, "(Reserved)"),
        MAPPED_ADDRESS(1, "MAPPED_ADDRESS"),
        WAS_RESPONSE_ADDRESS(2, "(Reserved; was RESPONSE-ADDRESS)"),
        WAS_CHANGE_REQUEST(3, "(Reserved; was CHANGE-ADDRESS)"),
        WAS_SOURCE_ADDRESS(4, "(Reserved; was SOURCE-ADDRESS)"),
        WAS_CHANGED_ADDRESS(5, "(Reserved; was CHANGED-ADDRESS)"),
        USERNAME(6, "USERNAME"),
        WAS_PASSWORD(7, "(Reserved; was PASSWORD)"),
        MESSAGE_INTEGRITY(8, "MESSAGE-INTEGRITY"),
        ERROR_CODE(9, "ERROR-CODE"),
        UNKNOWN_ATTRIBUTES(10, "UNKNOWN-ATTRIBUTES"),
        WAS_REFLECTED_FROM(11, "(Reserved; was REFLECTED-FROM)"),
        REALM(20, "REALM"),
        NONCE(21, "NONCE"),
        XOR_MAPPED_ADDRESS(32, "XOR-MAPPED-ADDRESS"),
        XXX_RESERVATION_TOKEN(34, "RESERVATION-TOKEN"),
        OLD_XOR_MAPPED_ADDRESS(32800, "XOR-MAPPED-ADDRESS"),
        SOFTWARE(32802, "SOFTWARE"),
        ALTERNATE_SERVER(32803, "ALTERNATE-SERVER"),
        FINGERPRINT(32808, "FINGERPRINT"),
        RESPONSE_ORIGIN(32811, "RESPONSE-ORIGIN"),
        OTHER_ADDRESS(32812, "OTHER-ADDRESS");

        final int id;
        final String text;

        private Type(int id, String text) {
            this.id = id;
            this.text = text;
        }

        public static Type parse(int id) {
            return InternalConstants.ParseEnum.parse(Type.class, id);
        }

        @Override
        public int code() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "0x" + Integer.toHexString(this.code()) + ": '" + this.getText() + '\'';
        }
    }
}

