/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.ppl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.scion.jpan.Path;
import org.scion.jpan.PathMetadata;
import org.scion.jpan.ppl.HopPredicate;
import org.scion.jpan.ppl.PplException;

class ACL {
    static final String ERR_NO_DEFAULT = "ACL does not have a default";
    static final String ERR_EXTRA_ENTRIES = "ACL has unused extra entries after a default entry";
    private final AclEntry[] entries;
    private static final String DENY_SYMBOL = "-";
    private static final String ALLOW_SYMBOL = "+";

    static ACL create(AclEntry ... entries) {
        ACL.validateACL(entries);
        return new ACL(entries);
    }

    static ACL createNoValidate(AclEntry ... entries) {
        return new ACL(entries);
    }

    private ACL(AclEntry ... entries) {
        this.entries = entries;
    }

    List<Path> eval(List<Path> paths) {
        if (this.entries.length == 0) {
            return paths;
        }
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path path : paths) {
            if (this.evalPath(path.getMetadata()) != AclAction.ALLOW) continue;
            result.add(path);
        }
        return result;
    }

    AclAction evalPath(PathMetadata pm) {
        for (int i = 0; i < pm.getInterfacesList().size(); ++i) {
            PathMetadata.PathInterface iface = pm.getInterfacesList().get(i);
            if (this.evalInterface(iface, i % 2 != 0) != AclAction.DENY) continue;
            return AclAction.DENY;
        }
        return AclAction.ALLOW;
    }

    AclAction evalInterface(PathMetadata.PathInterface iface, boolean ingress) {
        for (AclEntry aclEntry : this.entries) {
            if (aclEntry.rule != null && !aclEntry.rule.pathIFMatch(iface, ingress)) continue;
            return aclEntry.action;
        }
        throw new PplException("Default ACL action missing");
    }

    private static void validateACL(AclEntry[] entries) {
        if (entries.length == 0) {
            throw new PplException(ERR_NO_DEFAULT);
        }
        int foundAt = -1;
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].rule != null && !entries[i].rule.matchesAll()) continue;
            foundAt = i;
            break;
        }
        if (foundAt < 0) {
            throw new PplException(ERR_NO_DEFAULT);
        }
        if (foundAt != entries.length - 1) {
            throw new PplException(ERR_EXTRA_ENTRIES);
        }
    }

    public JsonElement toJson() {
        JsonArray array = new JsonArray(this.entries.length);
        for (AclEntry entry : this.entries) {
            array.add(entry.string());
        }
        return array;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ACL acl = (ACL)o;
        return Objects.deepEquals(this.entries, acl.entries);
    }

    public int hashCode() {
        return Arrays.hashCode(this.entries);
    }

    public String toString() {
        return "ACL{entries=" + Arrays.toString(this.entries) + '}';
    }

    private static enum AclAction {
        DENY,
        ALLOW;

    }

    static class AclEntry {
        private final AclAction action;
        private final HopPredicate rule;

        private AclEntry(AclAction action, HopPredicate rule) {
            this.action = action;
            this.rule = rule;
        }

        static AclEntry create(String str) {
            String[] parts = str.split(" ");
            if (parts.length == 1) {
                return new AclEntry(AclEntry.getAction(parts[0]), null);
            }
            if (parts.length == 2) {
                return new AclEntry(AclEntry.getAction(parts[0]), HopPredicate.fromString(parts[1]));
            }
            throw new PplException("ACLEntry has too many parts: " + str);
        }

        public static AclEntry create(boolean allow, String hopFieldPredicate) {
            HopPredicate hp = hopFieldPredicate == null ? null : HopPredicate.fromString(hopFieldPredicate);
            return new AclEntry(allow ? AclAction.ALLOW : AclAction.DENY, hp);
        }

        String string() {
            String ruleStr;
            String str = ACL.DENY_SYMBOL;
            if (this.action == AclAction.ALLOW) {
                str = ACL.ALLOW_SYMBOL;
            }
            if (this.rule != null && !(ruleStr = this.rule.string()).equals("0")) {
                str = str + " " + ruleStr;
            }
            return str;
        }

        public String toString() {
            return "AclEntry{action=" + (Object)((Object)this.action) + ", rule=" + this.rule + '}';
        }

        private static AclAction getAction(String symbol) {
            if (ACL.ALLOW_SYMBOL.equals(symbol)) {
                return AclAction.ALLOW;
            }
            if (ACL.DENY_SYMBOL.equals(symbol)) {
                return AclAction.DENY;
            }
            throw new PplException("Bad action symbol: action=" + symbol);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AclEntry aclEntry = (AclEntry)o;
            return this.action == aclEntry.action && Objects.equals(this.rule, aclEntry.rule);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.action, this.rule});
        }
    }
}

