/*
 * Decompiled with CFR 0.152.
 */
package org.scion.jpan.ppl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.scion.jpan.Path;
import org.scion.jpan.PathMetadata;
import org.scion.jpan.ScionUtil;
import org.scion.jpan.antlr.SequenceBaseListener;
import org.scion.jpan.antlr.SequenceLexer;
import org.scion.jpan.antlr.SequenceParser;
import org.scion.jpan.ppl.PplException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Sequence {
    private static final Logger LOG = LoggerFactory.getLogger((String)Sequence.class.getName());
    private static final String ISD_WILDCARD = "([0-9]+)";
    private static final String AS_WILDCARD = "(([0-9]+)|([0-9a-fA-F]+:[0-9a-fA-F]+:[0-9a-fA-F]+))";
    private static final String IF_WILDCARD = "([0-9]+)";
    private final Pattern re;
    private final String srcstr;
    private final String restr;

    private Sequence(Pattern re, String srcstr, String restr) {
        this.re = re;
        this.srcstr = srcstr;
        this.restr = restr;
    }

    static Sequence create(String s) {
        try {
            Pattern re;
            LOG.info("COMPILING: {}", (Object)s);
            if (s == null || s.isEmpty()) {
                return new Sequence(null, null, null);
            }
            ANTLRInputStream istream = new ANTLRInputStream((Reader)new StringReader(s));
            SequenceLexer lexer = new SequenceLexer((CharStream)istream);
            lexer.removeErrorListeners();
            ErrorListener errListener = new ErrorListener();
            lexer.addErrorListener(errListener);
            CommonTokenStream tstream = new CommonTokenStream((TokenSource)lexer, 0);
            SequenceParser parser = new SequenceParser((TokenStream)tstream);
            parser.removeErrorListeners();
            parser.addErrorListener(errListener);
            MySequenceListener listener = new MySequenceListener();
            new ParseTreeWalker().walk((ParseTreeListener)listener, (ParseTree)parser.start());
            if (errListener.msg != null) {
                throw new PplException("Failed to parse a sequence: sequence=" + s + " ;msg=" + errListener.msg);
            }
            String restr = String.format("^%s$", listener.stack.get(0));
            try {
                re = Pattern.compile(restr);
            }
            catch (Exception e) {
                throw new PplException("Error while parsing sequence regexp: regexp=" + restr);
            }
            return new Sequence(re, s, restr);
        }
        catch (IOException e) {
            LOG.error("Error while compiling path policy from: {}", (Object)s);
            throw new PplException("Error while compiling path policy from: " + s, e);
        }
    }

    List<Path> eval(List<Path> paths) {
        if (this.re == null || "".equals(this.srcstr)) {
            return paths;
        }
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path path : paths) {
            String desc;
            block4: {
                try {
                    desc = Sequence.getSequence(path);
                    if (desc.isEmpty()) break block4;
                    desc = desc + " ";
                }
                catch (Exception e) {
                    LOG.error("get sequence from path", (Throwable)e);
                    continue;
                }
            }
            if (!this.re.matcher(desc).matches()) continue;
            result.add(path);
        }
        return result;
    }

    private static String hop(long isdAs, long ingress, long egress) {
        return String.format("%s#%d,%d", ScionUtil.toStringIA(isdAs), ingress, egress);
    }

    static String getSequence(Path path) {
        List<PathMetadata.PathInterface> ifaces = path.getMetadata().getInterfacesList();
        if (ifaces.size() % 2 != 0) {
            throw new PplException("Invalid path with odd number of hops: path=" + path);
        }
        if (ifaces.isEmpty()) {
            return "";
        }
        StringBuilder hops = new StringBuilder();
        hops.append(Sequence.hop(ifaces.get(0).getIsdAs(), 0L, ifaces.get(0).getId()));
        hops.append(" ");
        for (int i = 1; i < ifaces.size() - 1; i += 2) {
            hops.append(Sequence.hop(ifaces.get(i).getIsdAs(), ifaces.get(i).getId(), ifaces.get(i + 1).getId()));
            hops.append(" ");
        }
        hops.append(Sequence.hop(ifaces.get(ifaces.size() - 1).getIsdAs(), ifaces.get(ifaces.size() - 1).getId(), 0L));
        return hops.toString();
    }

    String getSourceString() {
        return this.srcstr;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sequence sequence = (Sequence)o;
        return Objects.equals(this.re.toString(), sequence.re.toString()) && Objects.equals(this.srcstr, sequence.srcstr) && Objects.equals(this.restr, sequence.restr);
    }

    public int hashCode() {
        return Objects.hash(this.re, this.srcstr, this.restr);
    }

    public String toString() {
        return "Sequence{re=" + this.re + ", srcstr='" + this.srcstr + '\'' + ", restr='" + this.restr + '\'' + '}';
    }

    private static class MySequenceListener
    extends SequenceBaseListener {
        List<String> stack = new ArrayList<String>();

        private MySequenceListener() {
        }

        void push(String s) {
            this.stack.add(s);
        }

        String pop() {
            String result = this.stack.isEmpty() ? "X" : this.stack.remove(this.stack.size() - 1);
            return result;
        }

        @Override
        public void exitStart(SequenceParser.StartContext c) {
            String re = this.pop();
            this.push(re);
        }

        @Override
        public void exitQuestionMark(SequenceParser.QuestionMarkContext c) {
            String re = String.format("(%s)?", this.pop());
            this.push(re);
        }

        @Override
        public void exitPlus(SequenceParser.PlusContext c) {
            String re = String.format("(%s)+", this.pop());
            this.push(re);
        }

        @Override
        public void exitAsterisk(SequenceParser.AsteriskContext c) {
            String re = String.format("(%s)*", this.pop());
            this.push(re);
        }

        @Override
        public void exitOr(SequenceParser.OrContext c) {
            String right = this.pop();
            String left = this.pop();
            String re = String.format("(%s|%s)", left, right);
            this.push(re);
        }

        @Override
        public void exitConcatenation(SequenceParser.ConcatenationContext c) {
            String right = this.pop();
            String left = this.pop();
            String re = String.format("(%s%s)", left, right);
            this.push(re);
        }

        @Override
        public void exitParentheses(SequenceParser.ParenthesesContext c) {
            String re = this.pop();
            this.push(re);
        }

        @Override
        public void exitHop(SequenceParser.HopContext c) {
            String re = String.format("(%s +)", this.pop());
            this.push(re);
        }

        @Override
        public void exitISDHop(SequenceParser.ISDHopContext c) {
            String isd = this.pop();
            String re = String.format("(%s-%s#%s,%s)", isd, Sequence.AS_WILDCARD, "([0-9]+)", "([0-9]+)");
            this.push(re);
        }

        @Override
        public void exitISDASHop(SequenceParser.ISDASHopContext c) {
            String as = this.pop();
            String isd = this.pop();
            String re = String.format("(%s-%s#%s,%s)", isd, as, "([0-9]+)", "([0-9]+)");
            this.push(re);
        }

        @Override
        public void exitISDASIFHop(SequenceParser.ISDASIFHopContext c) {
            String iface = this.pop();
            String as = this.pop();
            String isd = this.pop();
            String re = String.format("(%s-%s#((%s,%s)|(%s,%s)))", isd, as, "([0-9]+)", iface, iface, "([0-9]+)");
            this.push(re);
        }

        @Override
        public void exitISDASIFIFHop(SequenceParser.ISDASIFIFHopContext c) {
            String ifout = this.pop();
            String ifin = this.pop();
            String as = this.pop();
            String isd = this.pop();
            String re = String.format("(%s-%s#%s,%s)", isd, as, ifin, ifout);
            this.push(re);
        }

        @Override
        public void exitWildcardISD(SequenceParser.WildcardISDContext c) {
            this.push("([0-9]+)");
        }

        @Override
        public void exitISD(SequenceParser.ISDContext c) {
            String re = c.getText();
            this.push(re);
        }

        @Override
        public void exitWildcardAS(SequenceParser.WildcardASContext c) {
            this.push(Sequence.AS_WILDCARD);
        }

        @Override
        public void exitLegacyAS(SequenceParser.LegacyASContext c) {
            String re = c.getText().substring(1);
            this.push(re);
        }

        @Override
        public void exitAS(SequenceParser.ASContext c) {
            String re = c.getText().substring(1);
            this.push(re);
        }

        @Override
        public void exitWildcardIFace(SequenceParser.WildcardIFaceContext c) {
            this.push("([0-9]+)");
        }

        @Override
        public void exitIFace(SequenceParser.IFaceContext c) {
            String re = c.getText();
            this.push(re);
        }
    }

    private static class ErrorListener
    implements ANTLRErrorListener {
        String msg;

        private ErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object o, int line, int column, String msg, RecognitionException e) {
            this.msg = this.msg + String.format("%d:%d %s%n", line, column, msg);
        }

        public void reportAmbiguity(Parser parser, DFA dfa, int line, int column, boolean b, BitSet bitSet, ATNConfigSet atnConfigSet) {
            this.msg = this.msg + String.format("%d:%d %s%n", line, column, this.msg);
            throw new UnsupportedOperationException(this.msg);
        }

        public void reportAttemptingFullContext(Parser parser, DFA dfa, int i, int i1, BitSet bitSet, ATNConfigSet atnConfigSet) {
            throw new UnsupportedOperationException();
        }

        public void reportContextSensitivity(Parser parser, DFA dfa, int i, int i1, int i2, ATNConfigSet atnConfigSet) {
            throw new UnsupportedOperationException();
        }
    }
}

