/*
 * Decompiled with CFR 0.152.
 */
package scodec.bits;

import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public abstract class ByteVectorCrossPlatform$class {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final ByteVector deflate(ByteVector $this, int level, int strategy, boolean nowrap, int chunkSize) {
        ByteVector byteVector;
        if ($this.isEmpty()) {
            byteVector = $this;
            return byteVector;
        }
        Deflater deflater = new Deflater(level, nowrap);
        try {
            deflater.setStrategy(strategy);
            byte[] buffer = new byte[(int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)chunkSize), $this.size())];
            ObjectRef result = ObjectRef.create((Object)ByteVector$.MODULE$.empty());
            $this.foreachV((Function1<ByteVector.View, BoxedUnit>)new Serializable($this, deflater, buffer, result){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ByteVector $outer;
                private final Deflater deflater$1;
                private final byte[] buffer$1;
                private final ObjectRef result$1;

                public final void apply(ByteVector.View v) {
                    this.deflater$1.setInput(v.toArray());
                    this.result$1.elem = ((ByteVector)this.result$1.elem).$plus$plus(ByteVectorCrossPlatform$class.loop$1(this.$outer, ByteVector$.MODULE$.empty(), false, this.deflater$1, this.buffer$1));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.deflater$1 = deflater$1;
                    this.buffer$1 = buffer$1;
                    this.result$1 = result$1;
                }
            });
            deflater.setInput((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()));
            deflater.finish();
            byteVector = ((ByteVector)result.elem).$plus$plus(ByteVectorCrossPlatform$class.loop$1($this, ByteVector$.MODULE$.empty(), true, deflater, buffer));
            deflater.end();
            return byteVector;
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.end();
            throw throwable;
        }
    }

    public static final int deflate$default$1(ByteVector $this) {
        return -1;
    }

    public static final int deflate$default$2(ByteVector $this) {
        return 0;
    }

    public static final boolean deflate$default$3(ByteVector $this) {
        return false;
    }

    public static final int deflate$default$4(ByteVector $this) {
        return 4096;
    }

    public static final Either inflate(ByteVector $this, int chunkSize, boolean nowrap) {
        Right right;
        block8: {
            if ($this.isEmpty()) {
                right = package$.MODULE$.Right().apply((Object)$this);
            } else {
                byte[] arr = $this.toArray();
                Inflater inflater = new Inflater(nowrap);
                try {
                    inflater.setInput(arr);
                    try {
                        byte[] buffer = new byte[RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(chunkSize), arr.length)];
                        ByteVector inflated = ByteVectorCrossPlatform$class.loop$2($this, ByteVector$.MODULE$.empty(), inflater, buffer);
                        if (inflater.finished()) {
                            right = package$.MODULE$.Right().apply((Object)inflated);
                            break block8;
                        }
                        right = package$.MODULE$.Left().apply((Object)new DataFormatException(new StringBuilder().append((Object)"Insufficient data -- inflation reached end of input without completing inflation - ").append((Object)inflated).toString()));
                    }
                    catch (DataFormatException dataFormatException) {
                        right = package$.MODULE$.Left().apply((Object)dataFormatException);
                    }
                }
                finally {
                    inflater.end();
                }
            }
        }
        return right;
    }

    public static final int inflate$default$1(ByteVector $this) {
        return 4096;
    }

    public static final boolean inflate$default$2(ByteVector $this) {
        return false;
    }

    public static final ByteVector sha1(ByteVector $this) {
        return $this.digest("SHA-1");
    }

    public static final ByteVector sha256(ByteVector $this) {
        return $this.digest("SHA-256");
    }

    public static final ByteVector md5(ByteVector $this) {
        return $this.digest("MD5");
    }

    public static final ByteVector digest(ByteVector $this, String algorithm) {
        return $this.digest(MessageDigest.getInstance(algorithm));
    }

    public static final ByteVector digest(ByteVector $this, MessageDigest digest2) {
        $this.foreachV((Function1<ByteVector.View, BoxedUnit>)new Serializable($this, digest2){
            public static final long serialVersionUID = 0L;
            private final MessageDigest digest$1;

            public final void apply(ByteVector.View v) {
                this.digest$1.update(v.toArray());
            }
            {
                this.digest$1 = digest$1;
            }
        });
        return ByteVector$.MODULE$.view(digest2.digest());
    }

    public static final Either encrypt(ByteVector $this, Cipher ci, Key key, Option aparams, SecureRandom sr) {
        return $this.cipher(ci, key, 1, (Option<AlgorithmParameters>)aparams, sr);
    }

    public static final Option encrypt$default$3(ByteVector $this) {
        return None$.MODULE$;
    }

    public static final Either decrypt(ByteVector $this, Cipher ci, Key key, Option aparams, SecureRandom sr) {
        return $this.cipher(ci, key, 2, (Option<AlgorithmParameters>)aparams, sr);
    }

    public static final Option decrypt$default$3(ByteVector $this) {
        return None$.MODULE$;
    }

    public static Either cipher(ByteVector $this, Cipher ci, Key key, int opmode, Option aparams, SecureRandom sr) {
        Left left;
        try {
            aparams.fold((Function0)new Serializable($this, ci, key, opmode, sr){
                public static final long serialVersionUID = 0L;
                private final Cipher ci$1;
                private final Key key$1;
                private final int opmode$1;
                private final SecureRandom sr$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.ci$1.init(this.opmode$1, this.key$1, this.sr$1);
                }
                {
                    this.ci$1 = ci$1;
                    this.key$1 = key$1;
                    this.opmode$1 = opmode$1;
                    this.sr$1 = sr$1;
                }
            }, (Function1)new Serializable($this, ci, key, opmode, sr){
                public static final long serialVersionUID = 0L;
                private final Cipher ci$1;
                private final Key key$1;
                private final int opmode$1;
                private final SecureRandom sr$1;

                public final void apply(AlgorithmParameters aparams) {
                    this.ci$1.init(this.opmode$1, this.key$1, aparams, this.sr$1);
                }
                {
                    this.ci$1 = ci$1;
                    this.key$1 = key$1;
                    this.opmode$1 = opmode$1;
                    this.sr$1 = sr$1;
                }
            });
            $this.foreachV((Function1<ByteVector.View, BoxedUnit>)new Serializable($this, ci){
                public static final long serialVersionUID = 0L;
                private final Cipher ci$1;

                public final void apply(ByteVector.View view) {
                    this.ci$1.update(view.toArrayUnsafe());
                }
                {
                    this.ci$1 = ci$1;
                }
            });
            left = package$.MODULE$.Right().apply((Object)ByteVector$.MODULE$.view(ci.doFinal()));
        }
        catch (GeneralSecurityException generalSecurityException) {
            left = package$.MODULE$.Left().apply((Object)generalSecurityException);
        }
        return left;
    }

    public static Option cipher$default$4(ByteVector $this) {
        return None$.MODULE$;
    }

    public static final ByteVector loop$1(ByteVector $this, ByteVector acc, boolean fin, Deflater deflater$1, byte[] buffer$1) {
        while (!(fin && deflater$1.finished() || !fin && deflater$1.needsInput())) {
            int count = deflater$1.deflate(buffer$1);
            acc = acc.$plus$plus(ByteVector$.MODULE$.apply(buffer$1, 0, count));
        }
        return acc;
    }

    private static final ByteVector loop$2(ByteVector $this, ByteVector acc, Inflater inflater$1, byte[] buffer$2) {
        while (!inflater$1.finished() && !inflater$1.needsInput()) {
            int count = inflater$1.inflate(buffer$2);
            acc = acc.$plus$plus(ByteVector$.MODULE$.apply(buffer$2, 0, count));
        }
        return acc;
    }

    public static void $init$(ByteVector $this) {
    }
}

