/*
 * Decompiled with CFR 0.152.
 */
package scorex.crypto.authds.avltree.batch;

import com.google.common.primitives.Ints;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scorex.crypto.authds.avltree.batch.AuthenticatedTreeOps;
import scorex.crypto.authds.avltree.batch.BatchAVLProver$;
import scorex.crypto.authds.avltree.batch.BatchProofConstants;
import scorex.crypto.authds.avltree.batch.InternalNode;
import scorex.crypto.authds.avltree.batch.InternalProverNode;
import scorex.crypto.authds.avltree.batch.Leaf;
import scorex.crypto.authds.avltree.batch.Node;
import scorex.crypto.authds.avltree.batch.Operation;
import scorex.crypto.authds.avltree.batch.ProverLeaf;
import scorex.crypto.authds.avltree.batch.ProverNodes;
import scorex.crypto.authds.avltree.batch.ToStringHelper;
import scorex.crypto.authds.package$ADProof$;
import scorex.crypto.authds.package$ADValue$;
import scorex.crypto.authds.package$Balance$;
import scorex.crypto.hash.Blake2b256Unsafe;
import scorex.crypto.hash.ThreadUnsafeHash;
import scorex.utils.ByteArray$;
import scorex.utils.ScryptoLogging;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\tUe\u0001B\u0001\u0003\u00015\u0011aBQ1uG\"\fe\u000b\u0014)s_Z,'O\u0003\u0002\u0004\t\u0005)!-\u0019;dQ*\u0011QAB\u0001\bCZdGO]3f\u0015\t9\u0001\"\u0001\u0004bkRDGm\u001d\u0006\u0003\u0013)\taa\u0019:zaR|'\"A\u0006\u0002\rM\u001cwN]3y\u0007\u0001)2AD\u000eT'\u0011\u0001q\"F\u001a\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\r1r#G\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0015\u0003V$\b.\u001a8uS\u000e\fG/\u001a3Ue\u0016,w\n]:\u0011\u0005iYB\u0002\u0001\u0003\u00069\u0001\u0011\r!\b\u0002\u0002\tF\u0011a$\t\t\u0003!}I!\u0001I\t\u0003\u000f9{G\u000f[5oOB\u0011!\u0005\r\b\u0003G5r!\u0001J\u0016\u000f\u0005\u0015RcB\u0001\u0014*\u001b\u00059#B\u0001\u0015\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011A\u0006C\u0001\u0005Q\u0006\u001c\b.\u0003\u0002/_\u00059\u0001/Y2lC\u001e,'B\u0001\u0017\t\u0013\t\t$G\u0001\u0004ES\u001e,7\u000f\u001e\u0006\u0003]=\u0002\"A\u0006\u001b\n\u0005U\u0012!A\u0004+p'R\u0014\u0018N\\4IK2\u0004XM\u001d\u0005\to\u0001\u0011)\u0019!C\u0001q\u0005I1.Z=MK:<G\u000f[\u000b\u0002sA\u0011\u0001CO\u0005\u0003wE\u00111!\u00138u\u0011!i\u0004A!A!\u0002\u0013I\u0014AC6fs2+gn\u001a;iA!Aq\b\u0001BC\u0002\u0013\u0005\u0001)\u0001\bwC2,X\rT3oORDw\n\u001d;\u0016\u0003\u0005\u00032\u0001\u0005\":\u0013\t\u0019\u0015C\u0001\u0004PaRLwN\u001c\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u0003\u0006ya/\u00197vK2+gn\u001a;i\u001fB$\b\u0005\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0003AyG\u000e\u001a*p_R\fe\u000e\u001a%fS\u001eDG\u000fE\u0002\u0011\u0005&\u0003B\u0001\u0005&Ms%\u00111*\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007Yi\u0015$\u0003\u0002O\u0005\tY\u0001K]8wKJtu\u000eZ3t\u0011!\u0001\u0006A!b\u0001\n\u0007\t\u0016A\u00015g+\u0005\u0011\u0006C\u0001\u000eT\t\u0015!\u0006A1\u0001V\u0005\tAe)\u0005\u0002\u001f-B\u0019q\u000bW\r\u000e\u0003=J!!W\u0018\u0003!QC'/Z1e+:\u001c\u0018MZ3ICND\u0007\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\u0002\u0007!4\u0007\u0005C\u0003^\u0001\u0011\u0005a,\u0001\u0004=S:LGO\u0010\u000b\u0005?\n\u001cG\r\u0006\u0002aCB!a\u0003A\rS\u0011\u001d\u0001F\f%AA\u0004ICQa\u000e/A\u0002eBQa\u0010/A\u0002\u0005Cqa\u0012/\u0011\u0002\u0003\u0007\u0001\nC\u0004g\u0001\t\u0007I\u0011\u0003\u001d\u0002\u00171\f'-\u001a7MK:<G\u000f\u001b\u0005\u0007Q\u0002\u0001\u000b\u0011B\u001d\u0002\u00191\f'-\u001a7MK:<G\u000f\u001b\u0011\t\u0011)\u0004\u0001\u0019!C\u0001\u0005-\fq\u0001^8q\u001d>$W-F\u0001M\u0011!i\u0007\u00011A\u0005\u0002\tq\u0017a\u0003;pa:{G-Z0%KF$\"a\u001c:\u0011\u0005A\u0001\u0018BA9\u0012\u0005\u0011)f.\u001b;\t\u000fMd\u0017\u0011!a\u0001\u0019\u0006\u0019\u0001\u0010J\u0019\t\rU\u0004\u0001\u0015)\u0003M\u0003!!x\u000e\u001d(pI\u0016\u0004\u0003bB<\u0001\u0001\u0004%\t\u0001O\u0001\u000fe>|GOT8eK\"+\u0017n\u001a5u\u0011\u001dI\b\u00011A\u0005\u0002i\f!C]8pi:{G-\u001a%fS\u001eDGo\u0018\u0013fcR\u0011qn\u001f\u0005\bgb\f\t\u00111\u0001:\u0011\u0019i\b\u0001)Q\u0005s\u0005y!o\\8u\u001d>$W\rS3jO\"$\b\u0005C\u0004\u0000\u0001\u0001\u0007I\u0011B6\u0002\u0015=dG\rV8q\u001d>$W\rC\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0003\u0002\u0006\u0005qq\u000e\u001c3U_Btu\u000eZ3`I\u0015\fHcA8\u0002\b!A1/!\u0001\u0002\u0002\u0003\u0007A\nC\u0004\u0002\f\u0001\u0001\u000b\u0015\u0002'\u0002\u0017=dG\rV8q\u001d>$W\r\t\u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0005\u0003#\t!\u0002Z5sK\u000e$\u0018n\u001c8t+\t\t\u0019\u0002\u0005\u0004\u0002\u0016\u0005}\u00111E\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u00059Q.\u001e;bE2,'bAA\u000f#\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u0012q\u0003\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002\u0011\u0003KI1!a\n\u0012\u0005\u0011\u0011\u0015\u0010^3\t\u0013\u0005-\u0002\u00011A\u0005\n\u00055\u0012A\u00043je\u0016\u001cG/[8og~#S-\u001d\u000b\u0004_\u0006=\u0002\"C:\u0002*\u0005\u0005\t\u0019AA\n\u0011!\t\u0019\u0004\u0001Q!\n\u0005M\u0011a\u00033je\u0016\u001cG/[8og\u0002B\u0001\"a\u000e\u0001\u0001\u0004%I\u0001O\u0001\u0014I&\u0014Xm\u0019;j_:\u001c()\u001b;MK:<G\u000f\u001b\u0005\n\u0003w\u0001\u0001\u0019!C\u0005\u0003{\tq\u0003Z5sK\u000e$\u0018n\u001c8t\u0005&$H*\u001a8hi\"|F%Z9\u0015\u0007=\fy\u0004\u0003\u0005t\u0003s\t\t\u00111\u0001:\u0011\u001d\t\u0019\u0005\u0001Q!\ne\nA\u0003Z5sK\u000e$\u0018n\u001c8t\u0005&$H*\u001a8hi\"\u0004\u0003\u0002CA$\u0001\u0001\u0007I\u0011\u0002\u001d\u0002\u0017I,\u0007\u000f\\1z\u0013:$W\r\u001f\u0005\n\u0003\u0017\u0002\u0001\u0019!C\u0005\u0003\u001b\nqB]3qY\u0006L\u0018J\u001c3fq~#S-\u001d\u000b\u0004_\u0006=\u0003\u0002C:\u0002J\u0005\u0005\t\u0019A\u001d\t\u000f\u0005M\u0003\u0001)Q\u0005s\u0005a!/\u001a9mCfLe\u000eZ3yA!A\u0011q\u000b\u0001A\u0002\u0013%\u0001(A\u0007mCN$(+[4iiN#X\r\u001d\u0005\n\u00037\u0002\u0001\u0019!C\u0005\u0003;\n\u0011\u0003\\1tiJKw\r\u001b;Ti\u0016\u0004x\fJ3r)\ry\u0017q\f\u0005\tg\u0006e\u0013\u0011!a\u0001s!9\u00111\r\u0001!B\u0013I\u0014A\u00047bgR\u0014\u0016n\u001a5u'R,\u0007\u000f\t\u0005\n\u0003O\u0002\u0001\u0019!C\u0005\u0003S\nQAZ8v]\u0012,\"!a\u001b\u0011\u0007A\ti'C\u0002\u0002pE\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002t\u0001\u0001\r\u0011\"\u0003\u0002v\u0005Iam\\;oI~#S-\u001d\u000b\u0004_\u0006]\u0004\"C:\u0002r\u0005\u0005\t\u0019AA6\u0011!\tY\b\u0001Q!\n\u0005-\u0014A\u00024pk:$\u0007\u0005C\u0004\u0002\u0000\u0001!\t\"!!\u0002'9,\u0007\u0010\u001e#je\u0016\u001cG/[8o\u0013NdUM\u001a;\u0015\r\u0005-\u00141QAL\u0011!\t))! A\u0002\u0005\u001d\u0015aA6fsB!\u0011\u0011RAI\u001d\u0011\tY)a$\u000f\u0007\u0011\ni)\u0003\u0002\b\u0011%\u0011aFB\u0005\u0005\u0003'\u000b)JA\u0003B\t.+\u0017P\u0003\u0002/\r!A\u0011\u0011TA?\u0001\u0004\tY*A\u0001s!\u00111\u0012QT\r\n\u0007\u0005}%A\u0001\u0007J]R,'O\\1m\u001d>$W\rC\u0004\u0002$\u0002!\t\"!*\u0002\u001d-,\u00170T1uG\",7\u000fT3bMR1\u00111NAT\u0003SC\u0001\"!\"\u0002\"\u0002\u0007\u0011q\u0011\u0005\t\u00033\u000b\t\u000b1\u0001\u0002,B!a#!,\u001a\u0013\r\tyK\u0001\u0002\u0005\u0019\u0016\fg\r\u0003\u0004\u00024\u0002!\t\u0002O\u0001\u0011e\u0016\u0004H.Y=D_6\u0004\u0018M]5t_:Dq!a.\u0001\t#\tI,A\u0004bI\u0012tu\u000eZ3\u0015\u0011\u0005m\u0016\u0011YAb\u0003\u000b\u0004BAFA_3%\u0019\u0011q\u0018\u0002\u0003%%sG/\u001a:oC2\u0004&o\u001c<fe:{G-\u001a\u0005\t\u00033\u000b)\f1\u0001\u0002,\"A\u0011QQA[\u0001\u0004\t9\t\u0003\u0005\u0002H\u0006U\u0006\u0019AAe\u0003\u00051\b\u0003BAE\u0003\u0017LA!!4\u0002\u0016\n9\u0011\t\u0012,bYV,\u0007bBAi\u0001\u0011\u0005\u00111[\u0001\u0007I&<Wm\u001d;\u0016\u0005\u0005U\u0007\u0003BAE\u0003/LA!!7\u0002\u0016\nA\u0011\t\u0012#jO\u0016\u001cH\u000fC\u0004\u0002^\u0002!\t!a8\u0002'A,'OZ8s[>sWm\u00149fe\u0006$\u0018n\u001c8\u0015\t\u0005\u0005\u0018q\u001e\t\u0007\u0003G\fI/!<\u000e\u0005\u0005\u0015(bAAt#\u0005!Q\u000f^5m\u0013\u0011\tY/!:\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0011\u0005\u0006%\u0007\u0002CAy\u00037\u0004\r!a=\u0002\u0013=\u0004XM]1uS>t\u0007c\u0001\f\u0002v&\u0019\u0011q\u001f\u0002\u0003\u0013=\u0003XM]1uS>t\u0007bBA~\u0001\u0011\u0005\u0011Q`\u0001\u000eO\u0016tWM]1uKB\u0013xn\u001c4\u0015\u0005\u0005}\b\u0003BAE\u0005\u0003IAAa\u0001\u0002\u0016\n9\u0011\t\u0012)s_>4\u0007b\u0002B\u0004\u0001\u0011\u0005!\u0011B\u0001\u0016k:\fW\u000f\u001e5f]RL7-\u0019;fI2{wn[;q)\u0011\tiOa\u0003\t\u0011\u0005\u0015%Q\u0001a\u0001\u0003\u000fC\u0001Ba\u0004\u0001\t\u0003\u0011!\u0011C\u0001\nG\",7m\u001b+sK\u0016$2a\u001cB\n\u0011)\u0011)B!\u0004\u0011\u0002\u0003\u0007\u00111N\u0001\na>\u001cH\u000f\u0015:p_\u001aDqA!\u0007\u0001\t\u0003\u0012Y\"\u0001\u0005u_N#(/\u001b8h)\t\u0011i\u0002\u0005\u0003\u0003 \t\u001db\u0002\u0002B\u0011\u0005G\u0001\"AJ\t\n\u0007\t\u0015\u0012#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005S\u0011YC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005K\t\u0002B\u0003B\u0018\u0001E\u0005I\u0011\u0001\u0002\u00032\u0005\u00192\r[3dWR\u0013X-\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0007\u0016\u0005\u0003W\u0012)d\u000b\u0002\u00038A!!\u0011\bB\"\u001b\t\u0011YD\u0003\u0003\u0003>\t}\u0012!C;oG\",7m[3e\u0015\r\u0011\t%E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B#\u0005w\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000f%\u0011IEAA\u0001\u0012\u0003\u0011Y%\u0001\bCCR\u001c\u0007.\u0011,M!J|g/\u001a:\u0011\u0007Y\u0011iE\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B('\r\u0011ie\u0004\u0005\b;\n5C\u0011\u0001B*)\t\u0011Y\u0005\u0003\u0006\u0003X\t5\u0013\u0013!C\u0001\u00053\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTC\u0002B.\u0005K\u00129'\u0006\u0002\u0003^)\"!q\fB\u001b\u001d\r\u0001\"\u0011M\u0005\u0004\u0005G\n\u0012\u0001\u0002(p]\u0016$a\u0001\bB+\u0005\u0004iBa\u0002+\u0003V\t\u0007!\u0011N\t\u0004=\t-\u0004\u0003B,Y\u0005[\u00022A\u0007B3\u0011)\u0011\tH!\u0014\u0012\u0002\u0013\u0005!1O\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\r\tU$Q\u0012BH)!\u00119Ha \u0003\u0002\n\r%\u0006\u0002B=\u0005k\u00012a\u0016B>\u0013\r\u0011ih\f\u0002\u0011\u00052\f7.\u001a\u001aceU2TK\\:bM\u0016Daa\u000eB8\u0001\u0004I\u0004BB \u0003p\u0001\u0007\u0011\tC\u0004H\u0005_\u0002\rA!\"\u0011\tA\u0011%q\u0011\t\u0006!)\u0013I)\u000f\t\u0005-5\u0013Y\tE\u0002\u001b\u0005\u001b#a\u0001\bB8\u0005\u0004iBa\u0002+\u0003p\t\u0007!\u0011S\t\u0004=\tM\u0005\u0003B,Y\u0005\u0017\u0003")
public class BatchAVLProver<D extends byte[], HF extends ThreadUnsafeHash<D>>
implements AuthenticatedTreeOps<D>,
ToStringHelper {
    private final int keyLength;
    private final Option<Object> valueLengthOpt;
    private final HF hf;
    private final int labelLength;
    private ProverNodes<D> topNode;
    private int rootNodeHeight;
    private ProverNodes<D> oldTopNode;
    private ArrayBuffer<Object> directions;
    private int directionsBitLength;
    private int replayIndex;
    private int lastRightStep;
    private boolean found;
    private final byte[] PositiveInfinityKey;
    private final byte[] NegativeInfinityKey;
    private final byte LeafInPackagedProof;
    private final byte LabelInPackagedProof;
    private final byte EndOfTreeInPackagedProof;

    public static <D extends byte[], HF extends ThreadUnsafeHash<D>> Blake2b256Unsafe $lessinit$greater$default$4(int n, Option<Object> option, Option<Tuple2<ProverNodes<D>, Object>> option2) {
        return BatchAVLProver$.MODULE$.$lessinit$greater$default$4(n, option, option2);
    }

    public static <D extends byte[], HF extends ThreadUnsafeHash<D>> None$ $lessinit$greater$default$3() {
        return BatchAVLProver$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String arrayToString(byte[] a) {
        return ToStringHelper.arrayToString$(this, a);
    }

    @Override
    public byte[] digest(Node<D> rootNode) {
        return AuthenticatedTreeOps.digest$(this, rootNode);
    }

    @Override
    public Try<Tuple2<Node<D>, Option<byte[]>>> returnResultOfOneOperation(Operation operation, Node<D> rootNode) {
        return AuthenticatedTreeOps.returnResultOfOneOperation$(this, operation, rootNode);
    }

    @Override
    public Logger log() {
        return ScryptoLogging.log$(this);
    }

    @Override
    public byte[] PositiveInfinityKey() {
        return this.PositiveInfinityKey;
    }

    @Override
    public byte[] NegativeInfinityKey() {
        return this.NegativeInfinityKey;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$PositiveInfinityKey_$eq(byte[] x$1) {
        this.PositiveInfinityKey = x$1;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$NegativeInfinityKey_$eq(byte[] x$1) {
        this.NegativeInfinityKey = x$1;
    }

    @Override
    public byte LeafInPackagedProof() {
        return this.LeafInPackagedProof;
    }

    @Override
    public byte LabelInPackagedProof() {
        return this.LabelInPackagedProof;
    }

    @Override
    public byte EndOfTreeInPackagedProof() {
        return this.EndOfTreeInPackagedProof;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LeafInPackagedProof_$eq(byte x$1) {
        this.LeafInPackagedProof = x$1;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LabelInPackagedProof_$eq(byte x$1) {
        this.LabelInPackagedProof = x$1;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$EndOfTreeInPackagedProof_$eq(byte x$1) {
        this.EndOfTreeInPackagedProof = x$1;
    }

    @Override
    public int keyLength() {
        return this.keyLength;
    }

    @Override
    public Option<Object> valueLengthOpt() {
        return this.valueLengthOpt;
    }

    public HF hf() {
        return this.hf;
    }

    public int labelLength() {
        return this.labelLength;
    }

    public ProverNodes<D> topNode() {
        return this.topNode;
    }

    public void topNode_$eq(ProverNodes<D> x$1) {
        this.topNode = x$1;
    }

    @Override
    public int rootNodeHeight() {
        return this.rootNodeHeight;
    }

    @Override
    public void rootNodeHeight_$eq(int x$1) {
        this.rootNodeHeight = x$1;
    }

    private ProverNodes<D> oldTopNode() {
        return this.oldTopNode;
    }

    private void oldTopNode_$eq(ProverNodes<D> x$1) {
        this.oldTopNode = x$1;
    }

    private ArrayBuffer<Object> directions() {
        return this.directions;
    }

    private void directions_$eq(ArrayBuffer<Object> x$1) {
        this.directions = x$1;
    }

    private int directionsBitLength() {
        return this.directionsBitLength;
    }

    private void directionsBitLength_$eq(int x$1) {
        this.directionsBitLength = x$1;
    }

    private int replayIndex() {
        return this.replayIndex;
    }

    private void replayIndex_$eq(int x$1) {
        this.replayIndex = x$1;
    }

    private int lastRightStep() {
        return this.lastRightStep;
    }

    private void lastRightStep_$eq(int x$1) {
        this.lastRightStep = x$1;
    }

    private boolean found() {
        return this.found;
    }

    private void found_$eq(boolean x$1) {
        this.found = x$1;
    }

    @Override
    public boolean nextDirectionIsLeft(byte[] key, InternalNode<D> r) {
        BoxedUnit boxedUnit;
        boolean bl;
        if (this.found()) {
            bl = true;
        } else {
            int n = ByteArray$.MODULE$.compare(key, ((InternalProverNode)r).key());
            switch (n) {
                case 0: {
                    this.found_$eq(true);
                    this.lastRightStep_$eq(this.directionsBitLength());
                    bl = false;
                    break;
                }
                default: {
                    if (n < 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
            }
        }
        boolean ret = bl;
        if ((this.directionsBitLength() & 7) == 0) {
            byte by;
            ArrayBuffer<Object> arrayBuffer = this.directions();
            boolean bl2 = ret;
            if (bl2) {
                by = 1;
            } else if (!bl2) {
                by = 0;
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
            }
            boxedUnit = arrayBuffer.$plus$eq((Object)BoxesRunTime.boxToByte((byte)by));
        } else {
            if (ret) {
                int i = this.directionsBitLength() >> 3;
                this.directions().update(i, (Object)BoxesRunTime.boxToByte((byte)((byte)(BoxesRunTime.unboxToByte((Object)this.directions().apply(i)) | 1 << (this.directionsBitLength() & 7)))));
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        this.directionsBitLength_$eq(this.directionsBitLength() + 1);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean keyMatchesLeaf(byte[] key, Leaf<D> r) {
        void var3_3;
        boolean ret = this.found();
        this.found_$eq(false);
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int replayComparison() {
        void var1_1;
        int ret = this.replayIndex() == this.lastRightStep() ? 0 : ((byte)(BoxesRunTime.unboxToByte((Object)this.directions().apply(this.replayIndex() >> 3)) & (byte)(1 << (this.replayIndex() & 7))) == 0 ? 1 : -1);
        this.replayIndex_$eq(this.replayIndex() + 1);
        return (int)var1_1;
    }

    @Override
    public InternalProverNode<D> addNode(Leaf<D> r, byte[] key, byte[] v) {
        byte[] n = r.nextLeafKey();
        byte[] x$6 = key;
        byte[] x$7 = r.getNew$default$1();
        byte[] x$8 = r.getNew$default$2();
        return new InternalProverNode(key, (ProverLeaf)r.getNew(x$7, x$8, x$6), new ProverLeaf(key, v, n, this.hf()), BoxesRunTime.unboxToByte((Object)package$Balance$.MODULE$.$at$at(BoxesRunTime.boxToByte((byte)((byte)0)), package.Tagger$.MODULE$.baseRaw())), this.hf());
    }

    public byte[] digest() {
        return this.digest(this.topNode());
    }

    public Try<Option<byte[]>> performOneOperation(Operation operation) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.replayIndex_$eq(this.directionsBitLength());
            Try try_ = this.returnResultOfOneOperation(operation, this.topNode());
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    int oldDirectionsByteLength = (this.replayIndex() + 7) / 8;
                    this.directions().trimEnd(this.directions().length() - oldDirectionsByteLength);
                    this.directionsBitLength_$eq(this.replayIndex());
                    if ((this.directionsBitLength() & 7) > 0) {
                        int mask = (1 << (this.directionsBitLength() & 7)) - 1;
                        this.directions().update(this.directions().length() - 1, (Object)BoxesRunTime.boxToByte((byte)((byte)(BoxesRunTime.unboxToByte((Object)this.directions().apply(this.directions().length() - 1)) & mask))));
                    }
                    throw e;
                }
                throw new MatchError(try_);
            }
            Success success = (Success)try_;
            Tuple2 n = (Tuple2)success.value();
            this.topNode_$eq((ProverNodes)n._1());
            Option option = (Option)n._2();
            return option;
        });
    }

    public byte[] generateProof() {
        ArrayBuffer packagedTree = new ArrayBuffer();
        BooleanRef previousLeafAvailable = BooleanRef.create((boolean)false);
        this.packTree$1(this.oldTopNode(), packagedTree, previousLeafAvailable);
        packagedTree.$plus$eq((Object)BoxesRunTime.boxToByte((byte)this.EndOfTreeInPackagedProof()));
        packagedTree.$plus$plus$eq(this.directions());
        BatchAVLProver.resetNew$1(this.topNode());
        this.directions_$eq((ArrayBuffer<Object>)new ArrayBuffer());
        this.directionsBitLength_$eq(0);
        this.oldTopNode_$eq(this.topNode());
        return (byte[])package$ADProof$.MODULE$.$at$at(packagedTree.toArray(ClassTag$.MODULE$.Byte()), package.Tagger$.MODULE$.baseRaw());
    }

    public Option<byte[]> unauthenticatedLookup(byte[] key) {
        return this.unauthenticatedLookupHelper$1(this.topNode(), false, key);
    }

    public void checkTree(boolean postProof) {
        BooleanRef fail = BooleanRef.create((boolean)false);
        Tuple3 tuple3 = this.checkTreeHelper$1(this.topNode(), postProof, fail);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        ProverLeaf minTree = (ProverLeaf)tuple3._1();
        ProverLeaf maxTree = (ProverLeaf)tuple3._2();
        int treeHeight = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)minTree, (Object)maxTree, (Object)BoxesRunTime.boxToInteger((int)treeHeight));
        Tuple3 tuple33 = tuple32;
        ProverLeaf minTree2 = (ProverLeaf)tuple33._1();
        ProverLeaf maxTree2 = (ProverLeaf)tuple33._2();
        int treeHeight2 = BoxesRunTime.unboxToInt((Object)tuple33._3());
        Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(minTree2.key())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.NegativeInfinityKey())));
        Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(maxTree2.nextLeafKey())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.PositiveInfinityKey())));
        Predef$.MODULE$.require(treeHeight2 == this.rootNodeHeight());
        Predef$.MODULE$.require(!fail.elem, (Function0 & Serializable & scala.Serializable)() -> "Tree failed: \n" + this.toString());
    }

    public boolean checkTree$default$1() {
        return false;
    }

    public String toString() {
        return this.stringTreeHelper$1(this.topNode(), 0);
    }

    private final void packTree$1(ProverNodes rNode, ArrayBuffer packagedTree$1, BooleanRef previousLeafAvailable$1) {
        if (!rNode.visited()) {
            packagedTree$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)this.LabelInPackagedProof()));
            packagedTree$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(rNode.label())));
            Predef$.MODULE$.assert(rNode.label().length == this.labelLength());
            previousLeafAvailable$1.elem = false;
        } else {
            rNode.visited_$eq(false);
            ProverNodes proverNodes = rNode;
            if (proverNodes instanceof ProverLeaf) {
                ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
                packagedTree$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)this.LeafInPackagedProof()));
                Object object = !previousLeafAvailable$1.elem ? packagedTree$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(proverLeaf.key()))) : BoxedUnit.UNIT;
                packagedTree$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(proverLeaf.nextLeafKey())));
                Object object2 = this.valueLengthOpt().isEmpty() ? packagedTree$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(Ints.toByteArray((int)proverLeaf.value().length)))) : BoxedUnit.UNIT;
                packagedTree$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(proverLeaf.value())));
                previousLeafAvailable$1.elem = true;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (proverNodes instanceof InternalProverNode) {
                InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
                this.packTree$1((ProverNodes)internalProverNode.left(), packagedTree$1, previousLeafAvailable$1);
                this.packTree$1((ProverNodes)internalProverNode.right(), packagedTree$1, previousLeafAvailable$1);
                packagedTree$1.$plus$eq((Object)BoxesRunTime.boxToByte((byte)internalProverNode.balance()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)proverNodes);
            }
        }
    }

    private static final void resetNew$1(ProverNodes r) {
        block2: {
            if (!r.isNew()) break block2;
            ProverNodes proverNodes = r;
            if (proverNodes instanceof InternalProverNode) {
                InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
                BatchAVLProver.resetNew$1((ProverNodes)internalProverNode.left());
                BatchAVLProver.resetNew$1((ProverNodes)internalProverNode.right());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            r.isNew_$eq(false);
            r.visited_$eq(false);
        }
    }

    private final Option unauthenticatedLookupHelper$1(ProverNodes rNode, boolean found, byte[] key$1) {
        ProverNodes proverNodes;
        block6: {
            block3: while (true) {
                if ((proverNodes = rNode) instanceof ProverLeaf) break block6;
                if (!(proverNodes instanceof InternalProverNode)) break;
                InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
                if (found) {
                    found = true;
                    rNode = internalProverNode.left();
                    continue;
                }
                int n = ByteArray$.MODULE$.compare(key$1, internalProverNode.key());
                switch (n) {
                    case 0: {
                        found = true;
                        rNode = internalProverNode.right();
                        continue block3;
                    }
                }
                if (n < 0) {
                    found = false;
                    rNode = internalProverNode.left();
                    continue;
                }
                found = false;
                rNode = internalProverNode.right();
            }
            throw new MatchError((Object)proverNodes);
        }
        ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
        None$ none$ = found ? new Some((Object)proverLeaf.value()) : None$.MODULE$;
        return none$;
    }

    private final void myRequire$1(boolean t, String s, BooleanRef fail$1, ProverNodes rNode$1) {
        block1: {
            if (t) break block1;
            int x = rNode$1.key()[0];
            if (x < 0) {
                x += 256;
            }
            this.log().error("Tree failed at key = " + x + ": " + s);
            fail$1.elem = true;
        }
    }

    private final Tuple3 checkTreeHelper$1(ProverNodes rNode, boolean postProof$1, BooleanRef fail$1) {
        Tuple3 tuple3;
        this.myRequire$1(!postProof$1 || !rNode.visited() && !rNode.isNew(), "postproof flags", fail$1, rNode);
        ProverNodes proverNodes = rNode;
        if (proverNodes instanceof InternalProverNode) {
            Tuple3 tuple32;
            InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
            if (internalProverNode.left() instanceof InternalProverNode) {
                this.myRequire$1(ByteArray$.MODULE$.compare(internalProverNode.left().key(), internalProverNode.key()) < 0, "wrong left key", fail$1, rNode);
            }
            if (internalProverNode.right() instanceof InternalProverNode) {
                this.myRequire$1(ByteArray$.MODULE$.compare(internalProverNode.right().key(), internalProverNode.key()) > 0, "wrong right key", fail$1, rNode);
            }
            if ((tuple32 = this.checkTreeHelper$1((ProverNodes)internalProverNode.left(), postProof$1, fail$1)) == null) {
                throw new MatchError((Object)tuple32);
            }
            ProverLeaf minLeft = (ProverLeaf)tuple32._1();
            ProverLeaf maxLeft = (ProverLeaf)tuple32._2();
            int leftHeight = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Tuple3 tuple33 = new Tuple3((Object)minLeft, (Object)maxLeft, (Object)BoxesRunTime.boxToInteger((int)leftHeight));
            Tuple3 tuple34 = tuple33;
            ProverLeaf minLeft2 = (ProverLeaf)tuple34._1();
            ProverLeaf maxLeft2 = (ProverLeaf)tuple34._2();
            int leftHeight2 = BoxesRunTime.unboxToInt((Object)tuple34._3());
            Tuple3 tuple35 = this.checkTreeHelper$1((ProverNodes)internalProverNode.right(), postProof$1, fail$1);
            if (tuple35 == null) {
                throw new MatchError((Object)tuple35);
            }
            ProverLeaf minRight = (ProverLeaf)tuple35._1();
            ProverLeaf maxRight = (ProverLeaf)tuple35._2();
            int rightHeight = BoxesRunTime.unboxToInt((Object)tuple35._3());
            Tuple3 tuple36 = new Tuple3((Object)minRight, (Object)maxRight, (Object)BoxesRunTime.boxToInteger((int)rightHeight));
            Tuple3 tuple37 = tuple36;
            ProverLeaf minRight2 = (ProverLeaf)tuple37._1();
            ProverLeaf maxRight2 = (ProverLeaf)tuple37._2();
            int rightHeight2 = BoxesRunTime.unboxToInt((Object)tuple37._3());
            this.myRequire$1(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(maxLeft2.nextLeafKey())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(minRight2.key())), "children don't match", fail$1, rNode);
            this.myRequire$1(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(minRight2.key())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(internalProverNode.key())), "min of right subtree doesn't match", fail$1, rNode);
            this.myRequire$1(internalProverNode.balance() >= -1 && internalProverNode.balance() <= 1 && internalProverNode.balance() == rightHeight2 - leftHeight2, "wrong balance", fail$1, rNode);
            int height = package$.MODULE$.max(leftHeight2, rightHeight2) + 1;
            tuple3 = new Tuple3((Object)minLeft2, (Object)maxRight2, (Object)BoxesRunTime.boxToInteger((int)height));
        } else if (proverNodes instanceof ProverLeaf) {
            ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
            tuple3 = new Tuple3((Object)proverLeaf, (Object)proverLeaf, (Object)BoxesRunTime.boxToInteger((int)0));
        } else {
            throw new MatchError((Object)proverNodes);
        }
        return tuple3;
    }

    private final String stringTreeHelper$1(ProverNodes rNode, int depth) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append(((TraversableOnce)Seq$.MODULE$.fill(depth + 2, (Function0 & Serializable & scala.Serializable)() -> " ")).mkString());
        ProverNodes proverNodes = rNode;
        if (proverNodes instanceof ProverLeaf) {
            ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
            string = "At leaf label = " + this.arrayToString(proverLeaf.label()) + " key = " + this.arrayToString(proverLeaf.key()) + " nextLeafKey = " + this.arrayToString(proverLeaf.nextLeafKey()) + "\n";
        } else if (proverNodes instanceof InternalProverNode) {
            InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
            string = "Internal node label = " + this.arrayToString(internalProverNode.label()) + " key = " + this.arrayToString(internalProverNode.key()) + " balance = " + internalProverNode.balance() + "\n" + this.stringTreeHelper$1((ProverNodes)internalProverNode.left(), depth + 1) + this.stringTreeHelper$1((ProverNodes)internalProverNode.right(), depth + 1);
        } else {
            throw new MatchError((Object)proverNodes);
        }
        return stringBuilder.append((Object)string).toString();
    }

    public BatchAVLProver(int keyLength, Option<Object> valueLengthOpt, Option<Tuple2<ProverNodes<D>, Object>> oldRootAndHeight, HF hf) {
        this.keyLength = keyLength;
        this.valueLengthOpt = valueLengthOpt;
        this.hf = hf;
        BatchProofConstants.$init$(this);
        ScryptoLogging.$init$(this);
        AuthenticatedTreeOps.$init$(this);
        ToStringHelper.$init$(this);
        this.labelLength = hf.DigestSize();
        this.topNode = (ProverNodes)oldRootAndHeight.map((Function1 & Serializable & scala.Serializable)x$1 -> (ProverNodes)x$1._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            ProverLeaf t = new ProverLeaf(this.NegativeInfinityKey(), (byte[])package$ADValue$.MODULE$.$at$at(Array$.MODULE$.fill(BoxesRunTime.unboxToInt((Object)this.valueLengthOpt().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte()), package.Tagger$.MODULE$.baseRaw()), this.PositiveInfinityKey(), this.hf());
            t.isNew_$eq(false);
            return var1_1;
        });
        this.rootNodeHeight = BoxesRunTime.unboxToInt((Object)oldRootAndHeight.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._2$mcI$sp())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        this.oldTopNode = this.topNode();
        this.directions = new ArrayBuffer();
        this.directionsBitLength = 0;
        this.replayIndex = 0;
        this.lastRightStep = 0;
        this.found = false;
    }
}

