/*
 * Decompiled with CFR 0.152.
 */
package scorex.crypto.authds.avltree.batch;

import com.google.common.primitives.Ints;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Stack;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;
import scorex.crypto.authds.avltree.batch.AuthenticatedTreeOps;
import scorex.crypto.authds.avltree.batch.BatchAVLVerifier$;
import scorex.crypto.authds.avltree.batch.BatchProofConstants;
import scorex.crypto.authds.avltree.batch.InternalNode;
import scorex.crypto.authds.avltree.batch.InternalVerifierNode;
import scorex.crypto.authds.avltree.batch.LabelOnlyNode;
import scorex.crypto.authds.avltree.batch.Leaf;
import scorex.crypto.authds.avltree.batch.Node;
import scorex.crypto.authds.avltree.batch.Operation;
import scorex.crypto.authds.avltree.batch.ToStringHelper;
import scorex.crypto.authds.avltree.batch.VerifierLeaf;
import scorex.crypto.authds.avltree.batch.VerifierNodes;
import scorex.crypto.authds.package$ADKey$;
import scorex.crypto.authds.package$ADValue$;
import scorex.crypto.authds.package$Balance$;
import scorex.crypto.hash.Blake2b256Unsafe;
import scorex.crypto.hash.ThreadUnsafeHash;
import scorex.utils.ByteArray$;
import scorex.utils.ScryptoLogging;
import supertagged.package;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u0001\u0003\u00015\u0011\u0001CQ1uG\"\fe\u000b\u0014,fe&4\u0017.\u001a:\u000b\u0005\r!\u0011!\u00022bi\u000eD'BA\u0003\u0007\u0003\u001d\tg\u000f\u001c;sK\u0016T!a\u0002\u0005\u0002\r\u0005,H\u000f\u001b3t\u0015\tI!\"\u0001\u0004def\u0004Ho\u001c\u0006\u0002\u0017\u000511oY8sKb\u001c\u0001!F\u0002\u000f7q\u001bB\u0001A\b\u0016gA\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u00042AF\f\u001a\u001b\u0005\u0011\u0011B\u0001\r\u0003\u0005Q\tU\u000f\u001e5f]RL7-\u0019;fIR\u0013X-Z(qgB\u0011!d\u0007\u0007\u0001\t\u0015a\u0002A1\u0001\u001e\u0005\u0005!\u0015C\u0001\u0010\"!\t\u0001r$\u0003\u0002!#\t9aj\u001c;iS:<\u0007C\u0001\u00121\u001d\t\u0019SF\u0004\u0002%W9\u0011QE\u000b\b\u0003M%j\u0011a\n\u0006\u0003Q1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011B\u0001\u0017\t\u0003\u0011A\u0017m\u001d5\n\u00059z\u0013a\u00029bG.\fw-\u001a\u0006\u0003Y!I!!\r\u001a\u0003\r\u0011Kw-Z:u\u0015\tqs\u0006\u0005\u0002\u0017i%\u0011QG\u0001\u0002\u000f)>\u001cFO]5oO\"+G\u000e]3s\u0011!9\u0004A!A!\u0002\u0013A\u0014AD:uCJ$\u0018N\\4ES\u001e,7\u000f\u001e\t\u0003sur!A\u000f\u001f\u000f\u0005\u0011Z\u0014BA\u0004\t\u0013\tqc!\u0003\u0002?\u007f\tA\u0011\t\u0012#jO\u0016\u001cHO\u0003\u0002/\r!A\u0011\t\u0001B\u0001B\u0003%!)A\u0003qe>|g\r\u0005\u0002:\u0007&\u0011Ai\u0010\u0002\b\u0003\u0012\u0003&o\\8g\u0011!1\u0005A!b\u0001\n\u0003:\u0015!C6fs2+gn\u001a;i+\u0005A\u0005C\u0001\tJ\u0013\tQ\u0015CA\u0002J]RD\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I\u0001S\u0001\u000bW\u0016LH*\u001a8hi\"\u0004\u0003\u0002\u0003(\u0001\u0005\u000b\u0007I\u0011I(\u0002\u001dY\fG.^3MK:<G\u000f[(qiV\t\u0001\u000bE\u0002\u0011#\"K!AU\t\u0003\r=\u0003H/[8o\u0011!!\u0006A!A!\u0002\u0013\u0001\u0016a\u0004<bYV,G*\u001a8hi\"|\u0005\u000f\u001e\u0011\t\u0011Y\u0003!\u0011!Q\u0001\nA\u000b\u0001#\\1y\u001dVlw\n]3sCRLwN\\:\t\u0011a\u0003!\u0011!Q\u0001\nA\u000b!\"\\1y\t\u0016dW\r^3t\u0011!Q\u0006A!A!\u0002\u0017Y\u0016A\u00015g!\tQB\fB\u0003^\u0001\t\u0007aL\u0001\u0002I\rF\u0011ad\u0018\t\u0004A\u0006LR\"A\u0018\n\u0005\t|#\u0001\u0005+ie\u0016\fG-\u00168tC\u001a,\u0007*Y:i\u0011\u0015!\u0007\u0001\"\u0001f\u0003\u0019a\u0014N\\5u}Q9a-\u001b6lY6tGCA4i!\u00111\u0002!G.\t\u000fi\u001b\u0007\u0013!a\u00027\")qg\u0019a\u0001q!)\u0011i\u0019a\u0001\u0005\")ai\u0019a\u0001\u0011\")aj\u0019a\u0001!\"9ak\u0019I\u0001\u0002\u0004\u0001\u0006b\u0002-d!\u0003\u0005\r\u0001\u0015\u0005\ba\u0002\u0011\r\u0011\"\u0005H\u0003-a\u0017MY3m\u0019\u0016tw\r\u001e5\t\rI\u0004\u0001\u0015!\u0003I\u00031a\u0017MY3m\u0019\u0016tw\r\u001e5!\u0011\u0015!\b\u0001\"\u0001v\u0003\u0019!\u0017nZ3tiV\ta\u000fE\u0002\u0011#bBq\u0001\u001f\u0001A\u0002\u0013%q)A\beSJ,7\r^5p]NLe\u000eZ3y\u0011\u001dQ\b\u00011A\u0005\nm\f1\u0003Z5sK\u000e$\u0018n\u001c8t\u0013:$W\r_0%KF$\"\u0001`@\u0011\u0005Ai\u0018B\u0001@\u0012\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005\u00110!AA\u0002!\u000b1\u0001\u001f\u00132\u0011\u001d\t)\u0001\u0001Q!\n!\u000b\u0001\u0003Z5sK\u000e$\u0018n\u001c8t\u0013:$W\r\u001f\u0011\t\u0011\u0005%\u0001\u00011A\u0005\n\u001d\u000bQ\u0002\\1tiJKw\r\u001b;Ti\u0016\u0004\b\"CA\u0007\u0001\u0001\u0007I\u0011BA\b\u0003Ea\u0017m\u001d;SS\u001eDGo\u0015;fa~#S-\u001d\u000b\u0004y\u0006E\u0001\"CA\u0001\u0003\u0017\t\t\u00111\u0001I\u0011\u001d\t)\u0002\u0001Q!\n!\u000ba\u0002\\1tiJKw\r\u001b;Ti\u0016\u0004\b\u0005\u0003\u0005\u0002\u001a\u0001\u0001\r\u0011\"\u0003H\u0003-\u0011X\r\u001d7bs&sG-\u001a=\t\u0013\u0005u\u0001\u00011A\u0005\n\u0005}\u0011a\u0004:fa2\f\u00170\u00138eKb|F%Z9\u0015\u0007q\f\t\u0003C\u0005\u0002\u0002\u0005m\u0011\u0011!a\u0001\u0011\"9\u0011Q\u0005\u0001!B\u0013A\u0015\u0001\u0004:fa2\f\u00170\u00138eKb\u0004\u0003bBA\u0015\u0001\u0011E\u00111F\u0001\u0014]\u0016DH\u000fR5sK\u000e$\u0018n\u001c8Jg2+g\r\u001e\u000b\u0007\u0003[\t\u0019$!\u0010\u0011\u0007A\ty#C\u0002\u00022E\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u00026\u0005\u001d\u0002\u0019AA\u001c\u0003\rYW-\u001f\t\u0004s\u0005e\u0012bAA\u001e\u007f\t)\u0011\tR&fs\"A\u0011qHA\u0014\u0001\u0004\t\t%A\u0001s!\u00111\u00121I\r\n\u0007\u0005\u0015#A\u0001\u0007J]R,'O\\1m\u001d>$W\rC\u0004\u0002J\u0001!\t\"a\u0013\u0002\u001d-,\u00170T1uG\",7\u000fT3bMR1\u0011QFA'\u0003\u001fB\u0001\"!\u000e\u0002H\u0001\u0007\u0011q\u0007\u0005\t\u0003\u007f\t9\u00051\u0001\u0002RA!a#a\u0015\u001a\u0013\r\t)F\u0001\u0002\u0005\u0019\u0016\fg\r\u0003\u0004\u0002Z\u0001!\tbR\u0001\u0011e\u0016\u0004H.Y=D_6\u0004\u0018M]5t_:Dq!!\u0018\u0001\t#\ty&A\u0004bI\u0012tu\u000eZ3\u0015\u0011\u0005\u0005\u0014qMA5\u0003W\u0002BAFA23%\u0019\u0011Q\r\u0002\u0003)%sG/\u001a:oC24VM]5gS\u0016\u0014hj\u001c3f\u0011!\ty$a\u0017A\u0002\u0005E\u0003\u0002CA\u001b\u00037\u0002\r!a\u000e\t\u0011\u00055\u00141\fa\u0001\u0003_\n\u0011A\u001e\t\u0004s\u0005E\u0014bAA:\u007f\t9\u0011\t\u0012,bYV,\u0007\u0002CA<\u0001\u0001\u0007I\u0011C$\u0002\u001dI|w\u000e\u001e(pI\u0016DU-[4ii\"I\u00111\u0010\u0001A\u0002\u0013E\u0011QP\u0001\u0013e>|GOT8eK\"+\u0017n\u001a5u?\u0012*\u0017\u000fF\u0002}\u0003\u007fB\u0011\"!\u0001\u0002z\u0005\u0005\t\u0019\u0001%\t\u000f\u0005\r\u0005\u0001)Q\u0005\u0011\u0006y!o\\8u\u001d>$W\rS3jO\"$\b\u0005\u0003\u0006\u0002\b\u0002A)\u0019!C\u0005\u0003\u0013\u000b\u0011C]3d_:\u001cHO];di\u0016$GK]3f+\t\tY\t\u0005\u0003\u0011#\u00065\u0005\u0003\u0002\f\u0002\u0010fI1!!%\u0003\u000551VM]5gS\u0016\u0014hj\u001c3fg\"I\u0011Q\u0013\u0001A\u0002\u0013%\u0011\u0011R\u0001\bi>\u0004hj\u001c3f\u0011%\tI\n\u0001a\u0001\n\u0013\tY*A\u0006u_Btu\u000eZ3`I\u0015\fHc\u0001?\u0002\u001e\"Q\u0011\u0011AAL\u0003\u0003\u0005\r!a#\t\u0011\u0005\u0005\u0006\u0001)Q\u0005\u0003\u0017\u000b\u0001\u0002^8q\u001d>$W\r\t\u0005\b\u0003K\u0003A\u0011AAT\u0003M\u0001XM\u001d4pe6|e.Z(qKJ\fG/[8o)\u0011\tI+a.\u0011\r\u0005-\u0016\u0011WA[\u001b\t\tiKC\u0002\u00020F\tA!\u001e;jY&!\u00111WAW\u0005\r!&/\u001f\t\u0005!E\u000by\u0007\u0003\u0005\u0002:\u0006\r\u0006\u0019AA^\u0003%y\u0007/\u001a:bi&|g\u000eE\u0002\u0017\u0003{K1!a0\u0003\u0005%y\u0005/\u001a:bi&|g\u000eC\u0004\u0002D\u0002!\t%!2\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a2\u0011\t\u0005%\u0017\u0011\u001b\b\u0005\u0003\u0017\fi\r\u0005\u0002'#%\u0019\u0011qZ\t\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019.!6\u0003\rM#(/\u001b8h\u0015\r\ty-\u0005\u0005\b\u00033\u0004A\u0011AAn\u00031)\u0007\u0010\u001e:bGRtu\u000eZ3t)\u0011\ti.a<\u0011\tA\t\u0016q\u001c\t\u0007\u0003C\fI/!$\u000f\t\u0005\r\u0018q\u001d\b\u0004M\u0005\u0015\u0018\"\u0001\n\n\u00059\n\u0012\u0002BAv\u0003[\u00141aU3r\u0015\tq\u0013\u0003\u0003\u0005\u0002r\u0006]\u0007\u0019AAz\u0003%)\u0007\u0010\u001e:bGR|'\u000fE\u0004\u0011\u0003k\fi)!\f\n\u0007\u0005]\u0018CA\u0005Gk:\u001cG/[8oc!9\u00111 \u0001\u0005\u0002\u0005u\u0018\u0001E3yiJ\f7\r\u001e$jeN$hj\u001c3f)\u0011\tY)a@\t\u0011\u0005E\u0018\u0011 a\u0001\u0003g<\u0011Ba\u0001\u0003\u0003\u0003E\tA!\u0002\u0002!\t\u000bGo\u00195B-23VM]5gS\u0016\u0014\bc\u0001\f\u0003\b\u0019A\u0011AAA\u0001\u0012\u0003\u0011IaE\u0002\u0003\b=Aq\u0001\u001aB\u0004\t\u0003\u0011i\u0001\u0006\u0002\u0003\u0006!Q!\u0011\u0003B\u0004#\u0003%\tAa\u0005\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\u0019\u0011)Ba\u000b\u0003.U\u0011!q\u0003\u0016\u0004!\ne1F\u0001B\u000e!\u0011\u0011iBa\n\u000e\u0005\t}!\u0002\u0002B\u0011\u0005G\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015\u0012#\u0001\u0006b]:|G/\u0019;j_:LAA!\u000b\u0003 \t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\rq\u0011yA1\u0001\u001e\t\u001di&q\u0002b\u0001\u0005_\t2A\bB\u0019!\u0011\u0001\u0017Ma\r\u0011\u0007i\u0011Y\u0003\u0003\u0006\u00038\t\u001d\u0011\u0013!C\u0001\u0005s\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122TC\u0002B\u000b\u0005w\u0011i\u0004\u0002\u0004\u001d\u0005k\u0011\r!\b\u0003\b;\nU\"\u0019\u0001B #\rq\"\u0011\t\t\u0005A\u0006\u0014\u0019\u0005E\u0002\u001b\u0005wA!Ba\u0012\u0003\bE\u0005I\u0011\u0001B%\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU1!1\nB1\u0005G\"bB!\u0014\u0003V\t]#\u0011\fB.\u0005;\u0012yF\u000b\u0003\u0003P\te\u0001c\u00011\u0003R%\u0019!1K\u0018\u0003!\tc\u0017m[33EJ*d'\u00168tC\u001a,\u0007BB\u001c\u0003F\u0001\u0007\u0001\b\u0003\u0004B\u0005\u000b\u0002\rA\u0011\u0005\u0007\r\n\u0015\u0003\u0019\u0001%\t\r9\u0013)\u00051\u0001Q\u0011\u00191&Q\ta\u0001!\"1\u0001L!\u0012A\u0002A#a\u0001\bB#\u0005\u0004iBaB/\u0003F\t\u0007!QM\t\u0004=\t\u001d\u0004\u0003\u00021b\u0005S\u00022A\u0007B1\u0001")
public class BatchAVLVerifier<D extends byte[], HF extends ThreadUnsafeHash<D>>
implements AuthenticatedTreeOps<D>,
ToStringHelper {
    private Option<VerifierNodes<D>> reconstructedTree;
    private final byte[] startingDigest;
    private final byte[] proof;
    private final int keyLength;
    private final Option<Object> valueLengthOpt;
    private final Option<Object> maxNumOperations;
    private final Option<Object> maxDeletes;
    private final HF hf;
    private final int labelLength;
    private int directionsIndex;
    private int lastRightStep;
    private int replayIndex;
    private int rootNodeHeight;
    private Option<VerifierNodes<D>> topNode;
    private final byte[] PositiveInfinityKey;
    private final byte[] NegativeInfinityKey;
    private final byte LeafInPackagedProof;
    private final byte LabelInPackagedProof;
    private final byte EndOfTreeInPackagedProof;
    private volatile boolean bitmap$0;

    public static <D extends byte[], HF extends ThreadUnsafeHash<D>> Blake2b256Unsafe $lessinit$greater$default$7(byte[] byArray, byte[] byArray2, int n, Option<Object> option, Option<Object> option2, Option<Object> option3) {
        return BatchAVLVerifier$.MODULE$.$lessinit$greater$default$7(byArray, byArray2, n, option, option2, option3);
    }

    public static <D extends byte[], HF extends ThreadUnsafeHash<D>> Option<Object> $lessinit$greater$default$6() {
        return BatchAVLVerifier$.MODULE$.$lessinit$greater$default$6();
    }

    public static <D extends byte[], HF extends ThreadUnsafeHash<D>> Option<Object> $lessinit$greater$default$5() {
        return BatchAVLVerifier$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String arrayToString(byte[] a) {
        return ToStringHelper.arrayToString$(this, a);
    }

    @Override
    public byte[] digest(Node<D> rootNode) {
        return AuthenticatedTreeOps.digest$(this, rootNode);
    }

    @Override
    public Try<Tuple2<Node<D>, Option<byte[]>>> returnResultOfOneOperation(Operation operation, Node<D> rootNode) {
        return AuthenticatedTreeOps.returnResultOfOneOperation$(this, operation, rootNode);
    }

    @Override
    public Logger log() {
        return ScryptoLogging.log$(this);
    }

    @Override
    public byte[] PositiveInfinityKey() {
        return this.PositiveInfinityKey;
    }

    @Override
    public byte[] NegativeInfinityKey() {
        return this.NegativeInfinityKey;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$PositiveInfinityKey_$eq(byte[] x$1) {
        this.PositiveInfinityKey = x$1;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$NegativeInfinityKey_$eq(byte[] x$1) {
        this.NegativeInfinityKey = x$1;
    }

    @Override
    public byte LeafInPackagedProof() {
        return this.LeafInPackagedProof;
    }

    @Override
    public byte LabelInPackagedProof() {
        return this.LabelInPackagedProof;
    }

    @Override
    public byte EndOfTreeInPackagedProof() {
        return this.EndOfTreeInPackagedProof;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LeafInPackagedProof_$eq(byte x$1) {
        this.LeafInPackagedProof = x$1;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LabelInPackagedProof_$eq(byte x$1) {
        this.LabelInPackagedProof = x$1;
    }

    @Override
    public void scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$EndOfTreeInPackagedProof_$eq(byte x$1) {
        this.EndOfTreeInPackagedProof = x$1;
    }

    @Override
    public int keyLength() {
        return this.keyLength;
    }

    @Override
    public Option<Object> valueLengthOpt() {
        return this.valueLengthOpt;
    }

    public int labelLength() {
        return this.labelLength;
    }

    public Option<byte[]> digest() {
        return this.topNode().map((Function1 & Serializable & scala.Serializable)x$1 -> this.digest((Node)x$1));
    }

    private int directionsIndex() {
        return this.directionsIndex;
    }

    private void directionsIndex_$eq(int x$1) {
        this.directionsIndex = x$1;
    }

    private int lastRightStep() {
        return this.lastRightStep;
    }

    private void lastRightStep_$eq(int x$1) {
        this.lastRightStep = x$1;
    }

    private int replayIndex() {
        return this.replayIndex;
    }

    private void replayIndex_$eq(int x$1) {
        this.replayIndex = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean nextDirectionIsLeft(byte[] key, InternalNode<D> r) {
        void var3_3;
        boolean bl;
        if ((byte)(this.proof[this.directionsIndex() >> 3] & (byte)(1 << (this.directionsIndex() & 7))) != 0) {
            bl = true;
        } else {
            this.lastRightStep_$eq(this.directionsIndex());
            bl = false;
        }
        boolean ret = bl;
        this.directionsIndex_$eq(this.directionsIndex() + 1);
        return (boolean)var3_3;
    }

    @Override
    public boolean keyMatchesLeaf(byte[] key, Leaf<D> r) {
        boolean bl;
        int c = ByteArray$.MODULE$.compare(key, r.key());
        Predef$.MODULE$.require(c >= 0);
        if (c == 0) {
            bl = true;
        } else {
            Predef$.MODULE$.require(ByteArray$.MODULE$.compare(key, r.nextLeafKey()) < 0);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int replayComparison() {
        void var1_1;
        int ret = this.replayIndex() == this.lastRightStep() ? 0 : ((byte)(this.proof[this.replayIndex() >> 3] & (byte)(1 << (this.replayIndex() & 7))) == 0 && this.replayIndex() < this.lastRightStep() ? 1 : -1);
        this.replayIndex_$eq(this.replayIndex() + 1);
        return (int)var1_1;
    }

    @Override
    public InternalVerifierNode<D> addNode(Leaf<D> r, byte[] key, byte[] v) {
        byte[] n = r.nextLeafKey();
        byte[] x$4 = key;
        byte[] x$5 = r.getNew$default$1();
        byte[] x$6 = r.getNew$default$2();
        return new InternalVerifierNode<D>(r.getNew(x$5, x$6, x$4), new VerifierLeaf(key, v, n, this.hf), BoxesRunTime.unboxToByte((Object)package$Balance$.MODULE$.$at$at(BoxesRunTime.boxToByte((byte)((byte)0)), package.Tagger$.MODULE$.baseRaw())), this.hf);
    }

    @Override
    public int rootNodeHeight() {
        return this.rootNodeHeight;
    }

    @Override
    public void rootNodeHeight_$eq(int x$1) {
        this.rootNodeHeight = x$1;
    }

    private Option<VerifierNodes<D>> reconstructedTree$lzycompute() {
        BatchAVLVerifier batchAVLVerifier = this;
        synchronized (batchAVLVerifier) {
            if (!this.bitmap$0) {
                this.reconstructedTree = (Option)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    int n;
                    Predef$.MODULE$.require(this.labelLength() > 0);
                    Predef$.MODULE$.require(this.keyLength() > 0);
                    this.valueLengthOpt().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)vl -> Predef$.MODULE$.require(vl >= 0));
                    Predef$.MODULE$.require($this.startingDigest.length == this.labelLength() + 1);
                    this.rootNodeHeight_$eq(BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.startingDigest)).last()) & 0xFF);
                    if ($this.maxNumOperations.isDefined()) {
                        int logNumOps = 0;
                        int temp = 1;
                        int realNumOperations = BoxesRunTime.unboxToInt((Object)$this.maxNumOperations.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
                        while (temp < realNumOperations) {
                            temp *= 2;
                            ++logNumOps;
                        }
                        temp = 1 + package$.MODULE$.max(this.rootNodeHeight(), logNumOps);
                        int hnew = temp + temp / 2;
                        int realMaxDeletes = BoxesRunTime.unboxToInt((Object)$this.maxDeletes.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> realNumOperations));
                        n = (realNumOperations + realMaxDeletes) * (2 * this.rootNodeHeight() + 1) + realMaxDeletes * hnew + 1;
                    } else {
                        n = 0;
                    }
                    int maxNodes = n;
                    int numNodes = 0;
                    Stack s = new Stack();
                    IntRef i = IntRef.create((int)0);
                    None$ previousLeaf = None$.MODULE$;
                    while ($this.proof[i.elem] != this.EndOfTreeInPackagedProof()) {
                        Stack stack;
                        byte n2 = $this.proof[i.elem];
                        ++i.elem;
                        Predef$.MODULE$.require($this.maxNumOperations.isEmpty() || ++numNodes <= maxNodes, (Function0 & Serializable & scala.Serializable)() -> "Proof too long");
                        byte by = n2;
                        if (this.LabelInPackagedProof() == by) {
                            byte[] label = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.proof)).slice(i.elem, i.elem + this.labelLength());
                            i.elem += this.labelLength();
                            s.push(new LabelOnlyNode<byte[]>(label));
                            previousLeaf = None$.MODULE$;
                            stack = BoxedUnit.UNIT;
                            continue;
                        }
                        if (this.LeafInPackagedProof() == by) {
                            byte[] byArray;
                            if (previousLeaf.nonEmpty()) {
                                byArray = (byte[])package$ADKey$.MODULE$.$at$at(((Leaf)previousLeaf.get()).nextLeafKey(), package.Tagger$.MODULE$.baseTagged());
                            } else {
                                int start = i.elem;
                                i.elem += this.keyLength();
                                byArray = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.proof)).slice(start, i.elem), package.Tagger$.MODULE$.baseRaw());
                            }
                            byte[] key = byArray;
                            byte[] nextLeafKey = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.proof)).slice(i.elem, i.elem + this.keyLength()), package.Tagger$.MODULE$.baseRaw());
                            i.elem += this.keyLength();
                            int valueLength = BoxesRunTime.unboxToInt((Object)this.valueLengthOpt().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                                void var2_2;
                                int vl = Ints.fromByteArray((byte[])((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.proof)).slice(i$1.elem, i$1.elem + 4)));
                                i$1.elem += 4;
                                return (int)var2_2;
                            }));
                            byte[] value = (byte[])package$ADValue$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.proof)).slice(i.elem, i.elem + valueLength), package.Tagger$.MODULE$.baseRaw());
                            i.elem += valueLength;
                            VerifierLeaf leaf = new VerifierLeaf(key, value, nextLeafKey, $this.hf);
                            s.push(leaf);
                            previousLeaf = new Some(leaf);
                            stack = BoxedUnit.UNIT;
                            continue;
                        }
                        VerifierNodes right = (VerifierNodes)s.pop();
                        VerifierNodes left = (VerifierNodes)s.pop();
                        stack = s.push(new InternalVerifierNode(left, right, BoxesRunTime.unboxToByte((Object)package$Balance$.MODULE$.$at$at(BoxesRunTime.boxToByte((byte)n2), package.Tagger$.MODULE$.baseRaw())), $this.hf));
                    }
                    Predef$.MODULE$.require(s.size() == 1);
                    VerifierNodes root = (VerifierNodes)s.pop();
                    Predef$.MODULE$.require(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps($this.startingDigest)).startsWith((GenSeq)Predef$.MODULE$.wrapByteArray(root.label())));
                    this.directionsIndex_$eq((i.elem + 1) * 8);
                    return new Some((Object)root);
                }).recoverWith((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        A1.printStackTrace();
                        Failure failure = new Failure(A1);
                        return (B1)failure;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.reconstructedTree;
    }

    private Option<VerifierNodes<D>> reconstructedTree() {
        return !this.bitmap$0 ? this.reconstructedTree$lzycompute() : this.reconstructedTree;
    }

    private Option<VerifierNodes<D>> topNode() {
        return this.topNode;
    }

    private void topNode_$eq(Option<VerifierNodes<D>> x$1) {
        this.topNode = x$1;
    }

    public Try<Option<byte[]>> performOneOperation(Operation operation) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.replayIndex_$eq(this.directionsIndex());
            Try operationResult = this.returnResultOfOneOperation(operation, (Node)this.topNode().get());
            this.topNode_$eq((Option)operationResult.map((Function1 & Serializable & scala.Serializable)s -> new Some((Object)((VerifierNodes)s._1()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$));
            return (Option)((Tuple2)operationResult.get())._2();
        });
    }

    public String toString() {
        String string;
        Option<VerifierNodes<D>> option = this.topNode();
        if (None$.MODULE$.equals(option)) {
            string = "None";
        } else if (option instanceof Some) {
            Some some = (Some)option;
            VerifierNodes t = (VerifierNodes)some.value();
            string = this.stringTreeHelper$1(t, 0);
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public Option<Seq<VerifierNodes<D>>> extractNodes(Function1<VerifierNodes<D>, Object> extractor) {
        return this.topNode().map((Function1 & Serializable & scala.Serializable)t -> BatchAVLVerifier.treeTraverser$1(t, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), extractor));
    }

    public Option<VerifierNodes<D>> extractFirstNode(Function1<VerifierNodes<D>, Object> extractor) {
        return this.topNode().flatMap((Function1 & Serializable & scala.Serializable)t -> BatchAVLVerifier.treeTraverser$2(t, (Option)None$.MODULE$, extractor));
    }

    private final String stringTreeHelper$1(VerifierNodes rNode, int depth) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append(((TraversableOnce)Seq$.MODULE$.fill(depth + 2, (Function0 & Serializable & scala.Serializable)() -> " ")).mkString());
        VerifierNodes verifierNodes = rNode;
        if (verifierNodes instanceof VerifierLeaf) {
            VerifierLeaf verifierLeaf = (VerifierLeaf)verifierNodes;
            string = "At leaf label = " + this.arrayToString(verifierLeaf.label()) + " key = " + this.arrayToString(verifierLeaf.key()) + " nextLeafKey = " + this.arrayToString(verifierLeaf.nextLeafKey()) + "value = " + verifierLeaf.value() + "\n";
        } else if (verifierNodes instanceof InternalVerifierNode) {
            InternalVerifierNode internalVerifierNode = (InternalVerifierNode)verifierNodes;
            string = "Internal node label = " + this.arrayToString(internalVerifierNode.label()) + " balance = " + internalVerifierNode.balance() + "\n" + this.stringTreeHelper$1((VerifierNodes)internalVerifierNode.left(), depth + 1) + this.stringTreeHelper$1((VerifierNodes)internalVerifierNode.right(), depth + 1);
        } else if (verifierNodes instanceof LabelOnlyNode) {
            LabelOnlyNode labelOnlyNode = (LabelOnlyNode)verifierNodes;
            string = "Label-only node label = " + this.arrayToString(labelOnlyNode.label()) + "\n";
        } else {
            throw new MatchError((Object)verifierNodes);
        }
        return stringBuilder.append((Object)string).toString();
    }

    private static final Seq treeTraverser$1(VerifierNodes rNode, Seq collected, Function1 extractor$1) {
        Seq seq;
        VerifierNodes verifierNodes = rNode;
        if (verifierNodes instanceof VerifierLeaf) {
            Seq seq2;
            VerifierLeaf verifierLeaf = (VerifierLeaf)verifierNodes;
            if (BoxesRunTime.unboxToBoolean((Object)extractor$1.apply((Object)verifierLeaf))) {
                VerifierLeaf verifierLeaf2 = verifierLeaf;
                seq2 = (Seq)collected.$plus$colon((Object)verifierLeaf2, Seq$.MODULE$.canBuildFrom());
            } else {
                seq2 = collected;
            }
            seq = seq2;
        } else if (verifierNodes instanceof LabelOnlyNode) {
            Seq seq3;
            LabelOnlyNode labelOnlyNode = (LabelOnlyNode)verifierNodes;
            if (BoxesRunTime.unboxToBoolean((Object)extractor$1.apply((Object)labelOnlyNode))) {
                LabelOnlyNode labelOnlyNode2 = labelOnlyNode;
                seq3 = (Seq)collected.$plus$colon((Object)labelOnlyNode2, Seq$.MODULE$.canBuildFrom());
            } else {
                seq3 = collected;
            }
            seq = seq3;
        } else if (verifierNodes instanceof InternalVerifierNode) {
            InternalVerifierNode internalVerifierNode = (InternalVerifierNode)verifierNodes;
            seq = (Seq)((TraversableLike)collected.$plus$plus((GenTraversableOnce)BatchAVLVerifier.treeTraverser$1((VerifierNodes)internalVerifierNode.right(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), extractor$1), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)BatchAVLVerifier.treeTraverser$1((VerifierNodes)internalVerifierNode.left(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), extractor$1), Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)verifierNodes);
        }
        return seq;
    }

    private static final Option treeTraverser$2(VerifierNodes rNode, Option collected, Function1 extractor$2) {
        None$ none$;
        VerifierNodes verifierNodes = rNode;
        if (verifierNodes instanceof VerifierLeaf) {
            VerifierLeaf verifierLeaf = (VerifierLeaf)verifierNodes;
            none$ = BoxesRunTime.unboxToBoolean((Object)extractor$2.apply((Object)verifierLeaf)) ? new Some((Object)verifierLeaf) : None$.MODULE$;
        } else if (verifierNodes instanceof LabelOnlyNode) {
            LabelOnlyNode labelOnlyNode = (LabelOnlyNode)verifierNodes;
            none$ = BoxesRunTime.unboxToBoolean((Object)extractor$2.apply((Object)labelOnlyNode)) ? new Some((Object)labelOnlyNode) : None$.MODULE$;
        } else if (verifierNodes instanceof InternalVerifierNode) {
            InternalVerifierNode internalVerifierNode = (InternalVerifierNode)verifierNodes;
            none$ = collected.isEmpty() ? BatchAVLVerifier.treeTraverser$2((VerifierNodes)internalVerifierNode.left(), (Option)None$.MODULE$, extractor$2).orElse((Function0 & Serializable & scala.Serializable)() -> BatchAVLVerifier.treeTraverser$2((VerifierNodes)internalVerifierNode.right(), (Option)None$.MODULE$, extractor$2)) : collected;
        } else {
            throw new MatchError((Object)verifierNodes);
        }
        return none$;
    }

    public BatchAVLVerifier(byte[] startingDigest, byte[] proof, int keyLength, Option<Object> valueLengthOpt, Option<Object> maxNumOperations, Option<Object> maxDeletes, HF hf) {
        this.startingDigest = startingDigest;
        this.proof = proof;
        this.keyLength = keyLength;
        this.valueLengthOpt = valueLengthOpt;
        this.maxNumOperations = maxNumOperations;
        this.maxDeletes = maxDeletes;
        this.hf = hf;
        BatchProofConstants.$init$(this);
        ScryptoLogging.$init$(this);
        AuthenticatedTreeOps.$init$(this);
        ToStringHelper.$init$(this);
        this.labelLength = hf.DigestSize();
        this.directionsIndex = 0;
        this.lastRightStep = 0;
        this.replayIndex = 0;
        this.rootNodeHeight = 0;
        this.topNode = this.reconstructedTree();
    }
}

