/*
 * Decompiled with CFR 0.152.
 */
package scorex.crypto.authds.merkle;

import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.WrappedArray;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scorex.crypto.authds.merkle.InternalNode;
import scorex.crypto.authds.merkle.Leaf;
import scorex.crypto.authds.merkle.MerkleProof;
import scorex.crypto.authds.merkle.MerkleProof$;
import scorex.crypto.authds.merkle.MerkleTree$;
import scorex.crypto.authds.merkle.Node;
import scorex.crypto.hash.CryptographicHash;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0001\u0003\u0001.\u0011!\"T3sW2,GK]3f\u0015\t\u0019A!\u0001\u0004nKJ\\G.\u001a\u0006\u0003\u000b\u0019\ta!Y;uQ\u0012\u001c(BA\u0004\t\u0003\u0019\u0019'/\u001f9u_*\t\u0011\"\u0001\u0004tG>\u0014X\r_\u0002\u0001+\ta!e\u0005\u0003\u0001\u001bM1\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u000f)%\u0011Qc\u0004\u0002\b!J|G-^2u!\tqq#\u0003\u0002\u0019\u001f\ta1+\u001a:jC2L'0\u00192mK\"A!\u0004\u0001BK\u0002\u0013\u00051$A\u0004u_Btu\u000eZ3\u0016\u0003q\u00012!\b\u0010!\u001b\u0005\u0011\u0011BA\u0010\u0003\u00051Ie\u000e^3s]\u0006dgj\u001c3f!\t\t#\u0005\u0004\u0001\u0005\u000b\r\u0002!\u0019\u0001\u0013\u0003\u0003\u0011\u000b\"!\n\u0015\u0011\u000591\u0013BA\u0014\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!K\u001c\u000f\u0005)\"dBA\u00163\u001d\ta\u0013G\u0004\u0002.a5\taF\u0003\u00020\u0015\u00051AH]8pizJ\u0011!C\u0005\u0003\u000f!I!a\r\u0004\u0002\t!\f7\u000f[\u0005\u0003kY\nq\u0001]1dW\u0006<WM\u0003\u00024\r%\u0011\u0001(\u000f\u0002\u0007\t&<Wm\u001d;\u000b\u0005U2\u0004\u0002C\u001e\u0001\u0005#\u0005\u000b\u0011\u0002\u000f\u0002\u0011Q|\u0007OT8eK\u0002B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tAP\u0001\u0014K2,W.\u001a8ug\"\u000b7\u000f[%oI\u0016DXm]\u000b\u0002\u007fA!\u0001\tR$V\u001d\t\t%\t\u0005\u0002.\u001f%\u00111iD\u0001\u0007!J,G-\u001a4\n\u0005\u00153%aA'ba*\u00111i\u0004\t\u0003\u0011Js!!S(\u000f\u0005)kU\"A&\u000b\u00051{\u0011AC2pY2,7\r^5p]&\u0011ajS\u0001\b[V$\u0018M\u00197f\u0013\t\u0001\u0016+\u0001\u0007Xe\u0006\u0004\b/\u001a3BeJ\f\u0017P\u0003\u0002O\u0017&\u00111\u000b\u0016\u0002\u0007_\u001a\u0014\u0015\u0010^3\u000b\u0005A\u000b\u0006C\u0001\bW\u0013\t9vBA\u0002J]RD\u0001\"\u0017\u0001\u0003\u0012\u0003\u0006IaP\u0001\u0015K2,W.\u001a8ug\"\u000b7\u000f[%oI\u0016DXm\u001d\u0011\t\u000bm\u0003A\u0011\u0001/\u0002\rqJg.\u001b;?)\rifl\u0018\t\u0004;\u0001\u0001\u0003\"\u0002\u000e[\u0001\u0004a\u0002\"B\u001f[\u0001\u0004y\u0004\u0002C1\u0001\u0011\u000b\u0007I\u0011\u00012\u0002\u0011I|w\u000e\u001e%bg\",\u0012\u0001\u000b\u0005\tI\u0002A)\u0019!C\u0001K\u00061A.\u001a8hi\",\u0012!\u0016\u0005\u0006O\u0002!\t\u0001[\u0001\u000faJ|wN\u001a\"z\u000b2,W.\u001a8u)\tIw\u000eE\u0002\u000fU2L!a[\b\u0003\r=\u0003H/[8o!\tiR.\u0003\u0002o\u0005\tYQ*\u001a:lY\u0016\u0004&o\\8g\u0011\u0015\u0001h\r1\u0001r\u0003\u001d)G.Z7f]R\u00042!\b:!\u0013\t\u0019(A\u0001\u0003MK\u00064\u0007\"B;\u0001\t\u00031\u0018A\u00059s_>4')_#mK6,g\u000e\u001e%bg\"$\"![<\t\u000bM\"\b\u0019\u0001\u0015\t\u000be\u0004A\u0011\u0001>\u0002\u0019A\u0014xn\u001c4Cs&sG-\u001a=\u0015\u0005%\\\b\"\u0002?y\u0001\u0004)\u0016!B5oI\u0016D\b\u0002\u0003@\u0001\u0011\u000b\u0007I\u0011A3\u0002)1,gn\u001a;i/&$\b.R7qifdU-\u00194t\u0011)\t\t\u0001\u0001EC\u0002\u0013\u0005\u00131A\u0001\ti>\u001cFO]5oOV\u0011\u0011Q\u0001\t\u0004\u0001\u0006\u001d\u0011bAA\u0005\r\n11\u000b\u001e:j]\u001eD\u0011\"!\u0004\u0001\u0003\u0003%\t!a\u0004\u0002\t\r|\u0007/_\u000b\u0005\u0003#\t9\u0002\u0006\u0004\u0002\u0014\u0005e\u0011Q\u0004\t\u0005;\u0001\t)\u0002E\u0002\"\u0003/!aaIA\u0006\u0005\u0004!\u0003\"\u0003\u000e\u0002\fA\u0005\t\u0019AA\u000e!\u0011ib$!\u0006\t\u0011u\nY\u0001%AA\u0002}B\u0011\"!\t\u0001#\u0003%\t!a\t\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!\u0011QEA\u001e+\t\t9CK\u0002\u001d\u0003SY#!a\u000b\u0011\t\u00055\u0012qG\u0007\u0003\u0003_QA!!\r\u00024\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003ky\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011HA\u0018\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0007G\u0005}!\u0019\u0001\u0013\t\u0013\u0005}\u0002!%A\u0005\u0002\u0005\u0005\u0013AD2paf$C-\u001a4bk2$HEM\u000b\u0005\u0003\u0007\n9%\u0006\u0002\u0002F)\u001aq(!\u000b\u0005\r\r\niD1\u0001%\u0011%\tY\u0005AA\u0001\n\u0003\ni%A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002\\5\u0011\u00111\u000b\u0006\u0005\u0003+\n9&\u0001\u0003mC:<'BAA-\u0003\u0011Q\u0017M^1\n\t\u0005%\u00111\u000b\u0005\t\u0003?\u0002\u0011\u0011!C\u0001K\u0006a\u0001O]8ek\u000e$\u0018I]5us\"I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0011QM\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9'!\u001c\u0011\u00079\tI'C\u0002\u0002l=\u00111!\u00118z\u0011%\ty'!\u0019\u0002\u0002\u0003\u0007Q+A\u0002yIEB\u0011\"a\u001d\u0001\u0003\u0003%\t%!\u001e\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001e\u0011\u000b)\u000bI(a\u001a\n\u0007\u0005m4J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\ty\bAA\u0001\n\u0003\t\t)\u0001\u0005dC:,\u0015/^1m)\u0011\t\u0019)!#\u0011\u00079\t))C\u0002\u0002\b>\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002p\u0005u\u0014\u0011!a\u0001\u0003OB\u0011\"!$\u0001\u0003\u0003%\t%a$\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\u0016\u0005\n\u0003'\u0003\u0011\u0011!C!\u0003+\u000ba!Z9vC2\u001cH\u0003BAB\u0003/C!\"a\u001c\u0002\u0012\u0006\u0005\t\u0019AA4\u000f\u001d\tYJ\u0001E\u0001\u0003;\u000b!\"T3sW2,GK]3f!\ri\u0012q\u0014\u0004\u0007\u0003\tA\t!!)\u0014\t\u0005}UB\u0006\u0005\b7\u0006}E\u0011AAS)\t\ti\n\u0003\u0006\u0002*\u0006}%\u0019!C\u0001\u0003W\u000b!\u0002T3bMB\u0013XMZ5y+\t\ti\u000bE\u0002\u000f\u0003_K1!!-\u0010\u0005\u0011\u0011\u0015\u0010^3\t\u0013\u0005U\u0016q\u0014Q\u0001\n\u00055\u0016a\u0003'fC\u001a\u0004&/\u001a4jq\u0002B!\"!/\u0002 \n\u0007I\u0011AAV\u0003IIe\u000e^3s]\u0006dgj\u001c3f!J,g-\u001b=\t\u0013\u0005u\u0016q\u0014Q\u0001\n\u00055\u0016aE%oi\u0016\u0014h.\u00197O_\u0012,\u0007K]3gSb\u0004\u0003\u0002CAa\u0003?#\t!a1\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005\u0015\u0017Q\u001a\u000b\u0005\u0003\u000f\fY\u000e\u0006\u0003\u0002J\u0006=\u0007\u0003B\u000f\u0001\u0003\u0017\u00042!IAg\t\u0019\u0019\u0013q\u0018b\u0001I!A\u0011\u0011[A`\u0001\b\t\u0019.\u0001\u0002iMB1\u0011Q[Al\u0003\u0017l\u0011AN\u0005\u0004\u000334$!E\"ssB$xn\u001a:ba\"L7\rS1tQ\"A\u0011Q\\A`\u0001\u0004\ty.A\u0004qCfdw.\u00193\u0011\r\u0005\u0005\u0018\u0011^Ax\u001d\u0011\t\u0019/a:\u000f\u00075\n)/C\u0001\u0011\u0013\t)t\"\u0003\u0003\u0002l\u00065(aA*fc*\u0011Qg\u0004\t\u0005\u0003c\fIP\u0004\u0003\u0002t\u0006]hbA\u0016\u0002v&\u0011QAB\u0005\u0003k\u0011IA!a?\u0002~\nAA*Z1g\t\u0006$\u0018M\u0003\u00026\t!A!\u0011AAP\t\u0003\u0011\u0019!A\u0006dC2\u001cGk\u001c9O_\u0012,W\u0003\u0002B\u0003\u0005\u001b!BAa\u0002\u0003\u0014Q!!\u0011\u0002B\b!\u0011ibDa\u0003\u0011\u0007\u0005\u0012i\u0001\u0002\u0004$\u0003\u007f\u0014\r\u0001\n\u0005\t\u0003#\fy\u0010q\u0001\u0003\u0012A1\u0011Q[Al\u0005\u0017A\u0001B!\u0006\u0002\u0000\u0002\u0007!qC\u0001\u0006]>$Wm\u001d\t\u0007\u0003C\fIO!\u0007\u0011\u000bu\u0011YBa\u0003\n\u0007\tu!A\u0001\u0003O_\u0012,\u0007\u0006BA\u0000\u0005C\u0001BAa\t\u0003&5\u0011\u00111G\u0005\u0005\u0005O\t\u0019DA\u0004uC&d'/Z2\t\u0015\u0005\u0005\u0017qTA\u0001\n\u0003\u0013Y#\u0006\u0003\u0003.\tMBC\u0002B\u0018\u0005k\u0011I\u0004\u0005\u0003\u001e\u0001\tE\u0002cA\u0011\u00034\u001111E!\u000bC\u0002\u0011BqA\u0007B\u0015\u0001\u0004\u00119\u0004\u0005\u0003\u001e=\tE\u0002BB\u001f\u0003*\u0001\u0007q\b\u0003\u0006\u0003>\u0005}\u0015\u0011!CA\u0005\u007f\tq!\u001e8baBd\u00170\u0006\u0003\u0003B\t=C\u0003\u0002B\"\u0005#\u0002BA\u00046\u0003FA1aBa\u0012\u0003L}J1A!\u0013\u0010\u0005\u0019!V\u000f\u001d7feA!QD\bB'!\r\t#q\n\u0003\u0007G\tm\"\u0019\u0001\u0013\t\u0015\tM#1HA\u0001\u0002\u0004\u0011)&A\u0002yIA\u0002B!\b\u0001\u0003N!Q!\u0011LAP\u0003\u0003%IAa\u0017\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005;\u0002B!!\u0015\u0003`%!!\u0011MA*\u0005\u0019y%M[3di\u0002")
public class MerkleTree<D extends byte[]>
implements Product,
scala.Serializable {
    private byte[] rootHash;
    private int length;
    private int lengthWithEmptyLeafs;
    private String toString;
    private final InternalNode<D> topNode;
    private final Map<WrappedArray.ofByte, Object> elementsHashIndexes;
    private volatile byte bitmap$0;

    public static <D extends byte[]> Option<Tuple2<InternalNode<D>, Map<WrappedArray.ofByte, Object>>> unapply(MerkleTree<D> merkleTree) {
        return MerkleTree$.MODULE$.unapply(merkleTree);
    }

    public static <D extends byte[]> MerkleTree<D> apply(InternalNode<D> internalNode, Map<WrappedArray.ofByte, Object> map) {
        return MerkleTree$.MODULE$.apply(internalNode, map);
    }

    public static <D extends byte[]> InternalNode<D> calcTopNode(Seq<Node<D>> seq, CryptographicHash<D> cryptographicHash) {
        return MerkleTree$.MODULE$.calcTopNode(seq, cryptographicHash);
    }

    public static <D extends byte[]> MerkleTree<D> apply(Seq<byte[]> seq, CryptographicHash<D> cryptographicHash) {
        return MerkleTree$.MODULE$.apply(seq, cryptographicHash);
    }

    public static byte InternalNodePrefix() {
        return MerkleTree$.MODULE$.InternalNodePrefix();
    }

    public static byte LeafPrefix() {
        return MerkleTree$.MODULE$.LeafPrefix();
    }

    public InternalNode<D> topNode() {
        return this.topNode;
    }

    public Map<WrappedArray.ofByte, Object> elementsHashIndexes() {
        return this.elementsHashIndexes;
    }

    private byte[] rootHash$lzycompute() {
        MerkleTree merkleTree = this;
        synchronized (merkleTree) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.rootHash = (byte[])this.topNode().hash();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.rootHash;
    }

    public byte[] rootHash() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.rootHash$lzycompute() : this.rootHash;
    }

    private int length$lzycompute() {
        MerkleTree merkleTree = this;
        synchronized (merkleTree) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.length = this.elementsHashIndexes().size();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.length;
    }

    public int length() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.length$lzycompute() : this.length;
    }

    public Option<MerkleProof> proofByElement(Leaf<D> element) {
        return this.proofByElementHash((byte[])element.hash());
    }

    public Option<MerkleProof> proofByElementHash(byte[] hash) {
        return this.elementsHashIndexes().get((Object)new WrappedArray.ofByte(hash)).flatMap((Function1 & Serializable & scala.Serializable)i -> this.proofByIndex(BoxesRunTime.unboxToInt((Object)i)));
    }

    public Option<MerkleProof> proofByIndex(int index) {
        None$ none$;
        if (index >= 0 && index < this.length()) {
            Option leafWithProofs = this.loop$1(this.topNode(), index, this.lengthWithEmptyLeafs(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
            none$ = leafWithProofs.map((Function1 & Serializable & scala.Serializable)lp -> new MerkleProof(((Leaf)lp._1()).data(), (Seq<Tuple2<byte[], Object>>)((Seq)lp._2()), ((Leaf)lp._1()).hf()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private int lengthWithEmptyLeafs$lzycompute() {
        MerkleTree merkleTree = this;
        synchronized (merkleTree) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.lengthWithEmptyLeafs = Math.max((int)package$.MODULE$.pow(2.0, package$.MODULE$.ceil(MerkleTree.log2$1(this.length()))), 2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.lengthWithEmptyLeafs;
    }

    public int lengthWithEmptyLeafs() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.lengthWithEmptyLeafs$lzycompute() : this.lengthWithEmptyLeafs;
    }

    private String toString$lzycompute() {
        MerkleTree merkleTree = this;
        synchronized (merkleTree) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.toString = this.loop$2((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalNode[]{this.topNode()})), 0, "");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.toString;
    }

    public String toString() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.toString$lzycompute() : this.toString;
    }

    public <D extends byte[]> MerkleTree<D> copy(InternalNode<D> topNode, Map<WrappedArray.ofByte, Object> elementsHashIndexes) {
        return new MerkleTree<D>(topNode, elementsHashIndexes);
    }

    public <D extends byte[]> InternalNode<D> copy$default$1() {
        return this.topNode();
    }

    public <D extends byte[]> Map<WrappedArray.ofByte, Object> copy$default$2() {
        return this.elementsHashIndexes();
    }

    public String productPrefix() {
        return "MerkleTree";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        InternalNode<D> internalNode;
        int n = x$1;
        switch (n) {
            case 0: {
                internalNode = this.topNode();
                break;
            }
            case 1: {
                internalNode = this.elementsHashIndexes();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return internalNode;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MerkleTree;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MerkleTree)) return false;
        boolean bl = true;
        if (!bl) return false;
        MerkleTree merkleTree = (MerkleTree)x$1;
        InternalNode<D> internalNode = this.topNode();
        InternalNode<D> internalNode2 = merkleTree.topNode();
        if (internalNode == null) {
            if (internalNode2 != null) {
                return false;
            }
        } else if (!((Object)internalNode).equals(internalNode2)) return false;
        Map<WrappedArray.ofByte, Object> map = this.elementsHashIndexes();
        Map<WrappedArray.ofByte, Object> map2 = merkleTree.elementsHashIndexes();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (!merkleTree.canEqual(this)) return false;
        return true;
    }

    private final Option loop$1(Node node, int i, int curLength, Seq acc) {
        None$ none$;
        Node node2;
        while (true) {
            boolean bl = false;
            InternalNode internalNode = null;
            node2 = node;
            if (node2 instanceof InternalNode) {
                bl = true;
                internalNode = (InternalNode)node2;
                if (i < curLength / 2) {
                    acc = (Seq)acc.$colon$plus((Object)new Tuple2(internalNode.right().hash(), (Object)BoxesRunTime.boxToByte((byte)MerkleProof$.MODULE$.LeftSide())), Seq$.MODULE$.canBuildFrom());
                    curLength /= 2;
                    node = internalNode.left();
                    continue;
                }
            }
            if (!bl || i >= curLength) break;
            int n = i - curLength / 2;
            acc = (Seq)acc.$colon$plus((Object)new Tuple2(internalNode.left().hash(), (Object)BoxesRunTime.boxToByte((byte)MerkleProof$.MODULE$.RightSide())), Seq$.MODULE$.canBuildFrom());
            curLength /= 2;
            i = n;
            node = internalNode.right();
        }
        if (node2 instanceof Leaf) {
            Leaf leaf = (Leaf)node2;
            none$ = new Some((Object)new Tuple2((Object)leaf, acc.reverse()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private static final double log2$1(double x) {
        return package$.MODULE$.log(x) / package$.MODULE$.log(2.0);
    }

    private final String loop$2(Seq nodes, int level, String acc) {
        while (nodes.nonEmpty()) {
            String thisLevStr = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Level ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)level)})) + ((TraversableOnce)nodes.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Seq$.MODULE$.canBuildFrom())).mkString(",") + "\n";
            Seq nextLevNodes = (Seq)nodes.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Seq seq;
                Node node = x0$1;
                if (node instanceof InternalNode) {
                    InternalNode internalNode = (InternalNode)node;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{internalNode.left(), internalNode.right()}));
                } else {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                }
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
            acc = acc + thisLevStr;
            ++level;
            nodes = nextLevNodes;
        }
        return acc;
    }

    public MerkleTree(InternalNode<D> topNode, Map<WrappedArray.ofByte, Object> elementsHashIndexes) {
        this.topNode = topNode;
        this.elementsHashIndexes = elementsHashIndexes;
        Product.$init$((Product)this);
    }
}

