/*
 * Decompiled with CFR 0.152.
 */
package scorex.crypto.signatures;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.curve25519.OpportunisticCurve25519Provider;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try$;
import scorex.crypto.hash.Sha256$;
import scorex.crypto.signatures.EllipticCurveSignatureScheme;
import scorex.crypto.signatures.SigningFunctions;
import scorex.crypto.signatures.package$PrivateKey$;
import scorex.crypto.signatures.package$PublicKey$;
import scorex.crypto.signatures.package$SharedSecret$;
import scorex.crypto.signatures.package$Signature$;
import supertagged.package;

public final class Curve25519$
implements EllipticCurveSignatureScheme {
    public static Curve25519$ MODULE$;
    private Logger log;
    private final int SignatureLength25519;
    private final int KeyLength25519;
    private final int SignatureLength;
    private final int KeyLength;
    private final OpportunisticCurve25519Provider provider;
    private volatile boolean bitmap$0;

    static {
        new Curve25519$();
    }

    @Override
    public Tuple2<byte[], byte[]> createKeyPair() {
        return SigningFunctions.createKeyPair$(this);
    }

    public int SignatureLength25519() {
        return this.SignatureLength25519;
    }

    public int KeyLength25519() {
        return this.KeyLength25519;
    }

    @Override
    public int SignatureLength() {
        return this.SignatureLength;
    }

    @Override
    public int KeyLength() {
        return this.KeyLength;
    }

    private OpportunisticCurve25519Provider provider() {
        return this.provider;
    }

    @Override
    public Tuple2<byte[], byte[]> createKeyPair(byte[] seed) {
        byte[] hashedSeed = Sha256$.MODULE$.hash(seed);
        byte[] privateKey = (byte[])package$PrivateKey$.MODULE$.$at$at(this.provider().generatePrivateKey(hashedSeed), package.Tagger$.MODULE$.baseRaw());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)privateKey), package$PublicKey$.MODULE$.$at$at(this.provider().generatePublicKey(privateKey), package.Tagger$.MODULE$.baseRaw()));
    }

    @Override
    public byte[] sign(byte[] privateKey, byte[] message) {
        Predef$.MODULE$.require(privateKey.length == this.KeyLength());
        return (byte[])package$Signature$.MODULE$.$at$at(this.provider().calculateSignature(this.provider().getRandom(this.SignatureLength()), privateKey, message), package.Tagger$.MODULE$.baseRaw());
    }

    @Override
    public boolean verify(byte[] signature, byte[] message, byte[] publicKey) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(signature.length == MODULE$.SignatureLength());
            Predef$.MODULE$.require(publicKey.length == MODULE$.KeyLength());
            return MODULE$.provider().verifySignature(publicKey, message, signature);
        }).recoverWith((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Curve25519$.MODULE$.log().debug("Error while message signature verification", A1);
                Failure failure = new Failure(A1);
                return (B1)failure;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    @Override
    public byte[] createSharedSecret(byte[] privateKey, byte[] publicKey) {
        return (byte[])package$SharedSecret$.MODULE$.$at$at(this.provider().calculateAgreement(privateKey, publicKey), package.Tagger$.MODULE$.baseRaw());
    }

    private Logger log$lzycompute() {
        Curve25519$ curve25519$ = this;
        synchronized (curve25519$) {
            if (!this.bitmap$0) {
                this.log = LoggerFactory.getLogger(this.getClass());
                this.bitmap$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$0 ? this.log$lzycompute() : this.log;
    }

    private Curve25519$() {
        MODULE$ = this;
        SigningFunctions.$init$(this);
        this.SignatureLength25519 = 64;
        this.KeyLength25519 = 32;
        this.SignatureLength = this.SignatureLength25519();
        this.KeyLength = this.KeyLength25519();
        Constructor constructor = (Constructor)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])OpportunisticCurve25519Provider.class.getDeclaredConstructors())).head();
        constructor.setAccessible(true);
        this.provider = (OpportunisticCurve25519Provider)constructor.newInstance(new Object[0]);
    }
}

