/**
 * Copyright 2014 The Sculptor Project Team, including the original
 * author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sculptor.generator.cartridge.builder;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.sculptor.generator.cartridge.builder.BuilderProperties;
import org.sculptor.generator.chain.ChainLink;
import org.sculptor.generator.chain.ChainOverridable;
import org.sculptor.generator.ext.Helper;
import org.sculptor.generator.util.HelperBase;
import sculptormetamodel.Attribute;
import sculptormetamodel.DomainObject;
import sculptormetamodel.Module;
import sculptormetamodel.NamedElement;
import sculptormetamodel.Reference;

@ChainOverridable
@SuppressWarnings("all")
public class BuilderHelper extends ChainLink<BuilderHelper> {
  @Inject
  @Extension
  private HelperBase helperBase;
  
  @Inject
  @Extension
  private Helper helper;
  
  @Inject
  @Extension
  private BuilderProperties properties;
  
  public String getBuilderPackage(final Module module) {
    String _basePackage = this.helperBase.getBasePackage(module);
    String _builderPackage = this.properties.getBuilderPackage();
    return this.helperBase.concatPackage(_basePackage, _builderPackage);
  }
  
  public String getBuilderPackage(final DomainObject it) {
    Module _module = it.getModule();
    return this.getBuilderPackage(_module);
  }
  
  public List<Attribute> getBuilderAttributes(final DomainObject domainObject) {
    BuilderHelper headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERATTRIBUTES_DOMAINOBJECT];
    return headObj._chained_getBuilderAttributes(domainObject);
  }
  
  public List<Reference> getBuilderReferences(final DomainObject domainObject) {
    BuilderHelper headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERREFERENCES_DOMAINOBJECT];
    return headObj._chained_getBuilderReferences(domainObject);
  }
  
  public List<NamedElement> getBuilderConstructorParameters(final DomainObject domainObject) {
    BuilderHelper headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERCONSTRUCTORPARAMETERS_DOMAINOBJECT];
    return headObj._chained_getBuilderConstructorParameters(domainObject);
  }
  
  public List<NamedElement> getBuilderProperties(final DomainObject domainObject) {
    BuilderHelper headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERPROPERTIES_DOMAINOBJECT];
    return headObj._chained_getBuilderProperties(domainObject);
  }
  
  public String getBuilderClassName(final DomainObject domainObject) {
    BuilderHelper headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERCLASSNAME_DOMAINOBJECT];
    return headObj._chained_getBuilderClassName(domainObject);
  }
  
  public String getBuilderFqn(final DomainObject domainObject) {
    BuilderHelper headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERFQN_DOMAINOBJECT];
    return headObj._chained_getBuilderFqn(domainObject);
  }
  
  public boolean _needsBuilder(final DomainObject domainObject) {
    BuilderHelper headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes._NEEDSBUILDER_DOMAINOBJECT];
    return headObj._chained__needsBuilder(domainObject);
  }
  
  public boolean _needsBuilder(final sculptormetamodel.Enum domainObject) {
    BuilderHelper headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes._NEEDSBUILDER_ENUM];
    return headObj._chained__needsBuilder(domainObject);
  }
  
  public boolean needsBuilder(final DomainObject domainObject) {
    if (domainObject instanceof sculptormetamodel.Enum) {
      return _needsBuilder((sculptormetamodel.Enum)domainObject);
    } else if (domainObject != null) {
      return _needsBuilder(domainObject);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(domainObject).toString());
    }
  }
  
  public BuilderHelper(final BuilderHelper next) {
    super(next);
  }
  
  public List<Attribute> _chained_getBuilderAttributes(final DomainObject domainObject) {
    Collection<Attribute> _allAttributes = this.helper.getAllAttributes(domainObject);
    final Function1<Attribute, Boolean> _function = new Function1<Attribute, Boolean>() {
      public Boolean apply(final Attribute a) {
        boolean _and = false;
        boolean _and_1 = false;
        boolean _isUuid = BuilderHelper.this.helper.isUuid(a);
        boolean _not = (!_isUuid);
        if (!_not) {
          _and_1 = false;
        } else {
          Attribute _idAttribute = BuilderHelper.this.helper.getIdAttribute(domainObject);
          boolean _notEquals = (!Objects.equal(a, _idAttribute));
          _and_1 = _notEquals;
        }
        if (!_and_1) {
          _and = false;
        } else {
          String _name = a.getName();
          boolean _notEquals_1 = (!Objects.equal(_name, "version"));
          _and = _notEquals_1;
        }
        return Boolean.valueOf(_and);
      }
    };
    Iterable<Attribute> _filter = IterableExtensions.<Attribute>filter(_allAttributes, _function);
    return IterableExtensions.<Attribute>toList(_filter);
  }
  
  public List<Reference> _chained_getBuilderReferences(final DomainObject domainObject) {
    Collection<Reference> _allReferences = this.helper.getAllReferences(domainObject);
    return IterableExtensions.<Reference>toList(_allReferences);
  }
  
  public List<NamedElement> _chained_getBuilderConstructorParameters(final DomainObject domainObject) {
    return this.helper.getConstructorParameters(domainObject);
  }
  
  public List<NamedElement> _chained_getBuilderProperties(final DomainObject domainObject) {
    List<NamedElement> _xblockexpression = null;
    {
      final List<NamedElement> retVal = CollectionLiterals.<NamedElement>newArrayList();
      List<Attribute> _builderAttributes = this.getBuilderAttributes(domainObject);
      retVal.addAll(_builderAttributes);
      List<Reference> _builderReferences = this.getBuilderReferences(domainObject);
      retVal.addAll(_builderReferences);
      _xblockexpression = retVal;
    }
    return _xblockexpression;
  }
  
  public String _chained_getBuilderClassName(final DomainObject domainObject) {
    String _name = domainObject.getName();
    return (_name + "Builder");
  }
  
  public String _chained_getBuilderFqn(final DomainObject domainObject) {
    String _builderPackage = this.getBuilderPackage(domainObject);
    String _plus = (_builderPackage + ".");
    String _builderClassName = this.getBuilderClassName(domainObject);
    return (_plus + _builderClassName);
  }
  
  public boolean _chained__needsBuilder(final DomainObject domainObject) {
    boolean _isAbstract = domainObject.isAbstract();
    return (_isAbstract == false);
  }
  
  public boolean _chained__needsBuilder(final sculptormetamodel.Enum domainObject) {
    return false;
  }
  
  public BuilderHelper[] _getOverridesDispatchArray() {
    org.sculptor.generator.cartridge.builder.BuilderHelper[] result = new org.sculptor.generator.cartridge.builder.BuilderHelper[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.NUM_METHODS];
    result[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERATTRIBUTES_DOMAINOBJECT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERREFERENCES_DOMAINOBJECT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERCONSTRUCTORPARAMETERS_DOMAINOBJECT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERPROPERTIES_DOMAINOBJECT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERCLASSNAME_DOMAINOBJECT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERFQN_DOMAINOBJECT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes._NEEDSBUILDER_DOMAINOBJECT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes._NEEDSBUILDER_ENUM] = this; 
    return result;
  }
}
