/**
 * Copyright 2014 The Sculptor Project Team, including the original
 * author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sculptor.generator.cartridge.builder;

import org.sculptor.generator.cartridge.builder.BuilderProperties;

/**
 * Method dispatch class for BuilderProperties, used for dispatching to overrideable methods
 */
@SuppressWarnings("all")
public class BuilderPropertiesMethodDispatch extends BuilderProperties {
  public BuilderPropertiesMethodDispatch(final BuilderProperties[] methodsDispatchTable) {
    super(null);
    this.methodsDispatchTable = methodsDispatchTable; 
  }
  
  public BuilderPropertiesMethodDispatch(final BuilderProperties next, final BuilderProperties[] methodsDispatchTable) {
    super(next);
    this.methodsDispatchTable = methodsDispatchTable; 
  }
  
  private final BuilderProperties[] methodsDispatchTable;
  
  public final BuilderProperties[] getMethodsDispatchTable() {
    return(methodsDispatchTable);
  }
}
