/**
 * Copyright 2014 The Sculptor Project Team, including the original
 * author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sculptor.generator.cartridge.builder;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.sculptor.generator.cartridge.builder.BuilderHelper;
import org.sculptor.generator.chain.ChainLink;
import org.sculptor.generator.chain.ChainOverridable;
import org.sculptor.generator.ext.Helper;
import org.sculptor.generator.ext.Properties;
import org.sculptor.generator.template.domain.DomainObjectAttributeTmpl;
import org.sculptor.generator.template.domain.DomainObjectConstructorTmpl;
import org.sculptor.generator.template.domain.DomainObjectReferenceTmpl;
import org.sculptor.generator.util.HelperBase;
import org.sculptor.generator.util.OutputSlot;
import sculptormetamodel.Attribute;
import sculptormetamodel.DomainObject;
import sculptormetamodel.NamedElement;
import sculptormetamodel.Reference;

@ChainOverridable
@SuppressWarnings("all")
public class BuilderTmpl extends ChainLink<BuilderTmpl> {
  @Inject
  @Extension
  private BuilderHelper builderHelper;
  
  @Inject
  @Extension
  private HelperBase helperBase;
  
  @Inject
  @Extension
  private Helper helper;
  
  @Inject
  @Extension
  private Properties properties;
  
  @Inject
  private DomainObjectAttributeTmpl domainObjectAttributeTmpl;
  
  @Inject
  private DomainObjectReferenceTmpl domainObjectReferenceTmpl;
  
  @Inject
  private DomainObjectConstructorTmpl domainObjectConstructorTmpl;
  
  public String builder(final DomainObject it) {
    BuilderTmpl headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDER_DOMAINOBJECT];
    return headObj._chained_builder(it);
  }
  
  public String builderBody(final DomainObject it) {
    BuilderTmpl headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERBODY_DOMAINOBJECT];
    return headObj._chained_builderBody(it);
  }
  
  public String assignAttributeInConstructor(final NamedElement it) {
    BuilderTmpl headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.ASSIGNATTRIBUTEINCONSTRUCTOR_NAMEDELEMENT];
    return headObj._chained_assignAttributeInConstructor(it);
  }
  
  public String multiReferenceAdd(final Reference it, final DomainObject obj) {
    BuilderTmpl headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.MULTIREFERENCEADD_REFERENCE_DOMAINOBJECT];
    return headObj._chained_multiReferenceAdd(it, obj);
  }
  
  public String builderAttribute(final Attribute it) {
    BuilderTmpl headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERATTRIBUTE_ATTRIBUTE];
    return headObj._chained_builderAttribute(it);
  }
  
  public String builderAttributeSetter(final Attribute it, final DomainObject obj) {
    BuilderTmpl headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERATTRIBUTESETTER_ATTRIBUTE_DOMAINOBJECT];
    return headObj._chained_builderAttributeSetter(it, obj);
  }
  
  public String builderSingleReferenceSetter(final Reference it, final DomainObject obj) {
    BuilderTmpl headObj = getMethodsDispatchHead()[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERSINGLEREFERENCESETTER_REFERENCE_DOMAINOBJECT];
    return headObj._chained_builderSingleReferenceSetter(it, obj);
  }
  
  public BuilderTmpl(final BuilderTmpl next) {
    super(next);
  }
  
  public String _chained_builder(final DomainObject it) {
    String _builderFqn = this.builderHelper.getBuilderFqn(it);
    String _javaFileName = this.helper.javaFileName(_builderFqn);
    StringConcatenation _builder = new StringConcatenation();
    String _javaHeader = this.properties.javaHeader();
    _builder.append(_javaHeader, "");
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    String _builderPackage = this.builderHelper.getBuilderPackage(it);
    _builder.append(_builderPackage, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("/// Sculptor code formatter imports ///");
    _builder.newLine();
    _builder.newLine();
    String _builderBody = this.builderBody(it);
    _builder.append(_builderBody, "");
    _builder.newLineIfNotEmpty();
    return this.helper.fileOutput(_javaFileName, OutputSlot.TO_GEN_SRC, _builder.toString());
  }
  
  public String _chained_builderBody(final DomainObject it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Builder for ");
    String _name = it.getName();
    _builder.append(_name, " ");
    _builder.append(" class.");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public class ");
    String _builderClassName = this.builderHelper.getBuilderClassName(it);
    _builder.append(_builderClassName, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    List<Attribute> _builderAttributes = this.builderHelper.getBuilderAttributes(it);
    final Function1<Attribute, String> _function = new Function1<Attribute, String>() {
      public String apply(final Attribute a) {
        return BuilderTmpl.this.domainObjectAttributeTmpl.attribute(a, false);
      }
    };
    List<String> _map = ListExtensions.<Attribute, String>map(_builderAttributes, _function);
    String _join = IterableExtensions.join(_map);
    _builder.append(_join, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    List<Reference> _builderReferences = this.builderHelper.getBuilderReferences(it);
    final Function1<Reference, Boolean> _function_1 = new Function1<Reference, Boolean>() {
      public Boolean apply(final Reference r) {
        boolean _isMany = r.isMany();
        return Boolean.valueOf((!_isMany));
      }
    };
    Iterable<Reference> _filter = IterableExtensions.<Reference>filter(_builderReferences, _function_1);
    final Function1<Reference, String> _function_2 = new Function1<Reference, String>() {
      public String apply(final Reference e) {
        return BuilderTmpl.this.domainObjectReferenceTmpl.oneReferenceAttribute(e, false);
      }
    };
    Iterable<String> _map_1 = IterableExtensions.<Reference, String>map(_filter, _function_2);
    String _join_1 = IterableExtensions.join(_map_1);
    _builder.append(_join_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    List<Reference> _builderReferences_1 = this.builderHelper.getBuilderReferences(it);
    final Function1<Reference, Boolean> _function_3 = new Function1<Reference, Boolean>() {
      public Boolean apply(final Reference r) {
        return Boolean.valueOf(r.isMany());
      }
    };
    Iterable<Reference> _filter_1 = IterableExtensions.<Reference>filter(_builderReferences_1, _function_3);
    final Function1<Reference, String> _function_4 = new Function1<Reference, String>() {
      public String apply(final Reference e) {
        return BuilderTmpl.this.domainObjectReferenceTmpl.manyReferenceAttribute(e, false);
      }
    };
    Iterable<String> _map_2 = IterableExtensions.<Reference, String>map(_filter_1, _function_4);
    String _join_2 = IterableExtensions.join(_map_2);
    _builder.append(_join_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Static factory method for ");
    String _builderClassName_1 = this.builderHelper.getBuilderClassName(it);
    _builder.append(_builderClassName_1, "\t ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static ");
    String _name_1 = it.getName();
    _builder.append(_name_1, "\t");
    _builder.append("Builder ");
    String _name_2 = it.getName();
    String _firstLower = this.helperBase.toFirstLower(_name_2);
    _builder.append(_firstLower, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return new ");
    String _name_3 = it.getName();
    _builder.append(_name_3, "\t\t");
    _builder.append("Builder();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _name_4 = it.getName();
    _builder.append(_name_4, "\t");
    _builder.append("Builder() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    {
      List<NamedElement> _builderConstructorParameters = this.builderHelper.getBuilderConstructorParameters(it);
      boolean _isEmpty = _builderConstructorParameters.isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        _builder.append("\t");
        _builder.append("public ");
        String _name_5 = it.getName();
        _builder.append(_name_5, "\t");
        _builder.append("Builder(");
        List<NamedElement> _builderConstructorParameters_1 = this.builderHelper.getBuilderConstructorParameters(it);
        final Function1<NamedElement, String> _function_5 = new Function1<NamedElement, String>() {
          public String apply(final NamedElement p) {
            return BuilderTmpl.this.domainObjectConstructorTmpl.parameterTypeAndName(p);
          }
        };
        List<String> _map_3 = ListExtensions.<NamedElement, String>map(_builderConstructorParameters_1, _function_5);
        String _join_3 = IterableExtensions.join(_map_3, ",");
        _builder.append(_join_3, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        {
          List<NamedElement> _builderConstructorParameters_2 = this.builderHelper.getBuilderConstructorParameters(it);
          for(final NamedElement p : _builderConstructorParameters_2) {
            _builder.append("\t");
            _builder.append("\t");
            String _assignAttributeInConstructor = this.assignAttributeInConstructor(p);
            _builder.append(_assignAttributeInConstructor, "\t\t");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    List<Attribute> _builderAttributes_1 = this.builderHelper.getBuilderAttributes(it);
    final Function1<Attribute, String> _function_6 = new Function1<Attribute, String>() {
      public String apply(final Attribute a) {
        return BuilderTmpl.this.builderAttributeSetter(a, it);
      }
    };
    List<String> _map_4 = ListExtensions.<Attribute, String>map(_builderAttributes_1, _function_6);
    String _join_4 = IterableExtensions.join(_map_4);
    _builder.append(_join_4, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    List<Reference> _builderReferences_2 = this.builderHelper.getBuilderReferences(it);
    final Function1<Reference, Boolean> _function_7 = new Function1<Reference, Boolean>() {
      public Boolean apply(final Reference r) {
        boolean _isMany = r.isMany();
        return Boolean.valueOf((!_isMany));
      }
    };
    Iterable<Reference> _filter_2 = IterableExtensions.<Reference>filter(_builderReferences_2, _function_7);
    final Function1<Reference, String> _function_8 = new Function1<Reference, String>() {
      public String apply(final Reference r) {
        return BuilderTmpl.this.builderSingleReferenceSetter(r, it);
      }
    };
    Iterable<String> _map_5 = IterableExtensions.<Reference, String>map(_filter_2, _function_8);
    String _join_5 = IterableExtensions.join(_map_5);
    _builder.append(_join_5, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    List<Reference> _builderReferences_3 = this.builderHelper.getBuilderReferences(it);
    final Function1<Reference, Boolean> _function_9 = new Function1<Reference, Boolean>() {
      public Boolean apply(final Reference r) {
        return Boolean.valueOf(r.isMany());
      }
    };
    Iterable<Reference> _filter_3 = IterableExtensions.<Reference>filter(_builderReferences_3, _function_9);
    final Function1<Reference, String> _function_10 = new Function1<Reference, String>() {
      public String apply(final Reference r) {
        return BuilderTmpl.this.multiReferenceAdd(r, it);
      }
    };
    Iterable<String> _map_6 = IterableExtensions.<Reference, String>map(_filter_3, _function_10);
    String _join_6 = IterableExtensions.join(_map_6);
    _builder.append(_join_6, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    List<Attribute> _builderAttributes_2 = this.builderHelper.getBuilderAttributes(it);
    final Function1<Attribute, String> _function_11 = new Function1<Attribute, String>() {
      public String apply(final Attribute a) {
        return BuilderTmpl.this.domainObjectAttributeTmpl.propertyGetter(a);
      }
    };
    List<String> _map_7 = ListExtensions.<Attribute, String>map(_builderAttributes_2, _function_11);
    String _join_7 = IterableExtensions.join(_map_7);
    _builder.append(_join_7, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    List<Reference> _builderReferences_4 = this.builderHelper.getBuilderReferences(it);
    final Function1<Reference, Boolean> _function_12 = new Function1<Reference, Boolean>() {
      public Boolean apply(final Reference r) {
        boolean _isMany = r.isMany();
        return Boolean.valueOf((!_isMany));
      }
    };
    Iterable<Reference> _filter_4 = IterableExtensions.<Reference>filter(_builderReferences_4, _function_12);
    final Function1<Reference, String> _function_13 = new Function1<Reference, String>() {
      public String apply(final Reference r) {
        return BuilderTmpl.this.domainObjectReferenceTmpl.oneReferenceGetter(r, false);
      }
    };
    Iterable<String> _map_8 = IterableExtensions.<Reference, String>map(_filter_4, _function_13);
    String _join_8 = IterableExtensions.join(_map_8);
    _builder.append(_join_8, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    List<Reference> _builderReferences_5 = this.builderHelper.getBuilderReferences(it);
    final Function1<Reference, Boolean> _function_14 = new Function1<Reference, Boolean>() {
      public Boolean apply(final Reference r) {
        return Boolean.valueOf(r.isMany());
      }
    };
    Iterable<Reference> _filter_5 = IterableExtensions.<Reference>filter(_builderReferences_5, _function_14);
    final Function1<Reference, String> _function_15 = new Function1<Reference, String>() {
      public String apply(final Reference r) {
        return BuilderTmpl.this.domainObjectReferenceTmpl.manyReferenceGetter(r, false);
      }
    };
    Iterable<String> _map_9 = IterableExtensions.<Reference, String>map(_filter_5, _function_15);
    String _join_9 = IterableExtensions.join(_map_9);
    _builder.append(_join_9, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @return new ");
    String _name_6 = it.getName();
    _builder.append(_name_6, "\t ");
    _builder.append(" instance constructed based on the values that have been set into this builder");
    _builder.newLineIfNotEmpty();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _domainPackage = this.helperBase.getDomainPackage(it);
    String _plus = (_domainPackage + ".");
    String _name_7 = it.getName();
    String _plus_1 = (_plus + _name_7);
    _builder.append(_plus_1, "\t");
    _builder.append(" build() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    String _domainPackage_1 = this.helperBase.getDomainPackage(it);
    String _plus_2 = (_domainPackage_1 + ".");
    String _name_8 = it.getName();
    String _plus_3 = (_plus_2 + _name_8);
    _builder.append(_plus_3, "\t\t");
    _builder.append(" obj = new ");
    String _name_9 = it.getName();
    _builder.append(_name_9, "\t\t");
    _builder.append("(");
    {
      List<NamedElement> _builderConstructorParameters_3 = this.builderHelper.getBuilderConstructorParameters(it);
      boolean _hasElements = false;
      for(final NamedElement attr : _builderConstructorParameters_3) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "\t\t");
        }
        String _getAccessor = this.helper.getGetAccessor(attr);
        _builder.append(_getAccessor, "\t\t");
        _builder.append("()");
      }
    }
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    final List<NamedElement> attrs = CollectionLiterals.<NamedElement>newArrayList();
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    String _xblockexpression = null;
    {
      List<Attribute> _builderAttributes_3 = this.builderHelper.getBuilderAttributes(it);
      attrs.addAll(_builderAttributes_3);
      List<Reference> _builderReferences_6 = this.builderHelper.getBuilderReferences(it);
      final Function1<Reference, Boolean> _function_16 = new Function1<Reference, Boolean>() {
        public Boolean apply(final Reference r) {
          boolean _isMany = r.isMany();
          return Boolean.valueOf((!_isMany));
        }
      };
      Iterable<Reference> _filter_6 = IterableExtensions.<Reference>filter(_builderReferences_6, _function_16);
      List<Reference> _list = IterableExtensions.<Reference>toList(_filter_6);
      attrs.addAll(_list);
      List<NamedElement> _builderConstructorParameters_4 = this.builderHelper.getBuilderConstructorParameters(it);
      attrs.removeAll(_builderConstructorParameters_4);
      _xblockexpression = "";
    }
    _builder.append(_xblockexpression, "\t\t");
    _builder.newLineIfNotEmpty();
    {
      for(final NamedElement prop : attrs) {
        _builder.append("\t\t");
        _builder.append("obj.set");
        String _name_10 = prop.getName();
        String _firstUpper = this.helperBase.toFirstUpper(_name_10);
        _builder.append(_firstUpper, "\t\t");
        _builder.append("(");
        String _name_11 = prop.getName();
        _builder.append(_name_11, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    List<Reference> _builderReferences_6 = this.builderHelper.getBuilderReferences(it);
    final Function1<Reference, Boolean> _function_16 = new Function1<Reference, Boolean>() {
      public Boolean apply(final Reference r) {
        return Boolean.valueOf(r.isMany());
      }
    };
    Iterable<Reference> _filter_6 = IterableExtensions.<Reference>filter(_builderReferences_6, _function_16);
    final List<Reference> refs = IterableExtensions.<Reference>toList(_filter_6);
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    String _xblockexpression_1 = null;
    {
      List<NamedElement> _builderConstructorParameters_4 = this.builderHelper.getBuilderConstructorParameters(it);
      refs.removeAll(_builderConstructorParameters_4);
      _xblockexpression_1 = "";
    }
    _builder.append(_xblockexpression_1, "\t\t");
    _builder.newLineIfNotEmpty();
    {
      for(final Reference prop_1 : refs) {
        _builder.append("\t\t");
        _builder.append("obj.get");
        String _name_12 = prop_1.getName();
        String _firstUpper_1 = this.helperBase.toFirstUpper(_name_12);
        _builder.append(_firstUpper_1, "\t\t");
        _builder.append("().addAll(");
        String _name_13 = prop_1.getName();
        _builder.append(_name_13, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return obj;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder.toString();
  }
  
  public String _chained_assignAttributeInConstructor(final NamedElement it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _and = false;
      if (!(it instanceof Reference)) {
        _and = false;
      } else {
        boolean _isMany = ((Reference) it).isMany();
        _and = _isMany;
      }
      if (_and) {
        _builder.append("this.");
        String _name = it.getName();
        _builder.append(_name, "");
        _builder.append(".addAll(");
        String _name_1 = it.getName();
        _builder.append(_name_1, "");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      } else {
        _builder.append("this.");
        String _name_2 = it.getName();
        _builder.append(_name_2, "");
        _builder.append(" = ");
        String _name_3 = it.getName();
        _builder.append(_name_3, "");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    return _builder.toString();
  }
  
  public String _chained_multiReferenceAdd(final Reference it, final DomainObject obj) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/**");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* Adds an object to the to-many");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* association.");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("* It is added the collection {@link #get");
    String _name = it.getName();
    String _firstUpper = this.helperBase.toFirstUpper(_name);
    _builder.append(_firstUpper, " ");
    _builder.append("}.");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public ");
    String _name_1 = obj.getName();
    _builder.append(_name_1, "");
    _builder.append("Builder add");
    String _name_2 = it.getName();
    String _firstUpper_1 = this.helperBase.toFirstUpper(_name_2);
    String _singular = this.helper.singular(_firstUpper_1);
    _builder.append(_singular, "");
    _builder.append("(");
    String _typeName = this.helperBase.getTypeName(it);
    _builder.append(_typeName, "");
    _builder.append(" ");
    String _name_3 = it.getName();
    String _singular_1 = this.helper.singular(_name_3);
    _builder.append(_singular_1, "");
    _builder.append("Element) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("get");
    String _name_4 = it.getName();
    String _firstUpper_2 = this.helperBase.toFirstUpper(_name_4);
    _builder.append(_firstUpper_2, "\t");
    _builder.append("().add(");
    String _name_5 = it.getName();
    String _singular_2 = this.helper.singular(_name_5);
    _builder.append(_singular_2, "\t");
    _builder.append("Element);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return this;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
  
  public String _chained_builderAttribute(final Attribute it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("protected ");
    String _implTypeName = this.helperBase.getImplTypeName(it);
    _builder.append(_implTypeName, "");
    _builder.append(" ");
    String _name = it.getName();
    _builder.append(_name, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  public String _chained_builderAttributeSetter(final Attribute it, final DomainObject obj) {
    StringConcatenation _builder = new StringConcatenation();
    String _formatJavaDoc = this.helper.formatJavaDoc(it);
    _builder.append(_formatJavaDoc, "");
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    String _name = obj.getName();
    _builder.append(_name, "");
    _builder.append("Builder ");
    String _name_1 = it.getName();
    _builder.append(_name_1, "");
    _builder.append("(");
    String _typeName = this.helperBase.getTypeName(it);
    _builder.append(_typeName, "");
    _builder.append(" val) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.");
    String _name_2 = it.getName();
    _builder.append(_name_2, "\t");
    _builder.append(" = val;");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return this;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
  
  public String _chained_builderSingleReferenceSetter(final Reference it, final DomainObject obj) {
    StringConcatenation _builder = new StringConcatenation();
    String _formatJavaDoc = this.helper.formatJavaDoc(it);
    _builder.append(_formatJavaDoc, "");
    _builder.newLineIfNotEmpty();
    _builder.append("public ");
    String _name = obj.getName();
    _builder.append(_name, "");
    _builder.append("Builder ");
    String _name_1 = it.getName();
    _builder.append(_name_1, "");
    _builder.append("(");
    String _typeName = this.helperBase.getTypeName(it);
    _builder.append(_typeName, "");
    _builder.append(" ");
    String _name_2 = it.getName();
    _builder.append(_name_2, "");
    _builder.append(") {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("this.");
    String _name_3 = it.getName();
    _builder.append(_name_3, "\t");
    _builder.append(" = ");
    String _name_4 = it.getName();
    _builder.append(_name_4, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return this;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
  
  public BuilderTmpl[] _getOverridesDispatchArray() {
    org.sculptor.generator.cartridge.builder.BuilderTmpl[] result = new org.sculptor.generator.cartridge.builder.BuilderTmpl[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.NUM_METHODS];
    result[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDER_DOMAINOBJECT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERBODY_DOMAINOBJECT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.ASSIGNATTRIBUTEINCONSTRUCTOR_NAMEDELEMENT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.MULTIREFERENCEADD_REFERENCE_DOMAINOBJECT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERATTRIBUTE_ATTRIBUTE] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERATTRIBUTESETTER_ATTRIBUTE_DOMAINOBJECT] = this; 
    result[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERSINGLEREFERENCESETTER_REFERENCE_DOMAINOBJECT] = this; 
    return result;
  }
}
