/**
 * Copyright 2014 The Sculptor Project Team, including the original
 * author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sculptor.generator.cartridge.builder;

import org.sculptor.generator.cartridge.builder.BuilderTmpl;
import sculptormetamodel.Attribute;
import sculptormetamodel.DomainObject;
import sculptormetamodel.NamedElement;
import sculptormetamodel.Reference;

/**
 * Method dispatch class for BuilderTmpl, used for dispatching to overrideable methods
 */
@SuppressWarnings("all")
public class BuilderTmplMethodDispatch extends BuilderTmpl {
  public BuilderTmplMethodDispatch(final BuilderTmpl[] methodsDispatchTable) {
    super(null);
    this.methodsDispatchTable = methodsDispatchTable; 
  }
  
  public BuilderTmplMethodDispatch(final BuilderTmpl next, final BuilderTmpl[] methodsDispatchTable) {
    super(next);
    this.methodsDispatchTable = methodsDispatchTable; 
  }
  
  private final BuilderTmpl[] methodsDispatchTable;
  
  public final BuilderTmpl[] getMethodsDispatchTable() {
    return(methodsDispatchTable);
  }
  
  public String builder(final DomainObject it) {
    BuilderTmpl nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDER_DOMAINOBJECT];
    return nextObj._chained_builder(it);
  }
  
  public String builderBody(final DomainObject it) {
    BuilderTmpl nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERBODY_DOMAINOBJECT];
    return nextObj._chained_builderBody(it);
  }
  
  public String assignAttributeInConstructor(final NamedElement it) {
    BuilderTmpl nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.ASSIGNATTRIBUTEINCONSTRUCTOR_NAMEDELEMENT];
    return nextObj._chained_assignAttributeInConstructor(it);
  }
  
  public String multiReferenceAdd(final Reference it, final DomainObject obj) {
    BuilderTmpl nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.MULTIREFERENCEADD_REFERENCE_DOMAINOBJECT];
    return nextObj._chained_multiReferenceAdd(it, obj);
  }
  
  public String builderAttribute(final Attribute it) {
    BuilderTmpl nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERATTRIBUTE_ATTRIBUTE];
    return nextObj._chained_builderAttribute(it);
  }
  
  public String builderAttributeSetter(final Attribute it, final DomainObject obj) {
    BuilderTmpl nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERATTRIBUTESETTER_ATTRIBUTE_DOMAINOBJECT];
    return nextObj._chained_builderAttributeSetter(it, obj);
  }
  
  public String builderSingleReferenceSetter(final Reference it, final DomainObject obj) {
    BuilderTmpl nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderTmplMethodIndexes.BUILDERSINGLEREFERENCESETTER_REFERENCE_DOMAINOBJECT];
    return nextObj._chained_builderSingleReferenceSetter(it, obj);
  }
}
