/*
 * Decompiled with CFR 0.152.
 */
package org.sculptor.generator.cartridge.builder;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.sculptor.generator.cartridge.builder.BuilderProperties;
import org.sculptor.generator.chain.ChainLink;
import org.sculptor.generator.chain.ChainOverridable;
import org.sculptor.generator.ext.Helper;
import org.sculptor.generator.util.HelperBase;
import sculptormetamodel.Attribute;
import sculptormetamodel.DomainObject;
import sculptormetamodel.Enum;
import sculptormetamodel.Module;
import sculptormetamodel.NamedElement;
import sculptormetamodel.Reference;

@ChainOverridable
public class BuilderHelper
extends ChainLink<BuilderHelper> {
    @Inject
    @Extension
    private HelperBase helperBase;
    @Inject
    @Extension
    private Helper helper;
    @Inject
    @Extension
    private BuilderProperties properties;

    public String getBuilderPackage(Module module) {
        String _basePackage = this.helperBase.getBasePackage(module);
        String _builderPackage = this.properties.getBuilderPackage();
        return this.helperBase.concatPackage(_basePackage, _builderPackage);
    }

    public String getBuilderPackage(DomainObject it) {
        Module _module = it.getModule();
        return this.getBuilderPackage(_module);
    }

    public List<Attribute> getBuilderAttributes(DomainObject domainObject) {
        BuilderHelper headObj = ((BuilderHelper[])this.getMethodsDispatchHead())[0];
        return headObj._chained_getBuilderAttributes(domainObject);
    }

    public List<Reference> getBuilderReferences(DomainObject domainObject) {
        BuilderHelper headObj = ((BuilderHelper[])this.getMethodsDispatchHead())[1];
        return headObj._chained_getBuilderReferences(domainObject);
    }

    public List<NamedElement> getBuilderConstructorParameters(DomainObject domainObject) {
        BuilderHelper headObj = ((BuilderHelper[])this.getMethodsDispatchHead())[2];
        return headObj._chained_getBuilderConstructorParameters(domainObject);
    }

    public List<NamedElement> getBuilderProperties(DomainObject domainObject) {
        BuilderHelper headObj = ((BuilderHelper[])this.getMethodsDispatchHead())[3];
        return headObj._chained_getBuilderProperties(domainObject);
    }

    public String getBuilderClassName(DomainObject domainObject) {
        BuilderHelper headObj = ((BuilderHelper[])this.getMethodsDispatchHead())[4];
        return headObj._chained_getBuilderClassName(domainObject);
    }

    public String getBuilderFqn(DomainObject domainObject) {
        BuilderHelper headObj = ((BuilderHelper[])this.getMethodsDispatchHead())[5];
        return headObj._chained_getBuilderFqn(domainObject);
    }

    public boolean _needsBuilder(DomainObject domainObject) {
        BuilderHelper headObj = ((BuilderHelper[])this.getMethodsDispatchHead())[6];
        return headObj._chained__needsBuilder(domainObject);
    }

    public boolean _needsBuilder(Enum domainObject) {
        BuilderHelper headObj = ((BuilderHelper[])this.getMethodsDispatchHead())[7];
        return headObj._chained__needsBuilder(domainObject);
    }

    public boolean needsBuilder(DomainObject domainObject) {
        if (domainObject instanceof Enum) {
            return this._needsBuilder((Enum)domainObject);
        }
        if (domainObject != null) {
            return this._needsBuilder(domainObject);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(domainObject).toString());
    }

    public BuilderHelper(BuilderHelper next) {
        super((ChainLink)next);
    }

    public List<Attribute> _chained_getBuilderAttributes(final DomainObject domainObject) {
        Collection _allAttributes = this.helper.getAllAttributes(domainObject);
        Functions.Function1<Attribute, Boolean> _function = new Functions.Function1<Attribute, Boolean>(){

            public Boolean apply(Attribute a) {
                String _name;
                boolean _notEquals_1;
                Attribute _idAttribute;
                boolean _notEquals;
                boolean _not;
                boolean _and = false;
                boolean _and_1 = false;
                boolean _isUuid = BuilderHelper.this.helper.isUuid(a);
                boolean bl = _not = !_isUuid;
                _and_1 = !_not ? false : (_notEquals = !Objects.equal((Object)a, (Object)(_idAttribute = BuilderHelper.this.helper.getIdAttribute(domainObject))));
                _and = !_and_1 ? false : (_notEquals_1 = !Objects.equal((Object)(_name = a.getName()), (Object)"version"));
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_allAttributes, (Functions.Function1)_function);
        return IterableExtensions.toList((Iterable)_filter);
    }

    public List<Reference> _chained_getBuilderReferences(DomainObject domainObject) {
        Collection _allReferences = this.helper.getAllReferences(domainObject);
        return IterableExtensions.toList((Iterable)_allReferences);
    }

    public List<NamedElement> _chained_getBuilderConstructorParameters(DomainObject domainObject) {
        return this.helper.getConstructorParameters(domainObject);
    }

    public List<NamedElement> _chained_getBuilderProperties(DomainObject domainObject) {
        ArrayList _xblockexpression = null;
        ArrayList retVal = CollectionLiterals.newArrayList((Object[])new NamedElement[0]);
        List<Attribute> _builderAttributes = this.getBuilderAttributes(domainObject);
        retVal.addAll(_builderAttributes);
        List<Reference> _builderReferences = this.getBuilderReferences(domainObject);
        retVal.addAll(_builderReferences);
        _xblockexpression = retVal;
        return _xblockexpression;
    }

    public String _chained_getBuilderClassName(DomainObject domainObject) {
        String _name = domainObject.getName();
        return _name + "Builder";
    }

    public String _chained_getBuilderFqn(DomainObject domainObject) {
        String _builderPackage = this.getBuilderPackage(domainObject);
        String _plus = _builderPackage + ".";
        String _builderClassName = this.getBuilderClassName(domainObject);
        return _plus + _builderClassName;
    }

    public boolean _chained__needsBuilder(DomainObject domainObject) {
        boolean _isAbstract = domainObject.isAbstract();
        return !_isAbstract;
    }

    public boolean _chained__needsBuilder(Enum domainObject) {
        return false;
    }

    public BuilderHelper[] _getOverridesDispatchArray() {
        BuilderHelper[] result = new BuilderHelper[]{this, this, this, this, this, this, this, this};
        return result;
    }
}

