/**
 * Copyright 2014 The Sculptor Project Team, including the original
 * author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sculptor.generator.cartridge.builder;

/**
 * Constants for methods in BuilderTmpl, used for dispatching for overrideable methods
 */
@SuppressWarnings("all")
public interface BuilderTmplMethodIndexes {
  public final static int BUILDER_DOMAINOBJECT = 0;
  
  public final static int BUILDERBODY_DOMAINOBJECT = 1;
  
  public final static int ASSIGNATTRIBUTEINCONSTRUCTOR_NAMEDELEMENT = 2;
  
  public final static int MULTIREFERENCEADD_REFERENCE_DOMAINOBJECT = 3;
  
  public final static int BUILDERATTRIBUTE_ATTRIBUTE = 4;
  
  public final static int BUILDERATTRIBUTESETTER_ATTRIBUTE_DOMAINOBJECT = 5;
  
  public final static int BUILDERSINGLEREFERENCESETTER_REFERENCE_DOMAINOBJECT = 6;
  
  public final static int NUM_METHODS = 7;
}
