/*
 * Decompiled with CFR 0.152.
 */
package org.sculptor.generator.cartridge.builder;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.junit4.InjectWith;
import org.eclipselabs.xtext.utils.unittesting.XtextRunner2;
import org.eclipselabs.xtext.utils.unittesting.XtextTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.sculptor.dsl.SculptordslInjectorProvider;
import org.sculptor.generator.cartridge.builder.BuilderTmpl;
import org.sculptor.generator.test.GeneratorModelTestFixtures;
import org.sculptor.generator.test.GeneratorTestExtensions;
import sculptormetamodel.Application;
import sculptormetamodel.DomainObject;
import sculptormetamodel.Module;

@RunWith(value=XtextRunner2.class)
@InjectWith(value=SculptordslInjectorProvider.class)
public class BuilderTemplateTest
extends XtextTest {
    @Inject
    private GeneratorModelTestFixtures generatorModelTestFixtures;
    private BuilderTmpl builderTmpl;

    @Before
    public void setupExtensions() {
        BuilderTmpl _providedObject;
        this.generatorModelTestFixtures.setupInjector(new Class[]{BuilderTmpl.class});
        this.generatorModelTestFixtures.setupModel("generator-tests/builder/model.btdesign", new String[0]);
        this.builderTmpl = _providedObject = (BuilderTmpl)this.generatorModelTestFixtures.getProvidedObject(BuilderTmpl.class);
    }

    @Test
    public void testAppTransformation() {
        Application app = this.generatorModelTestFixtures.getApp();
        Assert.assertNotNull((Object)app);
        EList _modules = app.getModules();
        int _size = _modules.size();
        Assert.assertEquals((long)1L, (long)_size);
    }

    @Test
    public void testBuilderBody() {
        Application app = this.generatorModelTestFixtures.getApp();
        Assert.assertNotNull((Object)app);
        EList _modules = app.getModules();
        Module module = (Module)GeneratorTestExtensions.namedElement((EList)_modules, (String)"foobar");
        Assert.assertNotNull((Object)module);
        EList _domainObjects = module.getDomainObjects();
        DomainObject obj = (DomainObject)GeneratorTestExtensions.namedElement((EList)_domainObjects, (String)"Foo");
        Assert.assertNotNull((Object)obj);
        String code = this.builderTmpl.builderBody(obj);
        Assert.assertNotNull((Object)code);
        GeneratorTestExtensions.assertContainsConsecutiveFragments((String)code, (String[])new String[]{"public class FooBuilder {", "private String name;", "private java.util.Date timestamp;"});
        GeneratorTestExtensions.assertContainsConsecutiveFragments((String)code, (String[])new String[]{"public static FooBuilder foo() {", "return new FooBuilder();", "}", "public FooBuilder() {", "}"});
        GeneratorTestExtensions.assertContainsConsecutiveFragments((String)code, (String[])new String[]{"public FooBuilder() {", "}"});
        GeneratorTestExtensions.assertContainsConsecutiveFragments((String)code, (String[])new String[]{"public FooBuilder( String name, java.util.Date timestamp) {", "this.name = name;", "this.timestamp = timestamp;", "}"});
        GeneratorTestExtensions.assertContainsConsecutiveFragments((String)code, (String[])new String[]{"public FooBuilder name(String val) {", "this.name = val;", "return this;", "}", "public FooBuilder timestamp(java.util.Date val) {", "this.timestamp = val;", "return this;", "}"});
        GeneratorTestExtensions.assertContainsConsecutiveFragments((String)code, (String[])new String[]{"public String getName() {", "return name;", "}", "public java.util.Date getTimestamp() {", "return timestamp;", "}"});
        GeneratorTestExtensions.assertContainsConsecutiveFragments((String)code, (String[])new String[]{"public org.sculptor.example.builder.foobar.domain.Foo build() {", "org.sculptor.example.builder.foobar.domain.Foo obj = new Foo(getName(), getTimestamp());", "return obj;", "}"});
    }
}

