/**
 * Copyright 2014 The Sculptor Project Team, including the original
 * author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sculptor.generator.cartridge.builder;

import java.util.List;
import org.sculptor.generator.cartridge.builder.BuilderHelper;
import sculptormetamodel.Attribute;
import sculptormetamodel.DomainObject;
import sculptormetamodel.NamedElement;
import sculptormetamodel.Reference;

/**
 * Method dispatch class for BuilderHelper, used for dispatching to overrideable methods
 */
@SuppressWarnings("all")
public class BuilderHelperMethodDispatch extends BuilderHelper {
  public BuilderHelperMethodDispatch(final BuilderHelper[] methodsDispatchTable) {
    super(null);
    this.methodsDispatchTable = methodsDispatchTable; 
  }
  
  public BuilderHelperMethodDispatch(final BuilderHelper next, final BuilderHelper[] methodsDispatchTable) {
    super(next);
    this.methodsDispatchTable = methodsDispatchTable; 
  }
  
  private final BuilderHelper[] methodsDispatchTable;
  
  public final BuilderHelper[] getMethodsDispatchTable() {
    return(methodsDispatchTable);
  }
  
  public List<Attribute> getBuilderAttributes(final DomainObject domainObject) {
    BuilderHelper nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERATTRIBUTES_DOMAINOBJECT];
    return nextObj._chained_getBuilderAttributes(domainObject);
  }
  
  public List<Reference> getBuilderReferences(final DomainObject domainObject) {
    BuilderHelper nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERREFERENCES_DOMAINOBJECT];
    return nextObj._chained_getBuilderReferences(domainObject);
  }
  
  public List<NamedElement> getBuilderConstructorParameters(final DomainObject domainObject) {
    BuilderHelper nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERCONSTRUCTORPARAMETERS_DOMAINOBJECT];
    return nextObj._chained_getBuilderConstructorParameters(domainObject);
  }
  
  public List<NamedElement> getBuilderProperties(final DomainObject domainObject) {
    BuilderHelper nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERPROPERTIES_DOMAINOBJECT];
    return nextObj._chained_getBuilderProperties(domainObject);
  }
  
  public String getBuilderClassName(final DomainObject domainObject) {
    BuilderHelper nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERCLASSNAME_DOMAINOBJECT];
    return nextObj._chained_getBuilderClassName(domainObject);
  }
  
  public String getBuilderFqn(final DomainObject domainObject) {
    BuilderHelper nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes.GETBUILDERFQN_DOMAINOBJECT];
    return nextObj._chained_getBuilderFqn(domainObject);
  }
  
  public boolean _needsBuilder(final DomainObject domainObject) {
    BuilderHelper nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes._NEEDSBUILDER_DOMAINOBJECT];
    return nextObj._chained__needsBuilder(domainObject);
  }
  
  public boolean _needsBuilder(final sculptormetamodel.Enum domainObject) {
    BuilderHelper nextObj = methodsDispatchTable[org.sculptor.generator.cartridge.builder.BuilderHelperMethodIndexes._NEEDSBUILDER_ENUM];
    return nextObj._chained__needsBuilder(domainObject);
  }
}
