/**
 * Copyright 2014 The Sculptor Project Team, including the original
 * author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sculptor.generator.cartridge.builder;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.sculptor.generator.cartridge.builder.BuilderHelper;
import org.sculptor.generator.cartridge.builder.BuilderTmpl;
import org.sculptor.generator.chain.ChainOverride;
import org.sculptor.generator.ext.Helper;
import org.sculptor.generator.ext.Properties;
import org.sculptor.generator.template.RootTmpl;
import sculptormetamodel.Application;
import sculptormetamodel.DomainObject;

@ChainOverride
@SuppressWarnings("all")
public class RootTmplExtension extends RootTmpl {
  @Inject
  private BuilderTmpl builderTmpl;
  
  @Inject
  @Extension
  private BuilderHelper builderHelper;
  
  @Inject
  @Extension
  private Helper helper;
  
  @Inject
  @Extension
  private Properties properties;
  
  @Override
  public String root(final Application it) {
    RootTmpl headObj = getMethodsDispatchHead()[org.sculptor.generator.template.RootTmplMethodIndexes.ROOT_APPLICATION];
    return headObj._chained_root(it);
  }
  
  public RootTmplExtension(final RootTmpl next, final RootTmpl[] methodsDispatchNext) {
    super(next);
  }
  
  public String _chained_root(final Application it) {
    String _xblockexpression = null;
    {
      boolean _isDomainObjectToBeGenerated = this.properties.isDomainObjectToBeGenerated();
      if (_isDomainObjectToBeGenerated) {
        Collection<DomainObject> _allDomainObjects = this.helper.getAllDomainObjects(it, false);
        final Function1<DomainObject, Boolean> _function = new Function1<DomainObject, Boolean>() {
          @Override
          public Boolean apply(final DomainObject e) {
            return Boolean.valueOf(RootTmplExtension.this.builderHelper.needsBuilder(e));
          }
        };
        Iterable<DomainObject> _filter = IterableExtensions.<DomainObject>filter(_allDomainObjects, _function);
        final Procedure1<DomainObject> _function_1 = new Procedure1<DomainObject>() {
          @Override
          public void apply(final DomainObject e) {
            RootTmplExtension.this.builderTmpl.builder(e);
          }
        };
        IterableExtensions.<DomainObject>forEach(_filter, _function_1);
      }
      RootTmpl _next = this.getNext();
      _xblockexpression = _next.root(it);
    }
    return _xblockexpression;
  }
  
  public RootTmpl[] _getOverridesDispatchArray() {
    org.sculptor.generator.template.RootTmpl[] result = new org.sculptor.generator.template.RootTmpl[org.sculptor.generator.template.RootTmplMethodIndexes.NUM_METHODS];
    result[org.sculptor.generator.template.RootTmplMethodIndexes.ROOT_APPLICATION] = this; 
    return result;
  }
}
