/*
 * Decompiled with CFR 0.152.
 */
package org.sculptor.generator.cartridge.builder;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.sculptor.generator.cartridge.builder.BuilderHelper;
import org.sculptor.generator.chain.ChainLink;
import org.sculptor.generator.chain.ChainOverridable;
import org.sculptor.generator.ext.Helper;
import org.sculptor.generator.ext.Properties;
import org.sculptor.generator.template.domain.DomainObjectAttributeTmpl;
import org.sculptor.generator.template.domain.DomainObjectConstructorTmpl;
import org.sculptor.generator.template.domain.DomainObjectReferenceTmpl;
import org.sculptor.generator.util.HelperBase;
import org.sculptor.generator.util.OutputSlot;
import sculptormetamodel.Attribute;
import sculptormetamodel.DomainObject;
import sculptormetamodel.NamedElement;
import sculptormetamodel.Reference;
import sculptormetamodel.TypedElement;

@ChainOverridable
public class BuilderTmpl
extends ChainLink<BuilderTmpl> {
    @Inject
    @Extension
    private BuilderHelper builderHelper;
    @Inject
    @Extension
    private HelperBase helperBase;
    @Inject
    @Extension
    private Helper helper;
    @Inject
    @Extension
    private Properties properties;
    @Inject
    private DomainObjectAttributeTmpl domainObjectAttributeTmpl;
    @Inject
    private DomainObjectReferenceTmpl domainObjectReferenceTmpl;
    @Inject
    private DomainObjectConstructorTmpl domainObjectConstructorTmpl;

    public String builder(DomainObject it) {
        BuilderTmpl headObj = ((BuilderTmpl[])this.getMethodsDispatchHead())[0];
        return headObj._chained_builder(it);
    }

    public String builderBody(DomainObject it) {
        BuilderTmpl headObj = ((BuilderTmpl[])this.getMethodsDispatchHead())[1];
        return headObj._chained_builderBody(it);
    }

    public String assignAttributeInConstructor(NamedElement it) {
        BuilderTmpl headObj = ((BuilderTmpl[])this.getMethodsDispatchHead())[2];
        return headObj._chained_assignAttributeInConstructor(it);
    }

    public String multiReferenceAdd(Reference it, DomainObject obj) {
        BuilderTmpl headObj = ((BuilderTmpl[])this.getMethodsDispatchHead())[3];
        return headObj._chained_multiReferenceAdd(it, obj);
    }

    public String builderAttribute(Attribute it) {
        BuilderTmpl headObj = ((BuilderTmpl[])this.getMethodsDispatchHead())[4];
        return headObj._chained_builderAttribute(it);
    }

    public String builderAttributeSetter(Attribute it, DomainObject obj) {
        BuilderTmpl headObj = ((BuilderTmpl[])this.getMethodsDispatchHead())[5];
        return headObj._chained_builderAttributeSetter(it, obj);
    }

    public String builderSingleReferenceSetter(Reference it, DomainObject obj) {
        BuilderTmpl headObj = ((BuilderTmpl[])this.getMethodsDispatchHead())[6];
        return headObj._chained_builderSingleReferenceSetter(it, obj);
    }

    public BuilderTmpl(BuilderTmpl next) {
        super((ChainLink)next);
    }

    public String _chained_builder(DomainObject it) {
        String _builderFqn = this.builderHelper.getBuilderFqn(it);
        String _javaFileName = this.helper.javaFileName(_builderFqn);
        StringConcatenation _builder = new StringConcatenation();
        String _javaHeader = this.properties.javaHeader();
        _builder.append((Object)_javaHeader, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"package ");
        String _builderPackage = this.builderHelper.getBuilderPackage(it);
        _builder.append((Object)_builderPackage, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/// Sculptor code formatter imports ///");
        _builder.newLine();
        _builder.newLine();
        String _builderBody = this.builderBody(it);
        _builder.append((Object)_builderBody, "");
        _builder.newLineIfNotEmpty();
        return this.helper.fileOutput(_javaFileName, OutputSlot.TO_GEN_SRC, _builder.toString());
    }

    public String _chained_builderBody(final DomainObject it) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Builder for ");
        String _name = it.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)" class.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _builderClassName = this.builderHelper.getBuilderClassName(it);
        _builder.append((Object)_builderClassName, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        List<Attribute> _builderAttributes = this.builderHelper.getBuilderAttributes(it);
        Functions.Function1<Attribute, String> _function = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute a) {
                return BuilderTmpl.this.domainObjectAttributeTmpl.attribute(a, false);
            }
        };
        List _map = ListExtensions.map(_builderAttributes, (Functions.Function1)_function);
        String _join = IterableExtensions.join((Iterable)_map);
        _builder.append((Object)_join, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        List<Reference> _builderReferences = this.builderHelper.getBuilderReferences(it);
        Functions.Function1<Reference, Boolean> _function_1 = new Functions.Function1<Reference, Boolean>(){

            public Boolean apply(Reference r) {
                boolean _isMany = r.isMany();
                return !_isMany;
            }
        };
        Iterable _filter = IterableExtensions.filter(_builderReferences, (Functions.Function1)_function_1);
        Functions.Function1<Reference, String> _function_2 = new Functions.Function1<Reference, String>(){

            public String apply(Reference e) {
                return BuilderTmpl.this.domainObjectReferenceTmpl.oneReferenceAttribute(e, false);
            }
        };
        Iterable _map_1 = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_2);
        String _join_1 = IterableExtensions.join((Iterable)_map_1);
        _builder.append((Object)_join_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        List<Reference> _builderReferences_1 = this.builderHelper.getBuilderReferences(it);
        Functions.Function1<Reference, Boolean> _function_3 = new Functions.Function1<Reference, Boolean>(){

            public Boolean apply(Reference r) {
                return r.isMany();
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(_builderReferences_1, (Functions.Function1)_function_3);
        Functions.Function1<Reference, String> _function_4 = new Functions.Function1<Reference, String>(){

            public String apply(Reference e) {
                return BuilderTmpl.this.domainObjectReferenceTmpl.manyReferenceAttribute(e, false);
            }
        };
        Iterable _map_2 = IterableExtensions.map((Iterable)_filter_1, (Functions.Function1)_function_4);
        String _join_2 = IterableExtensions.join((Iterable)_map_2);
        _builder.append((Object)_join_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Static factory method for ");
        String _builderClassName_1 = this.builderHelper.getBuilderClassName(it);
        _builder.append((Object)_builderClassName_1, "\t ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static ");
        String _name_1 = it.getName();
        _builder.append((Object)_name_1, "\t");
        _builder.append((Object)"Builder ");
        String _name_2 = it.getName();
        String _firstLower = this.helperBase.toFirstLower(_name_2);
        _builder.append((Object)_firstLower, "\t");
        _builder.append((Object)"() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return new ");
        String _name_3 = it.getName();
        _builder.append((Object)_name_3, "\t\t");
        _builder.append((Object)"Builder();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_4 = it.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)"Builder() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        List<NamedElement> _builderConstructorParameters = this.builderHelper.getBuilderConstructorParameters(it);
        boolean _isEmpty = _builderConstructorParameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public ");
            String _name_5 = it.getName();
            _builder.append((Object)_name_5, "\t");
            _builder.append((Object)"Builder(");
            List<NamedElement> _builderConstructorParameters_1 = this.builderHelper.getBuilderConstructorParameters(it);
            Functions.Function1<NamedElement, String> _function_5 = new Functions.Function1<NamedElement, String>(){

                public String apply(NamedElement p) {
                    return BuilderTmpl.this.domainObjectConstructorTmpl.parameterTypeAndName(p);
                }
            };
            List _map_3 = ListExtensions.map(_builderConstructorParameters_1, (Functions.Function1)_function_5);
            String _join_3 = IterableExtensions.join((Iterable)_map_3, (CharSequence)",");
            _builder.append((Object)_join_3, "\t");
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            List<NamedElement> _builderConstructorParameters_2 = this.builderHelper.getBuilderConstructorParameters(it);
            for (NamedElement p : _builderConstructorParameters_2) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                String _assignAttributeInConstructor = this.assignAttributeInConstructor(p);
                _builder.append((Object)_assignAttributeInConstructor, "\t\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        List<Attribute> _builderAttributes_1 = this.builderHelper.getBuilderAttributes(it);
        Functions.Function1<Attribute, String> _function_6 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute a) {
                return BuilderTmpl.this.builderAttributeSetter(a, it);
            }
        };
        List _map_4 = ListExtensions.map(_builderAttributes_1, (Functions.Function1)_function_6);
        String _join_4 = IterableExtensions.join((Iterable)_map_4);
        _builder.append((Object)_join_4, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        List<Reference> _builderReferences_2 = this.builderHelper.getBuilderReferences(it);
        Functions.Function1<Reference, Boolean> _function_7 = new Functions.Function1<Reference, Boolean>(){

            public Boolean apply(Reference r) {
                boolean _isMany = r.isMany();
                return !_isMany;
            }
        };
        Iterable _filter_2 = IterableExtensions.filter(_builderReferences_2, (Functions.Function1)_function_7);
        Functions.Function1<Reference, String> _function_8 = new Functions.Function1<Reference, String>(){

            public String apply(Reference r) {
                return BuilderTmpl.this.builderSingleReferenceSetter(r, it);
            }
        };
        Iterable _map_5 = IterableExtensions.map((Iterable)_filter_2, (Functions.Function1)_function_8);
        String _join_5 = IterableExtensions.join((Iterable)_map_5);
        _builder.append((Object)_join_5, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        List<Reference> _builderReferences_3 = this.builderHelper.getBuilderReferences(it);
        Functions.Function1<Reference, Boolean> _function_9 = new Functions.Function1<Reference, Boolean>(){

            public Boolean apply(Reference r) {
                return r.isMany();
            }
        };
        Iterable _filter_3 = IterableExtensions.filter(_builderReferences_3, (Functions.Function1)_function_9);
        Functions.Function1<Reference, String> _function_10 = new Functions.Function1<Reference, String>(){

            public String apply(Reference r) {
                return BuilderTmpl.this.multiReferenceAdd(r, it);
            }
        };
        Iterable _map_6 = IterableExtensions.map((Iterable)_filter_3, (Functions.Function1)_function_10);
        String _join_6 = IterableExtensions.join((Iterable)_map_6);
        _builder.append((Object)_join_6, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        List<Attribute> _builderAttributes_2 = this.builderHelper.getBuilderAttributes(it);
        Functions.Function1<Attribute, String> _function_11 = new Functions.Function1<Attribute, String>(){

            public String apply(Attribute a) {
                return BuilderTmpl.this.domainObjectAttributeTmpl.propertyGetter(a);
            }
        };
        List _map_7 = ListExtensions.map(_builderAttributes_2, (Functions.Function1)_function_11);
        String _join_7 = IterableExtensions.join((Iterable)_map_7);
        _builder.append((Object)_join_7, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        List<Reference> _builderReferences_4 = this.builderHelper.getBuilderReferences(it);
        Functions.Function1<Reference, Boolean> _function_12 = new Functions.Function1<Reference, Boolean>(){

            public Boolean apply(Reference r) {
                boolean _isMany = r.isMany();
                return !_isMany;
            }
        };
        Iterable _filter_4 = IterableExtensions.filter(_builderReferences_4, (Functions.Function1)_function_12);
        Functions.Function1<Reference, String> _function_13 = new Functions.Function1<Reference, String>(){

            public String apply(Reference r) {
                return BuilderTmpl.this.domainObjectReferenceTmpl.oneReferenceGetter(r, false);
            }
        };
        Iterable _map_8 = IterableExtensions.map((Iterable)_filter_4, (Functions.Function1)_function_13);
        String _join_8 = IterableExtensions.join((Iterable)_map_8);
        _builder.append((Object)_join_8, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        List<Reference> _builderReferences_5 = this.builderHelper.getBuilderReferences(it);
        Functions.Function1<Reference, Boolean> _function_14 = new Functions.Function1<Reference, Boolean>(){

            public Boolean apply(Reference r) {
                return r.isMany();
            }
        };
        Iterable _filter_5 = IterableExtensions.filter(_builderReferences_5, (Functions.Function1)_function_14);
        Functions.Function1<Reference, String> _function_15 = new Functions.Function1<Reference, String>(){

            public String apply(Reference r) {
                return BuilderTmpl.this.domainObjectReferenceTmpl.manyReferenceGetter(r, false);
            }
        };
        Iterable _map_9 = IterableExtensions.map((Iterable)_filter_5, (Functions.Function1)_function_15);
        String _join_9 = IterableExtensions.join((Iterable)_map_9);
        _builder.append((Object)_join_9, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @return new ");
        String _name_6 = it.getName();
        _builder.append((Object)_name_6, "\t ");
        _builder.append((Object)" instance constructed based on the values that have been set into this builder");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _domainPackage = this.helperBase.getDomainPackage(it);
        String _plus = _domainPackage + ".";
        String _name_7 = it.getName();
        String _plus_1 = _plus + _name_7;
        _builder.append((Object)_plus_1, "\t");
        _builder.append((Object)" build() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _domainPackage_1 = this.helperBase.getDomainPackage(it);
        String _plus_2 = _domainPackage_1 + ".";
        String _name_8 = it.getName();
        String _plus_3 = _plus_2 + _name_8;
        _builder.append((Object)_plus_3, "\t\t");
        _builder.append((Object)" obj = new ");
        String _name_9 = it.getName();
        _builder.append((Object)_name_9, "\t\t");
        _builder.append((Object)"(");
        List<NamedElement> _builderConstructorParameters_3 = this.builderHelper.getBuilderConstructorParameters(it);
        boolean _hasElements = false;
        for (NamedElement attr : _builderConstructorParameters_3) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "\t\t");
            }
            String _getAccessor = this.helper.getGetAccessor(attr);
            _builder.append((Object)_getAccessor, "\t\t");
            _builder.append((Object)"()");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        ArrayList attrs = CollectionLiterals.newArrayList((Object[])new NamedElement[0]);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _xblockexpression = null;
        List<Attribute> _builderAttributes_3 = this.builderHelper.getBuilderAttributes(it);
        attrs.addAll(_builderAttributes_3);
        List<Reference> _builderReferences_6 = this.builderHelper.getBuilderReferences(it);
        Functions.Function1<Reference, Boolean> _function_16 = new Functions.Function1<Reference, Boolean>(){

            public Boolean apply(Reference r) {
                boolean _isMany = r.isMany();
                return !_isMany;
            }
        };
        Iterable _filter_6 = IterableExtensions.filter(_builderReferences_6, (Functions.Function1)_function_16);
        List _list = IterableExtensions.toList((Iterable)_filter_6);
        attrs.addAll(_list);
        List<NamedElement> _builderConstructorParameters_4 = this.builderHelper.getBuilderConstructorParameters(it);
        attrs.removeAll(_builderConstructorParameters_4);
        _xblockexpression = "";
        _builder.append((Object)_xblockexpression, "\t\t");
        _builder.newLineIfNotEmpty();
        for (NamedElement prop : attrs) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"obj.set");
            String _name_10 = prop.getName();
            String _firstUpper = this.helperBase.toFirstUpper(_name_10);
            _builder.append((Object)_firstUpper, "\t\t");
            _builder.append((Object)"(");
            String _name_11 = prop.getName();
            _builder.append((Object)_name_11, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        List<Reference> _builderReferences_62 = this.builderHelper.getBuilderReferences(it);
        Functions.Function1<Reference, Boolean> _function_162 = new Functions.Function1<Reference, Boolean>(){

            public Boolean apply(Reference r) {
                return r.isMany();
            }
        };
        Iterable _filter_62 = IterableExtensions.filter(_builderReferences_62, (Functions.Function1)_function_162);
        List refs = IterableExtensions.toList((Iterable)_filter_62);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        String _xblockexpression_1 = null;
        _builderConstructorParameters_4 = this.builderHelper.getBuilderConstructorParameters(it);
        refs.removeAll(_builderConstructorParameters_4);
        _xblockexpression_1 = "";
        _builder.append((Object)_xblockexpression_1, "\t\t");
        _builder.newLineIfNotEmpty();
        for (Reference prop_1 : refs) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"obj.get");
            String _name_12 = prop_1.getName();
            String _firstUpper_1 = this.helperBase.toFirstUpper(_name_12);
            _builder.append((Object)_firstUpper_1, "\t\t");
            _builder.append((Object)"().addAll(");
            String _name_13 = prop_1.getName();
            _builder.append((Object)_name_13, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return obj;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }

    public String _chained_assignAttributeInConstructor(NamedElement it) {
        boolean _isMany;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        _and = !(it instanceof Reference) ? false : (_isMany = ((Reference)it).isMany());
        if (_and) {
            _builder.append((Object)"this.");
            String _name = it.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)".addAll(");
            String _name_1 = it.getName();
            _builder.append((Object)_name_1, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append((Object)"this.");
            String _name_2 = it.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)" = ");
            String _name_3 = it.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder.toString();
    }

    public String _chained_multiReferenceAdd(Reference it, DomainObject obj) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Adds an object to the to-many");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* association.");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* It is added the collection {@link #get");
        String _name = it.getName();
        String _firstUpper = this.helperBase.toFirstUpper(_name);
        _builder.append((Object)_firstUpper, " ");
        _builder.append((Object)"}.");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public ");
        String _name_1 = obj.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"Builder add");
        String _name_2 = it.getName();
        String _firstUpper_1 = this.helperBase.toFirstUpper(_name_2);
        String _singular = this.helper.singular(_firstUpper_1);
        _builder.append((Object)_singular, "");
        _builder.append((Object)"(");
        String _typeName = this.helperBase.getTypeName(it);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _name_3 = it.getName();
        String _singular_1 = this.helper.singular(_name_3);
        _builder.append((Object)_singular_1, "");
        _builder.append((Object)"Element) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"get");
        String _name_4 = it.getName();
        String _firstUpper_2 = this.helperBase.toFirstUpper(_name_4);
        _builder.append((Object)_firstUpper_2, "\t");
        _builder.append((Object)"().add(");
        String _name_5 = it.getName();
        String _singular_2 = this.helper.singular(_name_5);
        _builder.append((Object)_singular_2, "\t");
        _builder.append((Object)"Element);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    public String _chained_builderAttribute(Attribute it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"protected ");
        String _implTypeName = this.helperBase.getImplTypeName((TypedElement)it);
        _builder.append((Object)_implTypeName, "");
        _builder.append((Object)" ");
        String _name = it.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String _chained_builderAttributeSetter(Attribute it, DomainObject obj) {
        StringConcatenation _builder = new StringConcatenation();
        String _formatJavaDoc = this.helper.formatJavaDoc((NamedElement)it);
        _builder.append((Object)_formatJavaDoc, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        String _name = obj.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"Builder ");
        String _name_1 = it.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"(");
        String _typeName = this.helperBase.getTypeName((TypedElement)it);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" val) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"this.");
        String _name_2 = it.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)" = val;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    public String _chained_builderSingleReferenceSetter(Reference it, DomainObject obj) {
        StringConcatenation _builder = new StringConcatenation();
        String _formatJavaDoc = this.helper.formatJavaDoc((NamedElement)it);
        _builder.append((Object)_formatJavaDoc, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"public ");
        String _name = obj.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"Builder ");
        String _name_1 = it.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"(");
        String _typeName = this.helperBase.getTypeName(it);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" ");
        String _name_2 = it.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"this.");
        String _name_3 = it.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)" = ");
        String _name_4 = it.getName();
        _builder.append((Object)_name_4, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return this;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    public BuilderTmpl[] _getOverridesDispatchArray() {
        BuilderTmpl[] result = new BuilderTmpl[]{this, this, this, this, this, this, this};
        return result;
    }
}

