/**
@author David Shen
@brief Declaration of Base SRF with tangent plane surface class.
*/
// SRM SDK Release 4.4.0 - January 21, 2010

// - SRM spec. 4.4

/*
 *                             NOTICE
 * 
 * This software is provided openly and freely for use in representing and
 * interchanging environmental data & databases.
 * 
 * This software was developed for use by the United States Government with
 * unlimited rights.  The software was developed under contract
 * DASG60-02-D-0006 TO-193 by Science Applications International Corporation.
 * The software is unclassified and is deemed as Distribution A, approved
 * for Public Release.
 * 
 * Use by others is permitted only upon the ACCEPTANCE OF THE TERMS AND
 * CONDITIONS, AS STIPULATED UNDER THE FOLLOWING PROVISIONS:
 * 
 *    1. Recipient may make unlimited copies of this software and give
 *       copies to other persons or entities as long as the copies contain
 *       this NOTICE, and as long as the same copyright notices that
 *       appear on, or in, this software remain.
 * 
 *    2. Trademarks. All trademarks belong to their respective trademark
 *       holders.  Third-Party applications/software/information are
 *       copyrighted by their respective owners.
 * 
 *    3. Recipient agrees to forfeit all intellectual property and
 *       ownership rights for any version created from the modification
 *       or adaptation of this software, including versions created from
 *       the translation and/or reverse engineering of the software design.
 * 
 *    4. Transfer.  Recipient may not sell, rent, lease, or sublicense
 *       this software.  Recipient may, however enable another person
 *       or entity the rights to use this software, provided that this
 *       AGREEMENT and NOTICE is furnished along with the software and
 *       /or software system utilizing this software.
 * 
 *       All revisions, modifications, created by the Recipient, to this
 *       software and/or related technical data shall be forwarded by the
 *       Recipient to the Government at the following address:
 * 
 *         SMDC
 *         Attention SEDRIS (TO193) TPOC
 *         P.O. Box 1500
 *         Huntsville, AL  35807-3801
 * 
 *         or via electronic mail to:  se-mgmt@sedris.org
 * 
 *    5. No Warranty. This software is being delivered to you AS IS
 *       and there is no warranty, EXPRESS or IMPLIED, as to its use
 *       or performance.
 * 
 *       The RECIPIENT ASSUMES ALL RISKS, KNOWN AND UNKNOWN, OF USING
 *       THIS SOFTWARE.  The DEVELOPER EXPRESSLY DISCLAIMS, and the
 *       RECIPIENT WAIVES, ANY and ALL PERFORMANCE OR RESULTS YOU MAY
 *       OBTAIN BY USING THIS SOFTWARE OR DOCUMENTATION.  THERE IS
 *       NO WARRANTY, EXPRESS OR, IMPLIED, AS TO NON-INFRINGEMENT OF
 *       THIRD PARTY RIGHTS, MERCHANTABILITY, OR FITNESS FOR ANY
 *       PARTICULAR PURPOSE.  IN NO EVENT WILL THE DEVELOPER, THE
 *       UNITED STATES GOVERNMENT OR ANYONE ELSE ASSOCIATED WITH THE
 *       DEVELOPMENT OF THIS SOFTWARE BE HELD LIABLE FOR ANY CONSEQUENTIAL,
 *       INCIDENTAL OR SPECIAL DAMAGES, INCLUDING ANY LOST PROFITS
 *       OR LOST SAVINGS WHATSOEVER.
 */

/*
 * COPYRIGHT 2010, SCIENCE APPLICATIONS INTERNATIONAL CORPORATION.
 *                 ALL RIGHTS RESERVED.
 * 
 */

// SRM_OTHERS_GOES_HERE

package SRM;

/** The BaseSRF_WithTangentPlaneSurface abstract class.
@author David Shen
@see BaseSRF_3D, BaseSRF
*/
public abstract class BaseSRF_WithTangentPlaneSurface extends BaseSRF_3D
{

    /** Creates a surface coordinate object with default [ Double.NaN, Double.NaN ].
        @return a surface coordinate object
    */
    public abstract CoordSurf createSurfaceCoordinate( );

    /** Creates a surface coordinate object with initial values.
        @param coord_surf_comp1 in: the values of the first component of the surface coordinate
        @param coord_surf_comp2 in: the values of the second component of the surface coordinate
        @return a surface coordinate object
    */
    public abstract CoordSurf createSurfaceCoordinate(double coord_surf_comp1,
                                                      double coord_surf_comp2 );

    /** Retrieves a coordinate surface component values
        @param coord_surf in: a surface coordinate
        @return an array of size 2 containing the component values for the surface coordinate
        @note The input surface coordinate must have been created using this SRF.
    */
    public double[] getSurfaceCoordinateValues( CoordSurf coord_surf )  throws SrmException
    {
        if (coord_surf == null)
            throw new SrmException( SrmException._INVALID_INPUT,
                                    new String("getSurfaceCoordinateValues: Input null reference coordinate") );

        return coord_surf.getValues();
    }


    /** Returns a surface coordinate associated with a 3D coordinate.
        @param coord in: a 3D coordinate in this SRF
        @return a surface coordinate object in this SRF
        @note The input coordinate must have been created using this SRF.
    */
    public abstract CoordSurf getAssociatedSurfaceCoordinate( Coord3D coord) throws SrmException;

    /** Returns a 3D coordinate representing the same location as specified
        by a surface coordinate.
        @param surf_coord in: a surface coordinate in this SRF
        @return a 3D coordinate object in this SRF
        @note The input surface coordinate must have been created using this SRF.
    */
    public abstract Coord3D getPromotedSurfaceCoordinate( CoordSurf surf_coord) throws SrmException;
}
