/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF_3D;
import SRM.Const;
import SRM.Coord3D;
import SRM.CoordSurf;
import SRM.CreateSRF;
import SRM.LteSupport;
import SRM.OrmData;
import SRM.OrmDataSet;
import SRM.SRF_LocalTangentSpaceEuclidean;
import SRM.SRM_DSS_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFSM_Code;
import SRM.SRM_SRFS_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;

public abstract class BaseSRF_WithEllipsoidalHeight
extends BaseSRF_3D {
    private static double[] _wgs84GeoidSeparationData = null;

    public abstract CoordSurf createSurfaceCoordinate();

    public abstract CoordSurf createSurfaceCoordinate(double var1, double var3);

    public double[] getSurfaceCoordinateValues(CoordSurf coord_surf) throws SrmException {
        if (coord_surf == null) {
            throw new SrmException(8, new String("getSurfaceCoordinateValues: Input null reference coordinate"));
        }
        return coord_surf.getValues();
    }

    public abstract CoordSurf getAssociatedSurfaceCoordinate(Coord3D var1) throws SrmException;

    public abstract Coord3D getPromotedSurfaceCoordinate(CoordSurf var1) throws SrmException;

    public SRF_LocalTangentSpaceEuclidean createLocalTangentSpaceEuclideanSRF(CoordSurf surf_coord, double azimuth, double false_x_origin, double false_y_origin, double offset_height) throws SrmException {
        if (surf_coord == null) {
            throw new SrmException(8, new String("createLocalTangentEuclideanSRF: null reference input parameter"));
        }
        if (surf_coord.getSRF() != this) {
            throw new SrmException(5, new String("createLocalTangentEuclideanSRF: Coordinate associated with different SRF"));
        }
        try {
            return LteSupport.createLtesSRF(this, surf_coord.getValues(), azimuth, false_x_origin, false_y_origin, offset_height);
        }
        catch (SrmException ex) {
            throw new SrmException(8, new String("createLocalTangentEuclideanSRF: Incompatible input parameters"));
        }
    }

    public SRM_SRFSM_Code getNaturalSRFSetMemberCode(CoordSurf src_coord, SRM_ORM_Code orm_dst, SRM_RT_Code rt_dst, SRM_SRFS_Code tgt_srfs) throws SrmException {
        if (src_coord == null || orm_dst == null || rt_dst == null || tgt_srfs == null) {
            throw new SrmException(8, new String("getNaturalSRFSetMemberCode: null reference input parameter"));
        }
        if (src_coord.getSRF() != this) {
            throw new SrmException(5, new String("getNaturalSRFSetMemberCode: Coordinate associated with different SRF"));
        }
        double[] tmpCoord = new double[]{src_coord.getValues()[0], src_coord.getValues()[1], 0.0};
        return this.getMemberCode(tmpCoord, orm_dst, rt_dst, tgt_srfs);
    }

    public BaseSRF_3D getNaturalSRFSetMember(CoordSurf src_coord, SRM_ORM_Code orm_dst, SRM_RT_Code rt_dst, SRM_SRFS_Code tgt_srfs) throws SrmException {
        if (src_coord == null || orm_dst == null || rt_dst == null || tgt_srfs == null) {
            throw new SrmException(8, new String("getNaturalSRFSetMemberCode: null reference input parameter"));
        }
        if (src_coord.getSRF() != this) {
            throw new SrmException(5, new String("getNaturalSRFSetMemberCode: Coordinate associated with different SRF"));
        }
        double[] tmpCoord = new double[]{src_coord.getValues()[0], src_coord.getValues()[1], 0.0};
        SRM_SRFSM_Code tmpMemberCode = this.getMemberCode(tmpCoord, orm_dst, rt_dst, tgt_srfs);
        return (BaseSRF_3D)CreateSRF.srfSetMember(tgt_srfs, tmpMemberCode, orm_dst, rt_dst);
    }

    public static double calculateEuclideanDistance(CoordSurf coord1, CoordSurf coord2) throws SrmException {
        if (coord1 == null || coord2 == null) {
            throw new SrmException(8, new String("calculateEuclideanDistance: null reference input parameter"));
        }
        if (OrmDataSet.getElem((SRM_ORM_Code)coord1.getSRF().getOrm())._reference_orm != OrmDataSet.getElem((SRM_ORM_Code)coord2.getSRF().getOrm())._reference_orm) {
            throw new SrmException(8, new String("calculateEuclideanDistance: coordinates associated with different reference ORMs"));
        }
        double[] tempCcSrcCoord = BaseSRF_WithEllipsoidalHeight.interimConv(coord1, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC);
        double[] tempCcTgtCoord = BaseSRF_WithEllipsoidalHeight.interimConv(coord2, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC);
        double delta_x = tempCcSrcCoord[0] - tempCcTgtCoord[0];
        double delta_y = tempCcSrcCoord[1] - tempCcTgtCoord[1];
        double delta_z = tempCcSrcCoord[2] - tempCcTgtCoord[2];
        return Math.sqrt(Const.square(delta_x) + Const.square(delta_y) + Const.square(delta_z));
    }

    public double calculateGeodesicDistance(CoordSurf src_coord, CoordSurf des_coord) throws SrmException {
        if (src_coord.getSRF() != this || des_coord.getSRF() != this) {
            throw new SrmException(5, new String("calculateGeodesicDistance: input coordinate not in this SRF"));
        }
        if (src_coord.getValues()[1] == des_coord.getValues()[1] && src_coord.getValues()[2] == des_coord.getValues()[2]) {
            throw new SrmException(8, new String("calculateGeodesicDistance: the source and destination coordinates are the same"));
        }
        double[] tempCdSrcCoord = BaseSRF_WithEllipsoidalHeight.interimConv(src_coord, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC);
        double[] tempCdDesCoord = BaseSRF_WithEllipsoidalHeight.interimConv(des_coord, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC);
        OrmData orm_data = new OrmData(this.getOrm());
        return this.compute_geodesic_distance(tempCdSrcCoord[1], tempCdSrcCoord[0], tempCdDesCoord[1], tempCdDesCoord[0], orm_data.A, orm_data.F);
    }

    public double calculateVerticalSeparationOffset(SRM_DSS_Code dss, CoordSurf surf_coord) throws SrmException {
        if (surf_coord == null || dss == null) {
            throw new SrmException(8, "calculateVerticalSeparationOffset: null input parameter");
        }
        if (surf_coord.getSRF() != this) {
            throw new SrmException(5, "calculateVerticalSeparationOffset: input coordinate not in this SRF");
        }
        if (dss == SRM_DSS_Code.DSSCOD_UNSPECIFIED) {
            throw new SrmException(9, "calculateVerticalSeparationOffset: Invalid DSS code");
        }
        if (dss != SRM_DSS_Code.DSSCOD_EGM96_GEOID || dss != SRM_DSS_Code.DSSCOD_WGS84_ELLIPSOID || dss != SRM_DSS_Code.DSSCOD_EGM84_GEOID) {
            throw new SrmException(12, "calculateVerticalSeparationOffset: not supported for this DSS");
        }
        if (dss == SRM_DSS_Code.DSSCOD_EGM84_GEOID) {
            throw new SrmException(19, "calculateVerticalSeparationOffset: not implemented for DSS_EGM84_GEOID");
        }
        double[] tgtCdCoord = BaseSRF_WithEllipsoidalHeight.interimConv(surf_coord, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC);
        return this.dssCalculation(dss, tgtCdCoord);
    }

    private double compute_geodesic_distance(double phi_1, double lambda_1, double phi_2, double lambda_2, double a, double f) {
        double e2 = (2.0 - f) * f;
        double u1 = Math.atan((1.0 - f) * Math.tan(phi_1));
        double u2 = Math.atan((1.0 - f) * Math.tan(phi_2));
        double deltaomega_old = 0.0;
        double deltaomega_new = 1.0;
        double sigma = 0.0;
        double sinun2 = 0.0;
        double sigmam = 0.0;
        double sin_sigma = 0.0;
        double cos_sigma = 0.0;
        double cos_sigmam = 0.0;
        double cos_2sigmam = 0.0;
        while (Math.abs(deltaomega_old - deltaomega_new) > 1.0E-12) {
            deltaomega_old = deltaomega_new;
            double omega = lambda_2 - lambda_1 + deltaomega_old;
            double cos_u1 = Math.cos(u1);
            double cos_u2 = Math.cos(u2);
            double sin_u1 = Math.sin(u1);
            double sin_u2 = Math.sin(u2);
            double cos_omega = Math.cos(omega);
            double sin_omega = Math.sin(omega);
            double x = cos_u2 * sin_omega;
            double y = cos_u1 * sin_u2 - sin_u1 * cos_u2 * cos_omega;
            sigma = Math.atan2(Math.sqrt(x * x + y * y), sin_u1 * sin_u2 + cos_u1 * cos_u2 * cos_omega);
            sin_sigma = Math.sin(sigma);
            cos_sigma = Math.cos(sigma);
            double cosun = cos_u1 * cos_u2 * sin_omega / sin_sigma;
            sinun2 = 1.0 - cosun * cosun;
            sigmam = sinun2 == 0.0 ? Math.acos(cos_sigma - 2.0) : Math.acos(cos_sigma - 2.0 * sin_u1 * sin_u2 / sinun2 + 1.0E-12);
            cos_sigmam = Math.cos(sigmam);
            cos_2sigmam = Math.cos(2.0 * sigmam);
            double v = 0.25 * f * sinun2;
            double K3 = v * (1.0 + f + f * f - v * (3.0 + 7.0 * f - 13.0 * v));
            deltaomega_new = (1.0 - K3) * f * cosun * (sigma + K3 * sin_sigma * (cos_sigmam + K3 * cos_sigma * cos_2sigmam));
        }
        double t = e2 / (1.0 - e2) * sinun2 / 4.0;
        double K1 = 1.0 + t * (1.0 - t * (3.0 - t * (5.0 - 11.0 * t)) * 0.25);
        double K2 = t * (1.0 - t * (2.0 - t * (37.0 - 94.0 * t) * 0.125));
        double deltasigma = K2 * sin_sigma * (cos_sigmam + K2 * (cos_sigma * cos_2sigmam + K2 * (1.0 + 2.0 * Math.cos(2.0 * sigma)) * Math.cos(3.0 * sigmam) / 6.0) * 0.25);
        double geodesic_distance = K1 * (1.0 - f) * a * (sigma - deltasigma);
        return geodesic_distance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getFileContent(int numRow, int numCol, String file_name) throws FileNotFoundException, IOException {
        double[] ret_data = new double[numRow * numCol];
        Reader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file_name)));
            StringBuffer sb = new StringBuffer();
            char[] cBuf = new char[numRow * numCol];
            int i = 0;
            while ((i = reader.read(cBuf)) > -1) {
                sb.append(cBuf, 0, i);
            }
            StringTokenizer st_data = new StringTokenizer(sb.toString(), ",");
            int total_token = st_data.countTokens();
            for (int j = 0; j < total_token; ++j) {
                ret_data[j] = Double.parseDouble(st_data.nextToken());
            }
            double[] dArray = ret_data;
            return dArray;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private double dssCalculation(SRM_DSS_Code dss, double[] coord_org_wgs84_cd) throws SrmException {
        int Index;
        double PostY;
        if (dss == SRM_DSS_Code.DSSCOD_WGS84_ELLIPSOID) {
            return 0.0;
        }
        int ScaleFactor = 4;
        int NumbGeoidCols = 1441;
        int NumbGeoidRows = 721;
        try {
            if (_wgs84GeoidSeparationData == null) {
                _wgs84GeoidSeparationData = this.getFileContent(NumbGeoidRows, NumbGeoidCols, "WGS84GeoidSeparationTable.dat");
            }
        }
        catch (FileNotFoundException ex) {
            throw new SrmException(20, "calculateVerticalSeparationOffset: Geoid Separation data file not found");
        }
        catch (IOException ex) {
            throw new SrmException(20, "calculateVerticalSeparationOffset: Internal file I/O error");
        }
        catch (NullPointerException ex) {
            throw new SrmException(20, "calculateVerticalSeparationOffset: Geoid Separation data file not found");
        }
        double OffsetX = coord_org_wgs84_cd[0] < 0.0 ? (Math.toRadians(coord_org_wgs84_cd[0]) + 360.0) * (double)ScaleFactor : Math.toRadians(coord_org_wgs84_cd[0]) * (double)ScaleFactor;
        double OffsetY = (90.0 - Math.toRadians(coord_org_wgs84_cd[1])) * (double)ScaleFactor;
        double PostX = Math.floor(OffsetX);
        if (PostX + 1.0 == (double)NumbGeoidCols) {
            PostX -= 1.0;
        }
        if ((PostY = Math.floor(OffsetY)) + 1.0 == (double)NumbGeoidRows) {
            PostY -= 1.0;
        }
        if ((Index = (int)(PostY * (double)NumbGeoidCols + PostX)) > _wgs84GeoidSeparationData.length || Index < 0) {
            throw new SrmException(12, "calculateVerticalSeparationOffset: computation not possible");
        }
        double ElevationNW = _wgs84GeoidSeparationData[Index];
        double ElevationNE = _wgs84GeoidSeparationData[Index + 1];
        Index = (int)((PostY + 1.0) * (double)NumbGeoidCols + PostX);
        if (Index > _wgs84GeoidSeparationData.length || Index < 0) {
            throw new SrmException(12, "calculateVerticalSeparationOffset: computation not possible");
        }
        double ElevationSW = _wgs84GeoidSeparationData[Index];
        double ElevationSE = _wgs84GeoidSeparationData[Index + 1];
        double DeltaX = OffsetX - PostX;
        double DeltaY = OffsetY - PostY;
        double UpperY = ElevationNW + DeltaX * (ElevationNE - ElevationNW);
        double LowerY = ElevationSW + DeltaX * (ElevationSE - ElevationSW);
        return UpperY + DeltaY * (LowerY - UpperY);
    }
}

