/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.OrmData;
import SRM.SRF_LCE_3D_Params;
import SRM.SRF_LTSE_Params;
import SRM.SRF_LT_Params;
import SRM.SRF_LocalTangentSpaceAzimuthalSpherical;
import SRM.SRF_LocalTangentSpaceCylindrical;
import SRM.SRF_LocalTangentSpaceEuclidean;
import SRM.SRF_LococentricEuclidean3D;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFS_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class CcenConv
extends Conversions {
    private ToCdetConst _toCdetConst;
    private ToLteConst _toLteConst;
    private ToLceConst _toLceConst;

    protected CcenConv() {
        super(SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_LOCOCENTRIC_EUCLIDEAN_3D, SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN, SRM_SRFT_Code.SRFTCOD_CELESTIOMAGNETIC, SRM_SRFT_Code.SRFTCOD_EQUATORIAL_INERTIAL, SRM_SRFT_Code.SRFTCOD_SOLAR_ECLIPTIC, SRM_SRFT_Code.SRFTCOD_SOLAR_EQUATORIAL, SRM_SRFT_Code.SRFTCOD_HELIOSPHERIC_ARIES_ECLIPTIC, SRM_SRFT_Code.SRFTCOD_HELIOSPHER_EARTH_ECLIPTIC, SRM_SRFT_Code.SRFTCOD_HELIOSPHER_EARTH_EQUATORIAL, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new CcenConv();
    }

    protected SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        retValid = CoordCheck.forNaN_3D(src);
        switch (destSrfType) {
            case SRFTCOD_CELESTIODETIC: {
                this.toCdet(srcSrf, destSrf, src, dest);
                retValid = CoordCheck.forCelestiodetic(this.getOrmData(), dest);
                break;
            }
            case SRFTCOD_LOCOCENTRIC_EUCLIDEAN_3D: {
                if (this._toLceConst == null) {
                    this._toLceConst = new ToLceConst(((SRF_LococentricEuclidean3D)destSrf).getSRFParameters());
                }
                double[] p_minus_q = new double[3];
                for (int i = 0; i < 3; ++i) {
                    p_minus_q[i] = src[i] - this._toLceConst.lococentre[i];
                }
                dest[0] = Const.vectDotProd(p_minus_q, this._toLceConst.primary_axis);
                dest[1] = Const.vectDotProd(p_minus_q, this._toLceConst.secondary_axis);
                dest[2] = Const.vectDotProd(p_minus_q, this._toLceConst.xprod_rs);
                retValid = CoordCheck.forNaN_3D(dest);
                break;
            }
            case SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN: {
                this.toLte(srcSrf, destSrf, src, dest);
                if (srcSrf.getSRFSetCode() == SRM_SRFS_Code.SRFSCOD_GTRS_GLOBAL_COORDINATE_SYSTEM) {
                    retValid = CoordCheck.forGTRS(dest);
                }
                if (destSrf instanceof SRF_LocalTangentSpaceEuclidean) {
                    dest[0] = dest[0] + ((SRF_LocalTangentSpaceEuclidean)destSrf).get_x_false_origin();
                    dest[1] = dest[1] + ((SRF_LocalTangentSpaceEuclidean)destSrf).get_y_false_origin();
                }
                retValid = CoordCheck.forNaN_3D(dest);
                break;
            }
            case SRFTCOD_CELESTIOMAGNETIC: 
            case SRFTCOD_EQUATORIAL_INERTIAL: 
            case SRFTCOD_SOLAR_ECLIPTIC: 
            case SRFTCOD_SOLAR_EQUATORIAL: 
            case SRFTCOD_HELIOSPHERIC_ARIES_ECLIPTIC: 
            case SRFTCOD_HELIOSPHER_EARTH_ECLIPTIC: 
            case SRFTCOD_HELIOSPHER_EARTH_EQUATORIAL: {
                this.toSphere(srcSrf, destSrf, src, dest);
                retValid = CoordCheck.forSpherical(dest);
                break;
            }
            case SRFTCOD_UNSPECIFIED: {
                dest[0] = src[0];
                dest[1] = src[1];
                dest[2] = src[2];
            }
        }
        return retValid;
    }

    protected void toCdet(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coord, double[] dest_generic_coord) throws SrmException {
        boolean REGION_1 = false;
        boolean REGION_2 = true;
        int REGION_3 = 2;
        int REGION_4 = 3;
        int REGION_5 = 4;
        int REGION_UNDEFINED = 5;
        int REGION_SPHERICAL = 6;
        double dest_lat_ptr = -1.0;
        double dest_lon_ptr = -1.0;
        double dest_elv_ptr = -1.0;
        int region = 5;
        OrmData e_constants = this.getOrmData();
        if (this._toCdetConst == null) {
            this._toCdetConst = new ToCdetConst(this.getOrmData());
        }
        boolean done_by_special_case = false;
        double w2 = Const.square(source_generic_coord[0]) + Const.square(source_generic_coord[1]);
        double z2 = Const.square(source_generic_coord[2]);
        double w = Math.sqrt(w2);
        if (Math.abs(e_constants.Eps) <= 1.0E-12) {
            dest_lat_ptr = Math.atan2(source_generic_coord[2], w);
            dest_elv_ptr = Math.sqrt(w2 + z2) - e_constants.A;
            region = 6;
        } else if (Math.abs(source_generic_coord[0]) <= 1.0E-12) {
            if (source_generic_coord[1] > 0.0) {
                dest_lon_ptr = 1.5707963267948966;
            } else if (source_generic_coord[1] < 0.0) {
                dest_lon_ptr = -1.5707963267948966;
            } else if (source_generic_coord[2] >= 0.0) {
                dest_lat_ptr = 1.5707963267948966;
                dest_lon_ptr = 0.0;
                dest_elv_ptr = source_generic_coord[2] - e_constants.C;
                done_by_special_case = true;
            } else if (source_generic_coord[2] <= 0.0) {
                dest_lat_ptr = -1.5707963267948966;
                dest_lon_ptr = 0.0;
                dest_elv_ptr = -(source_generic_coord[2] + e_constants.C);
                done_by_special_case = true;
            } else {
                throw new SrmException(6, new String("changeCoordinateSRF: impossible conversion"));
            }
        }
        if (!done_by_special_case || region == 6) {
            if (region != 6) {
                double lowerBound = w2 + this._toCdetConst.u[1] * z2;
                double upperBound = w2 + this._toCdetConst.u[2] * z2;
                if (lowerBound >= this._toCdetConst.v[1] && upperBound <= this._toCdetConst.v[2]) {
                    region = 1;
                } else {
                    lowerBound = upperBound;
                    upperBound = w2 + z2 * this._toCdetConst.u[3];
                    if (lowerBound >= this._toCdetConst.v[2] && upperBound <= this._toCdetConst.v[3]) {
                        region = 2;
                    } else {
                        lowerBound = w2 + z2 * this._toCdetConst.u[0];
                        upperBound = w2 + z2 * this._toCdetConst.u[1];
                        if (lowerBound >= this._toCdetConst.v[0] && upperBound <= this._toCdetConst.v[1]) {
                            region = 0;
                        } else {
                            lowerBound = upperBound;
                            upperBound = w2 + z2 * this._toCdetConst.u[4];
                            region = lowerBound >= this._toCdetConst.v[3] && upperBound <= this._toCdetConst.v[4] ? 3 : 4;
                        }
                    }
                }
            }
            double ga = this._toCdetConst.b1[region] + (this._toCdetConst.b2[region] + this._toCdetConst.b3[region] * w2) / (this._toCdetConst.b4[region] + this._toCdetConst.b5[region] * w2 + z2);
            switch (region) {
                case 0: 
                case 1: {
                    double top = source_generic_coord[2] * ga;
                    dest_lat_ptr = Math.atan2(top, w);
                    double top2 = top * top;
                    double rr = top2 + w2;
                    double q = Math.sqrt(rr);
                    double s12 = top2 / rr;
                    double Rn = Const.computeRnFast(s12, e_constants);
                    if (s12 <= 0.5) {
                        dest_elv_ptr = q - Rn;
                        break;
                    }
                    dest_elv_ptr = q / ga + this._toCdetConst.aeps21 * Rn * e_constants.A_inv;
                    break;
                }
                case 2: 
                case 3: {
                    double top = source_generic_coord[2] * ga * this._toCdetConst.rho_inv;
                    double top2 = top * top;
                    double rr = top2 + w2;
                    double q = Math.sqrt(rr);
                    double qinv = 1.0 / q;
                    double sn = top * qinv;
                    double cn = w * qinv;
                    double s3 = Const.cube(sn);
                    double c3 = Const.cube(cn);
                    top = source_generic_coord[2] + this._toCdetConst.ak1 * s3;
                    double bot = w - this._toCdetConst.ak2 * c3;
                    top2 = Const.square(top);
                    rr = top2 + Const.square(bot);
                    q = Math.sqrt(rr);
                    double s12 = top2 / rr;
                    double Rn = Const.computeRnFast(s12, e_constants);
                    dest_elv_ptr = s12 <= 0.5 ? w * q / bot - Rn : source_generic_coord[2] * q / top + this._toCdetConst.aeps21 * Rn * e_constants.A_inv;
                    dest_lat_ptr = Math.atan2(top, bot);
                    break;
                }
                case 4: {
                    double cf = this._toCdetConst.C254 * z2;
                    double gee = w2 - this._toCdetConst.Eps21 * z2 - this._toCdetConst.CEEps2;
                    double g_inv = 1.0 / gee;
                    double alpha = cf * Const.square(g_inv);
                    double cl = this._toCdetConst.CEE * w2 * alpha * g_inv;
                    double arg2 = cl * (cl + 2.0);
                    double s1 = 1.0 + cl + Math.sqrt(arg2);
                    double s = Math.pow(s1, 0.3333333333333333);
                    double temp = s / (Const.square(s) + 1.0 + s);
                    double p = alpha * 0.3333333333333333 * Const.square(temp);
                    double xarg = 1.0 + this._toCdetConst.TwoCEE * p;
                    double q = Math.sqrt(xarg);
                    double q_inv = 1.0 / q;
                    double one_plus_q_inv = 1.0 / (1.0 + q);
                    double r2 = -p * (2.0 * (1.0 - e_constants.Eps2) * z2 * (q_inv * one_plus_q_inv) + w2);
                    double r1 = 1.0 + q_inv;
                    double ro = r1 + r2 > 0.0 ? e_constants.A * Math.sqrt(0.5 * (r1 + (r2 *= e_constants.A2_inv))) : 0.0;
                    double roe = e_constants.Eps2 * (ro -= p * e_constants.Eps2 * w * one_plus_q_inv);
                    double arg = Const.square(w - roe) + z2;
                    double v = Math.sqrt(arg - e_constants.Eps2 * z2);
                    double v_inv = 1.0 / v;
                    double zo = this._toCdetConst.C2DA * source_generic_coord[2] * v_inv;
                    dest_elv_ptr = Math.sqrt(arg) * (1.0 - this._toCdetConst.C2DA * v_inv);
                    double top = source_generic_coord[2] + this._toCdetConst.tem * zo;
                    dest_lat_ptr = Math.atan(top / w);
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    throw new SrmException(6, new String("changeCoordinateSRF: impossible conversion"));
                }
            }
            dest_lon_ptr = Math.atan2(source_generic_coord[1], source_generic_coord[0]);
        }
        dest_generic_coord[0] = dest_lon_ptr;
        dest_generic_coord[1] = dest_lat_ptr;
        dest_generic_coord[2] = dest_elv_ptr;
    }

    protected void toLte(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double[] temp = new double[4];
        double[] temp1 = new double[4];
        temp[0] = source_generic_coordinate[0];
        temp[1] = source_generic_coordinate[1];
        temp[2] = source_generic_coordinate[2];
        temp[3] = 1.0;
        OrmData e_constants = this.getOrmData();
        if (this._toLteConst == null) {
            if (destSrf instanceof SRF_LocalTangentSpaceAzimuthalSpherical) {
                SRF_LT_Params tmpLTParam = ((SRF_LocalTangentSpaceAzimuthalSpherical)destSrf).getSRFParameters();
                SRF_LTSE_Params tmpLTEParam = new SRF_LTSE_Params();
                tmpLTEParam.geodetic_longitude = tmpLTParam.geodetic_longitude;
                tmpLTEParam.geodetic_latitude = tmpLTParam.geodetic_latitude;
                tmpLTEParam.azimuth = tmpLTParam.azimuth;
                tmpLTEParam.x_false_origin = 0.0;
                tmpLTEParam.y_false_origin = 0.0;
                tmpLTEParam.height_offset = tmpLTParam.height_offset;
                this._toLteConst = new ToLteConst(e_constants, tmpLTEParam);
            } else if (destSrf instanceof SRF_LocalTangentSpaceCylindrical) {
                SRF_LT_Params tmpLTParam = ((SRF_LocalTangentSpaceCylindrical)destSrf).getSRFParameters();
                SRF_LTSE_Params tmpLTEParam = new SRF_LTSE_Params();
                tmpLTEParam.geodetic_longitude = tmpLTParam.geodetic_longitude;
                tmpLTEParam.geodetic_latitude = tmpLTParam.geodetic_latitude;
                tmpLTEParam.azimuth = tmpLTParam.azimuth;
                tmpLTEParam.x_false_origin = 0.0;
                tmpLTEParam.y_false_origin = 0.0;
                tmpLTEParam.height_offset = tmpLTParam.height_offset;
                this._toLteConst = new ToLteConst(e_constants, tmpLTEParam);
            } else {
                this._toLteConst = new ToLteConst(e_constants, ((SRF_LocalTangentSpaceEuclidean)destSrf).getSRFParameters());
            }
        }
        Const.multMatrixSubsetVector(this._toLteConst.T_inv, temp, temp1, 4);
        dest_generic_coordinate[0] = temp1[0];
        dest_generic_coordinate[1] = temp1[1];
        dest_generic_coordinate[2] = temp1[2];
    }

    protected void toSphere(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coord, double[] dest_generic_coord) throws SrmException {
        double x2 = Const.square(source_generic_coord[0]);
        double y2 = Const.square(source_generic_coord[1]);
        if (x2 > 1.0E-12 && y2 > 1.0E-12) {
            double lambda_prime = Math.atan(source_generic_coord[1] / source_generic_coord[0]);
            dest_generic_coord[0] = source_generic_coord[0] >= 0.0 ? lambda_prime : (source_generic_coord[1] >= 0.0 ? Math.PI + lambda_prime : -Math.PI + lambda_prime);
        } else {
            dest_generic_coord[0] = source_generic_coord[1] >= 1.0E-6 ? 1.5707963267948966 : -1.5707963267948966;
            dest_generic_coord[0] = source_generic_coord[0] >= 1.0E-6 ? 0.0 : Math.PI;
        }
        dest_generic_coord[2] = Math.sqrt(x2 + y2 + Const.square(source_generic_coord[2]));
        dest_generic_coord[1] = dest_generic_coord[2] != 0.0 ? Math.asin(source_generic_coord[2] / dest_generic_coord[2]) : 0.0;
    }

    private class ToLceConst {
        double[] lococentre = new double[3];
        double[] primary_axis = new double[3];
        double[] secondary_axis = new double[3];
        double[] xprod_rs = new double[3];

        public ToLceConst(SRF_LCE_3D_Params params) {
            Const.vectCrossProd(params.primary_axis, params.secondary_axis, this.xprod_rs);
            for (int i = 0; i < 3; ++i) {
                this.lococentre[i] = params.lococentre[i];
                this.primary_axis[i] = params.primary_axis[i];
                this.secondary_axis[i] = params.secondary_axis[i];
            }
        }
    }

    public class ToLteConst {
        double[][] T = new double[4][4];
        double[][] T_inv = new double[4][4];

        public ToLteConst(OrmData e_constants, SRF_LTSE_Params params) throws SrmException {
            Const.calc_T(e_constants, params, this.T, this.T_inv);
        }
    }

    public class ToCdetConst {
        double Eps21;
        double C254;
        double CEEps2;
        double CEE;
        double TwoCEE;
        double C2DA;
        double tem;
        double ARat1;
        double ARat2;
        double BRat1;
        double BRat2;
        double aeps21;
        double ak1;
        double ak2;
        double rho;
        double rho_inv;
        double[] b1 = new double[5];
        double[] b2 = new double[5];
        double[] b3 = new double[5];
        double[] b4 = new double[5];
        double[] b5 = new double[5];
        double[] u = new double[5];
        double[] v = new double[5];

        public ToCdetConst(OrmData e_constants) {
            double[] del = new double[5];
            if (e_constants.Eps > 1.0E-12) {
                double CE2 = e_constants.A2 - e_constants.C2;
                this.Eps21 = e_constants.Eps2 - 1.0;
                this.C254 = 54.0 * e_constants.C2;
                this.CEEps2 = e_constants.Eps2 * CE2;
                this.CEE = e_constants.Eps2 * e_constants.Eps2;
                this.TwoCEE = 2.0 * this.CEE;
                this.C2DA = e_constants.C2 / e_constants.A;
                this.tem = CE2 / e_constants.C2;
                this.rho = e_constants.A / e_constants.C;
                this.rho_inv = e_constants.C / e_constants.A;
                this.aeps21 = e_constants.A * (e_constants.Eps2 - 1.0);
                this.ak1 = e_constants.C * e_constants.Eps2 / (1.0 - e_constants.Eps2);
                this.ak2 = e_constants.Eps2 * e_constants.A;
                del[0] = 30000.0;
                del[1] = 50000.0;
                del[2] = 2.195E7;
                del[3] = 4.28E8;
                del[4] = 1.0E10;
                double hmn = -30000.0;
                for (int i = 0; i < 5; ++i) {
                    double a3;
                    double hmx = hmn + del[i];
                    double g1 = Const.gee(hmn, 0.0, e_constants.A, e_constants.Eps2);
                    double g2 = Const.gee(hmx, 0.0, e_constants.A, e_constants.Eps2);
                    double g3 = Const.gee(hmx, 1.5707963267948966, e_constants.A, e_constants.Eps2);
                    double g4 = Const.gee(hmn, 1.5707963267948966, e_constants.A, e_constants.Eps2);
                    double hm = (hmx - hmn) * 0.5;
                    double gm = Const.gee(hm, 0.7853981633974483, e_constants.A, e_constants.Eps2);
                    double d1 = Const.square(e_constants.C + hmx) * g3 - Const.square(e_constants.C + hmn) * g4;
                    double d2 = -(g4 - g3) / (Const.square(e_constants.C + hmx) - Const.square(e_constants.C + hmn));
                    double d3 = Const.square(e_constants.C + hmx) * d2 - g3;
                    double d4 = Const.square(e_constants.C + hmx) * (g3 - (d1 /= Const.square(e_constants.C + hmx) - Const.square(e_constants.C + hmn)));
                    double d5 = (g1 + d3) / Const.square(e_constants.A + hmn) - (g2 + d3) / Const.square(e_constants.A + hmx);
                    d5 /= g2 - g1;
                    double d6 = 1.0 / Const.square(e_constants.A + hmx) - 1.0 / Const.square(e_constants.A + hmn);
                    d6 = d6 * d4 / (g2 - g1);
                    double sm = 0.7071067811865476;
                    double rnm = e_constants.A / Math.sqrt(1.0 - e_constants.Eps2 * Const.square(sm));
                    double zm = ((1.0 - e_constants.Eps2) * rnm + hm) * sm;
                    double wm = (rnm + hm) * 0.7071067811865476;
                    double z2 = zm * zm;
                    double w2 = wm * wm;
                    double d7 = (z2 * d2 - d3 - gm - gm * w2 * d5) / w2;
                    double d8 = (z2 * gm - d4 - z2 * d1 + gm * w2 * d6) / w2;
                    double d9 = (g2 + d3) / Const.square(e_constants.A + hmx) + g2 * d5;
                    double d10 = -d4 / Const.square(e_constants.A + hmx) + d6 * g2;
                    double a4 = (d8 - d10) / (d9 + d7);
                    double a2 = d9 * a4 + d10;
                    double a5 = d5 * a4 + d6;
                    double a1 = d4 - d3 * a4;
                    this.b1[i] = a3 = d1 + d2 * a4;
                    this.b2[i] = a1 - a3 * a4;
                    this.b3[i] = a2 - a3 * a5;
                    this.b4[i] = a4;
                    this.b5[i] = a5;
                    double f1 = Const.square(e_constants.A + hmn - 1.0E-8);
                    double f2 = Const.square(e_constants.C + hmn - 1.0E-8);
                    this.u[i] = f1 / f2;
                    this.v[i] = f1;
                    hmn = hmx;
                }
            } else {
                this.Eps21 = Double.NaN;
                this.C254 = Double.NaN;
                this.CEEps2 = Double.NaN;
                this.CEE = Double.NaN;
                this.TwoCEE = Double.NaN;
                this.C2DA = Double.NaN;
                this.tem = Double.NaN;
                this.ARat1 = Double.NaN;
                this.ARat2 = Double.NaN;
                this.BRat1 = Double.NaN;
                this.BRat2 = Double.NaN;
                for (int i = 0; i < 5; ++i) {
                    this.b1[i] = Double.NaN;
                    this.b2[i] = Double.NaN;
                    this.b3[i] = Double.NaN;
                    this.b4[i] = Double.NaN;
                    this.b5[i] = Double.NaN;
                    this.u[i] = Double.NaN;
                    this.v[i] = Double.NaN;
                }
                this.aeps21 = Double.NaN;
                this.ak1 = Double.NaN;
                this.ak2 = Double.NaN;
                this.rho = Double.NaN;
                this.rho_inv = Double.NaN;
            }
        }
    }
}

