/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFT_Code;
import SRM.SphereConv;
import SRM.SrmException;

class CmagConv
extends SphereConv {
    protected CmagConv() {
        super(SRM_SRFT_Code.SRFTCOD_CELESTIOMAGNETIC, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new CmagConv();
    }

    protected SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        switch (destSrfType) {
            case SRFTCOD_CELESTIOCENTRIC: {
                retValid = CoordCheck.forSpherical(src);
                this.toCcen(srcSrf, destSrf, src, dest);
                break;
            }
            case SRFTCOD_UNSPECIFIED: {
                dest[0] = src[0];
                dest[1] = src[1];
                dest[2] = src[2];
            }
        }
        return retValid;
    }
}

