/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.Matrix;
import SRM.OrmData;
import SRM.RtDataSet;
import SRM.SRF_LTSE_Params;
import SRM.SRM_ORM_Code;
import SRM.SRM_RT_Code;
import SRM.SrmException;

final class Const {
    protected static final double PI = Math.PI;
    protected static final double TWO_PI = Math.PI * 2;
    protected static final double FOUR_PI = Math.PI * 4;
    protected static final double PI_DIV_4 = 0.7853981633974483;
    protected static final double PI_DIV_2 = 1.5707963267948966;
    protected static final double ONE_DIV_ROOT_2 = 0.7071067811865476;
    protected static final double RADIANS_PER_DEGREE = Math.PI / 180;
    protected static final double DEGREES_PER_RADIAN = 57.29577951308232;
    protected static final double EPSILON = 1.0E-6;
    protected static final double EPSILON_SQ = 1.0E-12;
    protected static final double TM_EXTENDED_LONGITUDE_RANGE = 0.061086523819801536;
    protected static final double TM_LONGITUDE_RANGE = 0.05235987755982989;

    Const() {
    }

    protected static final double square(double var) {
        return var * var;
    }

    protected static final double cube(double var) {
        return var * var * var;
    }

    protected static final double twoTimes(double var) {
        return var + var;
    }

    protected static final double triple(double var) {
        return var + var + var;
    }

    protected static final int roundDown(double var) {
        if ((double)Math.round(var) < var) {
            return (int)Math.round(var);
        }
        return (int)(Math.round(var) - 1L);
    }

    protected static final double power_p(OrmData e_constants, double var) {
        return Math.pow((1.0 - e_constants.Eps * var) / (1.0 + e_constants.Eps * var), e_constants.Eps * 0.5);
    }

    protected static final double power_p_inv(OrmData e_constants, double var) {
        return Math.pow((1.0 + e_constants.Eps * var) / (1.0 - e_constants.Eps * var), e_constants.Eps * 0.5);
    }

    protected static final double power_p_approx(double[] cr1, double[] cr2, double sin_lat) {
        return Math.abs(sin_lat) < 0.5807029557109 ? cr1[0] + (cr1[1] * sin_lat + cr1[2]) / (cr1[3] + sin_lat * (cr1[4] + sin_lat)) : cr2[0] + (cr2[1] * sin_lat + cr2[2]) / (cr2[3] + sin_lat * (cr2[4] + sin_lat));
    }

    protected static final double chi_approx(double[] b, double sin_squared_chi) {
        return b[0] + sin_squared_chi * (b[1] + sin_squared_chi * (b[2] + sin_squared_chi * b[3]));
    }

    protected static final double gee(double h, double xlat, double a, double eps2) {
        double s2 = Math.sin(xlat);
        s2 *= s2;
        double rn = a / Math.sqrt(1.0 - eps2 * s2);
        double result = (rn + h) / ((1.0 - eps2) * rn + h);
        return result;
    }

    protected static final double computeRnFast(double arg, OrmData e_constants) {
        double alpha = 1.004244;
        double d1 = -0.5 * e_constants.Eps2;
        double x = d1 * arg;
        double ak = 0.5 + x;
        double z = 1.0 - alpha * x;
        return e_constants.A * z * (1.5 - ak * z * z);
    }

    protected static final double computeRn(double arg, OrmData e_constants) {
        double temp = e_constants.Eps25 * arg;
        double z0 = 0.4999986087 - temp;
        return e_constants.A * z0 / (Const.square(z0) + 0.25 - temp);
    }

    protected static final double computeRnExact(double arg, OrmData e_constants) {
        return e_constants.A / Math.sqrt(1.0 - e_constants.Eps2 * arg);
    }

    protected static final double computeRnInv(double arg, OrmData e_constants) {
        double alpha = 0.4999986087;
        double temp = e_constants.Eps25 * arg;
        double z0 = 0.4999986087 - temp;
        return (Const.square(z0) + 0.25 - temp) / (e_constants.A * z0);
    }

    protected static boolean isValidOrmRt(SRM_ORM_Code orm, SRM_RT_Code rt) {
        boolean isValid = false;
        if (rt == SRM_RT_Code.RTCOD_UNSPECIFIED) {
            if (orm == SRM_ORM_Code.ORMCOD_EARTH_INERT_ARIES_1950 || orm == SRM_ORM_Code.ORMCOD_EARTH_INERT_ARIES_TRUE_OF_DATE || orm == SRM_ORM_Code.ORMCOD_EARTH_INERTIAL_J2000r0) {
                isValid = true;
            }
        } else if (orm == SRM_ORM_Code.ORMCOD_EXPERIMENTAL_NGA_MAX) {
            if (rt == SRM_RT_Code.RTCOD_EXPERIMENTAL_NGA_MAX_IDENTITY_BY_DEFAULT) {
                isValid = true;
            }
        } else if (orm == SRM_ORM_Code.ORMCOD_EXPERIMENTAL_NGA_SPHERE) {
            if (rt == SRM_RT_Code.RTCOD_EXPERIMENTAL_NGA_SPHERE_IDENTITY_BY_DEFAULT) {
                isValid = true;
            }
        } else {
            isValid = RtDataSet.isValidPair(orm, rt);
        }
        return isValid;
    }

    protected static final boolean isWellFormedLongitude(double longitude) {
        return longitude > -Math.PI && longitude <= Math.PI;
    }

    protected static final boolean isWellFormedLatitude(double latitude) {
        return latitude > -1.5707963267948966 && latitude < 1.5707963267948966;
    }

    protected static final boolean isWellFormedRadius(double radius) {
        return radius > 0.0;
    }

    protected static final boolean isWellFormedScale(double scale) {
        return scale > 0.5 && scale <= 1.25;
    }

    protected static final boolean isWellFormedAzimuth(double azimuth) {
        return azimuth >= 0.0 && azimuth <= Math.PI * 2;
    }

    protected static final boolean isWellFormedCylindricalAngle(double angle) {
        return angle >= 0.0 && angle < Math.PI * 2;
    }

    protected static final boolean isWellFormedHeight(double height) {
        return height > -50000.0002 && height <= 1000000.0;
    }

    protected static final boolean isEqual(double a, double b, double tolerance) {
        return Math.abs(a - b) <= tolerance;
    }

    protected static final double atanh(double x) {
        return Math.log((1.0 + x) / (1.0 - x)) * 0.5;
    }

    protected static final boolean areEqualAngles(double a, double b, double tolerance) {
        return Math.abs(a - b) <= tolerance || Math.abs(Math.abs(a - b) - Math.PI * 2) <= tolerance || Math.abs(Math.abs(a - b) - Math.PI * 4) <= tolerance;
    }

    protected static final boolean isEqual(double[] a, double[] b, double tolerance) {
        return Const.square(a[0] - b[0]) + Const.square(a[1] - b[1]) + Const.square(a[2] - b[2]) <= tolerance * tolerance;
    }

    protected static final boolean isEqual(double[][] a, double[][] b, double tolerance) {
        return Const.isEqual(a[0][0], b[0][0], tolerance) && Const.isEqual(a[0][1], b[0][1], tolerance) && Const.isEqual(a[0][2], b[0][2], tolerance) && Const.isEqual(a[1][0], b[1][0], tolerance) && Const.isEqual(a[1][1], b[1][1], tolerance) && Const.isEqual(a[1][2], b[1][2], tolerance) && Const.isEqual(a[2][0], b[2][0], tolerance) && Const.isEqual(a[2][1], b[2][1], tolerance) && Const.isEqual(a[2][2], b[2][2], tolerance);
    }

    protected static final boolean isUnit(double[] vec) {
        return Const.isEqual(Const.square(vec[0]) + Const.square(vec[1]) + Const.square(vec[2]), 1.0, 1.0E-6);
    }

    protected static final boolean inFourPiRange(double a) {
        return Math.PI * -2 <= a && Math.PI * 2 >= a;
    }

    protected static final boolean inPiRange(double a) {
        return -1.5707963267948966 <= a && 1.5707963267948966 >= a;
    }

    protected static final double reduce(double angle, double bound) {
        if (angle <= -bound) {
            return angle + 2.0 * bound;
        }
        return angle;
    }

    protected static final int max(double a, double b, double c) {
        if (a >= b && a >= c) {
            return 1;
        }
        if (b >= a && b >= c) {
            return 2;
        }
        return 3;
    }

    protected static double delta_lambda_min(double lambda1, double lambda2) {
        if (lambda2 >= lambda1) {
            double simple_difference = lambda2 - lambda1;
            if (Math.abs(simple_difference) >= Math.PI) {
                return Math.IEEEremainder(Math.PI * 2 - lambda2 + lambda1, Math.PI * 2);
            }
            return simple_difference;
        }
        double simple_difference = lambda1 - lambda2;
        if (Math.abs(simple_difference) >= Math.PI) {
            return Math.IEEEremainder(Math.PI * 2 - lambda1 + lambda2, Math.PI * 2);
        }
        return simple_difference;
    }

    protected static double arcLength(ArcLengthConst al, double phi, double sin_phi, double cos_phi) {
        return al.B0 * phi + sin_phi * cos_phi * (al.B2 + Const.square(sin_phi) * (al.B4 + Const.square(sin_phi) * al.B6));
    }

    protected static double footPoint(OrmData e_constants, ArcLengthConst al, FootPointConst fp, double mu) {
        double sin_mu = Math.sin(mu);
        double cos_mu = Math.cos(mu);
        return mu + sin_mu * cos_mu * (fp.P1 + Const.square(sin_mu) * (fp.P2 + Const.square(sin_mu) * fp.P3));
    }

    protected static double getLambdaStar(double longitude, double origin_longitude) {
        double lambda_star = longitude - origin_longitude;
        if (lambda_star <= -Math.PI) {
            lambda_star += Math.PI * 2;
        } else if (lambda_star > Math.PI) {
            lambda_star -= Math.PI * 2;
        }
        return lambda_star;
    }

    protected static double getAlphaStar(double azimuth, double origin_azimuth) {
        double alpha_star = azimuth - origin_azimuth;
        if (alpha_star < 0.0) {
            alpha_star += Math.PI * 2;
        } else if (alpha_star >= Math.PI * 2) {
            alpha_star -= Math.PI * 2;
        }
        return alpha_star;
    }

    protected static void copyArray(double[] src, double[] dest) {
        dest[0] = src[0];
        dest[1] = src[1];
        dest[2] = src[2];
    }

    protected static void ConstTimesVect(double[] dest, double factor) {
        dest[0] = dest[0] * factor;
        dest[1] = dest[1] * factor;
        dest[2] = dest[2] * factor;
    }

    protected static double[] vectSum(double[] vec1, double[] vec2) {
        double[] ret_sum = new double[]{vec1[0] + vec2[0], vec1[1] + vec2[1], vec1[2] + vec2[2]};
        return ret_sum;
    }

    protected static double vectDotProd(double[] v1, double[] v2) {
        double ret_v = 0.0;
        for (int i = 0; i < 3; ++i) {
            ret_v += v1[i] * v2[i];
        }
        return ret_v;
    }

    protected static void vectCrossProd(double[] v1, double[] v2, double[] v3) {
        v3[0] = v1[1] * v2[2] - v1[2] * v2[1];
        v3[1] = v1[2] * v2[0] - v1[0] * v2[2];
        v3[2] = v1[0] * v2[1] - v1[1] * v2[0];
    }

    protected static void multMatrixSubsetVector(double[][] A, double[] x, double[] b, int rank) {
        for (int i = 0; i < rank; ++i) {
            b[i] = 0.0;
            for (int j = 0; j < rank; ++j) {
                int n = i;
                b[n] = b[n] + A[i][j] * x[j];
            }
        }
    }

    protected static double exactArcLength(double a, double c, double e2, double xlat) {
        double c1 = 1.0 + e2 * (0.75 + e2 * (0.703125 + e2 * (0.68359375 + e2 * (0.67291259765625 + e2 * 0.6661834716796875))));
        double c2 = e2 * (0.75 + e2 * (0.9375 + e2 * (1.025390625 + e2 * (1.07666015625 + e2 * 1.1103057861328125))));
        double e4 = e2 * e2;
        double c3 = e4 * (0.234375 + e2 * (0.41015625 + e2 * (0.538330078125 + e2 * 10395.0 / 16384.0)));
        double e6 = e4 * e2;
        double c4 = e6 * (0.068359375 + e2 * (0.15380859375 + e2 * 31185.0 / 131072.0));
        double c5 = e4 * e4 * (0.01922607421875 + e2 * 3465.0 / 65536.0);
        double c6 = e4 * e6 * 693.0 / 131072.0;
        double con = a * (1.0 - e2);
        double t1 = con * c1 * xlat;
        double t2 = con * c2;
        double t3 = con * c3;
        double t4 = con * c4;
        double t5 = con * c5;
        double t6 = con * c6;
        t2 = t2 * Math.sin(2.0 * xlat) / 2.0;
        t3 = t3 * Math.sin(4.0 * xlat) / 4.0;
        t4 = t4 * Math.sin(6.0 * xlat) / 6.0;
        t5 = t5 * Math.sin(8.0 * xlat) / 8.0;
        t6 = t6 * Math.sin(10.0 * xlat) / 10.0;
        return t1 - t2 + t3 - t4 + t5 - t6;
    }

    protected static void WGS84_Transformation_Matrix(double[][] T, double delta_x, double delta_y, double delta_z, double omega_x, double omega_y, double omega_z, double delta_scale) {
        double cox = Math.cos(-omega_x);
        double sox = Math.sin(-omega_x);
        double coy = Math.cos(-omega_y);
        double soy = Math.sin(-omega_y);
        double coz = Math.cos(-omega_z);
        double soz = Math.sin(-omega_z);
        double[][] Tsr1 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        double[][] Tsr2 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        double[][] Tsr3 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        double[][] result1 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        Tsr3[0][0] = coz;
        Tsr3[0][1] = soz;
        Tsr3[0][2] = 0.0;
        Tsr3[1][0] = -soz;
        Tsr3[1][1] = coz;
        Tsr3[1][2] = 0.0;
        Tsr3[2][0] = 0.0;
        Tsr3[2][1] = 0.0;
        Tsr3[2][2] = 1.0;
        Tsr2[0][0] = coy;
        Tsr2[0][1] = 0.0;
        Tsr2[0][2] = -soy;
        Tsr2[1][0] = 0.0;
        Tsr2[1][1] = 1.0;
        Tsr2[1][2] = 0.0;
        Tsr2[2][0] = soy;
        Tsr2[2][1] = 0.0;
        Tsr2[2][2] = coy;
        Tsr1[0][0] = 1.0;
        Tsr1[0][1] = 0.0;
        Tsr1[0][2] = 0.0;
        Tsr1[1][0] = 0.0;
        Tsr1[1][1] = cox;
        Tsr1[1][2] = sox;
        Tsr1[2][0] = 0.0;
        Tsr1[2][1] = -sox;
        Tsr1[2][2] = cox;
        Const.matrixMultiply4x4(Tsr2, Tsr1, result1);
        Const.matrixMultiply4x4(Tsr3, result1, T);
        T[0][3] = delta_x;
        T[1][3] = delta_y;
        T[2][3] = delta_z;
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                double[] dArray = T[i];
                int n = j++;
                dArray[n] = dArray[n] * (1.0 + delta_scale * 1.0E-6);
            }
        }
    }

    protected static void WGS84_Transformation_Matrix_2D(double[][] T, double delta_x, double delta_y, double omega, double delta_scale) {
        double co = Math.cos(-omega);
        double so = Math.sin(-omega);
        T[0][0] = co;
        T[0][1] = so;
        T[1][0] = -so;
        T[1][1] = co;
        T[0][2] = delta_x;
        T[1][2] = delta_y;
        for (int i = 0; i < 2; ++i) {
            int j = 0;
            while (j < 2) {
                double[] dArray = T[i];
                int n = j++;
                dArray[n] = dArray[n] * (1.0 + delta_scale * 1.0E-6);
            }
        }
    }

    protected static void WGS84_InverseTransformation_Matrix(double[][] T, double delta_x, double delta_y, double delta_z, double omega_x, double omega_y, double omega_z, double delta_scale) {
        double cox = Math.cos(-omega_x);
        double sox = Math.sin(-omega_x);
        double coy = Math.cos(-omega_y);
        double soy = Math.sin(-omega_y);
        double coz = Math.cos(-omega_z);
        double soz = Math.sin(-omega_z);
        double[] delta_TR = new double[]{0.0, 0.0, 0.0, 1.0};
        double[] delta_RT = new double[4];
        double[][] Tsr1 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        double[][] Tsr2 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        double[][] Tsr3 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        double[][] result1 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        double[][] result2 = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        Tsr3[0][0] = coz;
        Tsr3[0][1] = soz;
        Tsr3[0][2] = 0.0;
        Tsr3[1][0] = -soz;
        Tsr3[1][1] = coz;
        Tsr3[1][2] = 0.0;
        Tsr3[2][0] = 0.0;
        Tsr3[2][1] = 0.0;
        Tsr3[2][2] = 1.0;
        Tsr2[0][0] = coy;
        Tsr2[0][1] = 0.0;
        Tsr2[0][2] = -soy;
        Tsr2[1][0] = 0.0;
        Tsr2[1][1] = 1.0;
        Tsr2[1][2] = 0.0;
        Tsr2[2][0] = soy;
        Tsr2[2][1] = 0.0;
        Tsr2[2][2] = coy;
        Tsr1[0][0] = 1.0;
        Tsr1[0][1] = 0.0;
        Tsr1[0][2] = 0.0;
        Tsr1[1][0] = 0.0;
        Tsr1[1][1] = cox;
        Tsr1[1][2] = sox;
        Tsr1[2][0] = 0.0;
        Tsr1[2][1] = -sox;
        Tsr1[2][2] = cox;
        Const.matrixMultiply4x4(Tsr2, Tsr1, result1);
        Const.matrixMultiply4x4(Tsr3, result1, result2);
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                double[] dArray = result2[i];
                int n = j++;
                dArray[n] = dArray[n] * (1.0 / (1.0 + delta_scale * 1.0E-6));
            }
        }
        Const.transpose(result2, T, 4);
        delta_TR[0] = -delta_x;
        delta_TR[1] = -delta_y;
        delta_TR[2] = -delta_z;
        Const.multMatrixSubsetVector(T, delta_TR, delta_RT, 3);
        T[0][3] = delta_RT[0];
        T[1][3] = delta_RT[1];
        T[2][3] = delta_RT[2];
    }

    protected static void normalizeDirection(double[] v) throws SrmException {
        double magnitude = Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        if (!(magnitude * magnitude > 1.0E-12)) {
            throw new SrmException(20, new String("Normalization of zero magnitude vector"));
        }
        double scale = 1.0 / magnitude;
        v[0] = v[0] * scale;
        v[1] = v[1] * scale;
        v[2] = v[2] * scale;
    }

    protected static double fix_longitude(double lon) {
        if (lon > Math.PI) {
            return lon - Math.PI * 2;
        }
        if (lon <= -Math.PI) {
            return lon + Math.PI * 2;
        }
        return lon;
    }

    protected static void applyMatrix3x3(double[] src, double[][] mtx3x3, double[] dest) {
        for (int i = 0; i < 3; ++i) {
            dest[i] = 0.0;
            for (int j = 0; j < 3; ++j) {
                int n = i;
                dest[n] = dest[n] + src[j] * mtx3x3[i][j];
            }
        }
    }

    protected static void applyMatrix4x4(double[] src, double[][] mtx4x4, double[] dest) {
        for (int i = 0; i < 4; ++i) {
            dest[i] = 0.0;
            for (int j = 0; j < 4; ++j) {
                int n = i;
                dest[n] = dest[n] + src[j] * mtx4x4[j][i];
            }
        }
    }

    protected static void matrixMultiply4x4(double[][] a, double[][] b, double[][] c) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                c[i][j] = 0.0;
                for (int n = 0; n < 4; ++n) {
                    double[] dArray = c[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + a[i][n] * b[n][j];
                }
            }
        }
    }

    protected static void matrixMultiply3x3(double[][] a, double[][] b, double[][] c) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                c[i][j] = 0.0;
                for (int n = 0; n < 3; ++n) {
                    double[] dArray = c[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + a[i][n] * b[n][j];
                }
            }
        }
    }

    protected static void invert(double[][] src, double[][] invSrc) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                invSrc[i][j] = src[j][i];
            }
        }
        invSrc[3][0] = -src[3][0];
        invSrc[3][1] = -src[3][1];
        invSrc[3][2] = -src[3][2];
        invSrc[3][3] = 1.0;
    }

    protected static void invert_datum(double[][] src, double delta_scale, double[][] invSrc) {
        double[] tmp = new double[3];
        double[] deltas = new double[]{-src[3][0], -src[3][1], -src[3][2]};
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                invSrc[i][j] = src[j][i];
            }
        }
        invSrc[0][3] = 0.0;
        invSrc[1][3] = 0.0;
        invSrc[2][3] = 0.0;
        Const.applyMatrix3x3(deltas, invSrc, tmp);
        invSrc[3][0] = tmp[0];
        invSrc[3][1] = tmp[1];
        invSrc[3][2] = tmp[2];
        double factor = 1.0 / (1.0 + delta_scale);
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < 4) {
                double[] dArray = invSrc[i];
                int n = j++;
                dArray[n] = dArray[n] * factor;
            }
        }
        invSrc[3][3] = 1.0;
    }

    protected static void transpose(double[][] src, double[][] transposedSrc, int rank) {
        for (int i = 0; i < rank; ++i) {
            for (int j = 0; j < rank; ++j) {
                transposedSrc[i][j] = src[j][i];
            }
        }
    }

    protected static double dot_product(double[] A, double[] B) {
        double result = 0.0;
        for (int i = 0; i < 3; ++i) {
            result += A[i] * B[i];
        }
        return result;
    }

    protected static double[] cross_product(double[] A, double[] B) {
        double[] result = new double[]{A[1] * B[2] - A[2] * B[1], A[2] * B[0] - A[0] * B[2], A[0] * B[1] - A[1] * B[0]};
        return result;
    }

    protected static double det(double[][] m) {
        Matrix mtx = new Matrix(m);
        return mtx.det();
    }

    protected static void cpMatrix(double[][] m_cp, double[][] m, int rank) {
        for (int i = 0; i < rank; ++i) {
            for (int j = 0; j < rank; ++j) {
                m_cp[i][j] = m[i][j];
            }
        }
    }

    protected static void print(double[] vec) {
        System.out.println("[ " + vec[0] + ", " + vec[1] + ", " + vec[2] + " ]");
    }

    protected static void LTP_Rotation_Matrix_T(double lambda, double phi, double alpha, double[][] T) {
        double cl = Math.cos(lambda);
        double sl = Math.sin(lambda);
        double cp = Math.cos(phi);
        double sp = Math.sin(phi);
        double ca = Math.cos(alpha);
        double sa = Math.sin(alpha);
        T[0][0] = -sl * ca + cl * sp * sa;
        T[0][1] = -sl * sa + -cl * sp * ca;
        T[0][2] = cl * cp;
        T[0][3] = 0.0;
        T[1][0] = cl * ca + sl * sp * sa;
        T[1][1] = cl * sa + -sl * sp * ca;
        T[1][2] = sl * cp;
        T[1][3] = 0.0;
        T[2][0] = cp * -sa;
        T[2][1] = cp * ca;
        T[2][2] = sp;
        T[2][3] = 0.0;
        T[3][0] = 0.0;
        T[3][1] = 0.0;
        T[3][2] = 0.0;
        T[3][3] = 1.0;
    }

    protected static void calc_T(OrmData e_constants, SRF_LTSE_Params params, double[][] T, double[][] T_inv) {
        double height_radius_factor;
        double radius;
        double[] R = new double[4];
        double[] R2 = new double[4];
        double slat = Math.sin(params.geodetic_latitude);
        double clat = Math.cos(params.geodetic_latitude);
        double slon = Math.sin(params.geodetic_longitude);
        double clon = Math.cos(params.geodetic_longitude);
        double azimuth = params.azimuth;
        double Origin_Height = params.height_offset;
        if (e_constants.Eps != 0.0) {
            double rn = e_constants.A / Math.sqrt(1.0 - e_constants.Eps2 * (slat * slat));
            radius = rn + Origin_Height;
            height_radius_factor = Origin_Height + rn * (1.0 - e_constants.Eps2);
        } else {
            height_radius_factor = radius = Origin_Height + e_constants.A;
        }
        R[0] = radius * clat * clon;
        R[1] = radius * clat * slon;
        R[2] = height_radius_factor * slat;
        R[3] = 1.0;
        Const.LTP_Rotation_Matrix_T(params.geodetic_longitude, params.geodetic_latitude, azimuth, T);
        T[0][3] = R[0];
        T[1][3] = R[1];
        T[2][3] = R[2];
        T[3][3] = 1.0;
        Const.transpose(T, T_inv, 4);
        R[0] = R[0] * -1.0;
        R[1] = R[1] * -1.0;
        R[2] = R[2] * -1.0;
        Const.multMatrixSubsetVector(T_inv, R, R2, 3);
        T_inv[3][0] = 0.0;
        T_inv[3][1] = 0.0;
        T_inv[3][2] = 0.0;
        T_inv[0][3] = R2[0];
        T_inv[1][3] = R2[1];
        T_inv[2][3] = R2[2];
        T_inv[3][3] = 1.0;
    }

    protected static void init_chi_series(OrmData e_constants, double[] b) throws SrmException {
        double Eps2 = e_constants.Eps2;
        double Eps4 = e_constants.Eps2 * e_constants.Eps2;
        b[0] = Eps2 * (1.0 + Eps2 * (1.0 + Eps2 * (1.0 + Eps2)));
        b[1] = -Eps4 * (7.0 + Eps2 * (17.0 + 30.0 * Eps2)) / 6.0;
        b[2] = Eps4 * Eps2 * (1.8666666666666667 + 6223.0 * Eps2 / 840.0);
        b[3] = -4279.0 * (Eps4 * Eps4) / 1260.0;
        if (e_constants.Eps2 < 0.0) {
            throw new SrmException(20, "Internal math inconsistency");
        }
    }

    protected static void init_power_p_series(OrmData e_constants, double[] cr1, double[] cr2) {
        double AA1 = 1.0000000000349;
        double AA2 = -0.643155723158021;
        double AA3 = -0.333332134894985;
        double AA4 = -2.41457540671514E-5;
        double AA5 = 0.143376648162652;
        double AA6 = 0.356844276587295;
        double AA7 = -0.333332875955149;
        double AA8 = 0.0;
        double AA9 = 0.0;
        double BB1 = AA1;
        double BB2 = e_constants.Eps2 * AA2;
        double BB3 = e_constants.Eps2 * (AA3 + e_constants.Eps * (AA4 + e_constants.Eps * AA5));
        double BB4 = e_constants.Eps2 * AA6;
        double BB5 = e_constants.Eps2 * (AA7 + e_constants.Eps * (AA8 + e_constants.Eps * AA9));
        cr1[0] = BB3 / BB5 - 1.87E-12;
        cr1[1] = (BB2 - BB4 * BB3 / BB5) / BB5;
        cr1[2] = (BB1 - BB3 / BB5) / BB5;
        cr1[3] = 1.0 / BB5;
        cr1[4] = BB4 / BB5;
        double AB1 = 0.999999999957885;
        double AB2 = -1.15979311942142;
        double AB3 = -0.333339671395063;
        double AB4 = 2.76473457331734E-4;
        double AB5 = 0.587786240368508;
        double AB6 = -0.159793128888088;
        double AB7 = -0.33333346598215;
        double AB8 = 7.46505041501704E-5;
        double AB9 = -0.0701559218182283;
        BB1 = AB1;
        BB2 = e_constants.Eps2 * AB2;
        BB3 = e_constants.Eps2 * (AB3 + e_constants.Eps * (AB4 + e_constants.Eps * AB5));
        BB4 = e_constants.Eps2 * AB6;
        BB5 = e_constants.Eps2 * (AB7 + e_constants.Eps * (AB8 + e_constants.Eps * AB9));
        cr2[0] = BB3 / BB5 + 2.689E-12;
        cr2[1] = (BB2 - BB4 * BB3 / BB5) / BB5;
        cr2[2] = (BB1 - BB3 / BB5) / BB5;
        cr2[3] = 1.0 / BB5;
        cr2[4] = BB4 / BB5;
    }

    public static void printMatrix(double[][] mtx, int rank) {
        for (int i = 0; i < rank; ++i) {
            for (int j = 0; j < rank; ++j) {
                System.out.print(mtx[i][j] + ", ");
            }
            System.out.print("\n");
        }
    }

    public static void main(String[] arg) {
        double[][] test_data = new double[][]{{16.0, 16.0, 19.0, 21.0, 20.0}, {14.0, 17.0, 15.0, 22.0, 18.0}, {24.0, 23.0, 21.0, 24.0, 20.0}, {18.0, 17.0, 16.0, 15.0, 20.0}, {18.0, 11.0, 9.0, 18.0, 7.0}};
        Matrix mtx = new Matrix(test_data);
        System.out.println("determinant=> " + mtx.det());
    }

    protected class GcToGdConst {
        double Eps21;
        double C254;
        double CEEps2;
        double CEE;
        double TwoCEE;
        double C2DA;
        double tem;
        double ARat1;
        double ARat2;
        double BRat1;
        double BRat2;
        double aeps21;
        double ak1;
        double ak2;
        double rho;
        double rho_inv;
        double[] b1 = new double[5];
        double[] b2 = new double[5];
        double[] b3 = new double[5];
        double[] b4 = new double[5];
        double[] b5 = new double[5];
        double[] u = new double[5];
        double[] v = new double[5];

        protected GcToGdConst() {
        }
    }

    protected static class FootPointConst {
        double k0_inv;
        double P1;
        double P2;
        double P3;

        public FootPointConst(OrmData e_constants, ArcLengthConst al, double central_scale) {
            this.k0_inv = 1.0 / central_scale;
            this.P1 = al.n * (3.0 + al.n * (5.25 + 7.75 * al.n));
            this.P2 = -Const.square(al.n) * (10.5 + 50.333333333333336 * al.n);
            this.P3 = 50.333333333333336 * Const.cube(al.n);
        }
    }

    protected static class ArcLengthConst {
        double n;
        double P;
        double Pn;
        double v;
        double Pv;
        double u;
        double B0;
        double B2;
        double B4;
        double B6;

        public ArcLengthConst(OrmData e_constants) {
            this.n = (e_constants.A - e_constants.B) / (e_constants.A + e_constants.B);
            this.P = e_constants.A / (1.0 + this.n);
            this.Pn = this.P * this.n;
            this.v = Const.square(this.n);
            this.Pv = this.P * this.v;
            this.u = 23.333333333333332 * this.n;
            this.B0 = this.P + 0.25 * this.Pv;
            this.B2 = this.Pn * (-3.0 + 3.75 * this.n - 4.0 * this.v);
            this.B4 = this.Pv * (-7.5 + this.u);
            this.B6 = -this.u * this.Pv;
        }
    }
}

