/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_3D;
import SRM.Const;
import SRM.Coord;
import SRM.Coord3D_Celestiodetic;
import SRM.Coord_ClassType;
import SRM.MGRS;
import SRM.OpManager;
import SRM.OrmDataSet;
import SRM.SRF_Celestiodetic;
import SRM.SRM_ORM_Code;
import SRM.SRM_RD_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;
import java.util.HashMap;

public abstract class Coord3D
extends Coord {
    protected double[] _values = new double[3];

    protected Coord3D(BaseSRF assocSRF, Coord_ClassType type) {
        super(assocSRF, type);
    }

    public double[] getValues() {
        double[] retVal = new double[]{this._values[0], this._values[1], this._values[2]};
        return retVal;
    }

    public void setValues(double[] values) throws SrmException {
        try {
            this._values[0] = values[0];
            this._values[1] = values[1];
            this._values[2] = values[2];
        }
        catch (RuntimeException primary_axis) {
            throw new SrmException(8, new String("Coord3D.setValues: Input array size different than 3"));
        }
    }

    public boolean isEqual(Coord coord) {
        if (coord == null) {
            return false;
        }
        double[] tmp = coord.getValues();
        return this.getClass() == coord.getClass() && Const.isEqual(this._values[0], tmp[0], 1.0E-6) && Const.isEqual(this._values[1], tmp[1], 1.0E-6) && Const.isEqual(this._values[2], tmp[2], 1.0E-6);
    }

    public void copyTo(Coord3D coord) throws SrmException {
        if (coord == null) {
            throw new SrmException(8, new String("Coord3D.copyTo: Input coordinate reference is null"));
        }
        if (this.getSRF() != coord.getSRF()) {
            throw new SrmException(5, new String("Coord3D.copyTo: Input coordinate not of the same SRF"));
        }
        coord._values[0] = this._values[0];
        coord._values[1] = this._values[1];
        coord._values[2] = this._values[2];
    }

    public String getMGRS(int precision) throws SrmException {
        try {
            return this.impl_get_mgrs(precision);
        }
        catch (SrmException se) {
            throw new SrmException(8, "Coord3D.getMGRS(): Invalid input for conversion to MGRS");
        }
    }

    public void setCoord(String strMGRS) throws SrmException {
        try {
            this.impl_set_coord(strMGRS);
        }
        catch (SrmException se) {
            throw new SrmException(8, "Coord3D.setCoord(): Invalid input for MGRS conversion to coordinate");
        }
    }

    protected String impl_get_mgrs(int precision) throws SrmException {
        SRM_RD_Code rdCode = OrmDataSet.getElem((SRM_ORM_Code)this.getSRF().getOrm())._rd_code;
        String ellipsoid_id = new String("WE");
        if (rdCode == SRM_RD_Code.RDCOD_BESSEL_1841_ETHIOPIA || rdCode == SRM_RD_Code.RDCOD_BESSEL_1841_NAMIBIA || rdCode == SRM_RD_Code.RDCOD_CLARKE_1858 || rdCode == SRM_RD_Code.RDCOD_CLARKE_1858_MODIFIED || rdCode == SRM_RD_Code.RDCOD_CLARKE_1866 || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880 || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880_CAPE || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880_FIJI || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880_IGN || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880_PALESTINE || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880_SYRIA) {
            ellipsoid_id = "BR";
        }
        MGRS MGRSHelper = new MGRS(ellipsoid_id, (BaseSRF_3D)this.getSRF());
        String strMGRS = "ERROR";
        if (this.getClassType() == Coord_ClassType.CD_3D) {
            strMGRS = MGRSHelper.Convert_Geodetic_To_MGRS(((Coord3D_Celestiodetic)this).get_latitude(), ((Coord3D_Celestiodetic)this).get_longitude(), precision);
        } else {
            double[] tempTgtCoord = BaseSRF.interimConv(this, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC);
            strMGRS = MGRSHelper.Convert_Geodetic_To_MGRS(tempTgtCoord[1], tempTgtCoord[0], precision);
        }
        return strMGRS;
    }

    protected void impl_set_coord(String strMGRS) throws SrmException {
        SRM_RD_Code rdCode = OrmDataSet.getElem((SRM_ORM_Code)this.getSRF().getOrm())._rd_code;
        String ellipsoid_id = "WE";
        if (rdCode == SRM_RD_Code.RDCOD_BESSEL_1841_ETHIOPIA || rdCode == SRM_RD_Code.RDCOD_BESSEL_1841_NAMIBIA || rdCode == SRM_RD_Code.RDCOD_CLARKE_1858 || rdCode == SRM_RD_Code.RDCOD_CLARKE_1858_MODIFIED || rdCode == SRM_RD_Code.RDCOD_CLARKE_1866 || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880 || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880_CAPE || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880_FIJI || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880_IGN || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880_PALESTINE || rdCode == SRM_RD_Code.RDCOD_CLARKE_1880_SYRIA) {
            ellipsoid_id = "BR";
        }
        MGRS MGRSHelper = new MGRS(ellipsoid_id, (BaseSRF_3D)this.getSRF());
        double[] tgtLatLon = MGRSHelper.Convert_MGRS_To_Geodetic(strMGRS);
        if (this.getClassType() == Coord_ClassType.CD_3D) {
            this.setValues(tgtLatLon);
        } else {
            SRF_Celestiodetic tempTgtCdSrf;
            if (this.getSRF()._internalSRFs == null) {
                this.getSRF()._internalSRFs = new HashMap();
            }
            if ((tempTgtCdSrf = (SRF_Celestiodetic)this.getSRF()._internalSRFs.get("Interim_Cd")) == null) {
                tempTgtCdSrf = new SRF_Celestiodetic(this.getSRF().getOrm(), this.getSRF().getRt());
                this.getSRF()._internalSRFs.put("Interim_Cd", tempTgtCdSrf);
            }
            double[] tempTgtCoord = new double[3];
            OpManager.instance().computeAsArray(tempTgtCdSrf, this.getSRF(), tgtLatLon, tempTgtCoord, null);
            this.setValues(tempTgtCoord);
        }
    }
}

