/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.Const;
import SRM.Coord;
import SRM.Coord3D;
import SRM.Coord_ClassType;
import SRM.SRF_EquatorialInertial;

public class Coord3D_EquatorialInertial
extends Coord3D {
    public Coord3D_EquatorialInertial(SRF_EquatorialInertial srf) {
        super(srf, Coord_ClassType.EI_3D);
        this.setValues(Double.NaN, Double.NaN, Double.NaN);
    }

    public Coord3D_EquatorialInertial(SRF_EquatorialInertial srf, double right_ascension, double declination, double radius) {
        super(srf, Coord_ClassType.EI_3D);
        this.setValues(right_ascension, declination, radius);
    }

    public Coord3D_EquatorialInertial(Coord3D_EquatorialInertial original) {
        super(original.getSRF(), Coord_ClassType.EI_3D);
        this.setValues(original._values[0], original._values[1], original._values[2]);
    }

    public void setValues(double right_ascension, double declination, double radius) {
        this._values[0] = right_ascension;
        this._values[1] = declination;
        this._values[2] = radius;
    }

    public double get_right_ascension() {
        return this._values[0];
    }

    public double get_declination() {
        return this._values[1];
    }

    public double get_radius() {
        return this._values[2];
    }

    public void set_right_ascension(double value) {
        this._values[0] = value;
    }

    public void set_declination(double value) {
        this._values[1] = value;
    }

    public void set_radius(double value) {
        this._values[2] = value;
    }

    public boolean isEqual(Coord coord) {
        if (coord == null) {
            return false;
        }
        double[] tmp = coord.getValues();
        return coord instanceof Coord3D_EquatorialInertial && Const.isEqual(this._values[0], tmp[0], 1.0E-6) && Const.isEqual(this._values[1], tmp[1], 1.0E-6) && Const.isEqual(this._values[2], tmp[2], 1.0E-6);
    }

    public String toString() {
        return new String("[ " + this._values[0] + ", " + this._values[1] + ", " + this._values[2] + " ]");
    }
}

