/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.Const;
import SRM.Coord;
import SRM.Coord3D;
import SRM.Coord_ClassType;
import SRM.SRF_SolarEquatorial;

public class Coord3D_SolarEquatorial
extends Coord3D {
    public Coord3D_SolarEquatorial(SRF_SolarEquatorial srf) {
        super(srf, Coord_ClassType.SEQ_3D);
        this.setValues(Double.NaN, Double.NaN, Double.NaN);
    }

    public Coord3D_SolarEquatorial(SRF_SolarEquatorial srf, double longitude, double latitude, double radius) {
        super(srf, Coord_ClassType.SEQ_3D);
        this.setValues(longitude, latitude, radius);
    }

    public Coord3D_SolarEquatorial(Coord3D_SolarEquatorial original) {
        super(original.getSRF(), Coord_ClassType.SEQ_3D);
        this.setValues(original._values[0], original._values[1], original._values[2]);
    }

    public void setValues(double longitude, double latitude, double radius) {
        this._values[0] = longitude;
        this._values[1] = latitude;
        this._values[2] = radius;
    }

    public double get_longitude() {
        return this._values[0];
    }

    public double get_latitude() {
        return this._values[1];
    }

    public double get_radius() {
        return this._values[2];
    }

    public void set_longitude(double value) {
        this._values[0] = value;
    }

    public void set_latitude(double value) {
        this._values[1] = value;
    }

    public void set_radius(double value) {
        this._values[2] = value;
    }

    public boolean isEqual(Coord coord) {
        if (coord == null) {
            return false;
        }
        double[] tmp = coord.getValues();
        return coord instanceof Coord3D_SolarEquatorial && Const.isEqual(this._values[0], tmp[0], 1.0E-6) && Const.isEqual(this._values[1], tmp[1], 1.0E-6) && Const.isEqual(this._values[2], tmp[2], 1.0E-6);
    }

    public String toString() {
        return new String("[ " + this._values[0] + ", " + this._values[1] + ", " + this._values[2] + " ]");
    }
}

