/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.GtrsDataSet;
import SRM.OrmData;
import SRM.SRF_PS_Params;
import SRM.SRF_TM_Params;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_Extended_Valid_Region_Params;
import SRM.SRM_Interval_Type;
import SRM.SRM_Polar_Aspect;
import SRM.SRM_SRFSM_Code;
import SRM.SRM_SRFSM_Japan_Rectangular_Plane_CS_Code;
import SRM.SRM_SRFSM_Lambert_NTF_Code;
import SRM.SRM_SRFSM_UTM_Code;
import SRM.SRM_SRFS_Code;
import SRM.SRM_SRFT_Code;
import SRM.SRM_SRF_Code;
import SRM.SrmException;

abstract class CoordCheck {
    private static SRM_SRFT_Code[] srfStdBoundaryDefTemplate = new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_UNSPECIFIED, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC};
    private static SRM_SRFT_Code[] srfsBoundaryDefTemplate = new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_UNSPECIFIED, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC};
    private static SRM_SRFT_Code[] srftBoundaryDefTemplate = new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_UNSPECIFIED, SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC, SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_RECT_3D, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_PLANETODETIC, SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN, SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_AZIMUTHAL_SPHERICAL, SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_CYLINDRICAL, SRM_SRFT_Code.SRFTCOD_LOCOCENTRIC_EUCLIDEAN_3D, SRM_SRFT_Code.SRFTCOD_CELESTIOMAGNETIC, SRM_SRFT_Code.SRFTCOD_EQUATORIAL_INERTIAL, SRM_SRFT_Code.SRFTCOD_SOLAR_ECLIPTIC, SRM_SRFT_Code.SRFTCOD_SOLAR_EQUATORIAL, SRM_SRFT_Code.SRFTCOD_SOLAR_MAGNETIC_ECLIPTIC, SRM_SRFT_Code.SRFTCOD_SOLAR_MAGNETIC_DIPOLE, SRM_SRFT_Code.SRFTCOD_HELIOSPHERIC_ARIES_ECLIPTIC, SRM_SRFT_Code.SRFTCOD_HELIOSPHER_EARTH_ECLIPTIC, SRM_SRFT_Code.SRFTCOD_HELIOSPHER_EARTH_EQUATORIAL, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_RECT_2D, SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_AZIMUTHAL_2D, SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_POLAR_2D};

    CoordCheck() {
    }

    protected static SRM_SRFT_Code getsrfsBoundaryDefTemplate(SRM_SRFS_Code srfs_code) {
        return srfsBoundaryDefTemplate[srfs_code.toInt()];
    }

    protected static SRM_SRFT_Code getsrfBoundaryDefTemplate(BaseSRF srf) throws SrmException {
        SRM_SRFT_Code retCode = SRM_SRFT_Code.SRFTCOD_UNSPECIFIED;
        if (srf.getSRFSetCode() != SRM_SRFS_Code.SRFSCOD_UNSPECIFIED) {
            retCode = srfsBoundaryDefTemplate[srf.getSRFSetCode().toInt()];
        } else if (srf.getSRFCode() != SRM_SRF_Code.SRFCOD_UNSPECIFIED) {
            retCode = srfStdBoundaryDefTemplate[srf.getSRFCode().toInt()];
        } else if (srf.getSRFTemplateCode() != SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            retCode = srftBoundaryDefTemplate[srf.getSRFTemplateCode().toInt()];
        } else {
            throw new SrmException(3, new String("Invalid source SRF Code"));
        }
        return retCode;
    }

    private static SRM_Coordinate_Valid_Region_Code validcoordCheck(SRM_Extended_Valid_Region_Params region, boolean region_is_angular, double v_coord) throws SrmException {
        SRM_Coordinate_Valid_Region_Code ret_reg = null;
        if (region == null || region.type == SRM_Interval_Type.IVLTYP_UNBOUNDED) {
            ret_reg = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        } else if (region.type == SRM_Interval_Type.IVLTYP_OPEN_INTERVAL) {
            ret_reg = region_is_angular && region.lower > region.upper ? (v_coord > region.lower && v_coord < Math.PI || v_coord > -Math.PI && v_coord < region.upper ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID : (v_coord > region.extended_lower && v_coord < Math.PI || v_coord > -Math.PI && v_coord < region.extended_upper ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID : SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED)) : (v_coord > region.lower && v_coord < region.upper ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID : (v_coord > region.extended_lower && v_coord < region.extended_upper ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID : SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED));
        } else if (region.type == SRM_Interval_Type.IVLTYP_CLOSED_INTERVAL) {
            if (!region_is_angular || !(region.lower > region.upper)) {
                ret_reg = v_coord >= region.lower && v_coord <= region.upper ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID : (v_coord >= region.extended_lower && v_coord <= region.extended_upper ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID : SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED);
            }
        } else if (region.type == SRM_Interval_Type.IVLTYP_GE_LT_INTERVAL || region.type == SRM_Interval_Type.IVLTYP_GE_SEMI_INTERVAL || region.type == SRM_Interval_Type.IVLTYP_LT_SEMI_INTERVAL) {
            if (!region_is_angular || !(region.lower > region.upper)) {
                ret_reg = v_coord >= region.lower && v_coord < region.upper ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID : (v_coord >= region.extended_lower && v_coord < region.extended_upper ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID : SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED);
            }
        } else if (!(region.type != SRM_Interval_Type.IVLTYP_GT_LE_INTERVAL && region.type != SRM_Interval_Type.IVLTYP_GT_SEMI_INTERVAL && region.type != SRM_Interval_Type.IVLTYP_LE_SEMI_INTERVAL || region_is_angular)) {
            ret_reg = v_coord > region.lower && v_coord <= region.upper ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID : (v_coord > region.extended_lower && v_coord <= region.extended_upper ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID : SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED);
        }
        if (ret_reg == null) {
            throw new SrmException(5, new String("Invalid coordinate"));
        }
        return ret_reg;
    }

    private static SRM_Coordinate_Valid_Region_Code validcoord2DCheck(SRM_Extended_Valid_Region_Params[] region, boolean[] region_is_angular, double[] v_coord) throws SrmException {
        SRM_Coordinate_Valid_Region_Code[] reg = new SRM_Coordinate_Valid_Region_Code[2];
        for (int i = 0; i < 2; ++i) {
            reg[i] = CoordCheck.validcoordCheck(region[i], region_is_angular[i], v_coord[i]);
        }
        SRM_Coordinate_Valid_Region_Code ret_reg = reg[0] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID && reg[1] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID : (reg[0] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED || reg[1] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED : SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID);
        return ret_reg;
    }

    private static SRM_Coordinate_Valid_Region_Code validcoord3DCheck(SRM_Extended_Valid_Region_Params[] region, boolean[] region_is_angular, double[] v_coord) throws SrmException {
        SRM_Coordinate_Valid_Region_Code[] reg = new SRM_Coordinate_Valid_Region_Code[3];
        for (int i = 0; i < 3; ++i) {
            reg[i] = CoordCheck.validcoordCheck(region[i], region_is_angular[i], v_coord[i]);
        }
        SRM_Coordinate_Valid_Region_Code ret_reg = reg[0] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID && reg[1] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID && reg[2] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID : (reg[0] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED || reg[1] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED || reg[2] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED : SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID);
        return ret_reg;
    }

    private static SRM_Coordinate_Valid_Region_Code validcoordGDCheck(SRM_Extended_Valid_Region_Params[] region, boolean[] region_is_angular, double[] v_coord) throws SrmException {
        SRM_Coordinate_Valid_Region_Code[] reg = new SRM_Coordinate_Valid_Region_Code[2];
        for (int i = 0; i < 2; ++i) {
            reg[i] = CoordCheck.validcoordCheck(region[i], region_is_angular[i], v_coord[i]);
        }
        SRM_Coordinate_Valid_Region_Code ret_reg = reg[0] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID && reg[1] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID : (reg[0] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED || reg[1] == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED ? SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED : SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID);
        return ret_reg;
    }

    protected static SRM_Coordinate_Valid_Region_Code forNaN_2D(double[] coord) throws SrmException {
        double nan_test_value = coord[0] * coord[1];
        if (Double.isNaN(nan_test_value)) {
            throw new SrmException(5, new String("Invalid (not well formed) coordinate - NaN"));
        }
        return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
    }

    protected static SRM_Coordinate_Valid_Region_Code forNaN_3D(double[] coord) throws SrmException {
        double nan_test_value = coord[0] * coord[1] * coord[2];
        if (Double.isNaN(nan_test_value)) {
            throw new SrmException(5, new String("Invalid (not well formed) coordinate - NaN"));
        }
        return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
    }

    protected static SRM_Coordinate_Valid_Region_Code forLsr3d(double[] coord) throws SrmException {
        if (Math.abs(coord[0]) + Math.abs(coord[1]) + Math.abs(coord[2]) > 1.0E-6) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        throw new SrmException(5, new String("Invalid LSR 3D coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forLsr2d(double[] coord) throws SrmException {
        if (Math.abs(coord[0]) + Math.abs(coord[1]) > 1.0E-6) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        throw new SrmException(5, new String("Invalid LSR 2D coordinate"));
    }

    protected static boolean forCelestiodeticSurface(double longitude, double geodetic_latitude) {
        return Const.isWellFormedLongitude(longitude) && Const.isWellFormedLatitude(geodetic_latitude) || longitude == 0.0 && (geodetic_latitude == -1.5707963267948966 || geodetic_latitude == 1.5707963267948966);
    }

    protected static SRM_Coordinate_Valid_Region_Code forCelestiodetic(OrmData ormData, double[] coord) throws SrmException {
        if ((Const.isWellFormedLongitude(coord[0]) && Const.isWellFormedLatitude(coord[1]) || coord[0] == 0.0 && (coord[1] == -1.5707963267948966 || coord[1] == 1.5707963267948966)) && coord[2] > -ormData.B && Const.isWellFormedHeight(coord[2])) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        throw new SrmException(5, new String("Invalid Celestiodetic coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forPlanetodetic(OrmData ormData, double[] coord) throws SrmException {
        if ((Const.isWellFormedLongitude(coord[1]) && Const.isWellFormedLatitude(coord[0]) || coord[1] == 0.0 && (coord[0] == -1.5707963267948966 || coord[0] == 1.5707963267948966)) && coord[2] > -ormData.B && Const.isWellFormedHeight(coord[2])) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        throw new SrmException(5, new String("Invalid Planetodetic coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forLocalSpaceAzimuthal2D(double[] coord) throws SrmException {
        if (Const.isWellFormedAzimuth(coord[0]) && Const.isWellFormedRadius(coord[1]) || coord[0] == 0.0 && coord[1] == 0.0) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        throw new SrmException(5, new String("Invalid Local Space Azimuthal coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forLocalSpacePolar(double[] coord) throws SrmException {
        if (Const.isWellFormedAzimuth(coord[0]) && Const.isWellFormedRadius(coord[1]) || coord[0] == 0.0 && coord[1] == 0.0) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        throw new SrmException(5, new String("Invalid Local Space Polar coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forMercator_cd(OrmData ormData, double[] coord) throws SrmException {
        return CoordCheck.forCelestiodetic(ormData, coord);
    }

    protected static SRM_Coordinate_Valid_Region_Code forTransverseMercator_cd(OrmData ormData, SRF_TM_Params params, double[] coord) throws SrmException {
        CoordCheck.forCelestiodetic(ormData, coord);
        if (Const.delta_lambda_min(coord[0], params.origin_longitude) <= 0.06981417007977318 && coord[1] <= 1.4748042179352083 && coord[1] >= -1.4049890478554354) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        if (Const.delta_lambda_min(coord[0], params.origin_longitude) <= 0.20944951023931957 && coord[1] <= 1.5706317938696972 && coord[1] >= -1.570611793869697) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID;
        }
        throw new SrmException(5, new String("Invalid coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forLCC_cd(OrmData ormData, double[] coord) throws SrmException {
        return CoordCheck.forCelestiodetic(ormData, coord);
    }

    protected static SRM_Coordinate_Valid_Region_Code forPolarStereographic_cd(SRF_PS_Params params, double[] coord) throws SrmException {
        if (params.polar_aspect == SRM_Polar_Aspect.PLRASP_NORTH) {
            if (coord[1] >= 0.0 && coord[1] <= 1.5707963267948966 && coord[0] > -Math.PI && coord[0] <= Math.PI || coord[1] == 1.5707963267948966 && coord[0] == 0.0) {
                return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
            }
            throw new SrmException(5, new String("Invalid coordinate"));
        }
        if (coord[1] >= -1.5707963267948966 && coord[1] <= 0.0 && coord[0] > -Math.PI && coord[0] <= Math.PI || coord[1] == -1.5707963267948966 && coord[0] == 0.0) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        throw new SrmException(5, new String("Invalid coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forEquidistantCylindrical_cd(OrmData ormData, double[] coord) throws SrmException {
        return CoordCheck.forCelestiodetic(ormData, coord);
    }

    protected static SRM_Coordinate_Valid_Region_Code forSpherical(double[] coord) throws SrmException {
        if ((Const.isWellFormedLongitude(coord[0]) && Const.isWellFormedLatitude(coord[1]) || coord[0] == 0.0 && (coord[1] == -1.5707963267948966 || coord[1] == 1.5707963267948966)) && Const.isWellFormedRadius(coord[2]) || coord[0] == 0.0 && coord[1] == 0.0 && coord[2] == 0.0) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        throw new SrmException(5, new String("Invalid coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forAzSpherical(double[] coord) throws SrmException {
        if ((Const.isWellFormedAzimuth(coord[0]) && Const.isWellFormedLatitude(coord[1]) || coord[0] == 0.0 && (coord[1] == -1.5707963267948966 || coord[1] == 1.5707963267948966)) && Const.isWellFormedRadius(coord[2]) || coord[0] == 0.0 && coord[1] == 0.0 && coord[2] == 0.0) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        throw new SrmException(5, new String("Invalid coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forCylindrical(double[] coord) throws SrmException {
        if (Const.isWellFormedAzimuth(coord[0]) && Const.isWellFormedRadius(coord[1]) || coord[0] == 0.0 && coord[1] == 0.0) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        throw new SrmException(5, new String("Invalid coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forALSP_cd(OrmData ormData, SRF_TM_Params params, double[] coord) throws SrmException {
        return CoordCheck.forTransverseMercator_cd(ormData, params, coord);
    }

    protected static SRM_Coordinate_Valid_Region_Code forGTRS(double[] coord) throws SrmException {
        return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED;
    }

    protected static SRM_Coordinate_Valid_Region_Code forGTRS_cd(SRM_SRFSM_Code srfSetMemberCode, double[] coord) throws SrmException {
        double GtrsCellOriginLat = 0.0;
        GtrsDataSet tmpGtrsElem = GtrsDataSet.getElem(srfSetMemberCode.toInt());
        GtrsCellOriginLat = GtrsDataSet.getCellOrigLat(tmpGtrsElem);
        if (coord[0] >= GtrsDataSet.getCellOrigLonMinExtent(srfSetMemberCode.toInt(), tmpGtrsElem) && coord[0] <= GtrsDataSet.getCellOrigLonMaxExtent(srfSetMemberCode.toInt(), tmpGtrsElem) && coord[1] >= GtrsCellOriginLat - Math.PI / 360 && coord[1] <= GtrsCellOriginLat + Math.PI / 360) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED;
    }

    protected static SRM_Coordinate_Valid_Region_Code forUPS_cd(SRF_PS_Params params, double[] coord) throws SrmException {
        if (params.polar_aspect == SRM_Polar_Aspect.PLRASP_NORTH) {
            if (coord[1] >= 1.4660765716752369) {
                return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
            }
            if (coord[1] >= 1.457349925415265) {
                return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID;
            }
            throw new SrmException(5, new String("Invalid coordinate"));
        }
        if (coord[1] <= -1.3962634015954636) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        if (coord[1] <= -1.387536755335492) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID;
        }
        throw new SrmException(5, new String("Invalid coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forUTM_cd(OrmData ormData, SRF_TM_Params params, SRM_SRFSM_UTM_Code srfSetMemberCode, double[] coord) throws SrmException {
        CoordCheck.forCelestiodetic(ormData, coord);
        double dlm = Const.delta_lambda_min(coord[0], params.origin_longitude);
        if (srfSetMemberCode.toInt() <= 60) {
            if (dlm <= 0.05235987755982989 && coord[1] < 1.4660765716752369 && coord[1] >= 0.0) {
                return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
            }
            if (dlm <= 0.10471975511965978 && coord[1] < 1.4748032179352084 && coord[1] >= -Math.PI / 360) {
                return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID;
            }
            throw new SrmException(5, new String("Invalid coordinate"));
        }
        if (dlm <= 0.05235987755982989 && coord[1] < 0.0 && coord[1] >= -1.3962634015954636) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        if (dlm <= 0.10471975511965978 && coord[1] < Math.PI / 360 && coord[1] >= -1.4049900478554354) {
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID;
        }
        throw new SrmException(5, new String("Invalid coordinate"));
    }

    protected static SRM_Coordinate_Valid_Region_Code forWISP_cd(OrmData ormData, double[] coord) throws SrmException {
        return CoordCheck.forLCC_cd(ormData, coord);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static SRM_Coordinate_Valid_Region_Code forLNTF_cd(OrmData ormData, SRM_SRFSM_Lambert_NTF_Code member, double[] coord) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = null;
        if (member == SRM_SRFSM_Lambert_NTF_Code.SRFSMLAMNTFCOD_ZONE_I) {
            if (!(coord[0] >= -0.08726646259971647)) throw new SrmException(5, new String("Invalid coordinate"));
            if (!(coord[0] <= 0.17453292519943295)) throw new SrmException(5, new String("Invalid coordinate"));
            if (!(coord[1] >= 0.9337511498169663)) throw new SrmException(5, new String("Invalid coordinate"));
            if (!(coord[1] < 0.9948376736367679)) throw new SrmException(5, new String("Invalid coordinate"));
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        if (member == SRM_SRFSM_Lambert_NTF_Code.SRFSMLAMNTFCOD_ZONE_II) {
            if (!(coord[0] >= -0.08726646259971647)) throw new SrmException(5, new String("Invalid coordinate"));
            if (!(coord[0] <= 0.17453292519943295)) throw new SrmException(5, new String("Invalid coordinate"));
            if (!(coord[1] >= 0.8813912722571364)) throw new SrmException(5, new String("Invalid coordinate"));
            if (!(coord[1] < 0.9337511498169663)) throw new SrmException(5, new String("Invalid coordinate"));
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        if (member == SRM_SRFSM_Lambert_NTF_Code.SRFSMLAMNTFCOD_ZONE_III) {
            if (!(coord[0] >= -0.08726646259971647)) throw new SrmException(5, new String("Invalid coordinate"));
            if (!(coord[0] <= 0.17453292519943295)) throw new SrmException(5, new String("Invalid coordinate"));
            if (!(coord[1] >= 0.8203047484373349)) throw new SrmException(5, new String("Invalid coordinate"));
            if (!(coord[1] < 0.8813912722571364)) throw new SrmException(5, new String("Invalid coordinate"));
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        if (member != SRM_SRFSM_Lambert_NTF_Code.SRFSMLAMNTFCOD_ZONE_IV) throw new SrmException(20, new String("Error in LNTF validation - illegal member=> " + member));
        if (!(coord[0] >= 0.13962634015954636)) throw new SrmException(5, new String("Invalid coordinate"));
        if (!(coord[0] <= 0.17453292519943295)) throw new SrmException(5, new String("Invalid coordinate"));
        if (!(coord[1] >= 0.7155849933176751)) throw new SrmException(5, new String("Invalid coordinate"));
        if (!(coord[1] < 0.7592182246175333)) throw new SrmException(5, new String("Invalid coordinate"));
        return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
    }

    protected static SRM_Coordinate_Valid_Region_Code forJapan_cd(OrmData ormData, SRM_SRFSM_Japan_Rectangular_Plane_CS_Code member, SRF_TM_Params params, double[] coord) throws SrmException {
        SRM_Coordinate_Valid_Region_Code status;
        switch (member.toInt()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                status = CoordCheck.forTransverseMercator_cd(ormData, params, coord);
                break;
            }
            case 14: {
                if (coord[0] > 2.452187599052033 && coord[0] < 2.4958208303518914 && coord[1] < 0.4886921905584123) {
                    status = CoordCheck.forTransverseMercator_cd(ormData, params, coord);
                    break;
                }
                throw new SrmException(5, new String("Invalid coordinate - out of valid range for zone"));
            }
            case 15: {
                if (coord[0] > 2.199114857512855 && coord[0] < 2.2689280275926285) {
                    status = CoordCheck.forTransverseMercator_cd(ormData, params, coord);
                    break;
                }
                throw new SrmException(5, new String("Invalid coordinate - out of valid range for zone"));
            }
            case 16: {
                if (coord[0] > 2.199114857512855) {
                    status = CoordCheck.forTransverseMercator_cd(ormData, params, coord);
                    break;
                }
                throw new SrmException(5, new String("Invalid coordinate - out of valid range for zone"));
            }
            case 17: {
                if (coord[0] > 2.2689280275926285) {
                    status = CoordCheck.forTransverseMercator_cd(ormData, params, coord);
                    break;
                }
                throw new SrmException(5, new String("Invalid coordinate - out of valid range for zone"));
            }
            case 18: {
                if (coord[0] > 2.452187599052033 && coord[1] < 0.4886921905584123) {
                    status = CoordCheck.forTransverseMercator_cd(ormData, params, coord);
                    break;
                }
                throw new SrmException(5, new String("Invalid coordinate - out of valid range for zone"));
            }
            case 19: {
                if (coord[0] > 2.4958208303518914 && coord[1] < 0.4886921905584123) {
                    status = CoordCheck.forTransverseMercator_cd(ormData, params, coord);
                    break;
                }
                throw new SrmException(5, new String("Invalid coordinate - out of valid range for zone"));
            }
            default: {
                throw new SrmException(5, new String("Invalid zone"));
            }
        }
        return status;
    }

    protected static SRM_Coordinate_Valid_Region_Code forTransverseMercator_native(double m, double bl, double x_threshold, double y_threshold, double[] coord) throws SrmException {
        if (coord[1] > y_threshold) {
            if (coord[1] > m * -Math.abs(coord[0]) + bl) {
                throw new SrmException(5, new String("Invalid coordinate - northing greater than threshold"));
            }
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        if (coord[1] < -y_threshold) {
            if (coord[1] < -m * -Math.abs(coord[0]) - bl) {
                throw new SrmException(5, new String("Invalid coordinate - northing less than threshold"));
            }
            return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        }
        if (Math.abs(coord[0]) > x_threshold) {
            throw new SrmException(5, new String("Invalid coordinate - easting greater than threshold"));
        }
        return SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
    }
}

