/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.Const;
import SRM.Coord;
import SRM.CoordSurf;
import SRM.Coord_ClassType;
import SRM.SRF_PolarStereographic;

public class CoordSurf_PolarStereographic
extends CoordSurf {
    public CoordSurf_PolarStereographic(SRF_PolarStereographic srf) {
        super(srf, Coord_ClassType.PS_AUGMENTED_3D);
        this.setValues(Double.NaN, Double.NaN);
    }

    public CoordSurf_PolarStereographic(SRF_PolarStereographic srf, double easting, double northing) {
        super(srf, Coord_ClassType.PS_SURFACE);
        this.setValues(easting, northing);
    }

    public CoordSurf_PolarStereographic(CoordSurf_PolarStereographic original) {
        super(original.getSRF(), Coord_ClassType.PS_SURFACE);
        this.setValues(original._values[0], original._values[1]);
    }

    public void setValues(double easting, double northing) {
        this._values[0] = easting;
        this._values[1] = northing;
    }

    public double get_easting() {
        return this._values[0];
    }

    public double get_northing() {
        return this._values[1];
    }

    public void set_easting(double value) {
        this._values[0] = value;
    }

    public void set_northing(double value) {
        this._values[1] = value;
    }

    public boolean isEqual(Coord coord) {
        if (coord == null) {
            return false;
        }
        double[] tmp = coord.getValues();
        return coord instanceof CoordSurf_PolarStereographic && Const.isEqual(this._values[0], tmp[0], 1.0E-6) && Const.isEqual(this._values[1], tmp[1], 1.0E-6);
    }

    public String toString() {
        return new String("[ " + this._values[0] + ", " + this._values[1] + " ]");
    }
}

