/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_3D;
import SRM.Const;
import SRM.GtrsDataSet;
import SRM.SRF_Celestiocentric;
import SRM.SRF_Celestiodetic;
import SRM.SRF_LambertConformalConic;
import SRM.SRF_LocalTangentSpaceEuclidean;
import SRM.SRF_Planetodetic;
import SRM.SRF_PolarStereographic;
import SRM.SRF_TransverseMercator;
import SRM.SRM_ORM_Code;
import SRM.SRM_Polar_Aspect;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFSM_Alabama_SPCS_Code;
import SRM.SRM_SRFSM_Code;
import SRM.SRM_SRFSM_GTRS_GCS_Code;
import SRM.SRM_SRFSM_Japan_Rectangular_Plane_CS_Code;
import SRM.SRM_SRFSM_Lambert_NTF_Code;
import SRM.SRM_SRFSM_UPS_Code;
import SRM.SRM_SRFSM_UTM_Code;
import SRM.SRM_SRFSM_Wisconsin_SPCS_Code;
import SRM.SRM_SRFS_Code;
import SRM.SRM_SRFT_Code;
import SRM.SRM_SRF_Code;
import SRM.SrmException;

class CreateSRF {
    CreateSRF() {
    }

    protected static BaseSRF fromCode(SRM_SRFT_Code srftCode, SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        BaseSRF_3D retSrf;
        if (srftCode == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC) {
            retSrf = new SRF_Celestiodetic(orm, rt);
        } else if (srftCode == SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC) {
            retSrf = new SRF_Celestiocentric(orm, rt);
        } else {
            throw new SrmException(9, new String("Validation checking not supported"));
        }
        return retSrf;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static BaseSRF standardSRF(SRM_SRF_Code srf_code, SRM_RT_Code rt_code) throws SrmException {
        void var2_17;
        Object var2_2 = null;
        if (srf_code == SRM_SRF_Code.SRFCOD_BRITISH_NATIONAL_GRID_AIRY) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_OSGB_1936, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_OSGB_1936"));
            SRF_TransverseMercator sRF_TransverseMercator = new SRF_TransverseMercator(SRM_ORM_Code.ORMCOD_OSGB_1936, rt_code, -Math.PI / 90, 0.8552113334772214, 0.9996012717, 400000.0, -100000.0);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_BRITISH_OSGRS80_GRID) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_ETRS_1989, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_ETRS_1989"));
            SRF_TransverseMercator sRF_TransverseMercator = new SRF_TransverseMercator(SRM_ORM_Code.ORMCOD_ETRS_1989, rt_code, -Math.PI / 90, 0.8552113334772214, 0.9996012717, 400000.0, -100000.0);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_DELAWARE_SPCS_1983) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_N_AM_1983, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_N_AM_1983"));
            SRF_TransverseMercator sRF_TransverseMercator = new SRF_TransverseMercator(SRM_ORM_Code.ORMCOD_N_AM_1983, rt_code, -1.3162691442123904, 0.6632251157578453, 0.999995, 200000.0, 0.0);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_GEOCENTRIC_WGS_1984) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_WGS_1984, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_WGS_1984"));
            SRF_Celestiocentric sRF_Celestiocentric = new SRF_Celestiocentric(SRM_ORM_Code.ORMCOD_WGS_1984, rt_code);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_GEODETIC_AUSTRALIA_1984) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_AUSTRALIAN_GEOD_1984, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_AUSTRALIAN_GEOD_1984"));
            SRF_Celestiodetic sRF_Celestiodetic = new SRF_Celestiodetic(SRM_ORM_Code.ORMCOD_AUSTRALIAN_GEOD_1984, rt_code);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_GEODETIC_WGS_1984) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_WGS_1984, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_WGS_1984"));
            SRF_Celestiodetic sRF_Celestiodetic = new SRF_Celestiodetic(SRM_ORM_Code.ORMCOD_WGS_1984, rt_code);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_GEODETIC_N_AMERICAN_1983) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_N_AM_1983, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_N_AM_1983"));
            SRF_Celestiodetic sRF_Celestiodetic = new SRF_Celestiodetic(SRM_ORM_Code.ORMCOD_N_AM_1983, rt_code);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_IRISH_GRID_1965) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_IRELAND_1965, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_IRELAND_1965"));
            SRF_TransverseMercator sRF_TransverseMercator = new SRF_TransverseMercator(SRM_ORM_Code.ORMCOD_IRELAND_1965, rt_code, -0.13962634015954636, 0.9337511498169663, 1.000035, 200000.0, 250000.0);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_IRISH_TRANSVERSE_MERCATOR_1989) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_ETRS_1989, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_ETRS_1989"));
            SRF_TransverseMercator sRF_TransverseMercator = new SRF_TransverseMercator(SRM_ORM_Code.ORMCOD_ETRS_1989, rt_code, -0.13962634015954636, 0.9337511498169663, 0.99982, 600000.0, 750000.0);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_LAMBERT_93) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_RGF_1993, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_RGF_1993"));
            SRF_LambertConformalConic sRF_LambertConformalConic = new SRF_LambertConformalConic(SRM_ORM_Code.ORMCOD_RGF_1993, rt_code, 0.05235987755982989, 0.8115781021773633, 0.767944870877505, 0.8552113334772214, 700000.0, 6600000.0);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_LAMBERT_II_WIDE) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_NTF_1896_PM_PARIS, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_NTF_1896_PM_PARIS"));
            SRF_LambertConformalConic sRF_LambertConformalConic = new SRF_LambertConformalConic(SRM_ORM_Code.ORMCOD_NTF_1896_PM_PARIS, rt_code, 0.0, 0.8168140899333461, 0.8010872577169285, 0.8324524921343296, 600000.0, 2200000.0);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_MARYLAND_SPCS_1983) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_N_AM_1983, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_N_AM_1983"));
            SRF_LambertConformalConic sRF_LambertConformalConic = new SRF_LambertConformalConic(SRM_ORM_Code.ORMCOD_N_AM_1983, rt_code, -1.3439035240356338, 0.6603162336711881, 0.6684611035138281, 0.688532389911763, 400000.0, 0.0);
        } else if (srf_code == SRM_SRF_Code.SRFCOD_MARS_PLANETOCENTRIC_2000) {
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_MARS_SPHERE_2000, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_MARS_SPHERE_2000"));
            SRF_Celestiodetic sRF_Celestiodetic = new SRF_Celestiodetic(SRM_ORM_Code.ORMCOD_MARS_SPHERE_2000, rt_code);
        } else {
            if (srf_code != SRM_SRF_Code.SRFCOD_MARS_PLANETOGRAPHIC_2000) throw new SrmException(9, new String("createStandardSRF: invalid SRF code"));
            if (!Const.isValidOrmRt(SRM_ORM_Code.ORMCOD_MARS_2000, rt_code)) throw new SrmException(9, new String("createStandardSRF: incompatble RT with ORMCOD_MARS_2000"));
            SRF_Planetodetic sRF_Planetodetic = new SRF_Planetodetic(SRM_ORM_Code.ORMCOD_MARS_2000, rt_code);
        }
        var2_17.setSrfCode(srf_code);
        return var2_17;
    }

    protected static BaseSRF srfSetMember(SRM_SRFS_Code srf_set, SRM_SRFSM_Code set_member, SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        BaseSRF retSRF = null;
        boolean is_compatible = false;
        if (srf_set == SRM_SRFS_Code.SRFSCOD_ALABAMA_SPCS) {
            if (set_member instanceof SRM_SRFSM_Alabama_SPCS_Code) {
                retSRF = CreateSRF.createAlabama_SPCS(set_member, orm, rt);
                is_compatible = true;
            }
        } else if (srf_set == SRM_SRFS_Code.SRFSCOD_GTRS_GLOBAL_COORDINATE_SYSTEM) {
            if (set_member instanceof SRM_SRFSM_GTRS_GCS_Code) {
                retSRF = CreateSRF.createGTRS_GCS(set_member, orm, rt);
                is_compatible = true;
            }
        } else if (srf_set == SRM_SRFS_Code.SRFSCOD_LAMBERT_NTF) {
            if (set_member instanceof SRM_SRFSM_Lambert_NTF_Code) {
                retSRF = CreateSRF.createLambert_NTF(set_member, orm, rt);
                is_compatible = true;
            }
        } else if (srf_set == SRM_SRFS_Code.SRFSCOD_JAPAN_RECTANGULAR_PLANE_CS) {
            if (set_member instanceof SRM_SRFSM_Japan_Rectangular_Plane_CS_Code) {
                retSRF = CreateSRF.createJpRectPlane(set_member, orm, rt);
                is_compatible = true;
            }
        } else if (srf_set == SRM_SRFS_Code.SRFSCOD_UNIVERSAL_POLAR_STEREOGRAPHIC) {
            if (set_member instanceof SRM_SRFSM_UPS_Code) {
                retSRF = CreateSRF.createUPS(set_member, orm, rt);
                is_compatible = true;
            }
        } else if (srf_set == SRM_SRFS_Code.SRFSCOD_UNIVERSAL_TRANSVERSE_MERCATOR) {
            if (set_member instanceof SRM_SRFSM_UTM_Code) {
                retSRF = CreateSRF.createUTM(set_member, orm, rt);
                is_compatible = true;
            }
        } else if (srf_set == SRM_SRFS_Code.SRFSCOD_WISCONSIN_SPCS) {
            if (set_member instanceof SRM_SRFSM_Wisconsin_SPCS_Code) {
                retSRF = CreateSRF.createWI_SPCS(set_member, orm, rt);
                is_compatible = true;
            }
        } else {
            throw new SrmException(9, new String("srfSetMember: invalid SRFS code"));
        }
        if (!is_compatible) {
            throw new SrmException(9, new String("srfSetMember: incompatible SRFS and SRFS Member codes"));
        }
        retSRF.setSrfSetCode(srf_set);
        return retSRF;
    }

    private static BaseSRF createAlabama_SPCS(SRM_SRFSM_Code set_member, SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        SRF_TransverseMercator retSRF = null;
        if (orm != SRM_ORM_Code.ORMCOD_N_AM_1983 || rt != SRM_RT_Code.RTCOD_N_AM_1983_CONTINENTAL_US) {
            throw new SrmException(9, new String("createSRFSetMember: invalid Alabama SPCS SRF ORM code"));
        }
        if (set_member == SRM_SRFSM_Alabama_SPCS_Code.SRFSMALCOD_WEST_ZONE) {
            retSRF = new SRF_TransverseMercator(orm, rt, -1.5271630954950384, 0.5235987755982988, 0.9999333333333333, 600000.0, 0.0);
        } else if (set_member == SRM_SRFSM_Alabama_SPCS_Code.SRFSMALCOD_EAST_ZONE) {
            retSRF = new SRF_TransverseMercator(orm, rt, -1.498074274628466, 0.5323254218582705, 0.99996, 200000.0, 0.0);
        } else {
            throw new SrmException(9, new String("createSRFSetMember: invalid Alabama SPCS SRF Set member code"));
        }
        retSRF.setSrfSetMemberCode(set_member);
        return retSRF;
    }

    private static BaseSRF createGTRS_GCS(SRM_SRFSM_Code set_member, SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        SRF_LocalTangentSpaceEuclidean retSRF = null;
        if (orm != SRM_ORM_Code.ORMCOD_WGS_1984 || rt != SRM_RT_Code.RTCOD_WGS_1984_IDENTITY) {
            throw new SrmException(9, new String("createSRFSetMember: invalid GCS ORM code (valid ORM=> WGS_1984"));
        }
        GtrsDataSet tmpGtrsElem = GtrsDataSet.getElem(set_member.toInt());
        retSRF = new SRF_LocalTangentSpaceEuclidean(orm, rt, GtrsDataSet.getCellOrigLon(set_member.toInt(), tmpGtrsElem), GtrsDataSet.getCellOrigLat(tmpGtrsElem), 0.0, 50000.0, 50000.0, 0.0);
        retSRF.setSrfSetMemberCode(set_member);
        return retSRF;
    }

    private static BaseSRF createLambert_NTF(SRM_SRFSM_Code set_member, SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        SRF_LambertConformalConic retSRF = null;
        if (orm != SRM_ORM_Code.ORMCOD_NTF_1896 || rt != SRM_RT_Code.RTCOD_NTF_1896_FRANCE) {
            throw new SrmException(9, new String("createSRFSetMember: invalid Lambert NTF SRF ORM code"));
        }
        if (set_member == SRM_SRFSM_Lambert_NTF_Code.SRFSMLAMNTFCOD_ZONE_I) {
            retSRF = new SRF_LambertConformalConic(orm, rt, 0.0, 0.8639379797371931, 0.8482042340776829, 0.8795745881275563, 600000.0, 200000.0);
        } else if (set_member == SRM_SRFSM_Lambert_NTF_Code.SRFSMLAMNTFCOD_ZONE_II) {
            retSRF = new SRF_LambertConformalConic(orm, rt, 0.0, 0.8168140899333461, 0.8010872577169285, 0.8324524921343296, 600000.0, 200000.0);
        } else if (set_member == SRM_SRFSM_Lambert_NTF_Code.SRFSMLAMNTFCOD_ZONE_III) {
            retSRF = new SRF_LambertConformalConic(orm, rt, 0.0, 0.7696902001294994, 0.7539698692645452, 0.7853299888976107, 600000.0, 200000.0);
        } else if (set_member == SRM_SRFSM_Lambert_NTF_Code.SRFSMLAMNTFCOD_ZONE_IV) {
            retSRF = new SRF_LambertConformalConic(orm, rt, 0.0, 0.735918079103409, 0.7253656051278317, 0.7464365385511198, 234358.0, 185861.369);
        } else {
            throw new SrmException(9, new String("createSRFSetMember: invalid Lambert NTF SRF Set member code"));
        }
        retSRF.setSrfSetMemberCode(set_member);
        return retSRF;
    }

    private static BaseSRF createJpRectPlane(SRM_SRFSM_Code set_member, SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        SRF_TransverseMercator retSRF = null;
        if (orm != SRM_ORM_Code.ORMCOD_JGD_2000 || rt != SRM_RT_Code.RTCOD_JGD_2000_IDENTITY_BY_MEASUREMENT) {
            throw new SrmException(9, new String("createSRFSetMember: invalid Japan Rectangular Plane CS RT/ORM code"));
        }
        if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_I) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.260201381332657, 0.5759586531581288, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_II) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.2951079663725436, 0.5759586531581288, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_III) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.306743494719172, 0.6283185307179586, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_IV) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.3300145514124297, 0.5759586531581288, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_V) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.344558961845716, 0.6283185307179586, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_VI) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.3736477827122884, 0.6283185307179586, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_VII) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.3940099573188887, 0.6283185307179586, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_VIII) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.4172810140121466, 0.6283185307179586, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_IX) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.4405520707054045, 0.6283185307179586, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_X) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.4580053632253476, 0.6981317007977318, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_XI) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.447824275922047, 0.767944870877505, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_XII) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.482730860961934, 0.767944870877505, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_XIII) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.5176374460018205, 0.767944870877505, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_XIV) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.478367537831948, 0.4537856055185257, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_XV) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.2252947962927703, 0.4537856055185257, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_XVI) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.1642082724729685, 0.4537856055185257, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_XVII) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.2863813201125716, 0.4537856055185257, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_XVIII) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.3736477827122884, 0.3490658503988659, 0.9999, 0.0, 0.0);
        } else if (set_member == SRM_SRFSM_Japan_Rectangular_Plane_CS_Code.SRFSMJPRPCSCOD_ZONE_XIX) {
            retSRF = new SRF_TransverseMercator(orm, rt, 2.6878070480712677, 0.4537856055185257, 0.9999, 0.0, 0.0);
        } else {
            throw new SrmException(9, new String("createSRFSetMember: invalid Japan Rectangular Plane CS Set member code"));
        }
        retSRF.setSrfSetMemberCode(set_member);
        return retSRF;
    }

    private static BaseSRF createUPS(SRM_SRFSM_Code set_member, SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        SRF_PolarStereographic retSRF = null;
        if (set_member == SRM_SRFSM_UPS_Code.SRFSMUPSCOD_NORTHERN_POLE) {
            retSRF = new SRF_PolarStereographic(orm, rt, SRM_Polar_Aspect.PLRASP_NORTH, 0.0, 0.994, 2000000.0, 2000000.0);
        } else if (set_member == SRM_SRFSM_UPS_Code.SRFSMUPSCOD_SOUTHERN_POLE) {
            retSRF = new SRF_PolarStereographic(orm, rt, SRM_Polar_Aspect.PLRASP_SOUTH, 0.0, 0.994, 2000000.0, 2000000.0);
        } else {
            throw new SrmException(9, new String("createSRFSetMember: invalid UPS Set member code"));
        }
        retSRF.setSrfSetMemberCode(set_member);
        return retSRF;
    }

    private static BaseSRF createUTM(SRM_SRFSM_Code set_member, SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        SRF_TransverseMercator retSRF = null;
        double origin_longitude = 0.0;
        double false_northing = 0.0;
        if (set_member.toInt() >= 1 && set_member.toInt() <= 60) {
            origin_longitude = ((double)set_member.toInt() * 6.0 - 183.0) * (Math.PI / 180);
            false_northing = 0.0;
        } else if (set_member.toInt() >= 61 && set_member.toInt() <= 120) {
            origin_longitude = ((double)set_member.toInt() * 6.0 - 543.0) * (Math.PI / 180);
            false_northing = 1.0E7;
        } else {
            throw new SrmException(9, new String("createSRFSetMember: invalid UTM Set member code"));
        }
        retSRF = new SRF_TransverseMercator(orm, rt, origin_longitude, 0.0, 0.9996, 500000.0, false_northing);
        retSRF.setSrfSetMemberCode(set_member);
        return retSRF;
    }

    private static BaseSRF createWI_SPCS(SRM_SRFSM_Code set_member, SRM_ORM_Code orm, SRM_RT_Code rt) throws SrmException {
        SRF_LambertConformalConic retSRF = null;
        if (orm != SRM_ORM_Code.ORMCOD_N_AM_1983 || rt != SRM_RT_Code.RTCOD_N_AM_1983_CONTINENTAL_US) {
            throw new SrmException(9, new String("createSRFSetMember: invalid WI SPCS SRF ORM code"));
        }
        if (set_member == SRM_SRFSM_Wisconsin_SPCS_Code.SRFSMWNSPCSCOD_SOUTH_ZONE) {
            retSRF = new SRF_LambertConformalConic(orm, rt, -1.5707963267948966, 0.7330382858376184, 0.7458373670189101, 0.7691084237121679, 600000.0, 0.0);
        } else if (set_member == SRM_SRFSM_Wisconsin_SPCS_Code.SRFSMWNSPCSCOD_CENTRAL_ZONE) {
            retSRF = new SRF_LambertConformalConic(orm, rt, -1.5707963267948966, 0.7650359887908478, 0.7723081940074908, 0.7941248096574199, 600000.0, 0.0);
        } else if (set_member == SRM_SRFSM_Wisconsin_SPCS_Code.SRFSMWNSPCSCOD_NORTH_ZONE) {
            retSRF = new SRF_LambertConformalConic(orm, rt, -1.5707963267948966, 0.7883070454841055, 0.7952883624920829, 0.8162323135160148, 600000.0, 0.0);
        } else {
            throw new SrmException(9, new String("createSRFSetMember: invalid WI SPCS SRF Set member code"));
        }
        retSRF.setSrfSetMemberCode(set_member);
        return retSRF;
    }
}

