/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.RtDataSet;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Code;
import SRM.SRM_ORM_Trans_2D_Params;
import SRM.SRM_ORM_Trans_3D_Params;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class DShiftConv
extends Conversions {
    protected double[][] _Tst = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    private boolean constAreSet = false;

    protected DShiftConv() {
        super(SRM_SRFT_Code.SRFTCOD_UNSPECIFIED, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new DShiftConv();
    }

    private double[][] makeTst(SRM_ORM_Trans_Params hst) {
        double[][] Tst = new double[4][4];
        if (hst instanceof SRM_ORM_Trans_3D_Params) {
            Const.WGS84_Transformation_Matrix(Tst, ((SRM_ORM_Trans_3D_Params)hst)._delta_x, ((SRM_ORM_Trans_3D_Params)hst)._delta_y, ((SRM_ORM_Trans_3D_Params)hst)._delta_z, ((SRM_ORM_Trans_3D_Params)hst)._omega_1, ((SRM_ORM_Trans_3D_Params)hst)._omega_2, ((SRM_ORM_Trans_3D_Params)hst)._omega_3, ((SRM_ORM_Trans_3D_Params)hst)._delta_s);
        } else {
            Const.WGS84_Transformation_Matrix_2D(Tst, ((SRM_ORM_Trans_2D_Params)hst)._delta_x, ((SRM_ORM_Trans_2D_Params)hst)._delta_y, ((SRM_ORM_Trans_2D_Params)hst)._omega, ((SRM_ORM_Trans_2D_Params)hst)._delta_s);
        }
        return Tst;
    }

    protected SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code srfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        double[] temp1 = new double[]{src[0], src[1], src[2], 1.0};
        double[] temp2 = new double[4];
        if (hst == null) {
            if (!this.constAreSet) {
                this.setDShiftConst(srcSrf.getOrm(), srcSrf.getRt(), destSrf.getOrm(), destSrf.getRt());
            }
            Const.multMatrixSubsetVector(this._Tst, temp1, temp2, 4);
        } else {
            Const.multMatrixSubsetVector(this.makeTst(hst), temp1, temp2, 4);
        }
        dest[0] = temp2[0];
        dest[1] = temp2[1];
        dest[2] = temp2[2];
        return retValid;
    }

    protected void setDShiftConst(SRM_ORM_Code srcOrm, SRM_RT_Code srcRt, SRM_ORM_Code tgtOrm, SRM_RT_Code tgtRt) throws SrmException {
        RtDataSet secondary_axis = null;
        RtDataSet t = null;
        secondary_axis = RtDataSet.getElem(srcRt);
        t = RtDataSet.getElem(tgtRt);
        double[][] T_SR = new double[4][4];
        double[][] T_RT = new double[4][4];
        if (Double.isNaN(secondary_axis._delta_x)) {
            secondary_axis._delta_x = 0.0;
            secondary_axis._delta_y = 0.0;
            secondary_axis._delta_z = 0.0;
            secondary_axis._omega_1 = 0.0;
            secondary_axis._omega_2 = 0.0;
            secondary_axis._omega_3 = 0.0;
            secondary_axis._delta_scale = 0.0;
        }
        if (Double.isNaN(t._delta_x)) {
            t._delta_x = 0.0;
            t._delta_y = 0.0;
            t._delta_z = 0.0;
            t._omega_1 = 0.0;
            t._omega_2 = 0.0;
            t._omega_3 = 0.0;
            t._delta_scale = 0.0;
        }
        Const.WGS84_Transformation_Matrix(T_SR, secondary_axis._delta_x, secondary_axis._delta_y, secondary_axis._delta_z, secondary_axis._omega_1, secondary_axis._omega_2, secondary_axis._omega_3, secondary_axis._delta_scale);
        Const.WGS84_InverseTransformation_Matrix(T_RT, t._delta_x, t._delta_y, t._delta_z, t._omega_1, t._omega_2, t._omega_3, t._delta_scale);
        Const.matrixMultiply4x4(T_RT, T_SR, this._Tst);
        this.constAreSet = true;
    }
}

