/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.OrmData;
import SRM.SRF_EC_Params;
import SRM.SRF_EquidistantCylindrical;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class EqcyConv
extends Conversions {
    private ToCdetConst _toCdetConst = null;

    protected EqcyConv() {
        super(SRM_SRFT_Code.SRFTCOD_EQUIDISTANT_CYLINDRICAL, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_CELESTIODETIC, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new EqcyConv();
    }

    public SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        if (destSrfType == SRM_SRFT_Code.SRFTCOD_CELESTIODETIC) {
            src[0] = src[0] - ((SRF_EquidistantCylindrical)srcSrf).get_false_easting();
            src[1] = src[1] - ((SRF_EquidistantCylindrical)srcSrf).get_false_northing();
            this.toCdet(srcSrf, destSrf, src, dest);
            retValid = CoordCheck.forEquidistantCylindrical_cd(this.getOrmData(), dest);
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            dest[0] = src[0];
            dest[1] = src[1];
            dest[2] = src[2];
        }
        return retValid;
    }

    protected void toCdet(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coordinate, double[] dest_generic_coordinate) throws SrmException {
        double lambda_star;
        double source_x = 0.0;
        double source_y = 0.0;
        double source_z = 0.0;
        OrmData e_constants = this.getOrmData();
        if (this._toCdetConst == null) {
            this._toCdetConst = new ToCdetConst(e_constants, ((SRF_EquidistantCylindrical)srcSrf).getSRFParameters());
        }
        source_x = source_generic_coordinate[0];
        source_y = source_generic_coordinate[1];
        source_z = source_generic_coordinate[2];
        double lambda = source_x * this._toCdetConst.scale_factor_inv * e_constants.A_inv;
        double dest_lon = lambda_star = Const.getLambdaStar(lambda, -this._toCdetConst.longitude_origin);
        double dest_lat = e_constants.Eps2 != 0.0 ? Const.footPoint(e_constants, this._toCdetConst.al, this._toCdetConst.fp, source_y * this._toCdetConst.conap_inv) : source_y * e_constants.A_inv;
        dest_generic_coordinate[0] = dest_lon;
        dest_generic_coordinate[1] = dest_lat;
        dest_generic_coordinate[2] = source_z;
    }

    private class ToCdetConst {
        double longitude_origin;
        double scale_factor_inv;
        double conap_inv;
        Const.FootPointConst fp;
        Const.ArcLengthConst al;

        public ToCdetConst(OrmData e_constants, SRF_EC_Params params) {
            this.longitude_origin = params.origin_longitude;
            this.scale_factor_inv = 1.0 / params.central_scale;
            double conap = e_constants.A * (1.0 - e_constants.Eps2 * (0.25 + e_constants.Eps2 * (0.046875 + e_constants.Eps2 * (0.01953125 + 0.01068115234375 * e_constants.Eps2))));
            this.conap_inv = 1.0 / conap;
            this.al = new Const.ArcLengthConst(e_constants);
            this.fp = new Const.FootPointConst(e_constants, this.al, 1.0);
        }
    }
}

