/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.LsrConv;
import SRM.SRF_LSR_2D_Params;
import SRM.SRF_LocalSpaceRectangular2D;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class Lsr2Conv
extends LsrConv {
    protected Lsr2Conv() {
        super(SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_RECT_2D, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_POLAR_2D, SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_AZIMUTHAL_2D, SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_RECT_2D, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new Lsr2Conv();
    }

    protected SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        switch (destSrfType) {
            case SRFTCOD_LOCAL_SPACE_POLAR_2D: {
                retValid = CoordCheck.forLsr2d(src);
                dest[1] = Math.atan2(src[1], src[0]);
                if (dest[1] < 0.0) {
                    dest[1] = dest[1] + Math.PI * 2;
                }
                dest[0] = Math.sqrt(src[0] * src[0] + src[1] * src[1]);
                retValid = CoordCheck.forLocalSpacePolar(dest);
                break;
            }
            case SRFTCOD_LOCAL_SPACE_AZIMUTHAL_2D: {
                retValid = CoordCheck.forLsr2d(src);
                dest[1] = Math.atan2(src[0], src[1]);
                if (dest[1] < 0.0) {
                    dest[1] = dest[1] + Math.PI * 2;
                }
                dest[0] = Math.sqrt(src[0] * src[0] + src[1] * src[1]);
                retValid = CoordCheck.forLocalSpaceAzimuthal2D(dest);
                break;
            }
            case SRFTCOD_LOCAL_SPACE_RECT_2D: {
                retValid = CoordCheck.forNaN_2D(src);
                this.toLsr(srcSrf, destSrf, src, dest);
                retValid = CoordCheck.forNaN_2D(dest);
                break;
            }
            case SRFTCOD_UNSPECIFIED: {
                dest[0] = src[0];
                dest[1] = src[1];
            }
        }
        return retValid;
    }

    protected static double[][] compute_F_u_v(SRF_LSR_2D_Params lsr_2d_SRF_params) throws SrmException {
        double[] e1 = new double[]{1.0, 0.0, 0.0};
        double[] e2 = new double[]{0.0, 1.0, 0.0};
        double[] s = new double[3];
        double[] t = new double[3];
        double[][] F = new double[4][4];
        switch (lsr_2d_SRF_params.forward_direction) {
            case AXDIR_POSITIVE_PRIMARY_AXIS: {
                Const.copyArray(e1, s);
                Const.copyArray(e2, t);
                break;
            }
            case AXDIR_POSITIVE_SECONDARY_AXIS: {
                Const.copyArray(e2, s);
                Const.copyArray(e1, t);
                break;
            }
            case AXDIR_NEGATIVE_PRIMARY_AXIS: {
                Const.copyArray(e1, s);
                Const.ConstTimesVect(s, -1.0);
                Const.copyArray(e2, t);
                Const.ConstTimesVect(t, -1.0);
                break;
            }
            case AXDIR_NEGATIVE_SECONDARY_AXIS: {
                Const.copyArray(e2, s);
                Const.ConstTimesVect(s, -1.0);
                Const.copyArray(e1, t);
                Const.ConstTimesVect(t, -1.0);
                break;
            }
            default: {
                throw new SrmException(3, new String("Invalid LSR 2D parameters"));
            }
        }
        F[0][0] = s[0];
        F[1][0] = t[0];
        F[2][0] = 0.0;
        F[3][0] = 0.0;
        F[0][1] = s[1];
        F[1][1] = t[1];
        F[2][1] = 0.0;
        F[3][1] = 0.0;
        F[0][2] = s[2];
        F[1][2] = t[2];
        F[2][2] = 0.0;
        F[3][2] = 0.0;
        F[0][3] = 0.0;
        F[1][3] = 0.0;
        F[2][3] = 0.0;
        F[3][3] = 1.0;
        return F;
    }

    protected void setTransformMatrix(BaseSRF srcSrf, BaseSRF destSrf) throws SrmException {
        double[][] F_inv_tgt = new double[4][4];
        SRF_LSR_2D_Params lsr2d_srf_src = ((SRF_LocalSpaceRectangular2D)srcSrf).getSRFParameters();
        SRF_LSR_2D_Params lsr2d_srf_tgt = ((SRF_LocalSpaceRectangular2D)destSrf).getSRFParameters();
        this._transformation_matrix = new double[4][4];
        double[][] F_src = Lsr2Conv.compute_F_u_v(lsr2d_srf_src);
        double[][] F_tgt = Lsr2Conv.compute_F_u_v(lsr2d_srf_tgt);
        F_tgt[2][2] = 1.0;
        Const.transpose(F_tgt, F_inv_tgt, 4);
        Const.matrixMultiply4x4(F_src, F_inv_tgt, this._transformation_matrix);
    }
}

