/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.LsrConv;
import SRM.SRF_LSR_3D_Params;
import SRM.SRF_LocalSpaceRectangular3D;
import SRM.SRM_Axis_Direction;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFT_Code;
import SRM.SrmException;

class Lsr3Conv
extends LsrConv {
    protected Lsr3Conv() {
        super(SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_RECT_3D, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_RECT_3D, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new Lsr3Conv();
    }

    protected SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        if (destSrfType == SRM_SRFT_Code.SRFTCOD_LOCAL_SPACE_RECT_3D) {
            this.toLsr(srcSrf, destSrf, src, dest);
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            dest[0] = src[0];
            dest[1] = src[1];
            dest[2] = src[2];
        }
        return retValid;
    }

    protected static double[][] compute_F_u_v_w(SRF_LSR_3D_Params lsr_3d_SRF_params) throws SrmException {
        double[] e1 = new double[]{1.0, 0.0, 0.0};
        double[] e2 = new double[]{0.0, 1.0, 0.0};
        double[] e3 = new double[]{0.0, 0.0, 1.0};
        double[] primary_axis = new double[3];
        double[] secondary_axis = new double[3];
        double[] t = new double[3];
        double[][] F = new double[4][4];
        if (lsr_3d_SRF_params.forward_direction == SRM_Axis_Direction.AXDIR_POSITIVE_PRIMARY_AXIS) {
            Const.copyArray(e1, primary_axis);
        } else if (lsr_3d_SRF_params.forward_direction == SRM_Axis_Direction.AXDIR_POSITIVE_SECONDARY_AXIS) {
            Const.copyArray(e2, primary_axis);
        } else if (lsr_3d_SRF_params.forward_direction == SRM_Axis_Direction.AXDIR_POSITIVE_TERTIARY_AXIS) {
            Const.copyArray(e3, primary_axis);
        } else if (lsr_3d_SRF_params.forward_direction == SRM_Axis_Direction.AXDIR_NEGATIVE_PRIMARY_AXIS) {
            Const.copyArray(e1, primary_axis);
            Const.ConstTimesVect(primary_axis, -1.0);
        } else if (lsr_3d_SRF_params.forward_direction == SRM_Axis_Direction.AXDIR_NEGATIVE_SECONDARY_AXIS) {
            Const.copyArray(e2, primary_axis);
            Const.ConstTimesVect(primary_axis, -1.0);
        } else {
            Const.copyArray(e3, primary_axis);
            Const.ConstTimesVect(primary_axis, -1.0);
        }
        if (lsr_3d_SRF_params.up_direction == SRM_Axis_Direction.AXDIR_POSITIVE_PRIMARY_AXIS) {
            Const.copyArray(e1, secondary_axis);
        } else if (lsr_3d_SRF_params.up_direction == SRM_Axis_Direction.AXDIR_POSITIVE_SECONDARY_AXIS) {
            Const.copyArray(e2, secondary_axis);
        } else if (lsr_3d_SRF_params.up_direction == SRM_Axis_Direction.AXDIR_POSITIVE_TERTIARY_AXIS) {
            Const.copyArray(e3, secondary_axis);
        } else if (lsr_3d_SRF_params.up_direction == SRM_Axis_Direction.AXDIR_NEGATIVE_PRIMARY_AXIS) {
            Const.copyArray(e1, secondary_axis);
            Const.ConstTimesVect(secondary_axis, -1.0);
        } else if (lsr_3d_SRF_params.up_direction == SRM_Axis_Direction.AXDIR_NEGATIVE_SECONDARY_AXIS) {
            Const.copyArray(e2, secondary_axis);
            Const.ConstTimesVect(secondary_axis, -1.0);
        } else {
            Const.copyArray(e3, secondary_axis);
            Const.ConstTimesVect(secondary_axis, -1.0);
        }
        Const.vectCrossProd(primary_axis, secondary_axis, t);
        if (Const.square(t[0]) + Const.square(t[1]) + Const.square(t[2]) < 1.0E-12) {
            throw new SrmException(3, new String("Invalid LSR 3D parameters"));
        }
        F[0][0] = primary_axis[0];
        F[1][0] = primary_axis[1];
        F[2][0] = primary_axis[2];
        F[3][0] = 0.0;
        F[0][1] = secondary_axis[0];
        F[1][1] = secondary_axis[1];
        F[2][1] = secondary_axis[2];
        F[3][1] = 0.0;
        F[0][2] = t[0];
        F[1][2] = t[1];
        F[2][2] = t[2];
        F[3][2] = 0.0;
        F[0][3] = 0.0;
        F[1][3] = 0.0;
        F[2][3] = 0.0;
        F[3][3] = 1.0;
        return F;
    }

    protected void setTransformMatrix(BaseSRF srcSrf, BaseSRF destSrf) throws SrmException {
        double[][] F_inv_tgt = new double[4][4];
        SRF_LSR_3D_Params lsr3d_srf_src = ((SRF_LocalSpaceRectangular3D)srcSrf).getSRFParameters();
        SRF_LSR_3D_Params lsr3d_srf_tgt = ((SRF_LocalSpaceRectangular3D)destSrf).getSRFParameters();
        this._transformation_matrix = new double[4][4];
        double[][] F_src = Lsr3Conv.compute_F_u_v_w(lsr3d_srf_src);
        double[][] F_tgt = Lsr3Conv.compute_F_u_v_w(lsr3d_srf_tgt);
        Const.transpose(F_tgt, F_inv_tgt, 4);
        Const.matrixMultiply4x4(F_inv_tgt, F_src, this._transformation_matrix);
    }
}

