/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.Const;
import SRM.Conversions;
import SRM.CoordCheck;
import SRM.SRF_LTSE_Params;
import SRM.SRF_LT_Params;
import SRM.SRF_LocalTangentSpaceAzimuthalSpherical;
import SRM.SRF_LocalTangentSpaceEuclidean;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_SRFT_Code;
import SRM.SphereConv;
import SRM.SrmException;

class LtasConv
extends SphereConv {
    private LtsasLtseConst _ltsasLtseConst;

    protected LtasConv() {
        super(SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_AZIMUTHAL_SPHERICAL, new SRM_SRFT_Code[]{SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN, SRM_SRFT_Code.SRFTCOD_UNSPECIFIED});
    }

    protected Conversions makeClone() {
        return new LtasConv();
    }

    protected SRM_Coordinate_Valid_Region_Code convert(SRM_SRFT_Code destSrfType, BaseSRF srcSrf, BaseSRF destSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        if (destSrfType == SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN) {
            boolean ltse_is_terminal = destSrfType == destSrf.getSRFTemplateCode();
            retValid = CoordCheck.forAzSpherical(src);
            this.toLtse(srcSrf, destSrf, src, dest, ltse_is_terminal);
        } else if (destSrfType == SRM_SRFT_Code.SRFTCOD_UNSPECIFIED) {
            dest[0] = src[0];
            dest[1] = src[1];
            dest[2] = src[2];
        }
        return retValid;
    }

    protected void toLtse(BaseSRF srcSrf, BaseSRF destSrf, double[] source_generic_coord, double[] dest_generic_coord, boolean ltse_is_terminal) throws SrmException {
        if (this._ltsasLtseConst == null) {
            if (ltse_is_terminal) {
                this._ltsasLtseConst = new LtsasLtseConst(((SRF_LocalTangentSpaceAzimuthalSpherical)srcSrf).getSRFParameters(), ((SRF_LocalTangentSpaceEuclidean)destSrf).getSRFParameters());
            } else {
                SRF_LT_Params tmp_ltsas = ((SRF_LocalTangentSpaceAzimuthalSpherical)srcSrf).getSRFParameters();
                SRF_LTSE_Params tmp_ltse = new SRF_LTSE_Params();
                tmp_ltse.azimuth = tmp_ltsas.azimuth;
                tmp_ltse.height_offset = tmp_ltsas.height_offset;
                this._ltsasLtseConst = new LtsasLtseConst(tmp_ltsas, tmp_ltse);
            }
        }
        double alpha_star = Const.getAlphaStar(source_generic_coord[0], this._ltsasLtseConst.ltsas_azimuth);
        double alpha_star_star = Const.getAlphaStar(alpha_star, -this._ltsasLtseConst.ltse_azimuth);
        dest_generic_coord[0] = source_generic_coord[2] * Math.cos(source_generic_coord[1]) * Math.sin(alpha_star_star);
        dest_generic_coord[1] = source_generic_coord[2] * Math.cos(source_generic_coord[1]) * Math.cos(alpha_star_star);
        dest_generic_coord[2] = source_generic_coord[2] * Math.sin(source_generic_coord[1]) - this._ltsasLtseConst.ltsas_height_offset + this._ltsasLtseConst.ltse_height_offset;
    }

    public class LtsasLtseConst {
        double ltsas_azimuth;
        double ltsas_height_offset;
        double ltse_azimuth;
        double ltse_height_offset;

        public LtsasLtseConst(SRF_LT_Params ltsas_params, SRF_LTSE_Params ltse_params) {
            this.ltsas_azimuth = ltsas_params.azimuth;
            this.ltsas_height_offset = ltsas_params.height_offset;
            this.ltse_azimuth = ltse_params.azimuth;
            this.ltse_height_offset = ltse_params.height_offset;
        }
    }
}

