/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.BaseSRF;
import SRM.BaseSRF_3D;
import SRM.OpManager;
import SRM.OrmDataSet;
import SRM.RdDataSet;
import SRM.SRF_Celestiodetic;
import SRM.SRF_PolarStereographic;
import SRM.SRF_TransverseMercator;
import SRM.SRM_ORM_Code;
import SRM.SRM_RD_Code;
import SRM.SRM_SRFSM_UPS_Code;
import SRM.SRM_SRFSM_UTM_Code;
import SRM.SRM_SRFS_Code;
import SRM.SrmException;
import java.util.HashMap;

class MGRS {
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final double RAD_TO_DEG = 57.29577951308232;
    protected static final int MGRS_NO_ERROR = 0;
    protected static final int MGRS_LAT_ERROR = 1;
    protected static final int MGRS_LON_ERROR = 2;
    protected static final int MGRS_STRING_ERROR = 4;
    protected static final int MGRS_PRECISION_ERROR = 8;
    protected static final int MGRS_A_ERROR = 16;
    protected static final int MGRS_INV_F_ERROR = 32;
    protected static final int MGRS_EASTING_ERROR = 64;
    protected static final int MGRS_NORTHING_ERROR = 128;
    protected static final int MGRS_ZONE_ERROR = 256;
    protected static final int MGRS_HEMISPHERE_ERROR = 512;
    protected static final int MGRS_LAT_WARNING = 1024;
    private static final int LETTER_A = 0;
    private static final int LETTER_B = 1;
    private static final int LETTER_C = 2;
    private static final int LETTER_D = 3;
    private static final int LETTER_E = 4;
    private static final int LETTER_F = 5;
    private static final int LETTER_G = 6;
    private static final int LETTER_H = 7;
    private static final int LETTER_I = 8;
    private static final int LETTER_J = 9;
    private static final int LETTER_K = 10;
    private static final int LETTER_L = 11;
    private static final int LETTER_M = 12;
    private static final int LETTER_N = 13;
    private static final int LETTER_O = 14;
    private static final int LETTER_P = 15;
    private static final int LETTER_Q = 16;
    private static final int LETTER_R = 17;
    private static final int LETTER_S = 18;
    private static final int LETTER_T = 19;
    private static final int LETTER_U = 20;
    private static final int LETTER_V = 21;
    private static final int LETTER_W = 22;
    private static final int LETTER_X = 23;
    private static final int LETTER_Y = 24;
    private static final int LETTER_Z = 25;
    private static final int MGRS_LETTERS = 3;
    private static final double ONEHT = 100000.0;
    private static final double TWOMIL = 2000000.0;
    private static final double PI = Math.PI;
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final double PI_OVER_30 = 0.10471975511965977;
    private static final double MIN_EASTING = 100000.0;
    private static final double MAX_EASTING = 900000.0;
    private static final double MIN_NORTHING = 0.0;
    private static final double MAX_NORTHING = 1.0E7;
    private static final int MAX_PRECISION = 5;
    private static final double MIN_UTM_LAT = -1.3962634015954636;
    private static final double MAX_UTM_LAT = 1.4660765716752369;
    private static final double MIN_EAST_NORTH = 0.0;
    private static final double MAX_EAST_NORTH = 4000000.0;
    private String MGRS_Ellipsoid_Code = "WE";
    private BaseSRF_3D MGRS_srf;
    protected static final String CLARKE_1866 = "CC";
    protected static final String CLARKE_1880 = "CD";
    protected static final String BESSEL_1841 = "BR";
    protected static final String BESSEL_1841_NAMIBIA = "BN";
    private static Latitude_Band[] Latitude_Band_Table = new Latitude_Band[]{new Latitude_Band(2, 1100000.0, -72.0, -80.5, 0.0), new Latitude_Band(3, 2000000.0, -64.0, -72.0, 2000000.0), new Latitude_Band(4, 2800000.0, -56.0, -64.0, 2000000.0), new Latitude_Band(5, 3700000.0, -48.0, -56.0, 2000000.0), new Latitude_Band(6, 4600000.0, -40.0, -48.0, 4000000.0), new Latitude_Band(7, 5500000.0, -32.0, -40.0, 4000000.0), new Latitude_Band(9, 6400000.0, -24.0, -32.0, 6000000.0), new Latitude_Band(10, 7300000.0, -16.0, -24.0, 6000000.0), new Latitude_Band(11, 8200000.0, -8.0, -16.0, 8000000.0), new Latitude_Band(12, 9100000.0, 0.0, -8.0, 8000000.0), new Latitude_Band(13, 0.0, 8.0, 0.0, 0.0), new Latitude_Band(15, 800000.0, 16.0, 8.0, 0.0), new Latitude_Band(16, 1700000.0, 24.0, 16.0, 0.0), new Latitude_Band(17, 2600000.0, 32.0, 24.0, 2000000.0), new Latitude_Band(18, 3500000.0, 40.0, 32.0, 2000000.0), new Latitude_Band(19, 4400000.0, 48.0, 40.0, 4000000.0), new Latitude_Band(20, 5300000.0, 56.0, 48.0, 4000000.0), new Latitude_Band(21, 6200000.0, 64.0, 56.0, 6000000.0), new Latitude_Band(22, 7000000.0, 72.0, 64.0, 6000000.0), new Latitude_Band(23, 7900000.0, 84.5, 72.0, 6000000.0)};
    private static UPS_Constant[] UPS_Constant_Table = new UPS_Constant[]{new UPS_Constant(0, 9, 25, 25, 800000.0, 800000.0), new UPS_Constant(1, 0, 17, 25, 2000000.0, 800000.0), new UPS_Constant(24, 9, 25, 15, 800000.0, 1300000.0), new UPS_Constant(25, 0, 9, 15, 2000000.0, 1300000.0)};

    private double[] Get_Latitude_Band_Min_Northing(int letter) throws SrmException {
        double[] ret = new double[2];
        if (letter >= 2 && letter <= 7) {
            ret[0] = MGRS.Latitude_Band_Table[letter - 2].min_northing;
            ret[1] = MGRS.Latitude_Band_Table[letter - 2].northing_offset;
        } else if (letter >= 9 && letter <= 13) {
            ret[0] = MGRS.Latitude_Band_Table[letter - 3].min_northing;
            ret[1] = MGRS.Latitude_Band_Table[letter - 3].northing_offset;
        } else if (letter >= 15 && letter <= 23) {
            ret[0] = MGRS.Latitude_Band_Table[letter - 4].min_northing;
            ret[1] = MGRS.Latitude_Band_Table[letter - 4].northing_offset;
        } else {
            throw new SrmException(8, "MGRS_STRING_ERROR");
        }
        return ret;
    }

    private double[] Get_Latitude_Range(int letter) throws SrmException {
        double[] ret = new double[2];
        if (letter >= 2 && letter <= 7) {
            ret[0] = MGRS.Latitude_Band_Table[letter - 2].north * (Math.PI / 180);
            ret[1] = MGRS.Latitude_Band_Table[letter - 2].south * (Math.PI / 180);
        } else if (letter >= 9 && letter <= 13) {
            ret[0] = MGRS.Latitude_Band_Table[letter - 3].north * (Math.PI / 180);
            ret[1] = MGRS.Latitude_Band_Table[letter - 3].south * (Math.PI / 180);
        } else if (letter >= 15 && letter <= 23) {
            ret[0] = MGRS.Latitude_Band_Table[letter - 4].north * (Math.PI / 180);
            ret[1] = MGRS.Latitude_Band_Table[letter - 4].south * (Math.PI / 180);
        } else {
            throw new SrmException(8, "MGRS_STRING_ERROR");
        }
        return ret;
    }

    protected MGRS(String Ellipsoid_Code, BaseSRF_3D srf) throws SrmException {
        this.MGRS_Ellipsoid_Code = Ellipsoid_Code;
        this.MGRS_srf = srf;
        SRM_RD_Code rdCode = OrmDataSet.getElem((SRM_ORM_Code)srf.getOrm())._rd_code;
        RdDataSet rdData = RdDataSet.getElem(rdCode);
        if (rdData._inv_F < 250.0 && rdData._inv_F > 350.0) {
            throw new SrmException(12, "MGRS: INV_F<250.0 or INV_F >350");
        }
    }

    protected int Get_Latitude_Letter(double latitude) throws SrmException {
        int letter;
        double lat_deg = latitude * 57.29577951308232;
        double EIGHTY_DEG_RAD = 1.3962634015954636;
        double EIGHT_DEG_RAD = 0.13962634015954636;
        if (lat_deg >= 72.0 && lat_deg < 84.5) {
            letter = 23;
        } else if (lat_deg >= -80.0 && lat_deg < 72.0) {
            double temp = (latitude + 1.3962634015954636) / 0.13962634015954636 + 1.0E-12;
            letter = MGRS.Latitude_Band_Table[(int)temp].letter;
        } else {
            throw new SrmException(8, "MGRS.Get_Latitude_Letter(): Invalid latitude");
        }
        return letter;
    }

    private boolean Check_Zone(String strMGRS) throws SrmException {
        int i = 0;
        int j = 0;
        int num_digits = 0;
        while (strMGRS.charAt(i) == ' ') {
            ++i;
        }
        j = i;
        while (Character.isDigit(strMGRS.charAt(i))) {
            ++i;
        }
        num_digits = i - j;
        if (num_digits <= 2) {
            return num_digits > 0;
        }
        throw new SrmException(8, "MGRS.Check_Zone(): invalid input string");
    }

    private int Round_MGRS(double value) {
        int ival = (int)value;
        double fraction = value - (double)ival;
        if (fraction > 0.5 || fraction == 0.5 && ival % 2 == 1) {
            ++ival;
        }
        return ival;
    }

    private String Make_MGRS_String(int Zone, int[] Letters, double Easting, double Northing, int Precision) {
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String strMGRS = new String();
        strMGRS = Zone > 0 ? (Zone > 9 ? strMGRS + Zone : "0" + Zone) : strMGRS + "  ";
        for (int jj = 0; jj < 3; ++jj) {
            strMGRS = strMGRS + alphabet.charAt(Letters[jj]);
        }
        double divisor = Math.pow(10.0, 5.0 - (double)Precision);
        if ((Easting %= 100000.0) >= 99999.5) {
            Easting = 99999.0;
        }
        int east = (int)(Easting / divisor);
        String east_str = "0000";
        east_str = east_str + Integer.toString(east);
        strMGRS = strMGRS + east_str.substring(east_str.length() - Precision, east_str.length());
        if ((Northing %= 100000.0) >= 99999.5) {
            Northing = 99999.0;
        }
        int north = (int)(Northing / divisor);
        String north_str = "0000";
        north_str = north_str + Integer.toString(north);
        strMGRS = strMGRS + north_str.substring(north_str.length() - Precision, north_str.length());
        return strMGRS;
    }

    private MGRSComponents Break_MGRS_String(String MGRS2) throws SrmException {
        int num_digits = 0;
        int num_letters = 0;
        int i = 0;
        MGRSComponents Comps = new MGRSComponents();
        String iMGRS = MGRS2.trim();
        while (Character.isDigit(iMGRS.charAt(num_digits))) {
            ++num_digits;
        }
        if (num_digits <= 2) {
            if (num_digits > 0) {
                Comps.Zone = Integer.parseInt(iMGRS.substring(i, i + 2));
                if (Comps.Zone < 1 || Comps.Zone > 60) {
                    throw new SrmException(8, "MGRS.Break_MGRS_String():  Invalid zone");
                }
            } else {
                Comps.Zone = 0;
            }
        } else {
            throw new SrmException(8, "MGRS.Break_MGRS_String():  Invalid number of digits in MGRS string");
        }
        for (i = num_digits; i < iMGRS.length() && Character.isLetter(iMGRS.charAt(i)); ++i) {
        }
        num_letters = i - num_digits;
        if (num_letters == 3) {
            Comps.Letters[0] = Character.toUpperCase(iMGRS.charAt(i - 3)) - 65;
            if (Comps.Letters[0] == 8 || Comps.Letters[0] == 14) {
                throw new SrmException(20, "MGRS.Break_MGRS_String():  MGRS_STRING_ERROR");
            }
            Comps.Letters[1] = Character.toUpperCase(iMGRS.charAt(i - 2)) - 65;
            if (Comps.Letters[1] == 8 || Comps.Letters[1] == 14) {
                throw new SrmException(20, "MGRS.Break_MGRS_String():  MGRS_STRING_ERROR");
            }
            Comps.Letters[2] = Character.toUpperCase(iMGRS.charAt(i - 1)) - 65;
            if (Comps.Letters[2] == 8 || Comps.Letters[2] == 14) {
                throw new SrmException(20, "MGRS.Break_MGRS_String():  MGRS_STRING_ERROR");
            }
        } else {
            throw new SrmException(8, "MGRS.Break_MGRS_String():  Invalid number of letters in MGRS string");
        }
        num_digits = iMGRS.length() - i;
        if (num_digits <= 10 && num_digits % 2 == 0) {
            Comps.Precision = num_digits / 2;
            if (Comps.Precision > 0) {
                int east = Integer.parseInt(iMGRS.substring(i, i + Comps.Precision));
                int north = Integer.parseInt(iMGRS.substring(i + Comps.Precision, i + 2 * Comps.Precision));
                double multiplier = Math.pow(10.0, 5 - Comps.Precision);
                Comps.Easting = (double)east * multiplier;
                Comps.Northing = (double)north * multiplier;
            } else {
                Comps.Easting = 0.0;
                Comps.Northing = 0.0;
            }
            return Comps;
        }
        throw new SrmException(8, "MGRS.Break_MGRS_String():  Invalid number of digits in MGRS string");
    }

    private GridValues Get_Grid_Values(int zone) {
        int set_number = zone % 6;
        if (set_number == 0) {
            set_number = 6;
        }
        boolean aa_pattern = !this.MGRS_Ellipsoid_Code.equals(CLARKE_1866) && !this.MGRS_Ellipsoid_Code.equals(CLARKE_1880) && !this.MGRS_Ellipsoid_Code.equals(BESSEL_1841) && !this.MGRS_Ellipsoid_Code.equals(BESSEL_1841_NAMIBIA);
        GridValues gv = new GridValues();
        if (set_number == 1 || set_number == 4) {
            gv.ltr2_low_value = 0;
            gv.ltr2_high_value = 7;
        } else if (set_number == 2 || set_number == 5) {
            gv.ltr2_low_value = 9;
            gv.ltr2_high_value = 17;
        } else if (set_number == 3 || set_number == 6) {
            gv.ltr2_low_value = 18;
            gv.ltr2_high_value = 25;
        }
        gv.pattern_offset = aa_pattern ? (set_number % 2 == 0 ? 500000.0 : 0.0) : (set_number % 2 == 0 ? 1500000.0 : 1000000.0);
        return gv;
    }

    private String UTM_To_MGRS(int Zone, char Hemisphere, double Longitude, double Latitude, double Easting, double Northing, int Precision) throws SrmException {
        int[] letters = new int[3];
        double divisor = Math.pow(10.0, 5 - Precision);
        double rounded_easting = (double)this.Round_MGRS(Easting / divisor) * divisor;
        boolean do_special_cases = false;
        if (Zone == 31 && Latitude >= 0.9773843811168246 && Latitude < 1.117010721276371 && (Longitude >= 0.05235987755982989 || rounded_easting >= 500000.0)) {
            Zone = 32;
            do_special_cases = true;
        } else if (Latitude > 1.2566370614359172 && Longitude >= 0.0 && Longitude <= 0.6806784082777885) {
            if (Longitude >= 0.0 && Longitude < 0.15707963267948966) {
                Zone = 31;
            } else if (Longitude >= 0.15707963267948966 && Longitude < 0.3665191429188092) {
                Zone = 33;
            } else if (Longitude >= 0.3665191429188092 && Longitude < 0.5759586531581288) {
                Zone = 35;
            } else if (Longitude >= 0.5759586531581288 && Longitude < 0.6806784082777885) {
                Zone = 37;
            }
            do_special_cases = true;
        }
        if (do_special_cases) {
            SRF_TransverseMercator tempUtmSrf;
            SRF_Celestiodetic tempCdSrf;
            if (this.MGRS_srf._internalSRFs == null) {
                this.MGRS_srf._internalSRFs = new HashMap();
            }
            if ((tempCdSrf = (SRF_Celestiodetic)this.MGRS_srf._internalSRFs.get("Interim_Cd")) == null) {
                tempCdSrf = new SRF_Celestiodetic(this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
                this.MGRS_srf._internalSRFs.put("Interim_Cd", tempCdSrf);
            }
            if ((tempUtmSrf = (SRF_TransverseMercator)this.MGRS_srf._internalSRFs.get("Interim_Utm" + Zone)) == null) {
                tempUtmSrf = (SRF_TransverseMercator)BaseSRF.createSRFSetMember(SRM_SRFS_Code.SRFSCOD_UNIVERSAL_TRANSVERSE_MERCATOR, SRM_SRFSM_UTM_Code.getEnum(Zone), this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
                this.MGRS_srf._internalSRFs.put("Interim_Utm" + Zone, tempUtmSrf);
            }
            double[] tempCdCoord = new double[]{Longitude, Latitude, 0.0};
            double[] tempUtmCoord = new double[]{0.0, 0.0, 0.0};
            OpManager.instance().computeAsArray(tempCdSrf, tempUtmSrf, tempCdCoord, tempUtmCoord, null);
            Easting = (double)this.Round_MGRS(tempUtmCoord[0] / divisor) * divisor;
            Northing = tempUtmCoord[1];
        } else {
            Easting = rounded_easting;
        }
        Northing = (double)this.Round_MGRS(Northing / divisor) * divisor;
        if (Latitude <= 0.0 && Northing == 1.0E7) {
            Latitude = 0.0;
            Northing = 0.0;
        }
        GridValues gv = this.Get_Grid_Values(Zone);
        try {
            double grid_northing;
            letters[0] = this.Get_Latitude_Letter(Latitude);
            for (grid_northing = Northing; grid_northing >= 2000000.0; grid_northing -= 2000000.0) {
            }
            if ((grid_northing += gv.pattern_offset) >= 2000000.0) {
                grid_northing -= 2000000.0;
            }
            letters[2] = (int)(grid_northing / 100000.0);
            if (letters[2] > 7) {
                letters[2] = letters[2] + 1;
            }
            if (letters[2] > 13) {
                letters[2] = letters[2] + 1;
            }
            double grid_easting = Easting;
            if (letters[0] == 21 && Zone == 31 && grid_easting == 500000.0) {
                grid_easting -= 1.0;
            }
            letters[1] = gv.ltr2_low_value + ((int)(grid_easting / 100000.0) - 1);
            if (gv.ltr2_low_value == 9 && letters[1] > 13) {
                letters[1] = letters[1] + 1;
            }
            return this.Make_MGRS_String(Zone, letters, grid_easting, Northing, Precision);
        }
        catch (SrmException se) {
            throw new SrmException(8, "MGRS.UTM_To_MGRS(): Invalid latitude");
        }
    }

    protected String Convert_Geodetic_To_MGRS(double Latitude, double Longitude, int Precision) throws SrmException {
        SRF_TransverseMercator tempUtmSrf;
        SRF_Celestiodetic tempCdSrf;
        int zone = Longitude >= 0.0 ? (int)Math.floor(Longitude / 0.10471975511965977) + 31 : (int)Math.floor((Longitude + Math.PI) / 0.10471975511965977) + 1;
        double easting = 0.0;
        double northing = 0.0;
        char hemisphere = Latitude >= 0.0 ? (char)'N' : 'S';
        String strMGRS = "ERROR";
        if (Latitude < -1.5707963267948966 || Latitude > 1.5707963267948966) {
            throw new SrmException(20, "MGRS.Convert_Geodetic_To_MGRS():  MGRS_LAT_ERROR");
        }
        if (Longitude < -Math.PI || Longitude > Math.PI * 2) {
            throw new SrmException(20, "MGRS.Convert_Geodetic_To_MGRS():  MGRS_LON_ERROR");
        }
        if (Precision < 0 || Precision > 5) {
            throw new SrmException(20, "MGRS.Convert_Geodetic_To_MGRS():  MGRS_PRECISION_ERROR");
        }
        if (Latitude < -1.3962634015954636 || Latitude > 1.4660765716752369) {
            SRF_PolarStereographic tempUpsSrf;
            SRF_Celestiodetic tempCdSrf2;
            if (this.MGRS_srf._internalSRFs == null) {
                this.MGRS_srf._internalSRFs = new HashMap();
            }
            if ((tempCdSrf2 = (SRF_Celestiodetic)this.MGRS_srf._internalSRFs.get("Interim_Cd")) == null) {
                tempCdSrf2 = new SRF_Celestiodetic(this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
                this.MGRS_srf._internalSRFs.put("Interim_Cd", tempCdSrf2);
            }
            int srm_ups_zone = Latitude >= 0.0 ? 1 : 2;
            if (this.MGRS_srf._internalSRFs == null) {
                this.MGRS_srf._internalSRFs = new HashMap();
            }
            if ((tempUpsSrf = (SRF_PolarStereographic)this.MGRS_srf._internalSRFs.get("Interim_Ups" + srm_ups_zone)) == null) {
                tempUpsSrf = (SRF_PolarStereographic)BaseSRF.createSRFSetMember(SRM_SRFS_Code.SRFSCOD_UNIVERSAL_POLAR_STEREOGRAPHIC, SRM_SRFSM_UPS_Code.getEnum(srm_ups_zone), this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
                this.MGRS_srf._internalSRFs.put("Interim_Ups" + srm_ups_zone, tempUpsSrf);
            }
            double[] tempCdCoord = new double[]{Longitude, Latitude, 0.0};
            double[] tempUpsCoord = new double[]{0.0, 0.0, 0.0};
            OpManager.instance().computeAsArray(tempCdSrf2, tempUpsSrf, tempCdCoord, tempUpsCoord, null);
            easting = tempUpsCoord[0];
            northing = tempUpsCoord[1];
            try {
                strMGRS = this.Convert_UPS_To_MGRS(hemisphere, easting, northing, Precision);
            }
            catch (SrmException se) {
                throw new SrmException(20, "MGRS.Convert_Geodetic_To_MGRS():  error");
            }
        }
        int srm_utm_zone = zone;
        if (hemisphere == 'S') {
            srm_utm_zone += 60;
        }
        if (this.MGRS_srf._internalSRFs == null) {
            this.MGRS_srf._internalSRFs = new HashMap();
        }
        if ((tempCdSrf = (SRF_Celestiodetic)this.MGRS_srf._internalSRFs.get("Interim_Cd")) == null) {
            tempCdSrf = new SRF_Celestiodetic(this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
            this.MGRS_srf._internalSRFs.put("Interim_Cd", tempCdSrf);
        }
        if ((tempUtmSrf = (SRF_TransverseMercator)this.MGRS_srf._internalSRFs.get("Interim_Utm" + srm_utm_zone)) == null) {
            tempUtmSrf = (SRF_TransverseMercator)BaseSRF.createSRFSetMember(SRM_SRFS_Code.SRFSCOD_UNIVERSAL_TRANSVERSE_MERCATOR, SRM_SRFSM_UTM_Code.getEnum(srm_utm_zone), this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
            this.MGRS_srf._internalSRFs.put("Interim_Utm" + srm_utm_zone, tempUtmSrf);
        }
        double[] tempCdCoord = new double[]{Longitude, Latitude, 0.0};
        double[] tempUtmCoord = new double[]{0.0, 0.0, 0.0};
        OpManager.instance().computeAsArray(tempCdSrf, tempUtmSrf, tempCdCoord, tempUtmCoord, null);
        easting = tempUtmCoord[0];
        northing = tempUtmCoord[1];
        try {
            strMGRS = this.Convert_UTM_To_MGRS(zone, hemisphere, Longitude, Latitude, easting, northing, Precision);
        }
        catch (SrmException se) {
            throw new SrmException(20, "MGRS.Convert_Geodetic_To_MGRS():  Unsuccessful MGRS computation from interim UTM coord.");
        }
        return strMGRS;
    }

    protected double[] Convert_MGRS_To_Geodetic(String strMGRS) throws SrmException {
        double Latitude = 0.0;
        double Longitude = 0.0;
        try {
            boolean zone_exists = this.Check_Zone(strMGRS);
            if (zone_exists) {
                SRF_TransverseMercator tempUtmSrf;
                SRF_Celestiodetic tempCdSrf;
                UTMComponents utm_coord = this.Convert_MGRS_To_UTM(strMGRS);
                if (this.MGRS_srf._internalSRFs == null) {
                    this.MGRS_srf._internalSRFs = new HashMap();
                }
                if ((tempCdSrf = (SRF_Celestiodetic)this.MGRS_srf._internalSRFs.get("Interim_Cd")) == null) {
                    tempCdSrf = new SRF_Celestiodetic(this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
                    this.MGRS_srf._internalSRFs.put("Interim_Cd", tempCdSrf);
                }
                int srm_utm_zone = utm_coord.Zone;
                if (utm_coord.Hemisphere == 'S') {
                    srm_utm_zone += 60;
                }
                if ((tempUtmSrf = (SRF_TransverseMercator)this.MGRS_srf._internalSRFs.get("Interim_Utm" + srm_utm_zone)) == null) {
                    tempUtmSrf = (SRF_TransverseMercator)BaseSRF.createSRFSetMember(SRM_SRFS_Code.SRFSCOD_UNIVERSAL_TRANSVERSE_MERCATOR, SRM_SRFSM_UTM_Code.getEnum(srm_utm_zone), this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
                    this.MGRS_srf._internalSRFs.put("Interim_Utm" + srm_utm_zone, tempUtmSrf);
                }
                double[] tempCdCoord = new double[]{0.0, 0.0, 0.0};
                double[] tempUtmCoord = new double[]{utm_coord.Easting, utm_coord.Northing, 0.0};
                OpManager.instance().computeAsArray(tempUtmSrf, tempCdSrf, tempUtmCoord, tempCdCoord, null);
                Longitude = tempCdCoord[0];
                Latitude = tempCdCoord[1];
            } else {
                SRF_PolarStereographic tempUpsSrf;
                SRF_Celestiodetic tempCdSrf;
                UPSComponents ups_coord = this.Convert_MGRS_To_UPS(strMGRS);
                if (this.MGRS_srf._internalSRFs == null) {
                    this.MGRS_srf._internalSRFs = new HashMap();
                }
                if ((tempCdSrf = (SRF_Celestiodetic)this.MGRS_srf._internalSRFs.get("Interim_Cd")) == null) {
                    tempCdSrf = new SRF_Celestiodetic(this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
                    this.MGRS_srf._internalSRFs.put("Interim_Cd", tempCdSrf);
                }
                int srm_ups_zone = 1;
                if (ups_coord.Hemisphere == 'S') {
                    srm_ups_zone = 2;
                }
                if ((tempUpsSrf = (SRF_PolarStereographic)this.MGRS_srf._internalSRFs.get("Interim_Ups" + srm_ups_zone)) == null) {
                    tempUpsSrf = (SRF_PolarStereographic)BaseSRF.createSRFSetMember(SRM_SRFS_Code.SRFSCOD_UNIVERSAL_POLAR_STEREOGRAPHIC, SRM_SRFSM_UPS_Code.getEnum(srm_ups_zone), this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
                    this.MGRS_srf._internalSRFs.put("Interim_Ups" + srm_ups_zone, tempUpsSrf);
                }
                double[] tempCdCoord = new double[]{0.0, 0.0, 0.0};
                double[] tempUpsCoord = new double[]{ups_coord.Easting, ups_coord.Northing, 0.0};
                OpManager.instance().computeAsArray(tempUpsSrf, tempCdSrf, tempUpsCoord, tempCdCoord, null);
                Longitude = tempCdCoord[0];
                Latitude = tempCdCoord[1];
            }
            double[] GeoCoords = new double[]{Longitude, Latitude, 0.0};
            return GeoCoords;
        }
        catch (SrmException se) {
            throw new SrmException(20, "MGRS.Convert_MGRS_To_Geodetic(): Unable to convert");
        }
    }

    private String Convert_UTM_To_MGRS(int Zone, char Hemisphere, double cd_lon, double cd_lat, double Easting, double Northing, int Precision) throws SrmException {
        if (Zone < 1 || Zone > 60) {
            throw new SrmException(20, "MGRS.Convert_UTM_To_MGRS():  MGRS_ZONE_ERROR");
        }
        if (Hemisphere != 'S' && Hemisphere != 'N') {
            throw new SrmException(20, "MGRS.Convert_UTM_To_MGRS():  MGRS_HEMISPHERE_ERROR");
        }
        if (Easting < 100000.0 || Easting > 900000.0) {
            throw new SrmException(20, "MGRS.Convert_UTM_To_MGRS():  MGRS_EASTING_ERROR");
        }
        if (Northing < 0.0 || Northing > 1.0E7) {
            throw new SrmException(20, "MGRS.Convert_UTM_To_MGRS():  MGRS_NORTHING_ERROR");
        }
        if (Precision < 0 || Precision > 5) {
            throw new SrmException(20, "MGRS.Convert_UTM_To_MGRS():  MGRS_PRECISION_ERROR");
        }
        return this.UTM_To_MGRS(Zone, Hemisphere, cd_lon, cd_lat, Easting, Northing, Precision);
    }

    private UTMComponents Convert_MGRS_To_UTM(String MGRS2) throws SrmException {
        double[] lat_limits;
        SRF_TransverseMercator tempUtmSrf;
        SRF_Celestiodetic tempCdSrf;
        double[] northing_data;
        double row_letter_northing = 0.0;
        double latitude = 0.0;
        double divisor = 1.0;
        MGRSComponents MGRSComps = this.Break_MGRS_String(MGRS2);
        if (MGRSComps.Zone == 0) {
            throw new SrmException(20, "MGRS.Convert_MGRS_To_UTM():  Invalid zone after breaking MGRS string");
        }
        if (MGRSComps.Letters[0] == 23 && (MGRSComps.Zone == 32 || MGRSComps.Zone == 34 || MGRSComps.Zone == 36)) {
            throw new SrmException(20, "MGRS.Convert_MGRS_To_UTM():  Invalid zone in MGRS string");
        }
        UTMComponents UTMComps = new UTMComponents();
        UTMComps.Hemisphere = MGRSComps.Letters[0] < 13 ? (char)83 : (char)78;
        UTMComps.Zone = MGRSComps.Zone;
        GridValues gv = this.Get_Grid_Values(MGRSComps.Zone);
        if (MGRSComps.Letters[1] < gv.ltr2_low_value || MGRSComps.Letters[1] > gv.ltr2_high_value || MGRSComps.Letters[2] > 21) {
            throw new SrmException(8, "MGRS.Convert_MGRS_To_UTM():  Invalid range for 2nd and 3rd letters of MGRS string");
        }
        double grid_easting = (double)(MGRSComps.Letters[1] - gv.ltr2_low_value + 1) * 100000.0;
        if (gv.ltr2_low_value == 9 && MGRSComps.Letters[1] > 14) {
            grid_easting -= 100000.0;
        }
        row_letter_northing = (double)MGRSComps.Letters[2] * 100000.0;
        if (MGRSComps.Letters[2] > 14) {
            row_letter_northing -= 100000.0;
        }
        if (MGRSComps.Letters[2] > 8) {
            row_letter_northing -= 100000.0;
        }
        if (row_letter_northing >= 2000000.0) {
            row_letter_northing -= 2000000.0;
        }
        try {
            northing_data = this.Get_Latitude_Band_Min_Northing(MGRSComps.Letters[0]);
        }
        catch (SrmException ex) {
            throw new SrmException(20, "Internal Error: Convert_MGRS_To_UTM: Get_Latitude_Band_Min_Northing");
        }
        double grid_northing = row_letter_northing - gv.pattern_offset;
        if (grid_northing < 0.0) {
            grid_northing += 2000000.0;
        }
        if ((grid_northing += northing_data[1]) < northing_data[0]) {
            grid_northing += 2000000.0;
        }
        UTMComps.Easting = grid_easting + MGRSComps.Easting;
        UTMComps.Northing = grid_northing + MGRSComps.Northing;
        int srm_utm_zone = MGRSComps.Zone;
        if (UTMComps.Hemisphere == 'S') {
            srm_utm_zone += 60;
        }
        if (this.MGRS_srf._internalSRFs == null) {
            this.MGRS_srf._internalSRFs = new HashMap();
        }
        if ((tempCdSrf = (SRF_Celestiodetic)this.MGRS_srf._internalSRFs.get("Interim_Cd")) == null) {
            tempCdSrf = new SRF_Celestiodetic(this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
            this.MGRS_srf._internalSRFs.put("Interim_Cd", tempCdSrf);
        }
        if ((tempUtmSrf = (SRF_TransverseMercator)this.MGRS_srf._internalSRFs.get("Interim_Utm" + srm_utm_zone)) == null) {
            tempUtmSrf = (SRF_TransverseMercator)BaseSRF.createSRFSetMember(SRM_SRFS_Code.SRFSCOD_UNIVERSAL_TRANSVERSE_MERCATOR, SRM_SRFSM_UTM_Code.getEnum(srm_utm_zone), this.MGRS_srf.getOrm(), this.MGRS_srf.getRt());
            this.MGRS_srf._internalSRFs.put("Interim_Utm" + srm_utm_zone, tempUtmSrf);
        }
        double[] tempCdCoord = new double[]{0.0, 0.0, 0.0};
        double[] tempUtmCoord = new double[]{UTMComps.Easting, UTMComps.Northing, 0.0};
        OpManager.instance().computeAsArray(tempUtmSrf, tempCdSrf, tempUtmCoord, tempCdCoord, null);
        latitude = tempCdCoord[1];
        divisor = Math.pow(10.0, MGRSComps.Precision);
        try {
            lat_limits = this.Get_Latitude_Range(MGRSComps.Letters[0]);
        }
        catch (SrmException ex) {
            throw new SrmException(20, "MGRS: Convert_MGRS_To_UTM(): Get_Latitude_Range");
        }
        if (!(lat_limits[1] - Math.PI / 180 / divisor <= latitude) || !(latitude <= lat_limits[0] + Math.PI / 180 / divisor)) {
            throw new SrmException(20, "MGRS: Convert_MGRS_To_UTM(): MGRS_LAT_WARNING");
        }
        return UTMComps;
    }

    protected String Convert_UPS_To_MGRS(char Hemisphere, double Easting, double Northing, int Precision) throws SrmException {
        double false_northing;
        double false_easting;
        int ltr2_low_value;
        int[] letters = new int[3];
        int index = 0;
        if (Hemisphere != 'N' && Hemisphere != 'S') {
            throw new SrmException(20, "MGRS::Convert_UPS_To_MGRS(): MGRS_HEMISPHERE_ERROR");
        }
        if (Easting < 0.0 || Easting > 4000000.0) {
            throw new SrmException(20, "MGRS::Convert_UPS_To_MGRS(): MGRS_EASTING_ERROR");
        }
        if (Northing < 0.0 || Northing > 4000000.0) {
            throw new SrmException(20, "MGRS::Convert_UPS_To_MGRS(): MGRS_NORTHING_ERROR");
        }
        if (Precision < 0 || Precision > 5) {
            throw new SrmException(20, "MGRS::Convert_UPS_To_MGRS(): MGRS_PRECISION_ERROR");
        }
        double divisor = Math.pow(10.0, 5 - Precision);
        Easting = (double)this.Round_MGRS(Easting / divisor) * divisor;
        Northing = (double)this.Round_MGRS(Northing / divisor) * divisor;
        if (Hemisphere == 'N') {
            letters[0] = Easting >= 2000000.0 ? 25 : 24;
            index = letters[0] - 22;
            ltr2_low_value = MGRS.UPS_Constant_Table[index].ltr2_low_value;
            false_easting = MGRS.UPS_Constant_Table[index].false_easting;
            false_northing = MGRS.UPS_Constant_Table[index].false_northing;
        } else {
            letters[0] = Easting >= 2000000.0 ? 1 : 0;
            ltr2_low_value = MGRS.UPS_Constant_Table[letters[0]].ltr2_low_value;
            false_easting = MGRS.UPS_Constant_Table[letters[0]].false_easting;
            false_northing = MGRS.UPS_Constant_Table[letters[0]].false_northing;
        }
        double grid_northing = Northing;
        letters[2] = (int)((grid_northing -= false_northing) / 100000.0);
        if (letters[2] > 7) {
            letters[2] = letters[2] + 1;
        }
        if (letters[2] > 13) {
            letters[2] = letters[2] + 1;
        }
        double grid_easting = Easting;
        letters[1] = ltr2_low_value + (int)((grid_easting -= false_easting) / 100000.0);
        if (Easting < 2000000.0) {
            if (letters[1] > 11) {
                letters[1] = letters[1] + 3;
            }
            if (letters[1] > 20) {
                letters[1] = letters[1] + 2;
            }
        } else {
            if (letters[1] > 2) {
                letters[1] = letters[1] + 2;
            }
            if (letters[1] > 7) {
                letters[1] = letters[1] + 1;
            }
            if (letters[1] > 11) {
                letters[1] = letters[1] + 3;
            }
        }
        return this.Make_MGRS_String(0, letters, Easting, Northing, Precision);
    }

    private UPSComponents Convert_MGRS_To_UPS(String MGRS2) throws SrmException {
        double false_northing;
        double false_easting;
        int ltr3_high_value;
        int ltr2_high_value;
        int ltr2_low_value;
        int index = 0;
        UPSComponents UPSComps = new UPSComponents();
        MGRSComponents MGRSComps = new MGRSComponents();
        MGRSComps = this.Break_MGRS_String(MGRS2);
        if (MGRSComps.Zone > 0) {
            throw new SrmException(8, "MGRS.Convert_MGRS_To_UPS():  Invalid zone in MGRS input string");
        }
        if (MGRSComps.Letters[0] >= 24) {
            UPSComps.Hemisphere = (char)78;
            index = MGRSComps.Letters[0] - 22;
            ltr2_low_value = MGRS.UPS_Constant_Table[index].ltr2_low_value;
            ltr2_high_value = MGRS.UPS_Constant_Table[index].ltr2_high_value;
            ltr3_high_value = MGRS.UPS_Constant_Table[index].ltr3_high_value;
            false_easting = MGRS.UPS_Constant_Table[index].false_easting;
            false_northing = MGRS.UPS_Constant_Table[index].false_northing;
        } else {
            UPSComps.Hemisphere = (char)83;
            int Let0 = MGRSComps.Letters[0];
            ltr2_low_value = MGRS.UPS_Constant_Table[Let0].ltr2_low_value;
            ltr2_high_value = MGRS.UPS_Constant_Table[Let0].ltr2_high_value;
            ltr3_high_value = MGRS.UPS_Constant_Table[Let0].ltr3_high_value;
            false_easting = MGRS.UPS_Constant_Table[Let0].false_easting;
            false_northing = MGRS.UPS_Constant_Table[Let0].false_northing;
        }
        if (MGRSComps.Letters[1] < ltr2_low_value || MGRSComps.Letters[1] > ltr2_high_value || MGRSComps.Letters[1] == 3 || MGRSComps.Letters[1] == 4 || MGRSComps.Letters[1] == 12 || MGRSComps.Letters[1] == 13 || MGRSComps.Letters[1] == 21 || MGRSComps.Letters[1] == 22 || MGRSComps.Letters[2] > ltr3_high_value) {
            throw new SrmException(8, "MGRS.Convert_MGRS_To_UPS():  Invalid range for 2nd and 3rd letters of MGRS string");
        }
        double grid_northing = (double)MGRSComps.Letters[2] * 100000.0 + false_northing;
        if (MGRSComps.Letters[2] > 8) {
            grid_northing -= 100000.0;
        }
        if (MGRSComps.Letters[2] > 14) {
            grid_northing -= 100000.0;
        }
        double grid_easting = (double)(MGRSComps.Letters[1] - ltr2_low_value) * 100000.0 + false_easting;
        if (ltr2_low_value != 0) {
            if (MGRSComps.Letters[1] > 11) {
                grid_easting -= 300000.0;
            }
            if (MGRSComps.Letters[1] > 20) {
                grid_easting -= 200000.0;
            }
        } else {
            if (MGRSComps.Letters[1] > 2) {
                grid_easting -= 200000.0;
            }
            if (MGRSComps.Letters[1] > 8) {
                grid_easting -= 100000.0;
            }
            if (MGRSComps.Letters[1] > 11) {
                grid_easting -= 300000.0;
            }
        }
        UPSComps.Easting = grid_easting + MGRSComps.Easting;
        UPSComps.Northing = grid_northing + MGRSComps.Northing;
        return UPSComps;
    }

    private class UTMComponents {
        int Zone;
        char Hemisphere;
        double Easting;
        double Northing;

        private UTMComponents() {
        }
    }

    private class MGRSComponents {
        int Zone;
        int[] Letters = new int[3];
        double Easting;
        double Northing;
        int Precision;

        private MGRSComponents() {
        }
    }

    private class UPSComponents {
        char Hemisphere;
        double Easting;
        double Northing;

        private UPSComponents() {
        }
    }

    private class GridValues {
        int ltr2_low_value;
        int ltr2_high_value;
        double pattern_offset;

        private GridValues() {
        }
    }

    private static class UPS_Constant {
        int letter;
        int ltr2_low_value;
        int ltr2_high_value;
        int ltr3_high_value;
        double false_easting;
        double false_northing;

        private UPS_Constant(int iLetter, int iLetter2_low_value, int iLetter2_high_value, int iLetter3_high_value, double FalseEasting, double FalseNorthing) {
            this.letter = iLetter;
            this.ltr2_low_value = iLetter2_low_value;
            this.ltr2_high_value = iLetter2_high_value;
            this.ltr3_high_value = iLetter3_high_value;
            this.false_easting = FalseEasting;
            this.false_northing = FalseNorthing;
        }
    }

    private static class Latitude_Band {
        int letter;
        double min_northing;
        double north;
        double south;
        double northing_offset;

        protected Latitude_Band(int iLetter, double MinNorthing, double NorthBand, double SouthBand, double NorthingOffset) {
            this.letter = iLetter;
            this.min_northing = MinNorthing;
            this.north = NorthBand;
            this.south = SouthBand;
            this.northing_offset = NorthingOffset;
        }
    }
}

