/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.GtrsDataSet;
import SRM.SRM_SRFSM_Code;
import SRM.SRM_SRFSM_GTRS_GCS_Code;
import SRM.SRM_SRFSM_UTM_Code;
import SRM.SrmException;

class NaturalSetMember {
    NaturalSetMember() {
    }

    protected static SRM_SRFSM_Code forUPS(double[] coord) throws SrmException {
        throw new SrmException(19, new String("Natural Set Member Code for UPS not implemented"));
    }

    protected static SRM_SRFSM_Code forUTM(double[] coord) throws SrmException {
        double[] my_coord = new double[]{Math.toDegrees(coord[0]), Math.toDegrees(coord[1])};
        if (my_coord[1] >= 84.5 || my_coord[1] <= -80.5) {
            throw new SrmException(5, new String("Source coordinate not defined within UTM zones"));
        }
        int zone = (int)Math.floor(31.0 + my_coord[0] * 0.16666666666666666);
        if (my_coord[0] < -180.0) {
            zone = 60;
        } else if (my_coord[0] > 180.0) {
            zone = 1;
        }
        if (my_coord[1] < 0.0) {
            zone += 60;
        }
        SRM_SRFSM_UTM_Code ret_zone = SRM_SRFSM_UTM_Code.getEnum(zone);
        return ret_zone;
    }

    protected static SRM_SRFSM_Code forGTRS(double[] coord) throws SrmException {
        SRM_SRFSM_GTRS_GCS_Code ret_cell = SRM_SRFSM_GTRS_GCS_Code.getEnum(GtrsDataSet.getNaturalCell(coord));
        return ret_cell;
    }

    protected static SRM_SRFSM_Code forALSP(double[] coord) throws SrmException {
        throw new SrmException(19, new String("Natural Set Member Code for ALABAMA SPCS not implemented"));
    }

    protected static SRM_SRFSM_Code forLAMBERT_NTF(double[] coord) throws SrmException {
        throw new SrmException(19, new String("Natural Set Member Code for LAMBERT NTF not implemented"));
    }

    protected static SRM_SRFSM_Code forJPRP(double[] coord) throws SrmException {
        throw new SrmException(19, new String("Natural Set Member Code for JAPAN RECTANGULAR PLACE CS not implemented"));
    }

    protected static SRM_SRFSM_Code forWISP(double[] coord) throws SrmException {
        throw new SrmException(19, new String("Natural Set Member Code for WISCONSIN SPCS not implemented"));
    }
}

