/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.AzConv;
import SRM.BaseSRF;
import SRM.Bfs;
import SRM.CacheManager;
import SRM.CcenConv;
import SRM.CdetConv;
import SRM.CmagConv;
import SRM.Conversions;
import SRM.DShiftConv;
import SRM.EqcyConv;
import SRM.EqinConv;
import SRM.FunctionMap;
import SRM.HaecConv;
import SRM.HeecConv;
import SRM.HeeqConv;
import SRM.IdentConv;
import SRM.LccConv;
import SRM.LceConv;
import SRM.LctpConv;
import SRM.Lsr2Conv;
import SRM.Lsr3Conv;
import SRM.LtasConv;
import SRM.LteConv;
import SRM.MercConv;
import SRM.OmConv;
import SRM.PdetConv;
import SRM.PolConv;
import SRM.PostConv;
import SRM.SRF_LocalTangentSpaceAzimuthalSpherical;
import SRM.SRF_LocalTangentSpaceCylindrical;
import SRM.SRM_Coordinate_Valid_Region_Code;
import SRM.SRM_ORM_Trans_Params;
import SRM.SRM_RT_Code;
import SRM.SRM_SRFT_Code;
import SRM.SeclConv;
import SRM.SeqtConv;
import SRM.SrmException;
import SRM.TmConv;
import java.util.Vector;

public class OpManager {
    private static OpManager _mngr = new OpManager();

    public static OpManager instance() {
        return _mngr;
    }

    private OpManager() {
        FunctionMap.instance().register(new CcenConv());
        FunctionMap.instance().register(new Lsr2Conv());
        FunctionMap.instance().register(new Lsr3Conv());
        FunctionMap.instance().register(new CdetConv());
        FunctionMap.instance().register(new MercConv());
        FunctionMap.instance().register(new TmConv());
        FunctionMap.instance().register(new LccConv());
        FunctionMap.instance().register(new LteConv());
        FunctionMap.instance().register(new LctpConv());
        FunctionMap.instance().register(new LtasConv());
        FunctionMap.instance().register(new CmagConv());
        FunctionMap.instance().register(new EqinConv());
        FunctionMap.instance().register(new SeclConv());
        FunctionMap.instance().register(new SeqtConv());
        FunctionMap.instance().register(new HaecConv());
        FunctionMap.instance().register(new HeecConv());
        FunctionMap.instance().register(new HeeqConv());
        FunctionMap.instance().register(new AzConv());
        FunctionMap.instance().register(new PolConv());
        FunctionMap.instance().register(new PdetConv());
        FunctionMap.instance().register(new OmConv());
        FunctionMap.instance().register(new LceConv());
        FunctionMap.instance().register(new PostConv());
        FunctionMap.instance().register(new EqcyConv());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector buildOpSeq(BaseSRF srcSrf, SRM_ORM_Trans_Params hst, BaseSRF tgtSrf) throws SrmException {
        Conversions conv;
        int i;
        Vector<Conversions> opList = new Vector<Conversions>();
        if (srcSrf.getOrm() == tgtSrf.getOrm() && srcSrf.getRt() == tgtSrf.getRt() && hst == null) {
            if (srcSrf.getClass() != tgtSrf.getClass()) {
                Vector<SRM_SRFT_Code> path = Bfs.instance().GetConversionPath(srcSrf.getSRFTemplateCode(), tgtSrf.getSRFTemplateCode());
                if (path == null) throw new SrmException(20, new String("Conversion not supported"));
                for (int i2 = 0; i2 < path.size(); ++i2) {
                    try {
                        Conversions conv2 = FunctionMap.instance().get(path.elementAt(i2));
                        if (i2 == 0) {
                            conv2.setIsSource();
                        } else if (i2 == path.size() - 1) {
                            conv2.setIsTarget();
                        }
                        conv2.setOrmData(srcSrf.getOrm());
                        opList.add(conv2);
                    }
                    catch (Exception e) {
                        throw new SrmException(20, new String("Conversion not supported"));
                    }
                    tgtSrf._myOpSeq.put(new Integer(srcSrf.hashCode()), opList);
                }
                return opList;
            }
            if (srcSrf.isEqual(tgtSrf)) {
                try {
                    opList.add(new IdentConv());
                    opList.add(new IdentConv());
                }
                catch (Exception e) {
                    throw new SrmException(20, new String("Inactionable failure"));
                }
                tgtSrf._myOpSeq.put(new Integer(srcSrf.hashCode()), opList);
                return opList;
            }
            Vector<Object> path = null;
            if (srcSrf instanceof SRF_LocalTangentSpaceCylindrical) {
                path = new Vector<SRM_SRFT_Code>();
                path.add((Object)SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_CYLINDRICAL);
                path.add((Object)SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN);
                path.add((Object)SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC);
                path.add((Object)SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN);
                path.add((Object)SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_CYLINDRICAL);
            } else if (srcSrf instanceof SRF_LocalTangentSpaceAzimuthalSpherical) {
                path = new Vector();
                path.add((Object)SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_AZIMUTHAL_SPHERICAL);
                path.add((Object)SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN);
                path.add((Object)SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC);
                path.add((Object)SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_EUCLIDEAN);
                path.add((Object)SRM_SRFT_Code.SRFTCOD_LOCAL_TANGENT_SPC_AZIMUTHAL_SPHERICAL);
            } else {
                path = Bfs.instance().GetConversionPath(srcSrf.getSRFTemplateCode(), tgtSrf.getSRFTemplateCode());
            }
            if (path == null) throw new SrmException(12, new String("No conversion possible"));
            for (int i3 = 0; i3 < path.size(); ++i3) {
                try {
                    Conversions conv3 = FunctionMap.instance().get((SRM_SRFT_Code)((Object)path.elementAt(i3)));
                    if (i3 == 0) {
                        conv3.setIsSource();
                    } else if (i3 == path.size() - 1) {
                        conv3.setIsTarget();
                    }
                    conv3.setOrmData(srcSrf.getOrm());
                    opList.add(conv3);
                    continue;
                }
                catch (Exception e) {
                    throw new SrmException(20, new String("Inactionable failure"));
                }
            }
            tgtSrf._myOpSeq.put(new Integer(srcSrf.hashCode()), opList);
            return opList;
        }
        Vector<SRM_SRFT_Code> path1 = Bfs.instance().GetConversionPath(srcSrf.getSRFTemplateCode(), SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC);
        if (path1 == null) {
            throw new SrmException(12, new String("No conversion possible"));
        }
        Vector<SRM_SRFT_Code> path2 = Bfs.instance().GetConversionPath(SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC, tgtSrf.getSRFTemplateCode());
        if (path2 == null) {
            throw new SrmException(12, new String("No conversion possible"));
        }
        if (srcSrf.getSRFTemplateCode() != SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC) {
            for (i = 0; i < path1.size(); ++i) {
                try {
                    conv = FunctionMap.instance().get(path1.elementAt(i));
                    conv.setOrmData(srcSrf.getOrm());
                    if (i == 0) {
                        conv.setIsSource();
                    }
                    opList.add(conv);
                    continue;
                }
                catch (Exception e) {
                    throw new SrmException(20, new String("Inactionable failure"));
                }
            }
        }
        opList.add(new DShiftConv());
        if (tgtSrf.getSRFTemplateCode() != SRM_SRFT_Code.SRFTCOD_CELESTIOCENTRIC) {
            for (i = 0; i < path2.size(); ++i) {
                try {
                    conv = FunctionMap.instance().get(path2.elementAt(i));
                    if (i == path2.size() - 1) {
                        conv.setIsTarget();
                    }
                    conv.setOrmData(tgtSrf.getOrm());
                    opList.add(conv);
                    continue;
                }
                catch (Exception e) {
                    throw new SrmException(20, new String("Inactionable failure"));
                }
            }
        }
        tgtSrf._myOpSeq.put(new Integer(srcSrf.hashCode()), opList);
        return opList;
    }

    protected SRM_Coordinate_Valid_Region_Code computeAsArray(BaseSRF srcSrf, BaseSRF tgtSrf, double[] src, double[] dest, SRM_ORM_Trans_Params hst) throws SrmException {
        SRM_Coordinate_Valid_Region_Code retValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        SRM_Coordinate_Valid_Region_Code thisValid = SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID;
        Vector opList = null;
        if (srcSrf.getOrm() != tgtSrf.getOrm() && hst == null && (srcSrf.getRt() == SRM_RT_Code.RTCOD_UNSPECIFIED || tgtSrf.getRt() == SRM_RT_Code.RTCOD_UNSPECIFIED)) {
            throw new SrmException(3, new String("changeCoordinateXX: SRFs with different ORMs and RT unspecified require tranformation object"));
        }
        if (tgtSrf._myOpSeq == null) {
            tgtSrf._myOpSeq = new CacheManager();
        }
        if ((opList = (Vector)tgtSrf._myOpSeq.get(new Integer(srcSrf.hashCode()))) == null) {
            opList = this.buildOpSeq(srcSrf, hst, tgtSrf);
        }
        int srf_iterations = srcSrf.getRt() == tgtSrf.getRt() && hst == null ? opList.size() - 1 : opList.size();
        for (int i = 0; i < srf_iterations; ++i) {
            SRM_SRFT_Code nextSrf = i < opList.size() - 1 ? ((Conversions)opList.elementAt(i + 1)).getSrc() : SRM_SRFT_Code.SRFTCOD_UNSPECIFIED;
            thisValid = ((Conversions)opList.elementAt(i)).convert(nextSrf, srcSrf, tgtSrf, src, dest, hst);
            System.arraycopy(dest, 0, src, 0, src.length);
            if (i == opList.size() - 1 || (retValid != SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID || thisValid == SRM_Coordinate_Valid_Region_Code.COORDVALRGN_VALID) && (retValid != SRM_Coordinate_Valid_Region_Code.COORDVALRGN_DEFINED || thisValid != SRM_Coordinate_Valid_Region_Code.COORDVALRGN_EXTENDED_VALID)) continue;
            retValid = thisValid;
        }
        return retValid;
    }
}

