/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.OriComp;
import SRM.SRM_Axis_Angle_Params;
import SRM.SRM_Euler_Angles_ZXZ_Params;
import SRM.SRM_Matrix_3x3;
import SRM.SRM_Ori_Rep;
import SRM.SRM_Quaternion_Params;
import SRM.SRM_Tait_Bryan_Angles_Params;
import SRM.SrmException;

public abstract class Orientation
implements Cloneable {
    public static final double epsilon = 1.0E-6;
    private SRM_Matrix_3x3 _matrix_base;
    private boolean _internal_data_is_current;

    protected SRM_Matrix_3x3 _get_matrix_base() {
        this._updateIntData();
        return this._matrix_base;
    }

    protected SRM_Matrix_3x3 _get_matrix_base_unch() {
        return this._matrix_base;
    }

    protected void _set_matrix_base(SRM_Matrix_3x3 mat) {
        this._matrix_base = mat;
    }

    protected boolean _get_internal_data_is_current() {
        return this._internal_data_is_current;
    }

    protected void _set_internal_data_is_current(boolean internal_data_is_current) {
        this._internal_data_is_current = internal_data_is_current;
    }

    protected abstract void _updateIntData();

    protected abstract void _updateRepData();

    public SRM_Matrix_3x3 getMatrix3x3() {
        return this._get_matrix_base();
    }

    public SRM_Axis_Angle_Params getAxisAngle() throws SrmException {
        return OriComp.matrix_to_axis_angle(this._get_matrix_base());
    }

    public SRM_Euler_Angles_ZXZ_Params getEulerAnglesZXZ() {
        return OriComp.matrix_to_euler_zxz(this._get_matrix_base());
    }

    public SRM_Tait_Bryan_Angles_Params getTaitBryanAngles() {
        return OriComp.matrix_to_tait_bryan(this._get_matrix_base());
    }

    public SRM_Quaternion_Params getQuaternion() throws SrmException {
        return OriComp.matrix_to_qt(this._get_matrix_base());
    }

    public void setMatrix3x3(SRM_Matrix_3x3 params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, new String("Orientation::setMatrix3x3: invalid matrix 3x3 parameters"));
        }
        this._set_matrix_base(params);
        this._updateRepData();
    }

    public void setMatrix3x3(double a11, double a12, double a13, double a21, double a22, double a23, double a31, double a32, double a33) throws SrmException {
        this.setMatrix3x3(new SRM_Matrix_3x3(a11, a12, a13, a21, a22, a23, a31, a32, a33));
    }

    public void setAxisAngle(SRM_Axis_Angle_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, new String("Orientation::setAxisAngle: invalid (axis, angle) parameters"));
        }
        this.setMatrix3x3(OriComp.axis_angle_to_matrix(params));
    }

    public void setAxisAngle(double[] axis, double angle_in_rad) throws SrmException {
        SRM_Axis_Angle_Params aa = new SRM_Axis_Angle_Params(axis, angle_in_rad);
        this.setAxisAngle(aa);
    }

    public void setEulerAnglesZXZ(SRM_Euler_Angles_ZXZ_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, new String("Orientation::setEulerAnglesZXZ: invalid Euler zxz parameters"));
        }
        this.setMatrix3x3(OriComp.euler_zxz_to_matrix(params));
    }

    public void setEulerAnglesZXZ(double spin, double nutation, double precession) throws SrmException {
        SRM_Euler_Angles_ZXZ_Params ea = new SRM_Euler_Angles_ZXZ_Params(spin, nutation, precession);
        this.setEulerAnglesZXZ(ea);
    }

    public void setTaitBryanAngles(SRM_Tait_Bryan_Angles_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, new String("Orientation::setTaitBryanAngles: invalid Tait-Bryan parameters"));
        }
        this.setMatrix3x3(OriComp.tait_bryan_to_matrix(params));
    }

    public void setTaitBryanAngles(double roll, double pitch, double yaw) throws SrmException {
        SRM_Tait_Bryan_Angles_Params tb = new SRM_Tait_Bryan_Angles_Params(roll, pitch, yaw);
        this.setTaitBryanAngles(tb);
    }

    public void setQuaternion(SRM_Quaternion_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, new String("Orientation::setQuaternion: invalid quaternion parameters"));
        }
        this.setMatrix3x3(OriComp.qt_to_matrix(params));
    }

    public void setQuaternion(double e0, double e1, double e2, double e3) throws SrmException {
        SRM_Quaternion_Params qt = new SRM_Quaternion_Params(e0, e1, e2, e3);
        this.setQuaternion(qt);
    }

    public abstract String toString();

    public abstract SRM_Ori_Rep getOriRep();

    public double[] transformVector(double[] vec) throws SrmException {
        return OriComp.matrixMultiply(this._get_matrix_base(), vec);
    }

    public static final boolean equivalence(Orientation instance1, Orientation instance2, double tolerance) throws SrmException {
        if (tolerance < 0.0) {
            throw new SrmException(8, new String("equivalance: invalid (negative) tolerance"));
        }
        return SRM_Matrix_3x3.isEquiv(instance1._get_matrix_base(), instance2._get_matrix_base(), tolerance);
    }

    public static final boolean equivalence(Orientation instance1, Orientation instance2) {
        return SRM_Matrix_3x3.isEquiv(instance1._get_matrix_base(), instance2._get_matrix_base(), 1.0E-6);
    }

    public boolean isEqual(Orientation ori) throws SrmException {
        return Orientation.equivalence(this, ori, 0.0);
    }
}

