/*
 * Decompiled with CFR 0.152.
 */
package SRM;

import SRM.OriComp;
import SRM.Orientation;
import SRM.SRM_Matrix_3x3;
import SRM.SRM_Ori_Rep;
import SRM.SRM_Quaternion_Params;
import SRM.SrmException;

public class OrientationQuaternion
extends Orientation {
    private SRM_Quaternion_Params _quaternion = new SRM_Quaternion_Params();

    public OrientationQuaternion() {
    }

    public OrientationQuaternion(SRM_Quaternion_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, "OrientationQuaternion(params): invalid quaternion parameters");
        }
        this._quaternion = params;
    }

    public OrientationQuaternion(double e0, double e1, double e2, double e3) throws SrmException {
        SRM_Quaternion_Params qt = new SRM_Quaternion_Params(e0, e1, e2, e3);
        if (!qt.valid()) {
            throw new SrmException(8, new String("OrientationQuaternion: invalid quaternion parameters"));
        }
        this._quaternion = qt;
    }

    public SRM_Quaternion_Params getQuaternion() {
        return new SRM_Quaternion_Params(this._quaternion);
    }

    public void setQuaternion(SRM_Quaternion_Params params) throws SrmException {
        if (!params.valid()) {
            throw new SrmException(8, new String("OrientationQuaternion.setQuaternion: invalid quaternion parameters"));
        }
        this._quaternion = params;
        this._set_internal_data_is_current(false);
    }

    public String toString() {
        return this._quaternion.toString();
    }

    public SRM_Ori_Rep getOriRep() {
        return SRM_Ori_Rep.ORI_REP_QUATERNION;
    }

    public static OrientationQuaternion compose(Orientation left, Orientation right) throws SrmException {
        SRM_Matrix_3x3 ret_mat = OriComp.matrixMultiply(left.getMatrix3x3(), right.getMatrix3x3());
        return new OrientationQuaternion(OriComp.matrix_to_qt(ret_mat));
    }

    protected void _updateIntData() {
        if (!this._get_internal_data_is_current()) {
            this._set_matrix_base(OriComp.qt_to_matrix(this._quaternion));
            this._set_internal_data_is_current(true);
        }
    }

    protected void _updateRepData() {
        this._quaternion = OriComp.matrix_to_qt(this._get_matrix_base_unch());
        this._set_internal_data_is_current(true);
    }
}

